#!/bin/sh
# -*- mode: Fundamental; tab-width: 4; -*-
# ex:ts=4
#
# JBoss startup script.
#
# $FreeBSD: ports/www/jakarta-tomcat4/files/startup.sh,v 1.4 2002/05/08 21:54:06 znerd Exp $
#


# Set some variables
MYSELF=`basename $0`

case "$1" in
	start)
		echo -n ' '
		truncate -s 0 /var/run/jboss3.pid
		chown www:www /var/run/jboss3.pid
		chmod 600 /var/run/jboss3.pid
		su -f -m www -c "exec /usr/local/bin/jboss3ctl start" >/dev/null && echo -n 'jboss3'
		;;
	stop)
		echo -n ' '
		chown www:www /var/run/jboss3.pid
		chmod 600 /var/run/jboss3.pid
		su -f -m www -c "exec /usr/local/bin/jboss3ctl stop" >/dev/null 2>&1 ; echo -n 'jboss3'
		;;
	*)
		echo ""
		echo "Usage: ${MYSELF} { start | stop }"
		echo ""
		exit 64
		;;
esac
