
import com.bitmechanic.gsp.*;
import com.bitmechanic.sql.*;

/**
 * Example of how to use the JDBC pool with GNU Server Pages
 * http://www.bitmechanic.com/projects/gsp/
 *
 * In your gsp.properties file you would have properties for the 
 * url, driver, username, and password needed to connect to your database.
 *
 */
public class JDBCApplication extends DefaultApplication {

  public void init(GspServlet servlet, ApplicationManager mgr) {
    super.init(servlet, mgr);

    // Setup connection pool
    try {
      //
      // Reap stale connections every 2 minutes
      ConnectionPoolManager pool = new ConnectionPoolManager(120);
      
      pool.addAlias("jdbcalias",
		    servlet.getProperty("jdbc.driver"),
		    servlet.getProperty("jdbc.url"),
		    servlet.getProperty("jdbc.user"),
		    servlet.getProperty("jdbc.password"),
   Integer.parseInt(servlet.getProperty("jdbc.maxconn")),
   Integer.parseInt(servlet.getProperty("jdbc.idletimeout")),
   Integer.parseInt(servlet.getProperty("jdbc.checkouttimeout")));


      //
      // put the pool in the application's hashtable so we can look at it
      // later and collect stats from it
      putValue("pool", pool);
    }
    catch(Exception e) {
      handleException(e);
    }
  }
}
