/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubyIndexException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;

public class RubyArray
extends RubyObject {
    private ArrayList list;
    private boolean tmpLock;
    static /* synthetic */ Class class$org$jruby$RubyArray;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;

    public RubyArray(Ruby ruby) {
        this(ruby, new ArrayList());
    }

    public RubyArray(Ruby ruby, List array) {
        this(ruby, new ArrayList(array), false);
    }

    public RubyArray(Ruby ruby, ArrayList array, boolean notCopy) {
        super(ruby, ruby.getRubyClass("Array"));
        this.list = array;
    }

    public static RubyArray nilArray(Ruby ruby) {
        return new RubyArray(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public ArrayList getList() {
        return this.list;
    }

    public RubyObject[] toJavaArray() {
        return this.list.toArray(new RubyObject[this.getLength()]);
    }

    public boolean isTmpLock() {
        return this.tmpLock;
    }

    public void setTmpLock(boolean tmpLock) {
        this.tmpLock = tmpLock;
    }

    public int getLength() {
        return this.list.size();
    }

    public static RubyClass createArrayClass(Ruby ruby) {
        RubyClass arrayClass = ruby.defineClass("Array", ruby.getClasses().getObjectClass());
        arrayClass.includeModule(ruby.getRubyModule("Enumerable"));
        arrayClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "create"));
        arrayClass.defineSingletonMethod("[]", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "create"));
        arrayClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "initialize"));
        arrayClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "inspect"));
        arrayClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "to_s"));
        arrayClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "to_a"));
        arrayClass.defineMethod("to_ary", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "to_a"));
        arrayClass.defineMethod("frozen?", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "frozen"));
        arrayClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("eql?", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "eql", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "hash"));
        arrayClass.defineMethod("===", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("[]", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "aref"));
        arrayClass.defineMethod("[]=", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "aset"));
        arrayClass.defineMethod("at", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "at", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyArray.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        arrayClass.defineMethod("first", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "first"));
        arrayClass.defineMethod("last", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "last"));
        arrayClass.defineMethod("concat", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "concat", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("<<", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "push", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("push", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "push"));
        arrayClass.defineMethod("pop", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "pop"));
        arrayClass.defineMethod("shift", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "shift"));
        arrayClass.defineMethod("unshift", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "unshift"));
        arrayClass.defineMethod("each", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "each"));
        arrayClass.defineMethod("each_index", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "each_index"));
        arrayClass.defineMethod("reverse_each", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "reverse_each"));
        arrayClass.defineMethod("length", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "length"));
        arrayClass.defineMethod("size", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "length"));
        arrayClass.defineMethod("empty?", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "empty_p"));
        arrayClass.defineMethod("index", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "index", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("rindex", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "rindex", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("indexes", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "indexes"));
        arrayClass.defineMethod("indices", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "indexes"));
        arrayClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "rbClone"));
        arrayClass.defineMethod("join", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "join"));
        arrayClass.defineMethod("reverse", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "reverse"));
        arrayClass.defineMethod("reverse!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "reverse_bang"));
        arrayClass.defineMethod("sort", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "sort"));
        arrayClass.defineMethod("sort!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "sort_bang"));
        arrayClass.defineMethod("collect", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "collect"));
        arrayClass.defineMethod("collect!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "collect_bang"));
        arrayClass.defineMethod("map!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "collect_bang"));
        arrayClass.defineMethod("filter", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "collect_bang"));
        arrayClass.defineMethod("delete", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "delete", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("delete_at", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "delete_at", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("delete_if", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "delete_if"));
        arrayClass.defineMethod("reject!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "reject_bang"));
        arrayClass.defineMethod("replace", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "replace", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("clear", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "clear"));
        arrayClass.defineMethod("fill", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "fill"));
        arrayClass.defineMethod("include?", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "includes", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("slice", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "aref"));
        arrayClass.defineMethod("slice!", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "slice_bang"));
        arrayClass.defineMethod("assoc", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "assoc", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("rassoc", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "rassoc", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_plus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_times", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_diff", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_and", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_or", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyArray.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        arrayClass.defineMethod("uniq", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "uniq"));
        arrayClass.defineMethod("uniq!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "uniq_bang"));
        arrayClass.defineMethod("compact", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "compact"));
        arrayClass.defineMethod("compact!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "compact_bang"));
        arrayClass.defineMethod("flatten", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "flatten"));
        arrayClass.defineMethod("flatten!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "flatten_bang"));
        arrayClass.defineMethod("nitems", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "nitems"));
        return arrayClass;
    }

    public void modify() {
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuby(), "Array");
        }
        if (this.isTmpLock()) {
            throw new TypeError(this.getRuby(), "can't modify array during sort");
        }
        if (this.isTaint() && this.getRuby().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuby(), "Insecure: can't modify array");
        }
    }

    private void autoExpand(long toLength) {
        this.list.ensureCapacity((int)toLength);
        int i = this.getLength();
        while ((long)i < toLength) {
            this.list.add(this.getRuby().getNil());
            ++i;
        }
    }

    public void store(long idx, RubyObject value) {
        this.modify();
        if (idx < 0L && (idx += (long)this.getLength()) < 0L) {
            throw new RubyIndexException(this.getRuby(), "index " + (idx - (long)this.getLength()) + " out of array");
        }
        this.autoExpand(idx + 1L);
        this.list.set((int)idx, value);
    }

    public RubyObject entry(long offset) {
        if (this.getLength() == 0) {
            return this.getRuby().getNil();
        }
        if (offset < 0L) {
            offset += (long)this.getLength();
        }
        if (offset < 0L || (long)this.getLength() <= offset) {
            return this.getRuby().getNil();
        }
        return (RubyObject)this.list.get((int)offset);
    }

    public RubyArray unshift(RubyObject item) {
        this.modify();
        this.list.add(0, item);
        return this;
    }

    public RubyObject subseq(long beg, long len) {
        int length = this.getLength();
        if (beg > (long)length) {
            return this.getRuby().getNil();
        }
        if (beg < 0L || len < 0L) {
            return this.getRuby().getNil();
        }
        if (beg + len > (long)length) {
            len = (long)length - beg;
        }
        if (len < 0L) {
            len = 0L;
        }
        if (len == 0L) {
            return RubyArray.newArray(this.getRuby(), 0L);
        }
        RubyArray ary2 = RubyArray.newArray(this.getRuby(), this.list.subList((int)beg, (int)(len + beg)));
        return ary2;
    }

    public void replace(long beg, long len, RubyObject repl) {
        int length = this.getLength();
        if (len < 0L) {
            throw new RubyIndexException(this.getRuby(), "Negative array length: " + len);
        }
        if (beg < 0L) {
            beg += (long)length;
        }
        if (beg < 0L) {
            throw new RubyIndexException(this.getRuby(), "Index out of bounds: " + beg);
        }
        this.modify();
        int i = 0;
        while (beg < (long)length && (long)i < len) {
            this.list.remove((int)beg);
            ++i;
        }
        this.autoExpand(beg);
        if (repl instanceof RubyArray) {
            ArrayList repList = ((RubyArray)repl).getList();
            this.list.ensureCapacity(length + repList.size());
            this.list.addAll((int)beg, new ArrayList(repList));
        } else if (!repl.isNil()) {
            this.list.add((int)beg, repl);
        }
    }

    public static RubyArray arrayValue(RubyObject other) {
        if (other instanceof RubyArray) {
            return (RubyArray)other;
        }
        try {
            return (RubyArray)other.convertType(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "Array", "to_ary");
        }
        catch (Exception ex) {
            throw new RubyArgumentException(other.getRuby(), "can't convert arg to Array: " + ex.getMessage());
        }
    }

    private boolean flatten(ArrayList ary) {
        boolean mod = false;
        int i = ary.size() - 1;
        while (i >= 0) {
            RubyObject obj = (RubyObject)ary.get(i);
            if (ary.get(i) instanceof RubyArray) {
                ArrayList ary2 = ((RubyArray)ary.remove(i)).getList();
                this.flatten(ary2);
                ary.addAll(i, ary2);
                mod = true;
            }
            --i;
        }
        return mod;
    }

    public static RubyArray newArray(Ruby ruby, long len) {
        return new RubyArray(ruby, new ArrayList((int)len));
    }

    public static RubyArray newArray(Ruby ruby) {
        return new RubyArray(ruby, new ArrayList(16));
    }

    public static RubyArray newArray(Ruby ruby, RubyObject obj) {
        return new RubyArray(ruby, Collections.singletonList(obj));
    }

    public static RubyArray newArray(Ruby ruby, RubyObject car, RubyObject cdr) {
        return new RubyArray(ruby, Arrays.asList(car, cdr));
    }

    public static RubyArray newArray(Ruby ruby, List list) {
        return new RubyArray(ruby, list);
    }

    public static RubyArray newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyArray array = RubyArray.newArray(ruby);
        array.setRubyClass((RubyClass)recv);
        array.callInit(args);
        return array;
    }

    public static RubyArray create(Ruby ruby, RubyObject recv, RubyObject[] args) {
        return RubyArray.newArray(ruby, Arrays.asList(args));
    }

    public RubyFixnum hash() {
        return new RubyFixnum(this.getRuby(), this.list.hashCode());
    }

    public RubyFixnum length() {
        return new RubyFixnum(this.getRuby(), this.getLength());
    }

    public RubyArray push(RubyObject[] items) {
        int length = items.length;
        if (length == 0) {
            throw new RubyArgumentException(this.getRuby(), "wrong # of arguments(at least 1)");
        }
        this.modify();
        boolean taint = false;
        int i = 0;
        while (i < length) {
            taint |= items[i].isTaint();
            this.list.add(items[i]);
            ++i;
        }
        this.setTaint(this.isTaint() || taint);
        return this;
    }

    public RubyArray push(RubyObject value) {
        this.modify();
        this.list.add(value);
        this.infectObject(value);
        return this;
    }

    public RubyObject pop() {
        this.modify();
        if (this.getLength() == 0) {
            return this.getRuby().getNil();
        }
        return (RubyObject)this.list.remove(this.getLength() - 1);
    }

    public RubyObject shift() {
        this.modify();
        if (this.getLength() == 0) {
            return this.getRuby().getNil();
        }
        return (RubyObject)this.list.remove(0);
    }

    public RubyArray unshift(RubyObject[] items) {
        if (items.length == 0) {
            throw new RubyArgumentException(this.getRuby(), "wrong # of arguments(at least 1)");
        }
        this.modify();
        boolean taint = false;
        int i = 0;
        while (i < items.length) {
            taint |= items[i].isTaint();
            this.list.add(i, items[i]);
            ++i;
        }
        this.setTaint(this.isTaint() || taint);
        return this;
    }

    public RubyBoolean includes(RubyObject item) {
        int i = 0;
        int n = this.getLength();
        while (i < n) {
            if (item.funcall("==", this.entry(i)).isTrue()) {
                return this.getRuby().getTrue();
            }
            ++i;
        }
        return this.getRuby().getFalse();
    }

    public RubyBoolean frozen() {
        return RubyBoolean.newBoolean(this.getRuby(), this.isFrozen() || this.isTmpLock());
    }

    public RubyObject initialize(RubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        long len = RubyNumeric.fix2long(args[0]);
        this.modify();
        if (len < 0L) {
            throw new RubyArgumentException(this.getRuby(), "negative array size");
        }
        if (len > Integer.MAX_VALUE) {
            throw new RubyArgumentException(this.getRuby(), "array size too big");
        }
        this.list = new ArrayList((int)len);
        if (len > 0L) {
            RubyObject obj = argc == 2 ? args[1] : this.getRuby().getNil();
            Collections.fill(this.list, obj);
        }
        return this;
    }

    public RubyObject dup() {
        return this.aref(new RubyObject[]{RubyFixnum.zero(this.getRuby()), this.length()});
    }

    public RubyObject aref(RubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            if (beg < 0L) {
                beg += (long)this.getLength();
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            return this.entry(RubyNumeric.fix2long(args[0]));
        }
        if (args[0] instanceof RubyBignum) {
            throw new RubyIndexException(this.getRuby(), "index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), true, false);
            if (begLen == null) {
                return this.getRuby().getNil();
            }
            return this.subseq(begLen[0], begLen[1]);
        }
        return this.entry(RubyNumeric.num2long(args[0]));
    }

    public RubyObject aset(RubyObject[] args) {
        int argc = this.argCount(args, 2, 3);
        if (argc == 3) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            this.replace(beg, len, args[2]);
            return args[2];
        }
        if (args[0] instanceof RubyFixnum) {
            this.store(RubyNumeric.fix2long(args[0]), args[1]);
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], args[1]);
            return args[1];
        }
        if (args[0] instanceof RubyBignum) {
            throw new RubyIndexException(this.getRuby(), "Index too large");
        }
        this.store(RubyNumeric.num2long(args[0]), args[1]);
        return args[1];
    }

    public RubyObject at(RubyFixnum pos) {
        return this.entry(pos.getLongValue());
    }

    public RubyArray concat(RubyObject obj) {
        this.modify();
        RubyArray other = RubyArray.arrayValue(obj);
        this.list.addAll(other.getList());
        this.infectObject(other);
        return this;
    }

    public RubyString inspect() {
        int length = this.getLength();
        if (length == 0) {
            return RubyString.newString(this.getRuby(), "[]");
        }
        RubyString result = RubyString.newString(this.getRuby(), "[");
        RubyString sep = RubyString.newString(this.getRuby(), ", ");
        int i = 0;
        while (i < length) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(this.entry(i).funcall("inspect"));
            ++i;
        }
        result.cat("]");
        return result;
    }

    public RubyObject first() {
        if (this.getLength() == 0) {
            return this.getRuby().getNil();
        }
        return this.entry(0L);
    }

    public RubyObject last() {
        if (this.getLength() == 0) {
            return this.getRuby().getNil();
        }
        return this.entry(this.getLength() - 1);
    }

    public RubyObject each() {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.getRuby().yield(this.entry(i));
            ++i;
        }
        return this;
    }

    public RubyObject each_index() {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.getRuby().yield(RubyFixnum.newFixnum(this.getRuby(), i));
            ++i;
        }
        return this;
    }

    public RubyObject reverse_each() {
        long i = this.getLength();
        while (i > 0L) {
            this.getRuby().yield(this.entry(i - 1L));
            --i;
        }
        return this;
    }

    RubyString join(RubyString sep) {
        int length = this.getLength();
        if (length == 0) {
            RubyString.newString(this.getRuby(), "");
        }
        StringBuffer sbuf = new StringBuffer();
        boolean taint = this.isTaint() || sep.isTaint();
        RubyObject tmp = this.entry(0L);
        taint |= tmp.isTaint();
        RubyString str = tmp instanceof RubyString ? (RubyString)tmp.dup() : (tmp instanceof RubyArray ? ((RubyArray)tmp).join(sep) : RubyString.objAsString(this.getRuby(), tmp));
        long i = 1L;
        while (i < (long)length) {
            tmp = this.entry(i);
            taint |= tmp.isTaint();
            if (tmp instanceof RubyArray) {
                tmp = ((RubyArray)tmp).join(sep);
            } else if (!(tmp instanceof RubyString)) {
                tmp = RubyString.objAsString(this.getRuby(), tmp);
            }
            str.append(sep.op_plus(tmp));
            ++i;
        }
        str.setTaint(taint);
        return str;
    }

    public RubyString join(RubyObject[] args) {
        int argc = this.argCount(args, 0, 1);
        RubyObject sep = argc == 1 ? args[0] : this.getRuby().getGlobalVar("$,");
        return this.join(sep.isNil() ? RubyString.newString(this.getRuby(), "") : RubyString.stringValue(sep));
    }

    public RubyString to_s() {
        RubyObject sep = this.getRuby().getGlobalVar("$,");
        return this.join(sep.isNil() ? RubyString.newString(this.getRuby(), "") : RubyString.stringValue(sep));
    }

    public RubyArray to_a() {
        return this;
    }

    public RubyBoolean equal(RubyObject obj) {
        RubyArray ary;
        if (!(obj instanceof RubyArray)) {
            return this.getRuby().getFalse();
        }
        int length = this.getLength();
        if (length != (ary = (RubyArray)obj).getLength()) {
            return this.getRuby().getFalse();
        }
        long i = 0L;
        while (i < (long)length) {
            if (this.entry(i).funcall("==", ary.entry(i)).isFalse()) {
                return this.getRuby().getFalse();
            }
            ++i;
        }
        return this.getRuby().getTrue();
    }

    public RubyBoolean eql(RubyObject obj) {
        RubyArray ary;
        if (!(obj instanceof RubyArray)) {
            return this.getRuby().getFalse();
        }
        int length = this.getLength();
        if (length != (ary = (RubyArray)obj).getLength()) {
            return this.getRuby().getFalse();
        }
        long i = 0L;
        while (i < (long)length) {
            if (this.entry(i).funcall("eql?", ary.entry(i)).isFalse()) {
                return this.getRuby().getFalse();
            }
            ++i;
        }
        return this.getRuby().getTrue();
    }

    public RubyObject compact_bang() {
        this.modify();
        boolean changed = false;
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (this.entry(i).isNil()) {
                this.list.remove(i);
                changed = true;
            }
            --i;
        }
        return changed ? this : this.getRuby().getNil();
    }

    public RubyObject compact() {
        RubyArray ary = (RubyArray)this.dup();
        return ary.compact_bang();
    }

    public RubyObject empty_p() {
        return this.getLength() == 0 ? this.getRuby().getTrue() : this.getRuby().getFalse();
    }

    public RubyObject clear() {
        this.modify();
        this.list.clear();
        return this;
    }

    public RubyObject fill(RubyObject[] args) {
        int argc = this.argCount(args, 1, 3);
        int beg = 0;
        int len = this.getLength();
        switch (argc) {
            case 1: {
                break;
            }
            case 2: {
                if (args[1] instanceof RubyRange) {
                    long[] begLen = ((RubyRange)args[1]).getBeginLength(len, false, true);
                    beg = (int)begLen[0];
                    len = (int)begLen[1];
                    break;
                }
            }
            default: {
                int n = beg = args[1].isNil() ? beg : RubyNumeric.fix2int(args[1]);
                if (beg < 0 && (beg += len) < 0) {
                    throw new RubyIndexException(this.getRuby(), "Negative array index");
                }
                len -= beg;
                if (argc != 3 || args[2].isNil()) break;
                len = RubyNumeric.fix2int(args[2]);
            }
        }
        this.modify();
        this.autoExpand(beg + len);
        int i = beg;
        while (i < beg + len) {
            this.list.set(i, args[0]);
            ++i;
        }
        return this;
    }

    public RubyObject index(RubyObject obj) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            if (obj.funcall("==", this.entry(i)).isTrue()) {
                return RubyFixnum.newFixnum(this.getRuby(), i);
            }
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject rindex(RubyObject obj) {
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (obj.funcall("==", this.entry(i)).isTrue()) {
                return RubyFixnum.newFixnum(this.getRuby(), i);
            }
            --i;
        }
        return this.getRuby().getNil();
    }

    public RubyArray indexes(RubyObject[] args) {
        RubyObject[] result = new RubyObject[args.length];
        boolean taint = false;
        int i = 0;
        while (i < args.length) {
            result[i] = this.entry(RubyNumeric.fix2int(args[i]));
            taint |= result[i].isTaint();
            ++i;
        }
        RubyArray ary = RubyArray.create(this.getRuby(), this, result);
        ary.setTaint(taint);
        return ary;
    }

    public RubyObject rbClone() {
        RubyArray ary = RubyArray.newArray(this.getRuby(), this.list);
        ary.infectObject(this);
        return ary;
    }

    public RubyObject reverse_bang() {
        this.modify();
        Collections.reverse(this.list);
        return this;
    }

    public RubyObject reverse() {
        RubyArray ary = (RubyArray)this.dup();
        ary.reverse_bang();
        return ary;
    }

    public RubyArray collect() {
        if (!this.getRuby().isBlockGiven()) {
            return (RubyArray)this.dup();
        }
        ArrayList<RubyObject> ary = new ArrayList<RubyObject>();
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            ary.add(this.getRuby().yield(this.entry(i)));
            ++i;
        }
        return new RubyArray(this.getRuby(), ary);
    }

    public RubyArray collect_bang() {
        this.modify();
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.list.set(i, this.getRuby().yield(this.entry(i)));
            ++i;
        }
        return this;
    }

    public RubyObject delete(RubyObject obj) {
        this.modify();
        RubyObject retVal = this.getRuby().getNil();
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (obj.funcall("==", this.entry(i)).isTrue()) {
                retVal = (RubyObject)this.list.remove(i);
            }
            --i;
        }
        if (retVal.isNil() && this.getRuby().isBlockGiven()) {
            retVal = this.getRuby().yield(this.entry(0L));
        }
        return retVal;
    }

    public RubyObject delete_at(RubyObject obj) {
        this.modify();
        int pos = (int)RubyNumeric.num2long(obj);
        int len = this.getLength();
        if (pos >= len) {
            return this.getRuby().getNil();
        }
        if (pos < 0 && (pos += len) < 0) {
            return this.getRuby().getNil();
        }
        return (RubyObject)this.list.remove(pos);
    }

    public RubyObject reject_bang() {
        this.modify();
        RubyObject retVal = this.getRuby().getNil();
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (this.getRuby().yield(this.entry(i)).isTrue()) {
                retVal = (RubyObject)this.list.remove(i);
            }
            --i;
        }
        return retVal.isNil() ? retVal : this;
    }

    public RubyObject delete_if() {
        this.reject_bang();
        return this;
    }

    public RubyObject replace(RubyObject other) {
        this.replace(0L, this.getLength(), RubyArray.arrayValue(other));
        return this;
    }

    public RubyObject op_cmp(RubyObject other) {
        RubyArray ary = RubyArray.arrayValue(other);
        int otherLen = ary.getLength();
        int len = this.getLength();
        if (len != otherLen) {
            return len > otherLen ? RubyFixnum.one(this.getRuby()) : RubyFixnum.minus_one(this.getRuby());
        }
        int i = 0;
        while (i < len) {
            RubyFixnum result = (RubyFixnum)this.entry(i).funcall("<=>", ary.entry(i));
            if (result.getLongValue() != 0L) {
                return result;
            }
            ++i;
        }
        return RubyFixnum.zero(this.getRuby());
    }

    public RubyObject slice_bang(RubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        RubyObject result = this.aref(args);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            this.replace(beg, len, this.getRuby().getNil());
        } else if (args[0] instanceof RubyFixnum && RubyNumeric.fix2long(args[0]) < (long)this.getLength()) {
            this.replace(RubyNumeric.fix2long(args[0]), 1L, this.getRuby().getNil());
        } else if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], this.getRuby().getNil());
        }
        return result;
    }

    public RubyObject assoc(RubyObject arg) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            RubyArray ary;
            if (this.entry(i) instanceof RubyArray && ((RubyArray)this.entry(i)).getLength() > 0 && arg.funcall("==", (ary = (RubyArray)this.entry(i)).entry(0L)).isTrue()) {
                return ary;
            }
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject rassoc(RubyObject arg) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            RubyArray ary;
            if (this.entry(i) instanceof RubyArray && ((RubyArray)this.entry(i)).getLength() > 1 && arg.funcall("==", (ary = (RubyArray)this.entry(i)).entry(1L)).isTrue()) {
                return ary;
            }
            ++i;
        }
        return this.getRuby().getNil();
    }

    public RubyObject flatten_bang() {
        this.modify();
        if (this.flatten(this.list)) {
            return this;
        }
        return this.getRuby().getNil();
    }

    public RubyObject flatten() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.flatten_bang();
        return rubyArray;
    }

    public RubyObject nitems() {
        int count = 0;
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            count += this.entry(i).isNil() ? 0 : 1;
            ++i;
        }
        return RubyFixnum.newFixnum(this.getRuby(), count);
    }

    public RubyObject op_plus(RubyObject other) {
        ArrayList otherList = RubyArray.arrayValue(other).getList();
        ArrayList newList = new ArrayList(this.getLength() + otherList.size());
        newList.addAll(this.list);
        newList.addAll(otherList);
        return new RubyArray(this.getRuby(), newList);
    }

    public RubyObject op_times(RubyObject arg) {
        if (arg instanceof RubyString) {
            return this.join((RubyString)arg);
        }
        int len = (int)RubyNumeric.num2long(arg);
        if (len < 0) {
            throw new RubyArgumentException(this.getRuby(), "negative argument");
        }
        ArrayList newList = new ArrayList(this.getLength() * len);
        int i = 0;
        while (i < len) {
            newList.addAll(this.list);
            ++i;
        }
        return new RubyArray(this.getRuby(), newList);
    }

    private ArrayList uniq(List oldList) {
        int oldLength = oldList.size();
        ArrayList<RubyObject> newList = new ArrayList<RubyObject>(oldLength);
        int i = 0;
        while (i < oldLength) {
            RubyObject obj = (RubyObject)oldList.get(i);
            boolean found = false;
            int newLength = newList.size();
            int j = 0;
            while (j < newLength) {
                if (obj.funcall("==", (RubyObject)newList.get(j)).isTrue()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                newList.add(obj);
            }
            ++i;
        }
        newList.trimToSize();
        return newList;
    }

    public RubyObject uniq_bang() {
        this.modify();
        ArrayList newList = this.uniq(this.list);
        if (newList.equals(this.list)) {
            return this.getRuby().getNil();
        }
        this.list = newList;
        return this;
    }

    public RubyObject uniq() {
        return new RubyArray(this.getRuby(), this.uniq(this.list));
    }

    public RubyObject op_diff(RubyObject other) {
        ArrayList ary1 = this.uniq(this.list);
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        int len2 = ary2.size();
        int i = ary1.size() - 1;
        while (i >= 0) {
            RubyObject obj = (RubyObject)ary1.get(i);
            int j = 0;
            while (j < len2) {
                if (obj.funcall("==", (RubyObject)ary2.get(j)).isTrue()) {
                    ary1.remove(i);
                    break;
                }
                ++j;
            }
            --i;
        }
        return new RubyArray(this.getRuby(), ary1);
    }

    public RubyObject op_and(RubyObject other) {
        ArrayList ary1 = this.uniq(this.list);
        int len1 = ary1.size();
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        int len2 = ary2.size();
        ArrayList<RubyObject> ary3 = new ArrayList<RubyObject>(len1);
        int i = 0;
        while (i < len1) {
            RubyObject obj = (RubyObject)ary1.get(i);
            int j = 0;
            while (j < len2) {
                if (obj.funcall("==", (RubyObject)ary2.get(j)).isTrue()) {
                    ary3.add(obj);
                    break;
                }
                ++j;
            }
            ++i;
        }
        ary3.trimToSize();
        return new RubyArray(this.getRuby(), ary3);
    }

    public RubyObject op_or(RubyObject other) {
        ArrayList ary1 = new ArrayList(this.list);
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        ary1.addAll(ary2);
        return new RubyArray(this.getRuby(), this.uniq(ary1));
    }

    public RubyArray sort() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.sort_bang();
        return rubyArray;
    }

    public RubyObject sort_bang() {
        if (this.getLength() <= 1) {
            return this.getRuby().getNil();
        }
        this.modify();
        this.setTmpLock(true);
        if (this.getRuby().isBlockGiven()) {
            Collections.sort(this.list, new BlockComparator());
        } else {
            Collections.sort(this.list, new DefaultComparator());
        }
        this.setTmpLock(false);
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            RubyObject obj1 = (RubyObject)o1;
            RubyObject obj2 = (RubyObject)o2;
            if (o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                return (int)(RubyNumeric.fix2long(obj1) - RubyNumeric.fix2long(obj2));
            }
            if (o1 instanceof RubyString && o2 instanceof RubyString) {
                return RubyNumeric.fix2int(((RubyString)o1).op_cmp((RubyObject)o2));
            }
            return RubyNumeric.fix2int(obj1.funcall("<=>", obj2));
        }

        public boolean equals(Object other) {
            return this == other;
        }
    }

    class BlockComparator
    implements Comparator {
        BlockComparator() {
        }

        public int compare(Object o1, Object o2) {
            RubyObject result = RubyArray.this.getRuby().yield(RubyArray.newArray(RubyArray.this.getRuby(), (RubyObject)o1, (RubyObject)o2));
            return (int)((RubyNumeric)result).getLongValue();
        }

        public boolean equals(Object other) {
            return this == other;
        }
    }
}

