/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;

public class RubyException
extends RubyObject {
    static /* synthetic */ Class class$org$jruby$RubyException;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyException(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createExceptionClass(Ruby ruby) {
        RubyClass exceptionClass = ruby.defineClass("Exception", ruby.getClasses().getObjectClass());
        exceptionClass.defineSingletonMethod("exception", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "newInstance"));
        exceptionClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "initialize"));
        exceptionClass.defineMethod("exception", CallbackFactory.getOptMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "exception"));
        exceptionClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "to_s"));
        exceptionClass.defineMethod("to_str", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "to_s"));
        exceptionClass.defineMethod("message", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "to_s"));
        exceptionClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "inspect"));
        exceptionClass.defineMethod("backtrace", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "backtrace"));
        exceptionClass.defineMethod("set_backtrace", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "set_backtrace", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyException.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        return exceptionClass;
    }

    private RubyArray createBacktrace(RubyObject newBackTrace) {
        if (newBackTrace instanceof RubyString) {
            return RubyArray.newArray(this.ruby, newBackTrace);
        }
        if (newBackTrace instanceof RubyArray) {
            int i = 0;
            while (i < ((RubyArray)newBackTrace).getLength()) {
                if (!(((RubyArray)newBackTrace).entry(i) instanceof RubyString)) {
                    throw new TypeError(this.ruby, "backtrace must be Array of String");
                }
                ++i;
            }
            return (RubyArray)newBackTrace;
        }
        throw new TypeError(this.ruby, "backtrace must be Array of String");
    }

    public static RubyException newException(Ruby ruby, RubyClass excptnClass, String msg) {
        RubyException newException = new RubyException(ruby, excptnClass);
        newException.setInstanceVar("mesg", RubyString.newString(ruby, msg));
        return newException;
    }

    public static RubyException newInstance(Ruby ruby, RubyObject recv, RubyObject[] args) {
        RubyException newException = new RubyException(ruby, (RubyClass)recv);
        newException.callInit(args);
        return newException;
    }

    public RubyObject initialize(RubyObject[] args) {
        if (args.length > 0) {
            this.setInstanceVar("mesg", args[0]);
        }
        return this;
    }

    public RubyArray backtrace() {
        if (!this.isInstanceVarDefined("bt")) {
            return RubyArray.nilArray(this.ruby);
        }
        return (RubyArray)this.getInstanceVar("bt");
    }

    public RubyArray set_backtrace(RubyObject newBacktrace) {
        return (RubyArray)this.setInstanceVar("bt", this.createBacktrace(newBacktrace));
    }

    public RubyException exception(RubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this;
            }
            case 1: {
                return RubyException.newInstance(this.getRuby(), this.getRubyClass(), args);
            }
        }
        throw new RubyArgumentException(this.getRuby(), "Wrong argument count");
    }

    public RubyString to_s() {
        RubyObject message = this.getInstanceVar("mesg");
        if (message.isNil()) {
            return this.getRubyClass().getClassPath();
        }
        message.setTaint(this.isTaint());
        return (RubyString)message;
    }

    public RubyString inspect() {
        RubyClass rubyClass = this.getRubyClass();
        RubyString exception = RubyString.stringValue(this);
        if (exception.getValue().length() == 0) {
            return rubyClass.getClassPath();
        }
        StringBuffer sb = new StringBuffer();
        sb.append("#<");
        sb.append(rubyClass.getClassPath().getValue());
        sb.append(": ");
        sb.append(exception.getValue());
        sb.append(">");
        return RubyString.newString(this.getRuby(), sb.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

