/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;

public class RubyFloat
extends RubyNumeric {
    private double value;
    static /* synthetic */ Class class$org$jruby$RubyFloat;
    static /* synthetic */ Class class$org$jruby$RubyObject;

    public RubyFloat(Ruby ruby) {
        this(ruby, 0.0);
    }

    public RubyFloat(Ruby ruby, double value) {
        super(ruby, ruby.getClasses().getFloatClass());
        this.value = value;
    }

    public Class getJavaClass() {
        return Double.TYPE;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return (long)this.value;
    }

    public static RubyClass createFloatClass(Ruby ruby) {
        RubyClass floatClass = ruby.defineClass("Float", ruby.getClasses().getNumericClass());
        floatClass.defineMethod("to_i", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "to_i"));
        floatClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "to_s"));
        floatClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "hash"));
        floatClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_plus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_minus", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_mul", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("/", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_div", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("%", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_mod", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("**", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_pow", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_equal", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_cmp", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod(">", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_gt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod(">=", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_ge", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("<", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_lt", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("<=", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "op_le", class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyFloat.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject));
        floatClass.defineMethod("floor", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "floor"));
        floatClass.defineMethod("ceil", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "ceil"));
        floatClass.defineMethod("round", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "round"));
        floatClass.defineMethod("truncate", CallbackFactory.getMethod(class$org$jruby$RubyFloat == null ? (class$org$jruby$RubyFloat = RubyFloat.class$("org.jruby.RubyFloat")) : class$org$jruby$RubyFloat, "truncate"));
        return floatClass;
    }

    protected int compareValue(RubyNumeric other) {
        double otherVal = other.getDoubleValue();
        return this.getValue() > otherVal ? 1 : (this.getValue() < otherVal ? -1 : 0);
    }

    public static RubyFloat newFloat(Ruby ruby, double value) {
        return new RubyFloat(ruby, value);
    }

    public RubyFixnum hash() {
        return new RubyFixnum(this.getRuby(), new Double(this.value).hashCode());
    }

    public RubyArray coerce(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyArray.newArray(this.getRuby(), this, RubyFloat.newFloat(this.getRuby(), other.getDoubleValue()));
    }

    public RubyInteger ceil() {
        double val = Math.ceil(this.getDoubleValue());
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            return RubyBignum.newBignum(this.getRuby(), val);
        }
        return RubyFixnum.newFixnum(this.getRuby(), (long)val);
    }

    public RubyInteger floor() {
        double val = Math.floor(this.getDoubleValue());
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            return RubyBignum.newBignum(this.getRuby(), val);
        }
        return RubyFixnum.newFixnum(this.getRuby(), (long)val);
    }

    public RubyInteger round() {
        double val = Math.round(this.getDoubleValue());
        if (val < -9.223372036854776E18 || val > 9.223372036854776E18) {
            return RubyBignum.newBignum(this.getRuby(), val);
        }
        return RubyFixnum.newFixnum(this.getRuby(), (long)val);
    }

    public RubyInteger truncate() {
        if (this.getDoubleValue() > 0.0) {
            return this.floor();
        }
        if (this.getDoubleValue() < 0.0) {
            return this.ceil();
        }
        return RubyFixnum.zero(this.getRuby());
    }

    public RubyNumeric op_uminus() {
        return RubyFloat.newFloat(this.getRuby(), -this.value);
    }

    public RubyNumeric op_plus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue() + other.getDoubleValue());
    }

    public RubyNumeric op_minus(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue() - other.getDoubleValue());
    }

    public RubyNumeric op_mul(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue() * other.getDoubleValue());
    }

    public RubyNumeric op_div(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue() / other.getDoubleValue());
    }

    public RubyNumeric op_mod(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuby(), this.getDoubleValue() % other.getDoubleValue());
    }

    public RubyNumeric op_pow(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFloat.newFloat(this.getRuby(), Math.pow(this.getDoubleValue(), other.getDoubleValue()));
    }

    public RubyBoolean op_equal(RubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return this.getRuby().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue((RubyNumeric)other) == 0);
    }

    public RubyNumeric op_cmp(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFixnum.newFixnum(this.getRuby(), this.compareValue(other));
    }

    public RubyBoolean op_gt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) > 0);
    }

    public RubyBoolean op_ge(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) >= 0);
    }

    public RubyBoolean op_lt(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) < 0);
    }

    public RubyBoolean op_le(RubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuby(), this.compareValue(other) <= 0);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuby(), Double.toString(this.getValue()));
    }

    public RubyInteger to_i() {
        return RubyFixnum.newFixnum(this.getRuby(), this.getLongValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

