/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import org.jruby.Ruby;
import org.jruby.RubyJavaObject;
import org.jruby.RubyObject;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RubyArgumentException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Callback;

public class JavaMethod
implements Callback {
    private Method[] methods = null;
    private boolean callSuper = false;
    private boolean singleton = false;

    public JavaMethod(Method[] methods, boolean callSuper) {
        this(methods, callSuper, false);
    }

    public JavaMethod(Method[] methods, boolean callSuper, boolean singleton) {
        this.methods = methods;
        this.callSuper = callSuper;
        this.singleton = singleton;
    }

    public RubyObject execute(RubyObject recv, RubyObject[] args, Ruby ruby) {
        Method method;
        LinkedList<Method> executeMethods = new LinkedList<Method>(Arrays.asList(this.methods));
        int argsLength = args != null ? args.length : 0;
        Iterator iter = executeMethods.iterator();
        while (iter.hasNext()) {
            method = (Method)iter.next();
            if (method.getParameterTypes().length == argsLength) continue;
            iter.remove();
        }
        iter = executeMethods.iterator();
        block3: while (iter.hasNext()) {
            method = (Method)iter.next();
            int i = 0;
            while (i < method.getParameterTypes().length) {
                if (!JavaUtil.isCompatible(args[i], method.getParameterTypes()[i])) {
                    iter.remove();
                    continue block3;
                }
                ++i;
            }
        }
        if (executeMethods.isEmpty()) {
            if (this.callSuper) {
                ruby.getRuntime().callSuper(args);
            } else {
                throw new RubyArgumentException(ruby, "wrong argument count or types.");
            }
        }
        method = executeMethods.getFirst();
        Object[] newArgs = new Object[argsLength];
        int i = 0;
        while (i < argsLength) {
            newArgs[i] = JavaUtil.convertRubyToJava(ruby, args[i], method.getParameterTypes()[i]);
            ++i;
        }
        try {
            Object receiver = !this.singleton ? ((RubyJavaObject)recv).getValue() : null;
            Object result = method.invoke(receiver, newArgs);
            return JavaUtil.convertJavaToRuby(ruby, result, method.getReturnType());
        }
        catch (Exception excptn) {
            throw new RaiseException(ruby, "RuntimeError", excptn.getMessage());
        }
    }
}

