/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;

public class DefinedNode
extends Node {
    public DefinedNode(Node headNode) {
        super(95, (Object)headNode, null, null);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        String def = this.getDefined(ruby, self);
        if (def == null) {
            return ruby.getNil();
        }
        return new RubyString(ruby, def);
    }

    public String getDefined(Ruby ruby, RubyObject self) {
        Node head = this.getHeadNode();
        switch (head.getType()) {
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 57: 
            case 58: {
                return "method";
            }
            case 46: {
                return ruby.isBlockGiven() ? "yield" : null;
            }
            case 91: {
                return "self";
            }
            case 92: {
                return "nil";
            }
            case 93: {
                return "true";
            }
            case 94: {
                return "false";
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 90: {
                return "assignment";
            }
            case 47: {
                return "local-variable";
            }
            case 48: {
                return "local-variable(in-block)";
            }
            case 49: {
                return "global-variable";
            }
            case 50: {
                return self.isInstanceVarDefined(head.getVId()) ? "instance-variable" : null;
            }
            case 51: {
                return "constant";
            }
            case 52: {
                return "class variable";
            }
            case 53: 
            case 83: {
                return null;
            }
            case 54: {
                return null;
            }
            case 55: {
                return null;
            }
        }
        try {
            self.eval(head);
            return "expression";
        }
        catch (JumpException jumpExcptn) {
            return null;
        }
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitDefinedNode(this);
    }
}

