/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;

public class DotNode
extends Node {
    private boolean exclusive;
    private boolean cannotCached = false;
    private RubyObject cachedValue = null;

    public DotNode(Node beginNode, Node endNode, boolean exclusive) {
        super(exclusive ? 87 : 86, (Object)beginNode, (Object)endNode, null);
        this.exclusive = exclusive;
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        if (this.cachedValue != null) {
            return this.cachedValue;
        }
        RubyRange result = RubyRange.newRange(ruby, self.eval(this.getBeginNode()), self.eval(this.getEndNode()), this.exclusive);
        if (this.cannotCached) {
            return result;
        }
        if (this.getBeginNode().getLiteral() instanceof RubyFixnum && this.getEndNode().getLiteral() instanceof RubyFixnum) {
            this.cachedValue = result;
        } else {
            this.cannotCached = true;
        }
        return result;
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitDotNode(this);
    }
}

