/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitorAdapter;
import org.jruby.runtime.Constants;

public class DumpVisitor
extends NodeVisitorAdapter {
    StringBuffer _buffer = new StringBuffer();
    StringBuffer _Indent = new StringBuffer();

    private void indent() {
        this._Indent.append('\t');
    }

    private void undent() {
        int lTabDepth = this._Indent.length();
        if (lTabDepth == 0) {
            this._Indent.setLength(0);
        } else {
            this._Indent.setLength(lTabDepth - 1);
        }
    }

    public String dump() {
        return this._buffer.toString();
    }

    protected void visit(Node iVisited) {
        this.visit(iVisited, true);
    }

    protected void visit(Node iVisited, boolean mayLeave) {
        this._buffer.append(this._Indent.toString()).append("<").append(Constants.NODE_TRANSLATOR[iVisited.getType()]);
        switch (iVisited.getType()) {
            case 96: {
                this._buffer.append(" file='").append(iVisited.getFile()).append("' line='").append(iVisited.getLine()).append("'");
                break;
            }
            case 26: 
            case 27: 
            case 29: 
            case 31: {
                this._buffer.append(" id='").append(iVisited.getVId()).append("'");
                break;
            }
            case 28: {
                this._buffer.append(" id='").append(iVisited.getEntry().getId()).append("'");
                break;
            }
            case 25: {
                this._buffer.append(" count='").append(iVisited.getCount()).append("'");
                break;
            }
            case 59: {
                this._buffer.append(" value='").append(iVisited.getLiteral().toString()).append("'");
                break;
            }
            case 75: {
                this._buffer.append(" mId='").append(iVisited.getMId()).append("' noex='").append(iVisited.getNoex()).append("'");
                break;
            }
            case 67: {
                this._buffer.append(" rest='").append(iVisited.getRest()).append("' count='").append(iVisited.getCount()).append("'");
            }
        }
        if (mayLeave) {
            this._buffer.append(">\n");
            this.indent();
        } else {
            this._buffer.append("/>\n");
        }
    }

    protected void leave(Node iVisited) {
        this.undent();
        this._buffer.append(this._Indent.toString()).append("</").append(Constants.NODE_TRANSLATOR[iVisited.getType()]).append(">\n");
    }
}

