/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyObject;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;

public class FlipNode
extends Node {
    private boolean exclusive;

    public FlipNode(Node beginNode, Node endNode, boolean exclusive) {
        super(exclusive ? 89 : 88, (Object)beginNode, (Object)endNode, null);
        this.exclusive = exclusive;
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        if (this.exclusive) {
            return this.evalFlip3(ruby, self);
        }
        return this.evalFlip2(ruby, self);
    }

    private RubyObject evalFlip2(Ruby ruby, RubyObject self) {
        if (ruby.getScope().getValue(this.getCount()).isFalse()) {
            if (this.getBeginNode().eval(ruby, self).isTrue()) {
                ruby.getScope().setValue(this.getCount(), this.getEndNode().eval(ruby, self).isTrue() ? ruby.getFalse() : ruby.getTrue());
                return ruby.getTrue();
            }
            return ruby.getFalse();
        }
        if (this.getEndNode().eval(ruby, self).isTrue()) {
            ruby.getScope().setValue(this.getCount(), ruby.getFalse());
        }
        return ruby.getTrue();
    }

    private RubyObject evalFlip3(Ruby ruby, RubyObject self) {
        if (ruby.getScope().getValue(this.getCount()).isFalse()) {
            RubyBoolean result = this.getBeginNode().eval(ruby, self).isTrue() ? ruby.getFalse() : ruby.getTrue();
            ruby.getScope().setValue(this.getCount(), result);
            return result;
        }
        if (this.getEndNode().eval(ruby, self).isTrue()) {
            ruby.getScope().setValue(this.getCount(), ruby.getFalse());
        }
        return ruby.getTrue();
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitFlip2Node(this);
    }
}

