/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeVisitor;
import org.jruby.nodes.ScopeNode;

public class ModuleNode
extends Node {
    public ModuleNode(String className, Node bodyNode) {
        super(81, (Object)className, (Object)bodyNode, null);
    }

    public RubyObject eval(Ruby ruby, RubyObject self) {
        if (ruby.getRubyClass() == null) {
            throw new TypeError(ruby, "no outer class/module");
        }
        RubyModule module = null;
        if (ruby.getRubyClass() != ruby.getClasses().getObjectClass() || ruby.isAutoloadDefined(this.getClassNameId())) {
            // empty if block
        }
        if (ruby.getRubyClass().isConstantDefined(this.getClassNameId())) {
            module = (RubyModule)ruby.getRubyClass().getConstant(this.getClassNameId());
        }
        if (module != null) {
            if (ruby.getSafeLevel() >= 4) {
                throw new RubySecurityException(ruby, "extending module prohibited");
            }
        } else {
            module = ruby.defineModule(this.getClassNameId());
            ruby.getRubyClass().setConstant(this.getClassNameId(), module);
            module.setClassPath(ruby.getRubyClass(), this.getClassNameId());
        }
        if (ruby.getWrapper() != null) {
            module.getSingletonClass().includeModule(ruby.getWrapper());
            module.includeModule(ruby.getWrapper());
        }
        return ((ScopeNode)this.getBodyNode()).setupModule(ruby, module);
    }

    public void accept(NodeVisitor iVisitor) {
        iVisitor.visitModuleNode(this);
    }
}

