/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nodes.util;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyObject;
import org.jruby.nodes.ArrayNode;
import org.jruby.nodes.Node;
import org.jruby.runtime.RubyBlock;
import org.jruby.util.RubyPointer;

public class ArgsUtil {
    public static RubyBlock beginCallArgs(Ruby ruby) {
        RubyBlock tmpBlock = ruby.getBlock().getTmp();
        if (ruby.getIter().getIter() == 1) {
            ruby.getBlock().pop();
        }
        ruby.getIter().push(0);
        return tmpBlock;
    }

    public static void endCallArgs(Ruby ruby, RubyBlock tmpBlock) {
        ruby.getBlock().setTmp(tmpBlock);
        ruby.getIter().pop();
    }

    public static RubyPointer setupArgs(Ruby ruby, RubyObject self, ArrayNode node) {
        String file = ruby.getSourceFile();
        int line = ruby.getSourceLine();
        RubyPointer args = new RubyPointer(node.getArrayList(ruby, self));
        ruby.setSourceFile(file);
        ruby.setSourceLine(line);
        return args;
    }

    public static RubyPointer setupArgs(Ruby ruby, RubyObject self, Node node) {
        if (node != null) {
            if (node instanceof ArrayNode) {
                String file = ruby.getSourceFile();
                int line = ruby.getSourceLine();
                RubyPointer args = new RubyPointer(((ArrayNode)node).getArrayList(ruby, self));
                ruby.setSourceFile(file);
                ruby.setSourceLine(line);
                return args;
            }
            RubyObject args = node.eval(ruby, self);
            String file = ruby.getSourceFile();
            int line = ruby.getSourceLine();
            if (!(args instanceof RubyArray)) {
                args = RubyArray.newArray(ruby, args);
            }
            ruby.setSourceFile(file);
            ruby.setSourceLine(line);
            return new RubyPointer(((RubyArray)args).getList());
        }
        return null;
    }
}

