/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.nodes.DRegxNode;
import org.jruby.nodes.DRegxOnceNode;
import org.jruby.nodes.DXStrNode;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeFactory;
import org.jruby.nodes.types.StrNodeConvertable;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.ParserHelper;
import org.jruby.parser.kwtable;

public class DefaultRubyScanner
implements DefaultRubyParser.yyInput {
    private Ruby ruby;
    private ParserHelper ph;
    private NodeFactory nf;
    private int token = 0;
    private String lex_curline;
    private int lex_pbeg;
    private int lex_p;
    private int lex_pend;
    private int lex_gets_ptr;
    private RubyObject lex_input;
    private RubyObject lex_lastline;
    private boolean lex_file_io;
    private StringBuffer tokenbuf;
    private Object yyVal;
    private long cond_stack;
    private int cond_nest = 0;
    private long cmdarg_stack;

    public DefaultRubyScanner(Ruby ruby) {
        this.ruby = ruby;
        this.ph = ruby.getParserHelper();
        this.nf = new NodeFactory(ruby);
    }

    public boolean advance() throws IOException {
        this.token = this.yylex();
        return this.token != 0;
    }

    public int token() {
        return this.token;
    }

    public Object value() {
        return this.yyVal;
    }

    public void COND_PUSH() {
        ++this.cond_nest;
        this.cond_stack = this.cond_stack << 1 | 1L;
    }

    public void COND_POP() {
        --this.cond_nest;
        this.cond_stack >>= 1;
    }

    private boolean COND_P() {
        return this.cond_nest > 0 && (this.cond_stack & 1L) != 0L;
    }

    public void CMDARG_PUSH() {
        this.cmdarg_stack = this.cmdarg_stack << 1 | 1L;
    }

    public void CMDARG_POP() {
        this.cmdarg_stack >>= 1;
    }

    private boolean CMDARG_P() {
        return this.cmdarg_stack != 0L && (this.cmdarg_stack & 1L) != 0L;
    }

    public void resetStacks() {
        this.cond_nest = 0;
        this.cond_stack = 0L;
        this.cmdarg_stack = 0L;
    }

    private kwtable rb_reserved_word(String w, int len) {
        return kwtable.rb_reserved_word(w, len);
    }

    private RubyInteger rb_cstr2inum(String s, int radix) {
        return RubyNumeric.str2inum(this.ruby, RubyString.newString(this.ruby, s), radix);
    }

    private RubyRegexp rb_reg_new(String s, int len, int options) {
        return RubyRegexp.newRegexp(this.ruby, RubyString.newString(this.ruby, s, len), options);
    }

    private void yyerror(String msg) {
        System.err.println(msg);
    }

    private boolean is_identchar(int ch) {
        return Character.isLetterOrDigit((char)ch) || ch == 95;
    }

    private RubyObject lex_gets_str(RubyObject _s) {
        String s = ((RubyString)_s).getValue();
        if (this.lex_gets_ptr != 0) {
            if (s.length() == this.lex_gets_ptr) {
                return this.ruby.getNil();
            }
            s = s.substring(this.lex_gets_ptr);
        }
        int end = 0;
        while (end < s.length()) {
            if (s.charAt(end++) != '\n') continue;
            this.ph.incrementLine();
            break;
        }
        this.lex_gets_ptr += end;
        return RubyString.newString(this.ruby, s, end);
    }

    private RubyObject lex_getline() {
        if (this.lex_file_io) {
            throw new Error();
        }
        RubyObject line = this.lex_gets_str(this.lex_input);
        if (this.ph.getRubyDebugLines() != null && !line.isNil()) {
            this.ph.getRubyDebugLines().push(line);
        }
        return line;
    }

    private int nextc() {
        int c;
        if (this.lex_p == this.lex_pend) {
            if (this.lex_input != null) {
                RubyObject v = this.lex_getline();
                if (v.isNil()) {
                    return -1;
                }
                if (this.ph.getHeredocEnd() > 0) {
                    this.ruby.setSourceLine(this.ph.getHeredocEnd());
                    this.ph.setHeredocEnd(0);
                }
                this.ruby.setSourceLine(this.ruby.getSourceLine() + 1);
                this.lex_curline = ((RubyString)v).getValue();
                this.lex_pbeg = 0;
                this.lex_p = 0;
                this.lex_pend = this.lex_curline.length();
                if (this.lex_curline.startsWith("__END__") && (this.lex_pend == 7 || this.lex_curline.charAt(7) == '\n' || this.lex_curline.charAt(7) == '\r')) {
                    this.ph.setRubyEndSeen(true);
                    this.lex_lastline = null;
                    return -1;
                }
                this.lex_lastline = v;
            } else {
                this.lex_lastline = null;
                return -1;
            }
        }
        if ((c = this.lex_curline.charAt(this.lex_p++)) == 13 && this.lex_p <= this.lex_pend && this.lex_curline.charAt(this.lex_p) == '\n') {
            ++this.lex_p;
            c = 10;
        }
        return c;
    }

    private void pushback(int c) {
        if (c == -1) {
            return;
        }
        --this.lex_p;
    }

    private boolean peek(int c) {
        return this.lex_p != this.lex_pend && c == this.lex_curline.charAt(this.lex_p);
    }

    private String tok() {
        return this.tokenbuf.toString();
    }

    private int toklen() {
        return this.tokenbuf.length();
    }

    private void tokfix() {
    }

    private char toklast() {
        return this.tokenbuf.charAt(this.toklen() - 1);
    }

    private void newtok() {
        this.tokenbuf = new StringBuffer(60);
    }

    private void tokadd(int c) {
        this.tokenbuf.append((char)c);
    }

    private int read_escape() {
        int c = this.nextc();
        switch (c) {
            case 92: {
                return c;
            }
            case 110: {
                return 10;
            }
            case 116: {
                return 9;
            }
            case 114: {
                return 13;
            }
            case 102: {
                return 12;
            }
            case 118: {
                return 11;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                int cc = 0;
                this.pushback(c);
                int i = 0;
                while (i < 3) {
                    c = this.nextc();
                    if (c == -1) {
                        this.yyerror("Invalid escape character syntax");
                        return 0;
                    }
                    if (c < 48 || 55 < c) {
                        this.pushback(c);
                        break;
                    }
                    cc = cc * 8 + c - 48;
                    ++i;
                }
                c = cc;
                return c;
            }
            case 120: {
                int[] numlen = new int[1];
                c = (int)this.scan_hex(this.lex_curline, this.lex_p, 2, numlen);
                this.lex_p += numlen[0];
                return c;
            }
            case 98: {
                return 8;
            }
            case 115: {
                return 32;
            }
            case 77: {
                c = this.nextc();
                if (c != 45) {
                    this.yyerror("Invalid escape character syntax");
                    this.pushback(c);
                    return 0;
                }
                c = this.nextc();
                if (c == 92) {
                    return this.read_escape() | 0x80;
                }
                if (c == -1) {
                    this.yyerror("Invalid escape character syntax");
                    return 0;
                }
                return c & 0xFF | 0x80;
            }
            case 67: {
                c = this.nextc();
                if (c != 45) {
                    this.yyerror("Invalid escape character syntax");
                    this.pushback(c);
                    return 0;
                }
            }
            case 99: {
                c = this.nextc();
                if (c == 92) {
                    c = this.read_escape();
                } else {
                    if (c == 63) {
                        return 127;
                    }
                    if (c == -1) {
                        this.yyerror("Invalid escape character syntax");
                        return 0;
                    }
                }
                return c & 0x9F;
            }
            case -1: {
                this.yyerror("Invalid escape character syntax");
                return 0;
            }
        }
        return c;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int tokadd_escape(int term) {
        int c = this.nextc();
        switch (c) {
            case 10: {
                return 0;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                this.tokadd(92);
                this.tokadd(c);
                int i = 0;
                while (true) {
                    if (i >= 2) {
                        return 0;
                    }
                    c = this.nextc();
                    if (c == -1) {
                        this.yyerror("Invalid escape character syntax");
                        return -1;
                    }
                    if (c < 48 || 55 < c) {
                        this.pushback(c);
                        return 0;
                    }
                    this.tokadd(c);
                    ++i;
                }
            }
            case 120: {
                this.tokadd(92);
                this.tokadd(c);
                int[] numlen = new int[1];
                this.scan_hex(this.lex_curline, this.lex_p, 2, numlen);
                while (true) {
                    int n = numlen[0];
                    numlen[0] = n - 1;
                    if (n == 0) {
                        return 0;
                    }
                    this.tokadd(this.nextc());
                }
            }
            case 77: {
                c = this.nextc();
                if (c != 45) {
                    this.yyerror("Invalid escape character syntax");
                    this.pushback(c);
                    return 0;
                }
                this.tokadd(92);
                this.tokadd(77);
                this.tokadd(45);
                c = this.nextc();
                if (c == 92) {
                    return this.tokadd_escape(term);
                }
                if (c == -1) {
                    this.yyerror("Invalid escape character syntax");
                    return -1;
                }
                this.tokadd(c);
                return 0;
            }
            case 67: {
                c = this.nextc();
                if (c != 45) {
                    this.yyerror("Invalid escape character syntax");
                    this.pushback(c);
                    return 0;
                }
                this.tokadd(92);
                this.tokadd(67);
                this.tokadd(45);
                c = this.nextc();
                if (c == 92) {
                    return this.tokadd_escape(term);
                }
                if (c == -1) {
                    this.yyerror("Invalid escape character syntax");
                    return -1;
                }
                this.tokadd(c);
                return 0;
            }
            case 99: {
                this.tokadd(92);
                this.tokadd(99);
                c = this.nextc();
                if (c == 92) {
                    return this.tokadd_escape(term);
                }
                if (c == -1) {
                    this.yyerror("Invalid escape character syntax");
                    return -1;
                }
                this.tokadd(c);
                return 0;
            }
            case -1: {
                this.yyerror("Invalid escape character syntax");
                return -1;
            }
        }
        if (c != term) {
            this.tokadd(92);
        }
        this.tokadd(c);
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private int parse_regx(int term, int paren) {
        int c;
        int kcode = 0;
        boolean once = false;
        int nest = 0;
        int options = 0;
        int re_start = this.ruby.getSourceLine();
        Node list = null;
        this.newtok();
        block16: while ((c = this.nextc()) != -1) {
            void var3_9;
            if (var3_9 == term && nest == 0) break;
            switch (var3_9) {
                case 35: {
                    list = this.str_extend(list, term);
                    if (list != Node.MINUS_ONE) continue block16;
                    return 0;
                }
                case 92: {
                    if (this.tokadd_escape(term) >= 0) continue block16;
                    return 0;
                }
                case -1: {
                    this.ruby.setSourceLine(re_start);
                    this.ph.rb_compile_error("unterminated regexp meets end of file");
                    return 0;
                }
                default: {
                    if (paren != 0) {
                        if (var3_9 == paren) {
                            ++nest;
                        }
                        if (var3_9 == term) {
                            --nest;
                        }
                    }
                    this.tokadd((int)var3_9);
                }
            }
        }
        block17: while (true) {
            c = this.nextc();
            switch (c) {
                case 105: {
                    options |= 1;
                    continue block17;
                }
                case 120: {
                    options |= 2;
                    continue block17;
                }
                case 112: {
                    this.ph.rb_warn("/p option is obsolete; use /m\n\tnote: /m does not change ^, $ behavior");
                    options |= 0xC;
                    continue block17;
                }
                case 109: {
                    options |= 4;
                    continue block17;
                }
                case 111: {
                    once = true;
                    continue block17;
                }
                case 110: {
                    kcode = 16;
                    continue block17;
                }
                case 101: {
                    kcode = 32;
                    continue block17;
                }
                case 115: {
                    kcode = 48;
                    continue block17;
                }
                case 117: {
                    kcode = 64;
                    continue block17;
                }
            }
            break;
        }
        this.pushback(c);
        this.tokfix();
        this.ph.setLexState(1);
        if (list != null) {
            list.setLine(re_start);
            if (this.toklen() > 0) {
                RubyString ss = RubyString.newString(this.ruby, this.tok(), this.toklen());
                this.ph.list_append(list, this.nf.newStr(ss));
            }
            list = once ? new DRegxOnceNode(list.getLiteral(), options | kcode) : new DRegxNode(list.getLiteral(), options | kcode);
            this.yyVal = list;
            return 317;
        }
        this.yyVal = this.rb_reg_new(this.tok(), this.toklen(), options | kcode);
        return 314;
    }

    /*
     * WARNING - void declaration
     */
    private int parse_string(int func, int term, int paren) {
        int c;
        Node list = null;
        int nest = 0;
        if (func == 39) {
            return this.parse_qstring(term, paren);
        }
        if (func == 0) {
            this.yyVal = RubyString.newString(this.ruby, this.lex_curline, this.lex_pend - 1);
            this.lex_p = this.lex_pend;
            return 312;
        }
        int strstart = this.ruby.getSourceLine();
        this.newtok();
        while ((c = this.nextc()) != term || nest > 0) {
            void var4_7;
            if (var4_7 == -1) {
                this.ruby.setSourceLine(strstart);
                this.ph.rb_compile_error("unterminated string meets end of file");
                return 0;
            }
            if (var4_7 == 35) {
                if ((list = this.str_extend(list, term)) != Node.MINUS_ONE) continue;
                this.ruby.setSourceLine(strstart);
                this.ph.rb_compile_error("unterminated string meets end of file");
                return 0;
            }
            if (var4_7 == 92) {
                c = this.nextc();
                if (c == 10) continue;
                if (c == term) {
                    this.tokadd(c);
                    continue;
                }
                this.pushback(c);
                if (func != 34) {
                    this.tokadd(92);
                }
                this.tokadd(this.read_escape());
                continue;
            }
            if (paren != 0) {
                if (c == paren) {
                    ++nest;
                }
                if (c == term && nest-- == 0) break;
            }
            this.tokadd(c);
        }
        this.tokfix();
        this.ph.setLexState(1);
        if (list != null) {
            list.setLine(strstart);
            if (this.toklen() > 0) {
                RubyString ss = RubyString.newString(this.ruby, this.tok(), this.toklen());
                this.ph.list_append(list, this.nf.newStr(ss));
            }
            this.yyVal = list;
            if (func == 96) {
                list = new DXStrNode(list.getLiteral());
                this.yyVal = list;
                return 316;
            }
            return 315;
        }
        this.yyVal = RubyString.newString(this.ruby, this.tok(), this.toklen());
        return func == 96 ? 313 : 312;
    }

    /*
     * WARNING - void declaration
     */
    private int parse_qstring(int term, int paren) {
        int c;
        int nest = 0;
        int strstart = this.ruby.getSourceLine();
        this.newtok();
        block4: while ((c = this.nextc()) != term || nest > 0) {
            void var4_5;
            if (var4_5 == -1) {
                this.ruby.setSourceLine(strstart);
                this.ph.rb_compile_error("unterminated string meets end of file");
                return 0;
            }
            if (var4_5 == 92) {
                c = this.nextc();
                switch (c) {
                    case 10: {
                        continue block4;
                    }
                    case 92: {
                        c = 92;
                        break;
                    }
                    default: {
                        if (c == term || paren != 0 && c == paren) {
                            this.tokadd(c);
                            continue block4;
                        }
                        this.tokadd(92);
                    }
                }
            }
            if (paren != 0) {
                if (c == paren) {
                    ++nest;
                }
                if (c == term && nest-- == 0) break;
            }
            this.tokadd(c);
        }
        this.tokfix();
        this.yyVal = RubyString.newString(this.ruby, this.tok(), this.toklen());
        this.ph.setLexState(1);
        return 312;
    }

    private int parse_quotedwords(int term, int paren) {
        Node str;
        Node qwords = null;
        int nest = 0;
        int strstart = this.ruby.getSourceLine();
        this.newtok();
        int c = this.nextc();
        while (this.ISSPACE(c)) {
            c = this.nextc();
        }
        this.pushback(c);
        block5: while ((c = this.nextc()) != term || nest > 0) {
            if (c == -1) {
                this.ruby.setSourceLine(strstart);
                this.ph.rb_compile_error("unterminated string meets end of file");
                return 0;
            }
            if (c == 92) {
                c = this.nextc();
                switch (c) {
                    case 10: {
                        continue block5;
                    }
                    case 92: {
                        c = 92;
                        break;
                    }
                    default: {
                        if (c == term || paren != 0 && c == paren) {
                            this.tokadd(c);
                            continue block5;
                        }
                        if (!this.ISSPACE(c)) {
                            this.tokadd(92);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (this.ISSPACE(c)) {
                this.tokfix();
                str = this.nf.newStr(RubyString.newString(this.ruby, this.tok(), this.toklen()));
                this.newtok();
                if (qwords == null) {
                    qwords = this.nf.newList(str);
                } else {
                    this.ph.list_append(qwords, str);
                }
                c = this.nextc();
                while (this.ISSPACE(c)) {
                    c = this.nextc();
                }
                this.pushback(c);
                continue;
            }
            if (paren != 0) {
                if (c == paren) {
                    ++nest;
                }
                if (c == term && nest-- == 0) break;
            }
            this.tokadd(c);
        }
        this.tokfix();
        if (this.toklen() > 0) {
            str = this.nf.newStr(RubyString.newString(this.ruby, this.tok(), this.toklen()));
            if (qwords == null) {
                qwords = this.nf.newList(str);
            } else {
                this.ph.list_append(qwords, str);
            }
        }
        if (qwords == null) {
            qwords = this.nf.newZArray();
        }
        this.yyVal = qwords;
        this.ph.setLexState(1);
        return 315;
    }

    /*
     * Unable to fully structure code
     */
    private int here_document(int term, int indent) {
        list = null;
        linesave = this.ruby.getSourceLine();
        this.newtok();
        switch (term) {
            case 34: 
            case 39: 
            case 96: {
                while ((c = this.nextc()) != term) {
                    this.tokadd((int)var3_5);
                }
                if (term != 39) break;
                term = 0;
                break;
            }
            default: {
                c = term;
                term = 34;
                if (this.is_identchar(c)) ** GOTO lbl20
                this.ph.rb_warn("use of bare << to mean <<\"\" is deprecated");
                break;
lbl-1000:
                // 1 sources

                {
                    this.tokadd(c);
                    c = this.nextc();
lbl20:
                    // 2 sources

                    ** while (this.is_identchar((int)c))
                }
lbl21:
                // 1 sources

                this.pushback(c);
            }
        }
        this.tokfix();
        lastline_save = this.lex_lastline;
        offset_save = this.lex_p - this.lex_pbeg;
        eos = this.tok();
        len = eos.length();
        str = RubyString.newString(this.ruby, "");
        while (true) {
            this.lex_lastline = line = this.lex_getline();
            if (line.isNil()) {
                this.ruby.setSourceLine(linesave);
                this.ph.rb_compile_error("can't find string \"" + eos + "\" anywhere before EOF");
                return 0;
            }
            this.ruby.setSourceLine(this.ruby.getSourceLine());
            p = ((RubyString)line).getValue();
            if (indent != 0) {
                while (Character.isWhitespace(p.charAt(0))) {
                    p = p.substring(1);
                }
            }
            if (p.startsWith(eos) && (p.charAt(len) == '\n' || p.charAt(len) == '\r' || len == ((RubyString)line).getValue().length())) break;
            this.lex_curline = ((RubyString)line).getValue();
            this.lex_p = 0;
            this.lex_pbeg = 0;
            this.lex_pend = this.lex_curline.length();
            do {
                switch (this.parse_string(term, 10, 10)) {
                    case 312: 
                    case 313: {
                        ((RubyString)this.yyVal).cat("\n");
                        if (list == null) {
                            str.concat((RubyString)this.yyVal);
                            break;
                        }
                        this.ph.list_append(list, this.nf.newStr((RubyObject)this.yyVal));
                        break;
                    }
                    case 315: {
                        if (list == null) {
                            list = this.nf.newDStr(str);
                        }
                    }
                    case 316: {
                        if (list == null) {
                            list = this.nf.newDXStr(str);
                        }
                        this.ph.list_append((Node)this.yyVal, this.nf.newStr(RubyString.newString(this.ruby, "\n")));
                        ((StrNodeConvertable)this.yyVal).convertToStrNode();
                        this.yyVal = this.nf.newList((Node)this.yyVal);
                        ((Node)this.yyVal).setNextNode(((Node)this.yyVal).getHeadNode().getNextNode());
                        this.ph.list_concat(list, (Node)this.yyVal);
                        break;
                    }
                    case 0: {
                        this.ruby.setSourceLine(linesave);
                        this.ph.rb_compile_error("can't find string \"" + eos + "\" anywhere before EOF");
                        return 0;
                    }
                }
            } while (this.lex_p != this.lex_pend);
        }
        this.lex_lastline = lastline_save;
        this.lex_curline = ((RubyString)this.lex_lastline).getValue();
        this.lex_pbeg = 0;
        this.lex_pend = this.lex_pbeg + this.lex_curline.length();
        this.lex_p = this.lex_pbeg + offset_save;
        this.ph.setLexState(1);
        this.ph.setHeredocEnd(this.ruby.getSourceLine());
        this.ruby.setSourceLine(linesave);
        if (list != null) {
            list.setLine(linesave + 1);
            this.yyVal = list;
        }
        switch (term) {
            case 0: 
            case 34: 
            case 39: {
                if (list != null) {
                    return 315;
                }
                this.yyVal = str;
                return 312;
            }
            case 96: {
                if (list != null) {
                    return 316;
                }
                this.yyVal = str;
                return 313;
            }
        }
        return 0;
    }

    private void arg_ambiguous() {
        this.ph.rb_warning("ambiguous first argument; make sure");
    }

    private boolean IS_ARG() {
        return this.ph.getLexState() == 2;
    }

    private int yylex() {
        int c;
        int space_seen = 0;
        block58: while (true) {
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return 0;
                }
                case 9: 
                case 11: 
                case 12: 
                case 13: 
                case 32: {
                    ++space_seen;
                    continue block58;
                }
                case 35: {
                    while ((c = this.nextc()) != 10) {
                        if (c != -1) continue;
                        return 0;
                    }
                }
                case 10: {
                    switch (this.ph.getLexState()) {
                        case 0: 
                        case 6: 
                        case 7: {
                            continue block58;
                        }
                    }
                    this.ph.setLexState(0);
                    return 10;
                }
                case 42: {
                    c = this.nextc();
                    if (c == 42) {
                        this.ph.setLexState(0);
                        if (this.nextc() == 61) {
                            this.yyVal = "**";
                            return 341;
                        }
                        this.pushback(c);
                        return 322;
                    }
                    if (c == 61) {
                        this.yyVal = "*";
                        this.ph.setLexState(0);
                        return 341;
                    }
                    this.pushback(c);
                    if (this.IS_ARG() && space_seen != 0 && !this.ISSPACE(c)) {
                        this.ph.rb_warning("'*' interpreted as argument prefix");
                        c = 346;
                    } else {
                        c = this.ph.getLexState() == 0 || this.ph.getLexState() == 5 ? 346 : 42;
                    }
                    this.ph.setLexState(0);
                    return c;
                }
                case 33: {
                    this.ph.setLexState(0);
                    c = this.nextc();
                    if (c == 61) {
                        return 326;
                    }
                    if (c == 126) {
                        return 332;
                    }
                    this.pushback(c);
                    return 33;
                }
                case 61: {
                    if (this.lex_p == 1 && this.lex_curline.startsWith("=begin") && (this.lex_pend == 6 || this.ISSPACE(this.lex_curline.charAt(6)))) {
                        do {
                            this.lex_p = this.lex_pend;
                            c = this.nextc();
                            if (c != -1) continue;
                            this.ph.rb_compile_error("embedded document meets end of file");
                            return 0;
                        } while (c != 61 || !this.lex_curline.substring(this.lex_p, this.lex_p + 3).equals("end") || this.lex_p + 3 != this.lex_pend && !this.ISSPACE(this.lex_curline.charAt(this.lex_p + 3)));
                        this.lex_p = this.lex_pend;
                        continue block58;
                    }
                    this.ph.setLexState(0);
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            return 325;
                        }
                        this.pushback(c);
                        return 324;
                    }
                    if (c == 126) {
                        return 331;
                    }
                    if (c == 62) {
                        return 342;
                    }
                    this.pushback(c);
                    return 61;
                }
                case 60: {
                    c = this.nextc();
                    if (!(c != 60 || this.ph.getLexState() == 1 || this.ph.getLexState() == 4 || this.ph.getLexState() == 8 || this.IS_ARG() && space_seen == 0)) {
                        int c2 = this.nextc();
                        int indent = 0;
                        if (c2 == 45) {
                            indent = 1;
                            c2 = this.nextc();
                        }
                        if (!this.ISSPACE(c2) && ("\"'`".indexOf(c2) != -1 || this.is_identchar(c2))) {
                            return this.here_document(c2, indent);
                        }
                        this.pushback(c2);
                    }
                    this.ph.setLexState(0);
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 62) {
                            return 323;
                        }
                        this.pushback(c);
                        return 328;
                    }
                    if (c == 60) {
                        if (this.nextc() == 61) {
                            this.yyVal = "<<";
                            return 341;
                        }
                        this.pushback(c);
                        return 337;
                    }
                    this.pushback(c);
                    return 60;
                }
                case 62: {
                    this.ph.setLexState(0);
                    c = this.nextc();
                    if (c == 61) {
                        return 327;
                    }
                    if (c == 62) {
                        c = this.nextc();
                        if (c == 61) {
                            this.yyVal = ">>";
                            return 341;
                        }
                        this.pushback(c);
                        return 338;
                    }
                    this.pushback(c);
                    return 62;
                }
                case 34: {
                    return this.parse_string(c, c, c);
                }
                case 96: {
                    if (this.ph.getLexState() == 6) {
                        return c;
                    }
                    if (this.ph.getLexState() == 7) {
                        return c;
                    }
                    return this.parse_string(c, c, c);
                }
                case 39: {
                    return this.parse_qstring(c, 0);
                }
                case 63: {
                    if (this.ph.getLexState() == 1) {
                        this.ph.setLexState(0);
                        return 63;
                    }
                    c = this.nextc();
                    if (c == -1) {
                        this.ph.rb_compile_error("incomplete character syntax");
                        return 0;
                    }
                    if (this.IS_ARG() && this.ISSPACE(c)) {
                        this.pushback(c);
                        this.ph.setLexState(0);
                        return 63;
                    }
                    if (c == 92) {
                        c = this.read_escape();
                    }
                    this.yyVal = RubyFixnum.newFixnum(this.ruby, c &= 0xFF);
                    this.ph.setLexState(1);
                    return 310;
                }
                case 38: {
                    c = this.nextc();
                    if (c == 38) {
                        this.ph.setLexState(0);
                        c = this.nextc();
                        if (c == 61) {
                            this.yyVal = "&&";
                            return 341;
                        }
                        this.pushback(c);
                        return 329;
                    }
                    if (c == 61) {
                        this.yyVal = "&";
                        this.ph.setLexState(0);
                        return 341;
                    }
                    this.pushback(c);
                    if (this.IS_ARG() && space_seen != 0 && !this.ISSPACE(c)) {
                        this.ph.rb_warning("`&' interpeted as argument prefix");
                        c = 347;
                    } else {
                        c = this.ph.getLexState() == 0 || this.ph.getLexState() == 5 ? 347 : 38;
                    }
                    this.ph.setLexState(0);
                    return c;
                }
                case 124: {
                    this.ph.setLexState(0);
                    c = this.nextc();
                    if (c == 124) {
                        c = this.nextc();
                        if (c == 61) {
                            this.yyVal = "||";
                            return 341;
                        }
                        this.pushback(c);
                        return 330;
                    }
                    if (c == 61) {
                        this.yyVal = "|";
                        return 341;
                    }
                    this.pushback(c);
                    return 124;
                }
                case 43: {
                    c = this.nextc();
                    if (this.ph.getLexState() == 6 || this.ph.getLexState() == 7) {
                        if (c == 64) {
                            return 320;
                        }
                        this.pushback(c);
                        return 43;
                    }
                    if (c == 61) {
                        this.ph.setLexState(0);
                        this.yyVal = "+";
                        return 341;
                    }
                    if (this.ph.getLexState() == 0 || this.ph.getLexState() == 5 || this.IS_ARG() && space_seen != 0 && !this.ISSPACE(c)) {
                        if (this.IS_ARG()) {
                            this.arg_ambiguous();
                        }
                        this.ph.setLexState(0);
                        this.pushback(c);
                        if (Character.isDigit((char)c)) {
                            c = 43;
                            return this.start_num(c);
                        }
                        return 320;
                    }
                    this.ph.setLexState(0);
                    this.pushback(c);
                    return 43;
                }
                case 45: {
                    c = this.nextc();
                    if (this.ph.getLexState() == 6 || this.ph.getLexState() == 7) {
                        if (c == 64) {
                            return 321;
                        }
                        this.pushback(c);
                        return 45;
                    }
                    if (c == 61) {
                        this.ph.setLexState(0);
                        this.yyVal = "-";
                        return 341;
                    }
                    if (this.ph.getLexState() == 0 || this.ph.getLexState() == 5 || this.IS_ARG() && space_seen != 0 && !this.ISSPACE(c)) {
                        if (this.IS_ARG()) {
                            this.arg_ambiguous();
                        }
                        this.ph.setLexState(0);
                        this.pushback(c);
                        if (Character.isDigit((char)c)) {
                            c = 45;
                            return this.start_num(c);
                        }
                        return 321;
                    }
                    this.ph.setLexState(0);
                    this.pushback(c);
                    return 45;
                }
                case 46: {
                    this.ph.setLexState(0);
                    c = this.nextc();
                    if (c == 46) {
                        c = this.nextc();
                        if (c == 46) {
                            return 334;
                        }
                        this.pushback(c);
                        return 333;
                    }
                    this.pushback(c);
                    if (!Character.isDigit((char)c)) {
                        this.ph.setLexState(7);
                        return 46;
                    }
                    c = 46;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.start_num(c);
                }
                case 93: 
                case 125: {
                    this.ph.setLexState(1);
                    return c;
                }
                case 41: {
                    if (this.cond_nest > 0) {
                        this.cond_stack >>= 1;
                    }
                    this.ph.setLexState(1);
                    return c;
                }
                case 58: {
                    c = this.nextc();
                    if (c == 58) {
                        if (this.ph.getLexState() == 0 || this.ph.getLexState() == 5 || this.IS_ARG() && space_seen != 0) {
                            this.ph.setLexState(0);
                            return 340;
                        }
                        this.ph.setLexState(7);
                        return 339;
                    }
                    this.pushback(c);
                    if (this.ph.getLexState() == 1 || this.ISSPACE(c)) {
                        this.ph.setLexState(0);
                        return 58;
                    }
                    this.ph.setLexState(6);
                    return 348;
                }
                case 47: {
                    if (this.ph.getLexState() == 0 || this.ph.getLexState() == 5) {
                        return this.parse_regx(47, 47);
                    }
                    c = this.nextc();
                    if (c == 61) {
                        this.ph.setLexState(0);
                        this.yyVal = "/";
                        return 341;
                    }
                    this.pushback(c);
                    if (this.IS_ARG() && space_seen != 0 && !this.ISSPACE(c)) {
                        this.arg_ambiguous();
                        return this.parse_regx(47, 47);
                    }
                    this.ph.setLexState(0);
                    return 47;
                }
                case 94: {
                    this.ph.setLexState(0);
                    c = this.nextc();
                    if (c == 61) {
                        this.yyVal = "^";
                        return 341;
                    }
                    this.pushback(c);
                    return 94;
                }
                case 44: 
                case 59: {
                    this.ph.setLexState(0);
                    return c;
                }
                case 126: {
                    if ((this.ph.getLexState() == 6 || this.ph.getLexState() == 7) && (c = this.nextc()) != 64) {
                        this.pushback(c);
                    }
                    this.ph.setLexState(0);
                    return 126;
                }
                case 40: {
                    if (this.cond_nest > 0) {
                        this.cond_stack = this.cond_stack << 1 | 0L;
                    }
                    if (this.ph.getLexState() == 0 || this.ph.getLexState() == 5) {
                        c = 343;
                    } else if (this.ph.getLexState() == 2 && space_seen != 0) {
                        this.ph.rb_warning(this.tok() + " (...) interpreted as method call");
                    }
                    this.ph.setLexState(0);
                    return c;
                }
                case 91: {
                    if (this.ph.getLexState() == 6 || this.ph.getLexState() == 7) {
                        c = this.nextc();
                        if (c == 93) {
                            c = this.nextc();
                            if (c == 61) {
                                return 336;
                            }
                            this.pushback(c);
                            return 335;
                        }
                        this.pushback(c);
                        return 91;
                    }
                    if (this.ph.getLexState() == 0 || this.ph.getLexState() == 5) {
                        c = 344;
                    } else if (this.IS_ARG() && space_seen != 0) {
                        c = 344;
                    }
                    this.ph.setLexState(0);
                    return c;
                }
                case 123: {
                    if (this.ph.getLexState() != 1 && this.ph.getLexState() != 2) {
                        c = 345;
                    }
                    this.ph.setLexState(0);
                    return c;
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        space_seen = 1;
                        continue block58;
                    }
                    this.pushback(c);
                    return 92;
                }
                case 37: {
                    while (true) {
                        if (this.ph.getLexState() == 0 || this.ph.getLexState() == 5) {
                            int term;
                            c = this.nextc();
                            if (!Character.isLetterOrDigit((char)c)) {
                                term = c;
                                c = 81;
                            } else {
                                term = this.nextc();
                            }
                            if (c == -1 || term == -1) {
                                this.ph.rb_compile_error("unterminated quoted string meets end of file");
                                return 0;
                            }
                            int paren = term;
                            if (term == 40) {
                                term = 41;
                            } else if (term == 91) {
                                term = 93;
                            } else if (term == 123) {
                                term = 125;
                            } else if (term == 60) {
                                term = 62;
                            } else {
                                paren = 0;
                            }
                            switch (c) {
                                case 81: {
                                    return this.parse_string(34, term, paren);
                                }
                                case 113: {
                                    return this.parse_qstring(term, paren);
                                }
                                case 119: {
                                    return this.parse_quotedwords(term, paren);
                                }
                                case 120: {
                                    return this.parse_string(96, term, paren);
                                }
                                case 114: {
                                    return this.parse_regx(term, paren);
                                }
                            }
                            this.yyerror("unknown type of %string");
                            return 0;
                        }
                        c = this.nextc();
                        if (c == 61) {
                            this.yyVal = "%";
                            return 341;
                        }
                        if (!this.IS_ARG() || space_seen == 0 || this.ISSPACE(c)) break;
                        this.pushback(c);
                    }
                    this.ph.setLexState(0);
                    this.pushback(c);
                    return 37;
                }
                case 36: {
                    this.ph.setLexState(1);
                    this.newtok();
                    c = this.nextc();
                    switch (c) {
                        case 95: {
                            c = this.nextc();
                            if (this.is_identchar(c)) {
                                this.tokadd(36);
                                this.tokadd(95);
                                break;
                            }
                            this.pushback(c);
                            c = 95;
                        }
                        case 126: {
                            this.ph.getLocalIndex(String.valueOf(c));
                        }
                        case 33: 
                        case 34: 
                        case 36: 
                        case 42: 
                        case 44: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 92: {
                            this.tokadd(36);
                            this.tokadd(c);
                            this.tokfix();
                            this.yyVal = this.tok();
                            return 306;
                        }
                        case 45: {
                            this.tokadd(36);
                            this.tokadd(c);
                            c = this.nextc();
                            this.tokadd(c);
                            this.tokfix();
                            this.yyVal = this.tok();
                            return 306;
                        }
                        case 38: 
                        case 39: 
                        case 43: 
                        case 96: {
                            this.yyVal = this.nf.newBackRef(c);
                            return 319;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.tokadd(36);
                            while (Character.isDigit((char)c)) {
                                this.tokadd(c);
                                c = this.nextc();
                            }
                            if (this.is_identchar(c)) break block58;
                            this.pushback(c);
                            this.tokfix();
                            this.yyVal = this.nf.newNthRef(Integer.parseInt(this.tok().substring(1)));
                            return 318;
                        }
                        default: {
                            if (!this.is_identchar(c)) {
                                this.pushback(c);
                                return 36;
                            }
                        }
                        case 48: {
                            this.tokadd(36);
                            break;
                        }
                    }
                    break block58;
                }
                case 64: {
                    c = this.nextc();
                    this.newtok();
                    this.tokadd(64);
                    if (c == 64) {
                        this.tokadd(64);
                        c = this.nextc();
                    }
                    if (Character.isDigit((char)c)) {
                        this.ph.rb_compile_error("`@" + c + "' is not a valid instance variable name");
                    }
                    if (this.is_identchar(c)) break block58;
                    this.pushback(c);
                    return 64;
                }
                default: {
                    if (!this.is_identchar(c) || Character.isDigit((char)c)) {
                        this.ph.rb_compile_error("Invalid char `\\" + c + "' in expression");
                        continue block58;
                    }
                    this.newtok();
                    break block58;
                }
            }
            break;
        }
        while (this.is_identchar(c)) {
            this.tokadd(c);
            c = this.nextc();
        }
        if ((c == 33 || c == 63) && this.is_identchar(this.tok().charAt(0)) && !this.peek(61)) {
            this.tokadd(c);
        } else {
            this.pushback(c);
        }
        this.tokfix();
        int result = 0;
        switch (this.tok().charAt(0)) {
            case '$': {
                this.ph.setLexState(1);
                result = 306;
                break;
            }
            case '@': {
                this.ph.setLexState(1);
                if (this.tok().charAt(1) == '@') {
                    result = 309;
                    break;
                }
                result = 307;
                break;
            }
            default: {
                kwtable kw;
                if (this.ph.getLexState() != 7 && (kw = this.rb_reserved_word(this.tok(), this.toklen())) != null) {
                    int state = this.ph.getLexState();
                    this.ph.setLexState(kw.state);
                    if (state == 6) {
                        this.yyVal = kw.name;
                    }
                    if (kw.id0 == 280) {
                        if (this.COND_P()) {
                            return 281;
                        }
                        if (this.CMDARG_P()) {
                            return 282;
                        }
                        return 280;
                    }
                    if (state == 0) {
                        return kw.id0;
                    }
                    if (kw.id0 != kw.id1) {
                        this.ph.setLexState(0);
                    }
                    return kw.id1;
                }
                if (this.toklast() == '!' || this.toklast() == '?') {
                    result = 305;
                } else {
                    if (this.ph.getLexState() == 6) {
                        c = this.nextc();
                        if (!(c != 61 || this.peek(126) || this.peek(62) || this.peek(61) && (this.lex_p + 1 >= this.lex_pend || this.lex_curline.charAt(this.lex_p + 1) != '>'))) {
                            result = 304;
                            this.tokadd(c);
                        } else {
                            this.pushback(c);
                        }
                    }
                    result = result == 0 && Character.isUpperCase(this.tok().charAt(0)) ? 308 : 304;
                }
                if (this.ph.getLexState() == 0 || this.ph.getLexState() == 7 || this.ph.getLexState() == 2) {
                    this.ph.setLexState(2);
                    break;
                }
                this.ph.setLexState(1);
            }
        }
        this.tokfix();
        this.yyVal = this.tok();
        return result;
    }

    private int start_num(int c) {
        boolean seen_uc = false;
        boolean seen_e = false;
        boolean seen_point = false;
        boolean is_float = false;
        this.ph.setLexState(1);
        this.newtok();
        if (c == 45 || c == 43) {
            this.tokadd(c);
            c = this.nextc();
        }
        if (c == 48) {
            c = this.nextc();
            if (c == 120 || c == 88) {
                c = this.nextc();
                do {
                    if (c == 95) {
                        seen_uc = true;
                        continue;
                    }
                    if (!this.ISXDIGIT(c)) break;
                    seen_uc = false;
                    this.tokadd(c);
                } while ((c = this.nextc()) != 0);
                this.pushback(c);
                this.tokfix();
                if (this.toklen() == 0) {
                    this.yyerror("hexadecimal number without hex-digits");
                } else if (seen_uc) {
                    return this.decode_num(c, is_float, seen_uc, true);
                }
                this.yyVal = this.rb_cstr2inum(this.tok(), 16);
                return 310;
            }
            if (c == 98 || c == 66) {
                c = this.nextc();
                do {
                    if (c == 95) {
                        seen_uc = true;
                        continue;
                    }
                    if (c != 48 && c != 49) break;
                    seen_uc = false;
                    this.tokadd(c);
                } while ((c = this.nextc()) != 0);
                this.pushback(c);
                this.tokfix();
                if (this.toklen() == 0) {
                    this.yyerror("numeric literal without digits");
                } else if (seen_uc) {
                    return this.decode_num(c, is_float, seen_uc, true);
                }
                this.yyVal = this.rb_cstr2inum(this.tok(), 2);
                return 310;
            }
            if (c >= 48 && c <= 55 || c == 95) {
                do {
                    if (c == 95) {
                        seen_uc = true;
                        continue;
                    }
                    if (c < 48 || c > 55) break;
                    seen_uc = false;
                    this.tokadd(c);
                } while ((c = this.nextc()) != 0);
                this.pushback(c);
                this.tokfix();
                if (seen_uc) {
                    return this.decode_num(c, is_float, seen_uc, true);
                }
                this.yyVal = this.rb_cstr2inum(this.tok(), 8);
                return 310;
            }
            if (c > 55 && c <= 57) {
                this.yyerror("Illegal octal digit");
            } else if (c == 46) {
                this.tokadd(48);
            } else {
                this.pushback(c);
                this.yyVal = RubyFixnum.zero(this.ruby);
                return 310;
            }
        }
        block9: while (true) {
            switch (c) {
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    seen_uc = false;
                    this.tokadd(c);
                    break;
                }
                case 46: {
                    if (seen_point || seen_e) {
                        return this.decode_num(c, is_float, seen_uc);
                    }
                    int c0 = this.nextc();
                    if (!Character.isDigit((char)c0)) {
                        this.pushback(c0);
                        return this.decode_num(c, is_float, seen_uc);
                    }
                    c = c0;
                    this.tokadd(46);
                    this.tokadd(c);
                    is_float = true;
                    seen_point = true;
                    seen_uc = false;
                    break;
                }
                case 69: 
                case 101: {
                    if (seen_e) {
                        return this.decode_num(c, is_float, seen_uc);
                    }
                    this.tokadd(c);
                    seen_e = true;
                    is_float = true;
                    while ((c = this.nextc()) == 95) {
                        seen_uc = true;
                    }
                    if (c != 45 && c != 43) continue block9;
                    this.tokadd(c);
                    break;
                }
                case 95: {
                    seen_uc = true;
                    break;
                }
                default: {
                    return this.decode_num(c, is_float, seen_uc);
                }
            }
            c = this.nextc();
        }
    }

    private int decode_num(int c, boolean is_float, boolean seen_uc) {
        return this.decode_num(c, is_float, seen_uc, false);
    }

    private int decode_num(int c, boolean is_float, boolean seen_uc, boolean trailing_uc) {
        if (!trailing_uc) {
            this.pushback(c);
            this.tokfix();
        }
        if (seen_uc || trailing_uc) {
            this.yyerror("trailing `_' in number");
        }
        if (is_float) {
            double d = 0.0;
            try {
                d = Double.parseDouble(this.tok());
            }
            catch (NumberFormatException e) {
                this.ph.rb_warn("Float " + this.tok() + " out of range");
            }
            this.yyVal = RubyFloat.newFloat(this.ruby, d);
            return 311;
        }
        this.yyVal = this.rb_cstr2inum(this.tok(), 10);
        return 310;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Node str_extend(Node list, int term) {
        int brace = -1;
        int c = this.nextc();
        switch (c) {
            case 36: 
            case 64: 
            case 123: {
                break;
            }
            default: {
                this.tokadd(35);
                this.pushback(c);
                return list;
            }
        }
        RubyString ss = RubyString.newString(this.ruby, this.tok(), this.toklen());
        if (list == null) {
            list = this.nf.newDStr(ss);
        } else if (this.toklen() > 0) {
            this.ph.list_append(list, this.nf.newStr(ss));
        }
        this.newtok();
        block3 : switch (c) {
            case 36: {
                this.tokadd(36);
                c = this.nextc();
                if (c == -1) {
                    return Node.MINUS_ONE;
                }
                switch (c) {
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        while (true) {
                            if (!Character.isDigit((char)c)) {
                                this.pushback(c);
                                break block3;
                            }
                            this.tokadd(c);
                            c = this.nextc();
                        }
                    }
                    case 33: 
                    case 36: 
                    case 38: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 46: 
                    case 58: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: 
                    case 64: 
                    case 92: 
                    case 95: 
                    case 126: {
                        this.tokadd(c);
                        break block3;
                    }
                }
                if (c == term) {
                    this.ph.list_append(list, this.nf.newStr(RubyString.newString(this.ruby, "#$")));
                    this.pushback(c);
                    this.newtok();
                    return list;
                }
                switch (c) {
                    case 34: 
                    case 39: 
                    case 47: 
                    case 96: {
                        this.tokadd(c);
                        break block3;
                    }
                }
                if (!this.is_identchar(c)) {
                    this.yyerror("bad global variable in string");
                    this.newtok();
                    return list;
                }
                while (true) {
                    if (!this.is_identchar(c)) {
                        this.pushback(c);
                        break block3;
                    }
                    this.tokadd(c);
                    c = this.nextc();
                }
            }
            case 64: {
                this.tokadd(c);
                c = this.nextc();
                if (c == 64) {
                    this.tokadd(c);
                    c = this.nextc();
                }
                while (true) {
                    if (!this.is_identchar(c)) {
                        this.pushback(c);
                        break block3;
                    }
                    this.tokadd(c);
                    c = this.nextc();
                }
            }
            case 123: {
                if (c == 123) {
                    brace = 125;
                }
                int nest = 0;
                block25: while (true) {
                    c = this.nextc();
                    switch (c) {
                        case -1: {
                            if (nest > 0) {
                                this.yyerror("bad substitution in string");
                                this.newtok();
                                return list;
                            }
                            return Node.MINUS_ONE;
                        }
                        case 125: {
                            if (c == brace) {
                                if (nest == 0) break;
                                --nest;
                            }
                            this.tokadd(c);
                            continue block25;
                        }
                        case 92: {
                            c = this.nextc();
                            if (c == -1) {
                                return Node.MINUS_ONE;
                            }
                            if (c == term) {
                                this.tokadd(c);
                                break;
                            }
                            this.tokadd(92);
                            this.tokadd(c);
                            break;
                        }
                        case 123: {
                            if (brace != -1) {
                                ++nest;
                            }
                        }
                        case 34: 
                        case 47: 
                        case 96: {
                            if (c == term) {
                                this.pushback(c);
                                this.ph.list_append(list, this.nf.newStr(RubyString.newString(this.ruby, "#")));
                                this.ph.rb_warning("bad substitution in string");
                                this.tokfix();
                                this.ph.list_append(list, this.nf.newStr(RubyString.newString(this.ruby, this.tok(), this.toklen())));
                                this.newtok();
                                return list;
                            }
                        }
                        default: {
                            this.tokadd(c);
                            break;
                        }
                    }
                    if (c == brace) break block3;
                }
            }
        }
        this.tokfix();
        Node node = this.nf.newEVStr(this.tok(), this.toklen());
        this.ph.list_append(list, node);
        this.newtok();
        return list;
    }

    private boolean ISSPACE(int c) {
        return Character.isWhitespace((char)c);
    }

    private boolean ISXDIGIT(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    /*
     * WARNING - void declaration
     */
    private long scan_hex(String s, int start, int len, int[] retlen) {
        int tmp;
        String hexdigit = "0123456789abcdef0123456789ABCDEFx";
        long retval = 0L;
        int st = start;
        while (len-- != 0 && st < s.length() && (tmp = hexdigit.indexOf(s.charAt(st))) != -1) {
            void var8_8;
            retval <<= 4;
            retval |= (long)(var8_8 & 0xF);
            ++st;
        }
        retlen[0] = st - start;
        return retval;
    }

    public void setLexFileIo(boolean lex_file_io) {
        this.lex_file_io = lex_file_io;
    }

    public void setLexGetsPtr(int lex_gets_ptr) {
        this.lex_gets_ptr = lex_gets_ptr;
    }

    public void setLexInput(RubyObject lex_input) {
        this.lex_input = lex_input;
    }

    public void setLexP(int lex_p) {
        this.lex_p = lex_p;
    }

    public void setLexPEnd(int lex_pend) {
        this.lex_pend = lex_pend;
    }
}

