/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.nodes.AndNode;
import org.jruby.nodes.ArrayNode;
import org.jruby.nodes.BackRefNode;
import org.jruby.nodes.BlockNode;
import org.jruby.nodes.BlockPassNode;
import org.jruby.nodes.FlipNode;
import org.jruby.nodes.NewlineNode;
import org.jruby.nodes.Node;
import org.jruby.nodes.NodeFactory;
import org.jruby.nodes.NthRefNode;
import org.jruby.nodes.OrNode;
import org.jruby.runtime.RubyVarmap;
import org.jruby.util.IdUtil;

public class ParserHelper {
    private Ruby ruby;
    private NodeFactory nf;
    private Node evalTree;
    private Node evalTreeBegin;
    private int inSingle;
    private int inDef;
    private boolean inDefined;
    private int compileForEval;
    private int lexState;
    private int classNest;
    private String curMid;
    private boolean rubyInCompile = false;
    private boolean rubyEndSeen;
    private int heredocEnd;
    private boolean commandStart = true;
    private RubyArray rubyDebugLines;
    private int _line;
    private LocalVars lvtbl = new LocalVars();

    public String getFile() {
        return this.ruby.getSourceFile();
    }

    public void setLine(int iLine) {
        this._line = iLine;
    }

    public int getLine() {
        return this._line;
    }

    public void incrementLine() {
        ++this._line;
    }

    public ParserHelper(Ruby ruby) {
        this.ruby = ruby;
    }

    public void init() {
        this.nf = new NodeFactory(this.ruby);
    }

    private void yyerror(String message) {
        this.rb_errmess(message);
    }

    public void rb_compile_error(String message) {
        this.rb_errmess(message);
    }

    public void rb_errmess(String message) {
        this.ruby.getRuntime().getErrorStream().println(this.ruby.getSourceFile() + ":" + this.getLine() + " " + message);
    }

    public void rb_warn(String message) {
        this.rb_errmess(" [WARN] " + message);
    }

    public void rb_warning(String message) {
        this.rb_errmess("[WARNING] " + message);
    }

    public void rb_bug(String message) {
        this.rb_errmess("[BUG] " + message);
    }

    public String getOperatorId(int operatorId) {
        switch (operatorId) {
            case 333: {
                return "..";
            }
            case 334: {
                return "...";
            }
            case 322: {
                return "**";
            }
            case 320: {
                return "+@";
            }
            case 321: {
                return "-@";
            }
            case 323: {
                return "<=>";
            }
            case 327: {
                return ">=";
            }
            case 328: {
                return "<=";
            }
            case 324: {
                return "==";
            }
            case 325: {
                return "===";
            }
            case 326: {
                return "!=";
            }
            case 331: {
                return "=~";
            }
            case 332: {
                return "!~";
            }
            case 335: {
                return "[]";
            }
            case 336: {
                return "[]=";
            }
            case 337: {
                return "<<";
            }
            case 338: {
                return ">>";
            }
            case 339: {
                return "::";
            }
        }
        return String.valueOf((char)operatorId);
    }

    public void fixpos(Object n1, Node n2) {
        this.fixpos((Node)n1, n2);
    }

    public Node arg_blk_pass(Node node1, Node node2) {
        if (node2 != null) {
            node2.setHeadNode(node1);
            return node2;
        }
        return node1;
    }

    public void rb_parser_append_print() {
        this.evalTree = this.block_append(this.evalTree, this.nf.newFCall("print", this.nf.newArray(this.nf.newGVar("$_"))));
    }

    public void rb_parser_while_loop(boolean chop, boolean split) {
        if (split) {
            this.evalTree = this.block_append(this.nf.newGAsgn("$F", this.nf.newCall(this.nf.newGVar("$_"), "split", null)), this.evalTree);
        }
        if (chop) {
            this.evalTree = this.block_append(this.nf.newCall(this.nf.newGVar("$_"), "chop!", null), this.evalTree);
        }
        this.evalTree = this.nf.newOptN(this.evalTree);
    }

    public RubyObject getBackref() {
        if (this.ruby.getScope().getLocalValues() != null) {
            return this.ruby.getScope().getValue(1);
        }
        return this.ruby.getNil();
    }

    public void setBackref(RubyObject val) {
        if (this.ruby.getScope().getLocalValues() != null) {
            this.ruby.getScope().setValue(1, val);
        } else {
            this.special_local_set("~", val);
        }
    }

    public RubyObject getLastline() {
        if (this.ruby.getScope().getLocalValues() != null) {
            return this.ruby.getScope().getValue(0);
        }
        return this.ruby.getNil();
    }

    public void setLastline(RubyObject val) {
        if (this.ruby.getScope().getLocalValues() != null) {
            this.ruby.getScope().setValue(0, val);
        } else {
            this.special_local_set("_", val);
        }
    }

    public Node getAccessNode(String id) {
        if ((id = id.intern()).charAt(0) == '#') {
            if ((id = id.substring(1).intern()) == "self") {
                return this.nf.newSelf();
            }
            if (id == "nil") {
                return this.nf.newNil();
            }
            if (id == "true") {
                return this.nf.newTrue();
            }
            if (id == "false") {
                return this.nf.newFalse();
            }
            if (id == "__FILE__") {
                return this.nf.newStr(RubyString.newString(this.ruby, this.ruby.getSourceFile()));
            }
            if (id == "__LINE__") {
                return this.nf.newLit(RubyFixnum.newFixnum(this.ruby, this.ruby.getSourceLine()));
            }
        } else {
            if (IdUtil.isLocal(id)) {
                if (this.dyna_in_block() && RubyVarmap.isDefined(this.ruby, id)) {
                    return this.nf.newDVar(id);
                }
                if (this.isLocalRegistered(id)) {
                    return this.nf.newLVar(id);
                }
                return this.nf.newVCall(id);
            }
            if (IdUtil.isGlobal(id)) {
                return this.nf.newGVar(id);
            }
            if (IdUtil.isInstanceVariable(id)) {
                return this.nf.newIVar(id);
            }
            if (IdUtil.isConstant(id)) {
                return this.nf.newConst(id);
            }
            if (IdUtil.isClassVariable(id)) {
                if (this.isInSingle()) {
                    return this.nf.newCVar2(id);
                }
                return this.nf.newCVar(id);
            }
        }
        this.rb_bug("Invalid id '" + id + "' for getAccessNode.");
        return null;
    }

    public Node getAssignmentNode(String id, Node valueNode) {
        this.value_expr(valueNode);
        id = id.intern();
        if (id.charAt(0) == '#') {
            if ((id = id.substring(1).intern()) == "self") {
                this.yyerror("Can't change the value of self");
            } else {
                this.yyerror("Can't assign to " + id);
            }
        } else {
            if (IdUtil.isLocal(id)) {
                if (RubyVarmap.isCurrent(this.ruby, id)) {
                    return this.nf.newDAsgnCurr(id, valueNode);
                }
                if (RubyVarmap.isDefined(this.ruby, id)) {
                    return this.nf.newDAsgn(id, valueNode);
                }
                if (this.isLocalRegistered(id) || !this.dyna_in_block()) {
                    return this.nf.newLAsgn(id, valueNode);
                }
                RubyVarmap.push(this.ruby, id, this.ruby.getNil());
                return this.nf.newDAsgnCurr(id, valueNode);
            }
            if (IdUtil.isGlobal(id)) {
                return this.nf.newGAsgn(id, valueNode);
            }
            if (IdUtil.isInstanceVariable(id)) {
                return this.nf.newIAsgn(id, valueNode);
            }
            if (IdUtil.isConstant(id)) {
                if (this.isInDef() || this.isInSingle()) {
                    this.yyerror("dynamic constant assignment");
                }
                return this.nf.newCDecl(id, valueNode);
            }
            if (IdUtil.isClassVariable(id)) {
                if (this.isInSingle()) {
                    return this.nf.newCVAsgn(id, valueNode);
                }
                return this.nf.newCVDecl(id, valueNode);
            }
            this.rb_bug("Id '" + id + "' not allowed for variable.");
        }
        return null;
    }

    private void fixpos(Node node, Node orig) {
        if (node == null || orig == null) {
            return;
        }
        node.setFile(orig.getFile());
        node.setLine(orig.getLine());
    }

    public Node newline_node(Node node) {
        NewlineNode nl = null;
        if (node != null) {
            nl = this.nf.newNewline(node);
            this.fixpos(nl, node);
        }
        return nl;
    }

    public Node block_append(Node head, Node tail) {
        Node end;
        if (tail == null) {
            return head;
        }
        if (head == null) {
            return tail;
        }
        if (head instanceof BlockNode) {
            end = ((BlockNode)head).getEndNode();
        } else {
            end = this.nf.newBlock(head);
            this.fixpos(end, head);
            head = end;
        }
        if (this.ruby.isVerbose()) {
            Node nd = end.getHeadNode();
            block4: while (true) {
                switch (nd.getType()) {
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 45: {
                        this.rb_warning("statement not reached");
                        break block4;
                    }
                    case 96: {
                        nd = nd.getNextNode();
                        continue block4;
                    }
                }
                break;
            }
        }
        if (!(tail instanceof BlockNode)) {
            tail = this.nf.newBlock(tail);
        }
        end.setNextNode(tail);
        head.setEndNode(tail.getEndNode());
        return head;
    }

    public Node list_append(Node head, Node tail) {
        if (head == null) {
            return this.nf.newList(tail);
        }
        Node last = head;
        while (last.getNextNode() != null) {
            last = last.getNextNode();
        }
        last.setNextNode(this.nf.newList(tail));
        head.setALength(head.getALength() + 1);
        return head;
    }

    public Node list_concat(Node head, Node tail) {
        Node last = head;
        while (last.getNextNode() != null) {
            last = last.getNextNode();
        }
        last.setNextNode(tail);
        head.setALength(head.getALength() + tail.getALength());
        return head;
    }

    public Node call_op(Node recv, int op, int narg, Node arg1) {
        return this.call_op(recv, this.getOperatorId(op), narg, arg1);
    }

    public Node call_op(Node recv, String id, int narg, Node arg1) {
        this.value_expr(recv);
        if (narg == 1) {
            this.value_expr(arg1);
        }
        return this.nf.newCall(recv, id, narg == 1 ? this.nf.newList(arg1) : null);
    }

    public Node match_gen(Node node1, Node node2) {
        this.getLocalIndex("~");
        switch (node1.getType()) {
            case 65: 
            case 66: {
                return this.nf.newMatch2(node1, node2);
            }
            case 59: {
                if (!(node1.getLiteral() instanceof RubyRegexp)) break;
                return this.nf.newMatch2(node1, node2);
            }
        }
        switch (node2.getType()) {
            case 65: 
            case 66: {
                return this.nf.newMatch3(node2, node1);
            }
            case 59: {
                if (!(node2.getLiteral() instanceof RubyRegexp)) break;
                return this.nf.newMatch3(node2, node1);
            }
        }
        return this.nf.newCall(node1, "=~", this.nf.newList(node2));
    }

    public Node aryset(Node recv, Node idx) {
        this.value_expr(recv);
        return this.nf.newCall(recv, "[]=", idx);
    }

    public Node attrset(Node recv, String id) {
        this.value_expr(recv);
        return this.nf.newCall(recv, id + "=", null);
    }

    public void rb_backref_error(Node node) {
        switch (node.getType()) {
            case 54: {
                this.rb_compile_error("Can't set variable $" + ((NthRefNode)node).getNth());
                break;
            }
            case 55: {
                this.rb_compile_error("Can't set variable $" + ((BackRefNode)node).getNth());
            }
        }
    }

    public Node arg_concat(Node node1, Node node2) {
        if (node2 == null) {
            return node1;
        }
        return this.nf.newArgsCat(node1, node2);
    }

    private Node arg_add(Node node1, Node node2) {
        if (node1 == null) {
            return this.nf.newList(node2);
        }
        if (node1 instanceof ArrayNode) {
            return this.list_append((ArrayNode)node1, node2);
        }
        return this.nf.newArgsPush(node1, node2);
    }

    public Node node_assign(Node lhs, Node rhs) {
        if (lhs == null) {
            return null;
        }
        this.value_expr(rhs);
        switch (lhs.getType()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                lhs.setValueNode(rhs);
                break;
            }
            case 37: {
                lhs.setArgsNode(this.arg_add(lhs.getArgsNode(), rhs));
                break;
            }
        }
        if (rhs != null) {
            this.fixpos(lhs, rhs);
        }
        return lhs;
    }

    public boolean value_expr(Node node) {
        if (node == null) {
            return true;
        }
        switch (node.getType()) {
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 45: 
            case 75: 
            case 76: 
            case 80: 
            case 81: {
                this.yyerror("void value expression");
                return false;
            }
            case 4: {
                while (node.getNextNode() != null) {
                    node = node.getNextNode();
                }
                return this.value_expr(node.getHeadNode());
            }
            case 17: {
                return this.value_expr(node.getBodyNode());
            }
            case 5: {
                return this.value_expr(node.getBodyNode()) && this.value_expr(node.getElseNode());
            }
            case 96: {
                return this.value_expr(node.getNextNode());
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void void_expr(Node node) {
        useless = null;
        if (this.ruby.isVerbose() && node != null) ** GOTO lbl5
        return;
lbl-1000:
        // 1 sources

        {
            node = node.getNextNode();
lbl5:
            // 2 sources

            ** while (node instanceof NewlineNode)
        }
lbl6:
        // 1 sources

        switch (node.getType()) {
            case 37: {
                if (!node.getMId().equals("+") && !node.getMId().equals("-") && !node.getMId().equals("*") && !node.getMId().equals("/") && !node.getMId().equals("%") && !node.getMId().equals("**") && !node.getMId().equals("+@") && !node.getMId().equals("-@") && !node.getMId().equals("|") && !node.getMId().equals("^") && !node.getMId().equals("&") && !node.getMId().equals("<=>") && !node.getMId().equals(">") && !node.getMId().equals(">=") && !node.getMId().equals("<") && !node.getMId().equals("<=") && !node.getMId().equals("==") && !node.getMId().equals("!=")) break;
                useless = node.getMId();
                break;
            }
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 54: 
            case 55: {
                useless = "a variable";
                break;
            }
            case 51: 
            case 85: {
                useless = "a constant";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 65: 
            case 66: {
                useless = "a literal";
                break;
            }
            case 83: 
            case 84: {
                useless = "::";
                break;
            }
            case 86: {
                useless = "..";
                break;
            }
            case 87: {
                useless = "...";
                break;
            }
            case 91: {
                useless = "self";
                break;
            }
            case 92: {
                useless = "nil";
                break;
            }
            case 93: {
                useless = "true";
                break;
            }
            case 94: {
                useless = "false";
                break;
            }
            case 95: {
                useless = "defined?";
            }
        }
        if (useless != null) {
            line = this.ruby.getSourceLine();
            this.ruby.setSourceLine(node.getLine());
            this.rb_warn("useless use of " + useless + "in void context");
            this.ruby.setSourceLine(line);
        }
    }

    public void void_stmts(Node node) {
        if (!this.ruby.isVerbose()) {
            return;
        }
        if (node == null) {
            return;
        }
        if (node.getType() != 4) {
            return;
        }
        while (node.getNextNode() != null) {
            this.void_expr(node.getHeadNode());
            node = node.getNextNode();
        }
        return;
    }

    private boolean assign_in_cond(Node node) {
        switch (node.getType()) {
            case 24: {
                this.yyerror("multiple assignment in conditional");
                return true;
            }
            case 25: 
            case 26: 
            case 28: 
            case 29: {
                break;
            }
            default: {
                return false;
            }
        }
        switch (node.getValueNode().getType()) {
            case 59: 
            case 60: 
            case 92: 
            case 93: 
            case 94: {
                this.rb_warn("found = in conditional, should be ==");
                return true;
            }
        }
        return true;
    }

    private boolean e_option_supplied() {
        return this.ruby.getSourceFile().equals("-e");
    }

    private void warn_unless_e_option(String str) {
        if (!this.e_option_supplied()) {
            this.rb_warn(str);
        }
    }

    private void warning_unless_e_option(String str) {
        if (!this.e_option_supplied()) {
            this.rb_warning(str);
        }
    }

    private Node cond0(Node node) {
        int type = node.getType();
        this.assign_in_cond(node);
        boolean exclusive = true;
        switch (type) {
            case 65: 
            case 66: {
                this.getLocalIndex("_");
                this.getLocalIndex("~");
                return this.nf.newMatch2(node, this.nf.newGVar("$_"));
            }
            case 86: {
                exclusive = false;
            }
            case 87: {
                FlipNode flipNode = new FlipNode(this.cond2(node.getBeginNode()), this.cond2(node.getEndNode()), exclusive);
                flipNode.setCount(this.registerLocal(null));
                return flipNode;
            }
            case 59: {
                if (node.getLiteral() instanceof RubyRegexp) {
                    this.getLocalIndex("_");
                    this.getLocalIndex("~");
                    return this.nf.newMatch(node);
                }
                if (!(node.getLiteral() instanceof RubyString)) break;
                this.getLocalIndex("_");
                this.getLocalIndex("~");
                return this.nf.newMatch(this.nf.newLit(RubyRegexp.newRegexp(this.ruby, (RubyString)node.getLiteral(), 0)));
            }
        }
        return node;
    }

    public Node cond(Node node) {
        if (node == null) {
            return null;
        }
        if (node.getType() == 96) {
            node.setNextNode(this.cond0(node.getNextNode()));
            return node;
        }
        return this.cond0(node);
    }

    private Node cond2(Node node) {
        int type = (node = this.cond(node)).getType();
        if (type == 96) {
            node = node.getNextNode();
        }
        if (type == 59 && node.getLiteral() instanceof RubyFixnum) {
            return this.call_op(node, 324, 1, this.nf.newGVar("$."));
        }
        return node;
    }

    public Node logop(int type, Node left, Node right) {
        this.value_expr(left);
        switch (type) {
            case 21: {
                return new AndNode(this.cond(left), this.cond(right));
            }
            case 22: {
                return new OrNode(this.cond(left), this.cond(right));
            }
        }
        throw new RuntimeException("[BUG] ParserHelper#logop: Nodetype=" + type);
    }

    public Node ret_args(Node node) {
        if (node != null) {
            if (node.getType() == 42 && node.getNextNode() == null) {
                return node.getHeadNode();
            }
            if (node.getType() == 74) {
                this.rb_compile_error("block argument should not be given");
            }
        }
        return node;
    }

    public Node new_call(Node r, String m, Node args) {
        if (args != null && args instanceof BlockPassNode) {
            args.setIterNode(this.nf.newCall(r, m, args.getHeadNode()));
            return args;
        }
        return this.nf.newCall(r, m, args);
    }

    public Node new_fcall(String mid, Node args) {
        if (args != null && args instanceof BlockPassNode) {
            args.setIterNode(this.nf.newFCall(mid, args.getHeadNode()));
            return args;
        }
        return this.nf.newFCall(mid, args);
    }

    public Node new_super(Node args) {
        if (args != null && args instanceof BlockPassNode) {
            args.setIterNode(this.nf.newSuper(args.getHeadNode()));
            return args;
        }
        return this.nf.newSuper(args);
    }

    public void local_push() {
        LocalVars local = new LocalVars();
        local.prev = this.lvtbl;
        local.tbl = null;
        local.dlev = 0;
        this.lvtbl = local;
    }

    public void local_pop() {
        LocalVars local;
        this.lvtbl = local = this.lvtbl.prev;
    }

    public List local_tbl() {
        return this.lvtbl.tbl;
    }

    private int registerLocal(String name) {
        String string = name = name != null ? name.intern() : null;
        if (this.lvtbl.tbl == null) {
            this.lvtbl.tbl = new ArrayList();
            this.lvtbl.tbl.add("_");
            this.lvtbl.tbl.add("~");
            if (name == "_") {
                return 0;
            }
            if (name == "~") {
                return 1;
            }
        }
        this.lvtbl.tbl.add(name);
        return this.lvtbl.cnt() - 1;
    }

    public int getLocalIndex(String name) {
        if (name == null) {
            return this.lvtbl.cnt();
        }
        if (this.lvtbl.tbl == null) {
            return this.registerLocal(name);
        }
        name = name.intern();
        int i = 0;
        while (i < this.lvtbl.cnt()) {
            if (name == this.lvtbl.tbl.get(i)) {
                return i;
            }
            ++i;
        }
        return this.registerLocal(name);
    }

    public boolean isLocalRegistered(String id) {
        id = id.intern();
        if (this.lvtbl == null || this.lvtbl.tbl == null) {
            return false;
        }
        int i = 0;
        while (i < this.lvtbl.tbl.size()) {
            if (id == this.lvtbl.tbl.get(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void top_local_init() {
        this.local_push();
        List lLocalNames = this.ruby.getScope().getLocalNames();
        int lcnt = lLocalNames != null ? lLocalNames.size() : 0;
        this.lvtbl.tbl = lcnt > 0 ? new ArrayList(lLocalNames) : null;
        this.lvtbl.dlev = this.ruby.getDynamicVars() != null ? 1 : 0;
    }

    public void top_local_setup() {
        int len = this.lvtbl.cnt();
        if (len > 0) {
            int i;
            int n = i = this.ruby.getScope().getLocalNames() != null ? this.ruby.getScope().getLocalNames().size() : 0;
            if (i < len) {
                if (i == 0 || (this.ruby.getScope().getFlags() & 1) == 0) {
                    ArrayList values = new ArrayList(len);
                    if (this.ruby.getScope().getLocalValues() != null) {
                        values.addAll(this.ruby.getScope().getLocalValues().subList(0, i));
                    }
                    values.addAll(Collections.nCopies(len - values.size(), this.ruby.getNil()));
                    this.ruby.getScope().setLocalValues(values);
                    this.ruby.getScope().setFlags(this.ruby.getScope().getFlags() | 1);
                } else {
                    ArrayList<RubyObject> values = new ArrayList<RubyObject>(len);
                    values.addAll(this.ruby.getScope().getLocalValues());
                    values.addAll(Collections.nCopies(len - values.size(), this.ruby.getNil()));
                    this.ruby.getScope().setLocalValues(values);
                }
                this.ruby.getScope().setLocalNames(this.local_tbl());
            }
        }
        this.local_pop();
    }

    public RubyVarmap dyna_push() {
        RubyVarmap vars = this.ruby.getDynamicVars();
        RubyVarmap.push(this.ruby, null, null);
        ++this.lvtbl.dlev;
        return vars;
    }

    public void dyna_pop(RubyVarmap vars) {
        --this.lvtbl.dlev;
        this.ruby.setDynamicVars(vars);
    }

    private boolean dyna_in_block() {
        return this.lvtbl.dlev > 0;
    }

    private void special_local_set(String c, RubyObject val) {
        this.top_local_init();
        int cnt = this.getLocalIndex(c);
        this.top_local_setup();
        this.ruby.getScope().setValue(cnt, val);
    }

    public Node getEvalTree() {
        return this.evalTree;
    }

    public void setEvalTree(Node evalTree) {
        this.evalTree = evalTree;
    }

    public Node getEvalTreeBegin() {
        return this.evalTreeBegin;
    }

    public void setEvalTreeBegin(Node evalTreeBegin) {
        this.evalTreeBegin = evalTreeBegin;
    }

    public boolean isInSingle() {
        return this.inSingle != 0;
    }

    public void setInSingle(int inSingle) {
        this.inSingle = inSingle;
    }

    public boolean isInDef() {
        return this.inDef != 0;
    }

    public void setInDef(int inDef) {
        this.inDef = inDef;
    }

    public int getInSingle() {
        return this.inSingle;
    }

    public int getInDef() {
        return this.inDef;
    }

    public boolean isInDefined() {
        return this.inDefined;
    }

    public void setInDefined(boolean inDefined) {
        this.inDefined = inDefined;
    }

    public int getCompileForEval() {
        return this.compileForEval;
    }

    public boolean isCompileForEval() {
        return this.compileForEval != 0;
    }

    public void setCompileForEval(int compileForEval) {
        this.compileForEval = compileForEval;
    }

    public int getLexState() {
        return this.lexState;
    }

    public void setLexState(int lexState) {
        this.lexState = lexState;
    }

    public int getClassNest() {
        return this.classNest;
    }

    public void setClassNest(int classNest) {
        this.classNest = classNest;
    }

    public String getCurMid() {
        return this.curMid;
    }

    public void setCurMid(String curMid) {
        this.curMid = curMid;
    }

    public boolean isRubyInCompile() {
        return this.rubyInCompile;
    }

    public void setRubyInCompile(boolean rubyInCompile) {
        this.rubyInCompile = rubyInCompile;
    }

    public boolean isRubyEndSeen() {
        return this.rubyEndSeen;
    }

    public void setRubyEndSeen(boolean rubyEndSeen) {
        this.rubyEndSeen = rubyEndSeen;
    }

    public RubyArray getRubyDebugLines() {
        return this.rubyDebugLines;
    }

    public void setRubyDebugLines(RubyArray rubyDebugLines) {
        this.rubyDebugLines = rubyDebugLines;
    }

    public int getHeredocEnd() {
        return this.heredocEnd;
    }

    public void setHeredocEnd(int heredocEnd) {
        this.heredocEnd = heredocEnd;
    }

    public boolean isCommandStart() {
        return this.commandStart;
    }

    public void setCommandStart(boolean commandStart) {
        this.commandStart = commandStart;
    }

    private static class LocalVars {
        List tbl;
        int dlev;
        LocalVars prev;

        private LocalVars() {
        }

        int cnt() {
            return this.tbl == null ? 0 : this.tbl.size();
        }
    }
}

