/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.regexp;

import gnu.regexp.RE;
import gnu.regexp.REException;
import gnu.regexp.REMatch;
import org.jruby.Ruby;
import org.jruby.RubyMatchData;
import org.jruby.RubyObject;
import org.jruby.exceptions.RubyRegexpException;
import org.jruby.regexp.IRegexpAdapter;

public class GNURegexpAdapter
extends IRegexpAdapter {
    private RE re;
    private int cflags = 0;
    private int eflags = 0;
    private boolean extended;

    public void compile(Ruby ruby, String pattern) throws RubyRegexpException {
        if (this.extended) {
            pattern = this.unextend(pattern);
        }
        try {
            this.re = new RE(pattern, this.cflags);
        }
        catch (REException e) {
            throw new RubyRegexpException(ruby, e.getMessage());
        }
    }

    public void setCasefold(boolean set) {
        this.cflags = set ? (this.cflags |= 2) : (this.cflags &= 0xFFFFFFFD);
    }

    public boolean getCasefold() {
        return (this.cflags & 2) > 0;
    }

    public void setExtended(boolean set) {
        this.extended = set;
    }

    public void setMultiline(boolean set) {
        this.cflags = set ? (this.cflags |= 4) : (this.cflags &= 0xFFFFFFFB);
    }

    public RubyObject search(Ruby ruby, String target, int startPos) {
        REMatch match = this.re.getMatch(target, startPos, this.eflags);
        if (match != null) {
            int count = this.re.getNumSubs() + 1;
            int[] begin = new int[count];
            int[] end = new int[count];
            int i = 0;
            while (i < count) {
                begin[i] = match.getStartIndex(i);
                end[i] = match.getEndIndex(i);
                ++i;
            }
            return new RubyMatchData(ruby, target, begin, end);
        }
        return ruby.getNil();
    }
}

