/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.nodes.CRefNode;

public class RubyFrame {
    public static final int FRAME_ALLOCA = 0;
    public static final int FRAME_MALLOC = 1;
    private RubyObject self = null;
    private List args = null;
    private String lastFunc = null;
    private RubyModule lastClass = null;
    private CRefNode cbase = null;
    private RubyFrame prev = null;
    private RubyFrame tmp = null;
    private String file = null;
    private int line = 0;
    private int iter = 0;
    private int flags = 0;
    private Ruby ruby = null;

    public RubyFrame(Ruby ruby) {
        this.ruby = ruby;
    }

    public RubyFrame(Ruby ruby, RubyObject self, List args, String lastFunc, RubyModule lastClass, CRefNode cbase, RubyFrame prev, RubyFrame tmp, String file, int line, int iter, int flags) {
        this(ruby);
        this.self = self;
        this.args = args;
        this.lastFunc = lastFunc;
        this.lastClass = lastClass;
        this.cbase = cbase;
        this.prev = prev;
        this.tmp = tmp;
        this.file = file;
        this.line = line;
        this.iter = iter;
        this.flags = flags;
    }

    public RubyFrame(RubyFrame frame) {
        this(frame.ruby, frame.self, frame.args, frame.lastFunc, frame.lastClass, frame.cbase, frame.prev, frame.tmp, frame.file, frame.line, frame.iter, frame.flags);
    }

    public List getArgs() {
        return this.args;
    }

    public void setArgs(List args) {
        this.args = args;
    }

    public CRefNode getCbase() {
        return this.cbase;
    }

    public void setCbase(CRefNode cbase) {
        this.cbase = cbase;
    }

    public String getFile() {
        return this.file;
    }

    public void setFile(String file) {
        this.file = file;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getIter() {
        return this.iter;
    }

    public void setIter(int iter) {
        this.iter = iter;
    }

    public RubyModule getLastClass() {
        return this.lastClass;
    }

    public void setLastClass(RubyModule lastClass) {
        this.lastClass = lastClass;
    }

    public String getLastFunc() {
        return this.lastFunc;
    }

    public void setLastFunc(String lastFunc) {
        this.lastFunc = lastFunc;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public RubyFrame getPrev() {
        return this.prev;
    }

    public void setPrev(RubyFrame prev) {
        this.prev = prev;
    }

    public RubyObject getSelf() {
        return this.self;
    }

    public void setSelf(RubyObject self) {
        this.self = self;
    }

    public RubyFrame getTmp() {
        return this.tmp;
    }

    public void setTmp(RubyFrame tmp) {
        this.tmp = tmp;
    }

    public void tmpPush() {
        RubyFrame tmpFrame;
        this.tmp = tmpFrame = new RubyFrame(this.ruby, this.self, this.args, this.lastFunc, this.lastClass, this.cbase, this.prev, this.tmp, this.file, this.line, this.iter, this.flags);
    }

    public void tmpPop() {
        this.self = this.tmp.self;
        this.args = this.tmp.args;
        this.lastFunc = this.tmp.lastFunc;
        this.lastClass = this.tmp.lastClass;
        this.cbase = this.tmp.cbase;
        this.prev = this.tmp.prev;
        this.file = this.tmp.file;
        this.line = this.tmp.line;
        this.iter = this.tmp.iter;
        this.flags = this.tmp.flags;
        this.ruby = this.tmp.ruby;
        this.tmp = this.tmp.tmp;
    }

    public void push() {
        RubyFrame oldFrame;
        this.prev = oldFrame = new RubyFrame(this.ruby, this.self, this.args, this.lastFunc, this.lastClass, this.cbase, this.prev, this.tmp, this.file, this.line, this.iter, this.flags);
        this.tmp = null;
        this.file = this.ruby.getSourceFile();
        this.line = this.ruby.getSourceLine();
        this.iter = this.ruby.getIter().getIter();
        this.args = null;
        this.flags = 0;
    }

    public void pop() {
        this.self = this.prev.self;
        this.args = this.prev.args;
        this.lastFunc = this.prev.lastFunc;
        this.lastClass = this.prev.lastClass;
        this.cbase = this.prev.cbase;
        this.tmp = this.prev.tmp;
        this.file = this.prev.file;
        this.line = this.prev.line;
        this.iter = this.prev.iter;
        this.flags = this.prev.flags;
        this.prev = this.prev.prev;
        this.ruby.setSourceFile(this.file);
        this.ruby.setSourceLine(this.line);
    }

    static {
        FRAME_ALLOCA = 0;
        FRAME_MALLOC = 1;
    }
}

