/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.RubyObject;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RubySecurityException;

public final class RubyGlobalEntry {
    private Ruby ruby = null;
    private String id = null;
    private RubyObject data = null;
    private GetterMethod getter = null;
    private SetterMethod setter = null;
    private static UndefMethods undefMethods = new UndefMethods();
    public static ValueMethods valueMethods = new ValueMethods();
    public static ReadonlySetter readonlySetter = new ReadonlySetter();

    public RubyGlobalEntry(Ruby ruby, String id) {
        this.ruby = ruby;
        this.id = id;
        this.getter = undefMethods;
        this.setter = undefMethods;
    }

    public Ruby getRuby() {
        return this.ruby;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected RubyObject getData() {
        return this.data;
    }

    public void setData(RubyObject data) {
        this.data = data;
    }

    private GetterMethod getGetter() {
        return this.getter;
    }

    public void setGetter(GetterMethod getter) {
        this.getter = getter;
    }

    private SetterMethod getSetter() {
        return this.setter;
    }

    public void setSetter(SetterMethod setter) {
        this.setter = setter;
    }

    public RubyObject get() {
        return this.getGetter().get(this.getId(), this.getData(), this);
    }

    public RubyObject set(RubyObject value) {
        if (this.ruby.getSafeLevel() >= 4) {
            throw new RubySecurityException(this.ruby, "Insecure: can't change global variable value");
        }
        this.getSetter().set(value, this.getId(), this.getData(), this);
        return value;
    }

    public boolean isDefined() {
        return !(this.getter instanceof UndefMethods);
    }

    public void undefine() {
        this.getter = undefMethods;
        this.setter = undefMethods;
    }

    public void alias(String newId) {
        if (this.ruby.getSafeLevel() >= 4) {
            throw new RubySecurityException(this.ruby, "Insecure: can't alias global variable");
        }
        RubyGlobalEntry entry = this.ruby.getGlobalEntry(newId);
        entry.data = this.data;
        entry.getter = this.getter;
        entry.setter = this.setter;
    }

    private static class ReadonlySetter
    implements SetterMethod {
        private ReadonlySetter() {
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            throw new NameError(entry.ruby, "can't set variable " + id);
        }
    }

    private static class ValueMethods
    implements GetterMethod,
    SetterMethod {
        private ValueMethods() {
        }

        public RubyObject get(String id, RubyObject value, RubyGlobalEntry entry) {
            return value;
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            entry.setData(value);
        }
    }

    private static class UndefMethods
    implements GetterMethod,
    SetterMethod {
        private UndefMethods() {
        }

        public RubyObject get(String id, RubyObject value, RubyGlobalEntry entry) {
            if (entry.getRuby().isVerbose()) {
                // empty if block
            }
            return entry.ruby.getNil();
        }

        public void set(RubyObject value, String id, RubyObject data, RubyGlobalEntry entry) {
            entry.setData(value);
            entry.setGetter(valueMethods);
            entry.setSetter(valueMethods);
        }
    }

    public static interface SetterMethod {
        public void set(RubyObject var1, String var2, RubyObject var3, RubyGlobalEntry var4);
    }

    public static interface GetterMethod {
        public RubyObject get(String var1, RubyObject var2, RubyGlobalEntry var3);
    }
}

