/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.NameError;
import org.jruby.nodes.CRefNode;
import org.jruby.runtime.RubyVarmap;
import org.jruby.util.RubyPointer;

public class RubyRuntime {
    private static final int TRACE_HEAD = 8;
    private static final int TRACE_TAIL = 5;
    private static final int TRACE_MAX = 18;
    private boolean printBugs = false;
    private Ruby ruby;
    private InputStream inputStream;
    private PrintStream errorStream;
    private PrintStream outputStream;

    public RubyRuntime(Ruby ruby) {
        this.ruby = ruby;
    }

    public void printBug(String description) {
        if (this.printBugs) {
            this.getErrorStream().println("[BUG] " + description);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyObject callSuper(RubyObject[] args) {
        if (this.ruby.getRubyFrame().getLastClass() == null) {
            throw new NameError(this.ruby, "superclass method '" + this.ruby.getRubyFrame().getLastFunc() + "' must be enabled by enableSuper().");
        }
        this.ruby.getIter().push();
        RubyObject result = this.ruby.getNil();
        try {
            result = this.ruby.getRubyFrame().getLastClass().getSuperClass().call(this.ruby.getRubyFrame().getSelf(), this.ruby.getRubyFrame().getLastFunc(), new RubyPointer(args), 3);
            Object var4_3 = null;
            this.ruby.getIter().pop();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.ruby.getIter().pop();
            throw throwable;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(RubyString scriptName, RubyString source, boolean wrap) {
        RubyObject self = this.ruby.getRubyTopSelf();
        CRefNode savedCRef = this.ruby.getCRef();
        if (!wrap || this.ruby.getSafeLevel() >= 4) {
            // empty if block
        }
        RubyVarmap.push(this.ruby);
        this.ruby.pushClass();
        RubyModule wrapper = this.ruby.getWrapper();
        this.ruby.setCRef(this.ruby.getTopCRef());
        if (!wrap) {
            this.ruby.secure(4);
            this.ruby.setRubyClass(this.ruby.getClasses().getObjectClass());
            this.ruby.setWrapper(null);
        } else {
            this.ruby.setWrapper(RubyModule.newModule(this.ruby));
            this.ruby.setRubyClass(this.ruby.getWrapper());
            self = this.ruby.getRubyTopSelf().rbClone();
            self.extendObject(this.ruby.getRubyClass());
            this.ruby.getCRef().push(this.ruby.getWrapper());
        }
        this.ruby.getRubyFrame().push();
        this.ruby.getRubyFrame().setLastFunc(null);
        this.ruby.getRubyFrame().setLastClass(null);
        this.ruby.getRubyFrame().setSelf(self);
        this.ruby.getRubyFrame().setCbase(new CRefNode(this.ruby.getRubyClass(), null));
        this.ruby.getScope().push();
        this.ruby.setActMethodScope(1);
        String last_func = this.ruby.getRubyFrame().getLastFunc();
        try {
            this.ruby.setInEval(this.ruby.getInEval() + 1);
            this.ruby.getRubyParser().compileString(scriptName.getValue(), source, 0);
            this.ruby.setInEval(this.ruby.getInEval() - 1);
            self.evalNode(this.ruby.getParserHelper().getEvalTree());
            Object var9_8 = null;
            this.ruby.getRubyFrame().setLastFunc(last_func);
            this.ruby.setCRef(savedCRef);
            this.ruby.getScope().pop();
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            this.ruby.getRubyFrame().setLastFunc(last_func);
            this.ruby.setCRef(savedCRef);
            this.ruby.getScope().pop();
            this.ruby.getRubyFrame().pop();
            this.ruby.popClass();
            RubyVarmap.pop(this.ruby);
            this.ruby.setWrapper(wrapper);
            throw throwable;
        }
        this.ruby.getRubyFrame().pop();
        this.ruby.popClass();
        RubyVarmap.pop(this.ruby);
        this.ruby.setWrapper(wrapper);
    }

    /*
     * WARNING - void declaration
     */
    public void loadFile(File iFile, boolean wrap) {
        if (iFile == null) {
            throw new RuntimeException("No such file to load");
        }
        try {
            String line;
            StringBuffer source = new StringBuffer((int)iFile.length());
            BufferedReader br = new BufferedReader(new FileReader(iFile));
            while ((line = br.readLine()) != null) {
                void var5_6;
                source.append((String)var5_6).append('\n');
            }
            br.close();
            this.loadScript(new RubyString(this.ruby, iFile.getPath()), new RubyString(this.ruby, source.toString()), wrap);
        }
        catch (IOException ioExcptn) {
            this.getErrorStream().println("Cannot read Rubyfile: \"" + iFile.getPath() + "\"");
            this.getErrorStream().println("IOEception: " + ioExcptn.getMessage());
        }
    }

    public void loadFile(RubyString fname, boolean wrap) {
        this.loadFile(new File(fname.getValue()), wrap);
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        RubyArray backtrace = (RubyArray)excp.funcall("backtrace");
        if (backtrace.isNil()) {
            if (this.ruby.getSourceFile() != null) {
                this.getErrorStream().print(this.ruby.getSourceFile() + ':' + this.ruby.getSourceLine());
            } else {
                this.getErrorStream().print(this.ruby.getSourceLine());
            }
        } else if (backtrace.getLength() == 0) {
            this.printErrorPos();
        } else {
            RubyObject mesg = backtrace.entry(0L);
            if (mesg.isNil()) {
                this.printErrorPos();
            } else {
                this.getErrorStream().print(mesg);
            }
        }
        RubyClass type = excp.getRubyClass();
        String info = excp.toString();
        if (type == this.ruby.getExceptions().getRuntimeError() && info.length() == 0) {
            this.getErrorStream().print(": unhandled exception\n");
        } else {
            String path = type.getClassPath().toString();
            if (info.length() == 0) {
                this.getErrorStream().print(": " + path + '\n');
            } else {
                if (path.startsWith("#")) {
                    path = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                this.getErrorStream().print(": " + info);
                if (path != null) {
                    this.getErrorStream().print(" (" + path + ")\n");
                }
                if (tail != null) {
                    this.getErrorStream().print(tail + '\n');
                }
            }
        }
        if (!backtrace.isNil()) {
            RubyObject[] elements = backtrace.toJavaArray();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof RubyString) {
                    this.getErrorStream().print("\tfrom " + elements[i] + '\n');
                }
                if (i == 8 && elements.length > 18) {
                    this.getErrorStream().print("\t ... " + (elements.length - 8 - 5) + "levels...\n");
                    i = elements.length - 5;
                }
                ++i;
            }
        }
    }

    private void printErrorPos() {
        if (this.ruby.getSourceFile() != null) {
            if (this.ruby.getRubyFrame().getLastFunc() != null) {
                this.getErrorStream().print(this.ruby.getSourceFile() + ':' + this.ruby.getSourceLine());
                this.getErrorStream().print(":in '" + this.ruby.getRubyFrame().getLastFunc() + '\'');
            } else if (this.ruby.getSourceLine() != 0) {
                this.getErrorStream().print(this.ruby.getSourceFile() + ':' + this.ruby.getSourceLine());
            } else {
                this.getErrorStream().print(this.ruby.getSourceFile());
            }
        }
    }

    public PrintStream getErrorStream() {
        return this.errorStream != null ? this.errorStream : System.err;
    }

    public void setErrorStream(PrintStream errorStream) {
        this.errorStream = errorStream;
    }

    public InputStream getInputStream() {
        return this.inputStream != null ? this.inputStream : System.in;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public PrintStream getOutputStream() {
        return this.outputStream != null ? this.outputStream : System.out;
    }

    public void setOutputStream(PrintStream outputStream) {
        this.outputStream = outputStream;
    }

    public boolean getPrintBugs() {
        return this.printBugs;
    }

    public void setPrintBugs(boolean printBugs) {
        this.printBugs = printBugs;
    }

    static {
        TRACE_HEAD = 8;
        TRACE_TAIL = 5;
        TRACE_MAX = 18;
    }
}

