/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import org.jruby.util.Pointer;
import org.jruby.util.RubyPointer;

public class DefaultPointer
extends AbstractList
implements Pointer {
    private ArrayList delegate;
    private int position;
    private boolean autoResize;
    private Object autoResizeObject;

    public DefaultPointer() {
        this(new ArrayList(), 0, true, null);
    }

    public DefaultPointer(int size) {
        this(new ArrayList<Object>(Collections.nCopies(size, null)), 0, true, null);
    }

    public DefaultPointer(boolean autoResize) {
        this(new ArrayList(), 0, autoResize, null);
    }

    public DefaultPointer(Object autoResizeObject, int size) {
        this(null, 0, true, autoResizeObject);
        this.delegate = new ArrayList(size);
        int i = 0;
        while (i < size) {
            this.delegate.add(autoResizeObject);
            ++i;
        }
    }

    public DefaultPointer(ArrayList delegate) {
        this(delegate, 0, true, null);
    }

    public DefaultPointer(ArrayList delegate, Object autoResizeObject) {
        this(delegate, 0, true, autoResizeObject);
    }

    public DefaultPointer(ArrayList delegate, boolean autoResize) {
        this(delegate, 0, autoResize, null);
    }

    protected DefaultPointer(ArrayList delegate, int position, boolean autoResize, Object autoResizeObject) {
        this.delegate = delegate;
        this.position = position;
        this.autoResize = autoResize;
        this.autoResizeObject = autoResizeObject;
        this.autoResize(position);
    }

    public ArrayList getDelegate() {
        if (this.position == 0) {
            return this.delegate;
        }
        return new ArrayList(this.delegate.subList(this.position, this.delegate.size() - 1));
    }

    protected void autoResize(int index) {
        if (!this.autoResize) {
            return;
        }
        if (index < 0) {
            throw new UnsupportedOperationException("Cannot access an element left of the list");
        }
        if (index > this.delegate.size()) {
            this.delegate.ensureCapacity(index);
            int i = this.delegate.size();
            while (i < index) {
                this.delegate.add(this.autoResizeObject);
                ++i;
            }
        }
    }

    public int size() {
        return this.delegate.size() - this.position;
    }

    public Object get(int index) {
        this.autoResize(index + this.position + 1);
        return this.delegate.get(index + this.position);
    }

    public Object set(int index, Object element) {
        this.autoResize(index + this.position + 1);
        return this.delegate.set(index + this.position, element);
    }

    public void add(int index, Object element) {
        this.autoResize(Math.max(0, index + this.position));
        this.delegate.add(index + this.position, element);
    }

    public void dec(int index) {
        this.inc(-index);
    }

    public void inc(int index) {
        this.position += index;
        this.autoResize(this.position);
    }

    public void dec() {
        this.inc(-1);
    }

    public void inc() {
        this.inc(1);
    }

    public void remove() {
        this.delegate.remove(this.position);
    }

    public Object remove(int index) {
        this.autoResize(this.position + 1);
        return this.delegate.remove(this.position + index);
    }

    public Object next() {
        return this.delegate.get(this.position);
    }

    public Pointer getPointer(int index) {
        return new RubyPointer(this.delegate, this.position + index, this.autoResize, this.autoResizeObject);
    }

    public boolean hasNext() {
        return this.position < this.delegate.size();
    }

    public boolean isAutoResize() {
        return this.autoResize;
    }

    public void setAutoResize(boolean autoResize) {
        this.autoResize = autoResize;
    }

    public void set(int index, Pointer pointer, int len) {
        int i = 0;
        while (i < len) {
            this.set(index + i, pointer.get(i));
            ++i;
        }
    }

    public void set(Pointer pointer, int len) {
        this.set(0, pointer, len);
    }

    public void setAll(Object element) {
        int len = this.delegate.size();
        int i = this.position;
        while (i < len) {
            this.delegate.set(i, element);
            ++i;
        }
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int newPosition) {
        this.position = newPosition;
    }

    public Object[] toArray() {
        int len = this.size();
        Object[] array = new Object[len];
        System.arraycopy(super.toArray(), this.position, array, 0, len);
        return array;
    }

    public Object[] toArray(Object[] array) {
        int len = this.size();
        System.arraycopy(super.toArray(), this.position, array, 0, len);
        return array;
    }
}

