/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubyIndexException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Asserts;
import org.jruby.util.Pack;
import org.jruby.util.collections.IdentitySet;

public class RubyArray
extends RubyObject
implements IndexCallable {
    private ArrayList list;
    private boolean tmpLock;
    private static final int M_INSPECT = 1;
    private static final int M_TO_S = 2;
    private static final int M_FROZEN = 3;
    private static final int M_EQUAL = 4;
    private static final int M_AREF = 10;
    private static final int M_ASET = 11;
    private static final int M_EQL = 12;
    private static final int M_HASH = 13;
    private static final int M_FIRST = 14;
    private static final int M_LAST = 15;
    private static final int M_CONCAT = 16;
    private static final int M_APPEND = 20;
    private static final int M_PUSH = 21;
    private static final int M_POP = 22;
    private static final int M_SHIFT = 23;
    private static final int M_UNSHIFT = 24;
    private static final int M_EACH = 25;
    private static final int M_EACH_INDEX = 26;
    private static final int M_REVERSE_EACH = 30;
    private static final int M_LENGTH = 31;
    private static final int M_EMPTY_P = 32;
    private static final int M_INDEX = 33;
    private static final int M_RINDEX = 34;
    private static final int M_CLONE = 40;
    private static final int M_JOIN = 41;
    private static final int M_INDICES = 42;
    private static final int M_REVERSE = 50;
    private static final int M_REVERSE_BANG = 51;
    private static final int M_SORT = 52;
    private static final int M_SORT_BANG = 53;
    private static final int M_COLLECT = 54;
    private static final int M_COLLECT_BANG = 60;
    private static final int M_DELETE = 61;
    private static final int M_DELETE_AT = 62;
    private static final int M_DELETE_IF = 63;
    private static final int M_REJECT_BANG = 64;
    private static final int M_REPLACE = 70;
    private static final int M_CLEAR = 71;
    private static final int M_INCLUDE_P = 72;
    static /* synthetic */ Class class$org$jruby$RubyArray;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyString;

    private RubyArray(Ruby ruby, ArrayList list) {
        super(ruby, ruby.getClasses().getArrayClass());
        this.list = list;
    }

    public static RubyArray nilArray(Ruby ruby) {
        return new RubyArray(ruby, null){

            public boolean isNil() {
                return true;
            }
        };
    }

    public ArrayList getList() {
        return this.list;
    }

    public IRubyObject[] toJavaArray() {
        return this.list.toArray(new IRubyObject[this.getLength()]);
    }

    public boolean isTmpLock() {
        return this.tmpLock;
    }

    public void setTmpLock(boolean tmpLock) {
        this.tmpLock = tmpLock;
    }

    public int getLength() {
        return this.list.size();
    }

    public boolean includes(IRubyObject item) {
        int i = 0;
        int n = this.getLength();
        while (i < n) {
            if (item.callMethod("==", this.entry(i)).isTrue()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static RubyClass createArrayClass(Ruby ruby) {
        RubyClass arrayClass = ruby.defineClass("Array", ruby.getClasses().getObjectClass());
        arrayClass.includeModule(ruby.getRubyModule("Enumerable"));
        arrayClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "newInstance"));
        arrayClass.defineSingletonMethod("[]", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "create"));
        arrayClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "initialize"));
        arrayClass.defineMethod("inspect", IndexedCallback.create(1, 0));
        arrayClass.defineMethod("to_s", IndexedCallback.create(2, 0));
        arrayClass.defineMethod("to_a", CallbackFactory.getSelfMethod(0));
        arrayClass.defineMethod("to_ary", CallbackFactory.getSelfMethod(0));
        arrayClass.defineMethod("frozen?", IndexedCallback.create(3, 0));
        arrayClass.defineMethod("==", IndexedCallback.create(4, 1));
        arrayClass.defineMethod("eql?", IndexedCallback.create(12, 1));
        arrayClass.defineMethod("===", IndexedCallback.create(4, 1));
        arrayClass.defineMethod("hash", IndexedCallback.create(13, 0));
        arrayClass.defineMethod("[]", IndexedCallback.createOptional(10));
        arrayClass.defineMethod("[]=", IndexedCallback.createOptional(11));
        arrayClass.defineMethod("at", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "at", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyArray.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        arrayClass.defineMethod("first", IndexedCallback.create(14, 0));
        arrayClass.defineMethod("last", IndexedCallback.create(15, 0));
        arrayClass.defineMethod("concat", IndexedCallback.create(16, 1));
        arrayClass.defineMethod("<<", IndexedCallback.create(20, 1));
        arrayClass.defineMethod("push", IndexedCallback.createOptional(21, 1));
        arrayClass.defineMethod("pop", IndexedCallback.create(22, 0));
        arrayClass.defineMethod("shift", IndexedCallback.create(23, 0));
        arrayClass.defineMethod("unshift", IndexedCallback.createOptional(24));
        arrayClass.defineMethod("each", IndexedCallback.create(25, 0));
        arrayClass.defineMethod("each_index", IndexedCallback.create(26, 0));
        arrayClass.defineMethod("reverse_each", IndexedCallback.create(30, 0));
        arrayClass.defineMethod("length", IndexedCallback.create(31, 0));
        arrayClass.defineMethod("size", IndexedCallback.create(31, 0));
        arrayClass.defineMethod("empty?", IndexedCallback.create(32, 0));
        arrayClass.defineMethod("index", IndexedCallback.create(33, 1));
        arrayClass.defineMethod("rindex", IndexedCallback.create(34, 1));
        arrayClass.defineMethod("indexes", IndexedCallback.createOptional(42));
        arrayClass.defineMethod("indices", IndexedCallback.createOptional(42));
        arrayClass.defineMethod("clone", IndexedCallback.create(40, 0));
        arrayClass.defineMethod("join", IndexedCallback.createOptional(41));
        arrayClass.defineMethod("reverse", IndexedCallback.create(50, 0));
        arrayClass.defineMethod("reverse!", IndexedCallback.create(51, 0));
        arrayClass.defineMethod("sort", IndexedCallback.create(52, 0));
        arrayClass.defineMethod("sort!", IndexedCallback.create(53, 0));
        arrayClass.defineMethod("collect", IndexedCallback.create(54, 0));
        arrayClass.defineMethod("collect!", IndexedCallback.create(60, 0));
        arrayClass.defineMethod("map!", IndexedCallback.create(60, 0));
        arrayClass.defineMethod("filter", IndexedCallback.create(60, 0));
        arrayClass.defineMethod("delete", IndexedCallback.create(61, 1));
        arrayClass.defineMethod("delete_at", IndexedCallback.create(62, 1));
        arrayClass.defineMethod("delete_if", IndexedCallback.create(63, 0));
        arrayClass.defineMethod("reject!", IndexedCallback.create(64, 0));
        arrayClass.defineMethod("replace", IndexedCallback.create(70, 1));
        arrayClass.defineMethod("clear", IndexedCallback.create(71, 0));
        arrayClass.defineMethod("fill", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "fill"));
        arrayClass.defineMethod("include?", IndexedCallback.create(72, 1));
        arrayClass.defineMethod("<=>", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_cmp", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("slice", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "aref"));
        arrayClass.defineMethod("slice!", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "slice_bang"));
        arrayClass.defineMethod("assoc", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "assoc", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("rassoc", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "rassoc", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_plus", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_times", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_diff", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_and", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_or", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("uniq", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "uniq"));
        arrayClass.defineMethod("uniq!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "uniq_bang"));
        arrayClass.defineMethod("compact", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "compact"));
        arrayClass.defineMethod("compact!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "compact_bang"));
        arrayClass.defineMethod("flatten", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "flatten"));
        arrayClass.defineMethod("flatten!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "flatten_bang"));
        arrayClass.defineMethod("nitems", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "nitems"));
        arrayClass.defineMethod("pack", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "pack", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyArray.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        return arrayClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 1: {
                return this.inspect();
            }
            case 2: {
                return this.to_s();
            }
            case 3: {
                return this.frozen();
            }
            case 4: {
                return this.equal(args[0]);
            }
            case 12: {
                return this.eql(args[0]);
            }
            case 13: {
                return this.hash();
            }
            case 10: {
                return this.aref(args);
            }
            case 11: {
                return this.aset(args);
            }
            case 14: {
                return this.first();
            }
            case 15: {
                return this.last();
            }
            case 16: {
                return this.concat(args[0]);
            }
            case 20: {
                return this.append(args[0]);
            }
            case 21: {
                return this.push(args);
            }
            case 22: {
                return this.pop();
            }
            case 23: {
                return this.shift();
            }
            case 24: {
                return this.unshift(args);
            }
            case 25: {
                return this.each();
            }
            case 26: {
                return this.each_index();
            }
            case 30: {
                return this.reverse_each();
            }
            case 31: {
                return this.length();
            }
            case 32: {
                return this.empty_p();
            }
            case 33: {
                return this.index(args[0]);
            }
            case 34: {
                return this.rindex(args[0]);
            }
            case 42: {
                return this.indices(args);
            }
            case 40: {
                return this.rbClone();
            }
            case 41: {
                return this.join(args);
            }
            case 50: {
                return this.reverse();
            }
            case 51: {
                return this.reverse_bang();
            }
            case 52: {
                return this.sort();
            }
            case 53: {
                return this.sort_bang();
            }
            case 54: {
                return this.collect();
            }
            case 60: {
                return this.collect_bang();
            }
            case 61: {
                return this.delete(args[0]);
            }
            case 62: {
                return this.delete_at(args[0]);
            }
            case 63: {
                return this.delete_if();
            }
            case 64: {
                return this.reject_bang();
            }
            case 70: {
                return this.replace(args[0]);
            }
            case 71: {
                return this.clear();
            }
            case 72: {
                return this.include_p(args[0]);
            }
        }
        Asserts.assertNotReached();
        return null;
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, this.list.hashCode());
    }

    public void modify() {
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuntime(), "Array");
        }
        if (this.isTmpLock()) {
            throw new TypeError(this.getRuntime(), "can't modify array during sort");
        }
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't modify array");
        }
    }

    private void autoExpand(long toLength) {
        this.list.ensureCapacity((int)toLength);
        int i = this.getLength();
        while ((long)i < toLength) {
            this.list.add(this.getRuntime().getNil());
            ++i;
        }
    }

    public void store(long idx, IRubyObject value) {
        this.modify();
        if (idx < 0L && (idx += (long)this.getLength()) < 0L) {
            throw new RubyIndexException(this.getRuntime(), "index " + (idx - (long)this.getLength()) + " out of array");
        }
        this.autoExpand(idx + 1L);
        this.list.set((int)idx, value);
    }

    public IRubyObject entry(long offset) {
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        if (offset < 0L) {
            offset += (long)this.getLength();
        }
        if (offset < 0L || (long)this.getLength() <= offset) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.get((int)offset);
    }

    public RubyArray unshift(IRubyObject item) {
        this.modify();
        this.list.add(0, item);
        return this;
    }

    public IRubyObject subseq(long beg, long len) {
        int length = this.getLength();
        if (beg > (long)length || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)length) {
            len = (long)length - beg;
        }
        if (len <= 0L) {
            return RubyArray.newArray(this.getRuntime(), 0L);
        }
        RubyArray ary2 = RubyArray.newArray(this.getRuntime(), new ArrayList(this.list.subList((int)beg, (int)(len + beg))));
        return ary2;
    }

    public void replace(long beg, long len, IRubyObject repl) {
        int length = this.getLength();
        if (len < 0L) {
            throw new RubyIndexException(this.getRuntime(), "Negative array length: " + len);
        }
        if (beg < 0L) {
            beg += (long)length;
        }
        if (beg < 0L) {
            throw new RubyIndexException(this.getRuntime(), "Index out of bounds: " + beg);
        }
        this.modify();
        int i = 0;
        while (beg < (long)this.getLength() && (long)i < len) {
            this.list.remove((int)beg);
            ++i;
        }
        this.autoExpand(beg);
        if (repl instanceof RubyArray) {
            ArrayList repList = ((RubyArray)repl).getList();
            this.list.ensureCapacity(this.getLength() + repList.size());
            this.list.addAll((int)beg, new ArrayList(repList));
        } else if (!repl.isNil()) {
            this.list.add((int)beg, repl);
        }
    }

    public static RubyArray arrayValue(IRubyObject other) {
        if (other instanceof RubyArray) {
            return (RubyArray)other;
        }
        try {
            return (RubyArray)other.convertType(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "Array", "to_ary");
        }
        catch (Exception ex) {
            throw new ArgumentError(other.getRuntime(), "can't convert arg to Array: " + ex.getMessage());
        }
    }

    private boolean flatten(ArrayList array) {
        return this.flatten(array, new IdentitySet());
    }

    private boolean flatten(ArrayList array, IdentitySet visited) {
        if (visited.contains(array)) {
            throw new ArgumentError(this.runtime, "tried to flatten recursive array");
        }
        visited.add(array);
        boolean isModified = false;
        int i = array.size() - 1;
        while (i >= 0) {
            if (array.get(i) instanceof RubyArray) {
                ArrayList ary2 = ((RubyArray)array.remove(i)).getList();
                this.flatten(ary2, visited);
                array.addAll(i, ary2);
                isModified = true;
            }
            --i;
        }
        visited.remove(array);
        return isModified;
    }

    public static final RubyArray newArray(Ruby ruby, long len) {
        return new RubyArray(ruby, new ArrayList((int)len));
    }

    public static final RubyArray newArray(Ruby ruby) {
        return new RubyArray(ruby, new ArrayList(16));
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject obj) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(1);
        list.add(obj);
        return new RubyArray(ruby, list);
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject car, IRubyObject cdr) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(2);
        list.add(car);
        list.add(cdr);
        return new RubyArray(ruby, list);
    }

    public static final RubyArray newArray(Ruby ruby, ArrayList list) {
        return new RubyArray(ruby, list);
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject[] args) {
        int size = args.length;
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(size);
        int i = 0;
        while (i < size) {
            list.add(args[i]);
            ++i;
        }
        return new RubyArray(ruby, list);
    }

    public static RubyArray newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyArray array = RubyArray.newArray(recv.getRuntime());
        array.setInternalClass((RubyClass)recv);
        array.callInit(args);
        return array;
    }

    public static RubyArray create(IRubyObject recv, IRubyObject[] args) {
        RubyArray array = RubyArray.newArray(recv.getRuntime(), args);
        array.setInternalClass((RubyClass)recv);
        return array;
    }

    public RubyFixnum length() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.getLength());
    }

    public RubyArray push(IRubyObject[] items) {
        this.modify();
        boolean tainted = false;
        int i = 0;
        while (i < items.length) {
            tainted |= items[i].isTaint();
            this.list.add(items[i]);
            ++i;
        }
        this.setTaint(this.isTaint() || tainted);
        return this;
    }

    public RubyArray append(IRubyObject value) {
        this.modify();
        this.list.add(value);
        this.infectBy(value);
        return this;
    }

    public IRubyObject pop() {
        this.modify();
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.remove(this.getLength() - 1);
    }

    public IRubyObject shift() {
        this.modify();
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.remove(0);
    }

    public RubyArray unshift(IRubyObject[] items) {
        if (items.length == 0) {
            throw new ArgumentError(this.getRuntime(), "wrong # of arguments(at least 1)");
        }
        this.modify();
        boolean taint = false;
        int i = 0;
        while (i < items.length) {
            taint |= items[i].isTaint();
            this.list.add(i, items[i]);
            ++i;
        }
        this.setTaint(this.isTaint() || taint);
        return this;
    }

    public RubyBoolean include_p(IRubyObject item) {
        return RubyBoolean.newBoolean(this.runtime, this.includes(item));
    }

    public RubyBoolean frozen() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isFrozen() || this.isTmpLock());
    }

    public IRubyObject initialize(IRubyObject[] args) {
        int argc = this.argCount(args, 0, 2);
        long len = 0L;
        if (argc != 0) {
            len = RubyNumeric.fix2long(args[0]);
        }
        this.modify();
        if (len < 0L) {
            throw new ArgumentError(this.getRuntime(), "negative array size");
        }
        if (len > Integer.MAX_VALUE) {
            throw new ArgumentError(this.getRuntime(), "array size too big");
        }
        this.list = new ArrayList((int)len);
        if (len > 0L) {
            IRubyObject obj = argc == 2 ? args[1] : this.getRuntime().getNil();
            Collections.fill(this.list, obj);
        }
        return this;
    }

    public IRubyObject aref(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            if (beg < 0L) {
                beg += (long)this.getLength();
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            return this.entry(RubyNumeric.fix2long(args[0]));
        }
        if (args[0] instanceof RubyBignum) {
            throw new RubyIndexException(this.getRuntime(), "index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), true, false);
            if (begLen == null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(begLen[0], begLen[1]);
        }
        return this.entry(RubyNumeric.num2long(args[0]));
    }

    public IRubyObject aset(IRubyObject[] args) {
        int argc = this.argCount(args, 2, 3);
        if (argc == 3) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            this.replace(beg, len, args[2]);
            return args[2];
        }
        if (args[0] instanceof RubyFixnum) {
            this.store(RubyNumeric.fix2long(args[0]), args[1]);
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], args[1]);
            return args[1];
        }
        if (args[0] instanceof RubyBignum) {
            throw new RubyIndexException(this.getRuntime(), "Index too large");
        }
        this.store(RubyNumeric.num2long(args[0]), args[1]);
        return args[1];
    }

    public IRubyObject at(RubyFixnum pos) {
        return this.entry(pos.getLongValue());
    }

    public RubyArray concat(IRubyObject obj) {
        this.modify();
        RubyArray other = RubyArray.arrayValue(obj);
        this.list.addAll(other.getList());
        this.infectBy(other);
        return this;
    }

    public RubyString inspect() {
        int length = this.getLength();
        if (length == 0) {
            return RubyString.newString(this.getRuntime(), "[]");
        }
        RubyString result = RubyString.newString(this.getRuntime(), "[");
        RubyString sep = RubyString.newString(this.getRuntime(), ", ");
        int i = 0;
        while (i < length) {
            if (i > 0) {
                result.append(sep);
            }
            result.append(this.entry(i).callMethod("inspect"));
            ++i;
        }
        result.cat("]");
        return result;
    }

    public IRubyObject first() {
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return this.entry(0L);
    }

    public IRubyObject last() {
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return this.entry(this.getLength() - 1);
    }

    public IRubyObject each() {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.getRuntime().yield(this.entry(i));
            ++i;
        }
        return this;
    }

    public IRubyObject each_index() {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.getRuntime().yield(RubyFixnum.newFixnum(this.getRuntime(), i));
            ++i;
        }
        return this;
    }

    public IRubyObject reverse_each() {
        long i = this.getLength();
        while (i > 0L) {
            this.getRuntime().yield(this.entry(i - 1L));
            --i;
        }
        return this;
    }

    RubyString join(RubyString sep) {
        int length = this.getLength();
        if (length == 0) {
            RubyString.newString(this.getRuntime(), "");
        }
        boolean taint = this.isTaint() || sep.isTaint();
        IRubyObject tmp = this.entry(0L);
        taint |= tmp.isTaint();
        RubyString str = tmp instanceof RubyString ? (RubyString)tmp.dup() : (tmp instanceof RubyArray ? ((RubyArray)tmp).join(sep) : RubyString.objAsString(tmp));
        long i = 1L;
        while (i < (long)length) {
            tmp = this.entry(i);
            taint |= tmp.isTaint();
            if (tmp instanceof RubyArray) {
                tmp = ((RubyArray)tmp).join(sep);
            } else if (!(tmp instanceof RubyString)) {
                tmp = RubyString.objAsString(tmp);
            }
            str.append(sep.op_plus(tmp));
            ++i;
        }
        str.setTaint(taint);
        return str;
    }

    public RubyString join(IRubyObject[] args) {
        int argc = this.argCount(args, 0, 1);
        IRubyObject sep = argc == 1 ? args[0] : this.getRuntime().getGlobalVar("$,");
        return this.join(sep.isNil() ? RubyString.newString(this.getRuntime(), "") : RubyString.stringValue(sep));
    }

    public RubyString to_s() {
        IRubyObject sep = this.getRuntime().getGlobalVar("$,");
        return this.join(sep.isNil() ? RubyString.newString(this.getRuntime(), "") : RubyString.stringValue(sep));
    }

    public RubyArray to_a() {
        return this;
    }

    public RubyBoolean equal(IRubyObject obj) {
        RubyArray ary;
        if (this == obj) {
            return this.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        int length = this.getLength();
        if (length != (ary = (RubyArray)obj).getLength()) {
            return this.getRuntime().getFalse();
        }
        long i = 0L;
        while (i < (long)length) {
            if (!this.entry(i).callMethod("==", ary.entry(i)).isTrue()) {
                return this.getRuntime().getFalse();
            }
            ++i;
        }
        return this.getRuntime().getTrue();
    }

    public RubyBoolean eql(IRubyObject obj) {
        RubyArray ary;
        if (!(obj instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        int length = this.getLength();
        if (length != (ary = (RubyArray)obj).getLength()) {
            return this.getRuntime().getFalse();
        }
        long i = 0L;
        while (i < (long)length) {
            if (!this.entry(i).callMethod("eql?", ary.entry(i)).isTrue()) {
                return this.getRuntime().getFalse();
            }
            ++i;
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject compact_bang() {
        this.modify();
        boolean changed = false;
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (this.entry(i).isNil()) {
                this.list.remove(i);
                changed = true;
            }
            --i;
        }
        return changed ? this : this.getRuntime().getNil();
    }

    public IRubyObject compact() {
        RubyArray ary = (RubyArray)this.dup();
        ary.compact_bang();
        return ary;
    }

    public IRubyObject empty_p() {
        return this.getLength() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject clear() {
        this.modify();
        this.list.clear();
        return this;
    }

    public IRubyObject fill(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 3);
        int beg = 0;
        int len = this.getLength();
        switch (argc) {
            case 1: {
                break;
            }
            case 2: {
                if (args[1] instanceof RubyRange) {
                    long[] begLen = ((RubyRange)args[1]).getBeginLength(len, false, true);
                    beg = (int)begLen[0];
                    len = (int)begLen[1];
                    break;
                }
            }
            default: {
                int n = beg = args[1].isNil() ? beg : RubyNumeric.fix2int(args[1]);
                if (beg < 0 && (beg += len) < 0) {
                    throw new RubyIndexException(this.getRuntime(), "Negative array index");
                }
                len -= beg;
                if (argc != 3 || args[2].isNil()) break;
                len = RubyNumeric.fix2int(args[2]);
            }
        }
        this.modify();
        this.autoExpand(beg + len);
        int i = beg;
        while (i < beg + len) {
            this.list.set(i, args[0]);
            ++i;
        }
        return this;
    }

    public IRubyObject index(IRubyObject obj) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            if (obj.callMethod("==", this.entry(i)).isTrue()) {
                return RubyFixnum.newFixnum(this.getRuntime(), i);
            }
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rindex(IRubyObject obj) {
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (obj.callMethod("==", this.entry(i)).isTrue()) {
                return RubyFixnum.newFixnum(this.getRuntime(), i);
            }
            --i;
        }
        return this.getRuntime().getNil();
    }

    public RubyArray indices(IRubyObject[] args) {
        IRubyObject[] result = new IRubyObject[args.length];
        boolean taint = false;
        int i = 0;
        while (i < args.length) {
            result[i] = this.entry(RubyNumeric.fix2int(args[i]));
            taint |= result[i].isTaint();
            ++i;
        }
        RubyArray ary = RubyArray.create(this.getInternalClass(), result);
        ary.setTaint(taint);
        return ary;
    }

    public IRubyObject rbClone() {
        RubyArray ary = RubyArray.newArray(this.getRuntime(), new ArrayList(this.list));
        ary.setupClone(this);
        return ary;
    }

    public RubyArray reverse_bang() {
        if (this.list.size() <= 1) {
            return RubyArray.nilArray(this.runtime);
        }
        this.modify();
        Collections.reverse(this.list);
        return this;
    }

    public IRubyObject reverse() {
        RubyArray ary = (RubyArray)this.dup();
        ary.reverse_bang();
        return ary;
    }

    public RubyArray collect() {
        if (!this.getRuntime().isBlockGiven()) {
            return (RubyArray)this.dup();
        }
        ArrayList<IRubyObject> ary = new ArrayList<IRubyObject>();
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            ary.add(this.getRuntime().yield(this.entry(i)));
            ++i;
        }
        return new RubyArray(this.getRuntime(), ary);
    }

    public RubyArray collect_bang() {
        this.modify();
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.list.set(i, this.getRuntime().yield(this.entry(i)));
            ++i;
        }
        return this;
    }

    public IRubyObject delete(IRubyObject obj) {
        this.modify();
        IRubyObject retVal = this.getRuntime().getNil();
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (obj.callMethod("==", this.entry(i)).isTrue()) {
                retVal = (IRubyObject)this.list.remove(i);
            }
            --i;
        }
        if (retVal.isNil() && this.getRuntime().isBlockGiven()) {
            retVal = this.getRuntime().yield(this.entry(0L));
        }
        return retVal;
    }

    public IRubyObject delete_at(IRubyObject obj) {
        this.modify();
        int pos = (int)RubyNumeric.num2long(obj);
        int len = this.getLength();
        if (pos >= len) {
            return this.getRuntime().getNil();
        }
        if (pos < 0 && (pos += len) < 0) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.remove(pos);
    }

    public IRubyObject reject_bang() {
        this.modify();
        IRubyObject retVal = this.getRuntime().getNil();
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (this.getRuntime().yield(this.entry(i)).isTrue()) {
                retVal = (IRubyObject)this.list.remove(i);
            }
            --i;
        }
        return retVal.isNil() ? retVal : this;
    }

    public IRubyObject delete_if() {
        this.reject_bang();
        return this;
    }

    public IRubyObject replace(IRubyObject other) {
        this.replace(0L, this.getLength(), RubyArray.arrayValue(other));
        return this;
    }

    public IRubyObject op_cmp(IRubyObject other) {
        RubyArray ary = RubyArray.arrayValue(other);
        int otherLen = ary.getLength();
        int len = this.getLength();
        if (len != otherLen) {
            return len > otherLen ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.minus_one(this.getRuntime());
        }
        int i = 0;
        while (i < len) {
            RubyFixnum result = (RubyFixnum)this.entry(i).callMethod("<=>", ary.entry(i));
            if (result.getLongValue() != 0L) {
                return result;
            }
            ++i;
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject slice_bang(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        IRubyObject result = this.aref(args);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            this.replace(beg, len, this.getRuntime().getNil());
        } else if (args[0] instanceof RubyFixnum && RubyNumeric.fix2long(args[0]) < (long)this.getLength()) {
            this.replace(RubyNumeric.fix2long(args[0]), 1L, this.getRuntime().getNil());
        } else if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], this.getRuntime().getNil());
        }
        return result;
    }

    public IRubyObject assoc(IRubyObject arg) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            RubyArray ary;
            if (this.entry(i) instanceof RubyArray && ((RubyArray)this.entry(i)).getLength() > 0 && arg.callMethod("==", (ary = (RubyArray)this.entry(i)).entry(0L)).isTrue()) {
                return ary;
            }
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rassoc(IRubyObject arg) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            RubyArray ary;
            if (this.entry(i) instanceof RubyArray && ((RubyArray)this.entry(i)).getLength() > 1 && arg.callMethod("==", (ary = (RubyArray)this.entry(i)).entry(1L)).isTrue()) {
                return ary;
            }
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject flatten_bang() {
        this.modify();
        if (this.flatten(this.list)) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject flatten() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.flatten_bang();
        return rubyArray;
    }

    public IRubyObject nitems() {
        int count = 0;
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            count += this.entry(i).isNil() ? 0 : 1;
            ++i;
        }
        return RubyFixnum.newFixnum(this.getRuntime(), count);
    }

    public IRubyObject op_plus(IRubyObject other) {
        ArrayList otherList = RubyArray.arrayValue(other).getList();
        ArrayList newList = new ArrayList(this.getLength() + otherList.size());
        newList.addAll(this.list);
        newList.addAll(otherList);
        return new RubyArray(this.getRuntime(), newList);
    }

    public IRubyObject op_times(IRubyObject arg) {
        if (arg instanceof RubyString) {
            return this.join((RubyString)arg);
        }
        int len = (int)RubyNumeric.num2long(arg);
        if (len < 0) {
            throw new ArgumentError(this.getRuntime(), "negative argument");
        }
        ArrayList newList = new ArrayList(this.getLength() * len);
        int i = 0;
        while (i < len) {
            newList.addAll(this.list);
            ++i;
        }
        return new RubyArray(this.getRuntime(), newList);
    }

    private ArrayList uniq(List oldList) {
        int oldLength = oldList.size();
        ArrayList<IRubyObject> newList = new ArrayList<IRubyObject>(oldLength);
        int i = 0;
        while (i < oldLength) {
            IRubyObject obj = (IRubyObject)oldList.get(i);
            boolean found = false;
            int newLength = newList.size();
            int j = 0;
            while (j < newLength) {
                if (obj.callMethod("==", (IRubyObject)newList.get(j)).isTrue()) {
                    found = true;
                    break;
                }
                ++j;
            }
            if (!found) {
                newList.add(obj);
            }
            ++i;
        }
        newList.trimToSize();
        return newList;
    }

    public IRubyObject uniq_bang() {
        this.modify();
        ArrayList newList = this.uniq(this.list);
        if (newList.equals(this.list)) {
            return this.getRuntime().getNil();
        }
        this.list = newList;
        return this;
    }

    public IRubyObject uniq() {
        return new RubyArray(this.getRuntime(), this.uniq(this.list));
    }

    public IRubyObject op_diff(IRubyObject other) {
        ArrayList ary1 = this.uniq(this.list);
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        int len2 = ary2.size();
        int i = ary1.size() - 1;
        while (i >= 0) {
            IRubyObject obj = (IRubyObject)ary1.get(i);
            int j = 0;
            while (j < len2) {
                if (obj.callMethod("==", (IRubyObject)ary2.get(j)).isTrue()) {
                    ary1.remove(i);
                    break;
                }
                ++j;
            }
            --i;
        }
        return new RubyArray(this.getRuntime(), ary1);
    }

    public IRubyObject op_and(IRubyObject other) {
        ArrayList ary1 = this.uniq(this.list);
        int len1 = ary1.size();
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        int len2 = ary2.size();
        ArrayList<IRubyObject> ary3 = new ArrayList<IRubyObject>(len1);
        int i = 0;
        while (i < len1) {
            IRubyObject obj = (IRubyObject)ary1.get(i);
            int j = 0;
            while (j < len2) {
                if (obj.callMethod("==", (IRubyObject)ary2.get(j)).isTrue()) {
                    ary3.add(obj);
                    break;
                }
                ++j;
            }
            ++i;
        }
        ary3.trimToSize();
        return new RubyArray(this.getRuntime(), ary3);
    }

    public IRubyObject op_or(IRubyObject other) {
        ArrayList ary1 = new ArrayList(this.list);
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        ary1.addAll(ary2);
        return new RubyArray(this.getRuntime(), this.uniq(ary1));
    }

    public RubyArray sort() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.sort_bang();
        return rubyArray;
    }

    public IRubyObject sort_bang() {
        if (this.getLength() <= 1) {
            return this.getRuntime().getNil();
        }
        this.modify();
        this.setTmpLock(true);
        if (this.getRuntime().isBlockGiven()) {
            Collections.sort(this.list, new BlockComparator());
        } else {
            Collections.sort(this.list, new DefaultComparator());
        }
        this.setTmpLock(false);
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(91);
        output.dumpInt(this.getList().size());
        Iterator iter = this.getList().iterator();
        while (iter.hasNext()) {
            output.dumpObject((IRubyObject)iter.next());
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyArray result = RubyArray.newArray(input.getRuntime());
        int size = input.unmarshalInt();
        int i = 0;
        while (i < size) {
            result.append(input.unmarshalObject());
            ++i;
        }
        return result;
    }

    public RubyString pack(RubyString iFmt) {
        return Pack.pack(this.list, iFmt);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        M_INSPECT = 1;
        M_TO_S = 2;
        M_FROZEN = 3;
        M_EQUAL = 4;
        M_AREF = 10;
        M_ASET = 11;
        M_EQL = 12;
        M_HASH = 13;
        M_FIRST = 14;
        M_LAST = 15;
        M_CONCAT = 16;
        M_APPEND = 20;
        M_PUSH = 21;
        M_POP = 22;
        M_SHIFT = 23;
        M_UNSHIFT = 24;
        M_EACH = 25;
        M_EACH_INDEX = 26;
        M_REVERSE_EACH = 30;
        M_LENGTH = 31;
        M_EMPTY_P = 32;
        M_INDEX = 33;
        M_RINDEX = 34;
        M_CLONE = 40;
        M_JOIN = 41;
        M_INDICES = 42;
        M_REVERSE = 50;
        M_REVERSE_BANG = 51;
        M_SORT = 52;
        M_SORT_BANG = 53;
        M_COLLECT = 54;
        M_COLLECT_BANG = 60;
        M_DELETE = 61;
        M_DELETE_AT = 62;
        M_DELETE_IF = 63;
        M_REJECT_BANG = 64;
        M_REPLACE = 70;
        M_CLEAR = 71;
        M_INCLUDE_P = 72;
    }

    class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            IRubyObject obj1 = (IRubyObject)o1;
            IRubyObject obj2 = (IRubyObject)o2;
            if (o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                return (int)(RubyNumeric.fix2long(obj1) - RubyNumeric.fix2long(obj2));
            }
            if (o1 instanceof RubyString && o2 instanceof RubyString) {
                return RubyNumeric.fix2int(((RubyString)o1).op_cmp((IRubyObject)o2));
            }
            return RubyNumeric.fix2int(obj1.callMethod("<=>", obj2));
        }

        public boolean equals(Object other) {
            return this == other;
        }
    }

    class BlockComparator
    implements Comparator {
        BlockComparator() {
        }

        public int compare(Object o1, Object o2) {
            IRubyObject result = RubyArray.this.getRuntime().yield(RubyArray.newArray(RubyArray.this.getRuntime(), (IRubyObject)o1, (IRubyObject)o2));
            return (int)((RubyNumeric)result).getLongValue();
        }

        public boolean equals(Object other) {
            return this == other;
        }
    }
}

