/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;

public class RubyBoolean
extends RubyObject {
    private boolean value;
    static /* synthetic */ Class class$org$jruby$RubyBoolean;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyBoolean(Ruby ruby, boolean value) {
        super(ruby, null, false);
        this.value = value;
    }

    public Class getJavaClass() {
        return Boolean.TYPE;
    }

    public RubyClass getInternalClass() {
        return this.value ? this.getRuntime().getClasses().getTrueClass() : this.getRuntime().getClasses().getFalseClass();
    }

    public boolean isTrue() {
        return this.value;
    }

    public boolean isFalse() {
        return !this.value;
    }

    public static RubyClass createFalseClass(Ruby ruby) {
        RubyClass falseClass = ruby.defineClass("FalseClass", ruby.getClasses().getObjectClass());
        falseClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "to_s"));
        falseClass.defineMethod("type", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "type"));
        falseClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_and", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyBoolean.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        falseClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_or", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyBoolean.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        falseClass.defineMethod("^", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_xor", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyBoolean.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        falseClass.getInternalClass().undefMethod("new");
        ruby.defineGlobalConstant("FALSE", ruby.getFalse());
        return falseClass;
    }

    public static RubyClass createTrueClass(Ruby ruby) {
        RubyClass trueClass = ruby.defineClass("TrueClass", ruby.getClasses().getObjectClass());
        trueClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "to_s"));
        trueClass.defineMethod("type", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "type"));
        trueClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_and", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyBoolean.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        trueClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_or", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyBoolean.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        trueClass.defineMethod("^", CallbackFactory.getMethod(class$org$jruby$RubyBoolean == null ? (class$org$jruby$RubyBoolean = RubyBoolean.class$("org.jruby.RubyBoolean")) : class$org$jruby$RubyBoolean, "op_xor", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyBoolean.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        trueClass.getInternalClass().undefMethod("new");
        ruby.defineGlobalConstant("TRUE", ruby.getTrue());
        return trueClass;
    }

    public static RubyBoolean newBoolean(Ruby ruby, boolean value) {
        if (value) {
            return ruby.getTrue();
        }
        return ruby.getFalse();
    }

    public RubyString to_s() {
        if (this.value) {
            return RubyString.newString(this.getRuntime(), "true");
        }
        return RubyString.newString(this.getRuntime(), "false");
    }

    public RubyClass type() {
        return this.getInternalClass();
    }

    public RubyBoolean op_and(IRubyObject obj) {
        if (this.isTrue() && obj.isTrue()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public RubyBoolean op_or(IRubyObject obj) {
        if (this.isFalse() && !obj.isTrue()) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public RubyBoolean op_xor(IRubyObject obj) {
        if (this.isTrue() && !obj.isTrue() || this.isFalse() && obj.isTrue()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(this.isTrue() ? 84 : 70);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

