/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyDir;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyJava;
import org.jruby.RubyJavaInterface;
import org.jruby.RubyJavaObject;
import org.jruby.RubyKernel;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyMethod;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyPrecision;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyThread;
import org.jruby.RubyTime;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;

public class RubyClasses {
    private Ruby ruby;
    private RubyClass arrayClass;
    private RubyClass bignumClass;
    private RubyClass bindingClass;
    private RubyClass classClass;
    private RubyClass continuationClass;
    private RubyClass dirClass;
    private RubyClass exceptionClass;
    private RubyClass falseClass;
    private RubyClass fileClass;
    private RubyClass fileStatClass;
    private RubyClass fixnumClass;
    private RubyClass floatClass;
    private RubyClass hashClass;
    private RubyClass integerClass;
    private RubyClass ioClass;
    private RubyClass javaInterfaceClass;
    private RubyClass javaObjectClass;
    private RubyClass matchDataClass;
    private RubyClass methodClass;
    private RubyClass moduleClass;
    private RubyClass nilClass;
    private RubyClass numericClass;
    private RubyClass objectClass;
    private RubyClass procClass;
    private RubyClass rangeClass;
    private RubyClass regExpClass;
    private RubyClass stringClass;
    private RubyClass structClass;
    private RubyClass structTmsClass;
    private RubyClass symbolClass;
    private RubyClass threadClass;
    private RubyClass threadGroupClass;
    private RubyClass timeClass;
    private RubyClass trueClass;
    private RubyModule comparableModule;
    private RubyModule enumerableModule;
    private RubyModule gcModule;
    private RubyModule javaModule;
    private RubyModule kernelModule;
    private RubyModule marshalModule;
    private RubyModule mathModule;
    private RubyModule objectSpaceModule;
    private RubyModule processModule;
    private RubyModule precisionModule;
    private RubyMap classMap;

    public RubyClasses(Ruby ruby) {
        this.ruby = ruby;
        this.classMap = new RubyHashMap();
    }

    private RubyClass defineBootClass(String name, RubyClass superClass) {
        RubyClass bootClass = RubyClass.newClass(this.ruby, superClass);
        bootClass.setName(name);
        this.classMap.put(name, bootClass);
        return bootClass;
    }

    public void initCoreClasses() {
        this.objectClass = this.defineBootClass("Object", null);
        this.moduleClass = this.defineBootClass("Module", this.objectClass);
        this.classClass = this.defineBootClass("Class", this.moduleClass);
        RubyClass metaClass = this.objectClass.makeMetaClass(this.classClass);
        metaClass = this.moduleClass.makeMetaClass(metaClass);
        metaClass = this.classClass.makeMetaClass(metaClass);
        this.kernelModule = RubyKernel.createKernelModule(this.ruby);
        this.objectClass.includeModule(this.kernelModule);
        this.objectClass.definePrivateMethod("initialize", CallbackFactory.getNilMethod(-1));
        this.classClass.definePrivateMethod("inherited", CallbackFactory.getNilMethod(1));
        RubyObject.createObjectClass(this.objectClass);
        RubyClass.createClassClass(this.classClass);
        RubyModule.createModuleClass(this.moduleClass);
        this.nilClass = RubyNil.createNilClass(this.ruby);
        this.falseClass = RubyBoolean.createFalseClass(this.ruby);
        this.trueClass = RubyBoolean.createTrueClass(this.ruby);
    }

    public RubyClass getBindingClass() {
        return this.bindingClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyClass getModuleClass() {
        return this.moduleClass;
    }

    public RubyClass getStructClass() {
        if (this.structClass == null) {
            this.structClass = RubyStruct.createStructClass(this.ruby);
        }
        return this.structClass;
    }

    public RubyModule getComparableModule() {
        if (this.comparableModule == null) {
            this.comparableModule = RubyComparable.createComparable(this.ruby);
        }
        return this.comparableModule;
    }

    public RubyClass getHashClass() {
        if (this.hashClass == null) {
            this.hashClass = RubyHash.createHashClass(this.ruby);
        }
        return this.hashClass;
    }

    public RubyModule getMathModule() {
        if (this.mathModule == null) {
            this.mathModule = RubyMath.createMathModule(this.ruby);
        }
        return this.mathModule;
    }

    public RubyClass getRegExpClass() {
        if (this.regExpClass == null) {
            this.regExpClass = RubyRegexp.createRegexpClass(this.ruby);
        }
        return this.regExpClass;
    }

    public RubyModule getProcessModule() {
        return this.processModule;
    }

    public RubyClass getIoClass() {
        if (this.ioClass == null) {
            this.ioClass = RubyIO.createIOClass(this.ruby);
        }
        return this.ioClass;
    }

    public RubyClass getThreadGroupClass() {
        return this.threadGroupClass;
    }

    public RubyClass getBignumClass() {
        if (this.bignumClass == null) {
            this.bignumClass = RubyBignum.createBignumClass(this.ruby);
        }
        return this.bignumClass;
    }

    public RubyClass getStructTmsClass() {
        return this.structTmsClass;
    }

    public RubyClass getRangeClass() {
        if (this.rangeClass == null) {
            this.rangeClass = RubyRange.createRangeClass(this.ruby);
        }
        return this.rangeClass;
    }

    public RubyModule getGcModule() {
        if (this.gcModule == null) {
            this.gcModule = RubyGC.createGCModule(this.ruby);
        }
        return this.gcModule;
    }

    public RubyClass getSymbolClass() {
        if (this.symbolClass == null) {
            this.symbolClass = RubySymbol.createSymbolClass(this.ruby);
        }
        return this.symbolClass;
    }

    public RubyClass getProcClass() {
        if (this.procClass == null) {
            this.procClass = RubyProc.createProcClass(this.ruby);
        }
        return this.procClass;
    }

    public RubyClass getContinuationClass() {
        return this.continuationClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    public RubyClass getFloatClass() {
        if (this.floatClass == null) {
            this.floatClass = RubyFloat.createFloatClass(this.ruby);
        }
        return this.floatClass;
    }

    public RubyClass getMethodClass() {
        if (this.methodClass == null) {
            this.methodClass = RubyMethod.createMethodClass(this.ruby);
        }
        return this.methodClass;
    }

    public RubyClass getMatchDataClass() {
        if (this.matchDataClass == null) {
            this.matchDataClass = RubyMatchData.createMatchDataClass(this.ruby);
        }
        return this.matchDataClass;
    }

    public RubyModule getMarshalModule() {
        if (this.marshalModule == null) {
            this.marshalModule = RubyMarshal.createMarshalModule(this.ruby);
        }
        return this.marshalModule;
    }

    public RubyClass getFixnumClass() {
        if (this.fixnumClass == null) {
            this.fixnumClass = RubyFixnum.createFixnumClass(this.ruby);
        }
        return this.fixnumClass;
    }

    public RubyClass getObjectClass() {
        return this.objectClass;
    }

    public RubyModule getObjectSpaceModule() {
        if (this.objectSpaceModule == null) {
            this.objectSpaceModule = RubyObjectSpace.createObjectSpaceModule(this.ruby);
        }
        return this.objectSpaceModule;
    }

    public RubyClass getDirClass() {
        if (this.dirClass == null) {
            this.dirClass = RubyDir.createDirClass(this.ruby);
        }
        return this.dirClass;
    }

    public RubyClass getExceptionClass() {
        if (this.exceptionClass == null) {
            this.exceptionClass = RubyException.createExceptionClass(this.ruby);
        }
        return this.exceptionClass;
    }

    public RubyClass getStringClass() {
        if (this.stringClass == null) {
            this.stringClass = RubyString.createStringClass(this.ruby);
        }
        return this.stringClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    public RubyClass getIntegerClass() {
        if (this.integerClass == null) {
            this.integerClass = RubyInteger.createIntegerClass(this.ruby);
        }
        return this.integerClass;
    }

    public RubyModule getKernelModule() {
        return this.kernelModule;
    }

    public RubyClass getThreadClass() {
        if (this.threadClass == null) {
            this.threadClass = RubyThread.createThreadClass(this.ruby);
        }
        return this.threadClass;
    }

    public RubyClass getFileClass() {
        if (this.fileClass == null) {
            this.fileClass = RubyFile.createFileClass(this.ruby);
        }
        return this.fileClass;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyClass getArrayClass() {
        if (this.arrayClass == null) {
            this.arrayClass = RubyArray.createArrayClass(this.ruby);
        }
        return this.arrayClass;
    }

    public RubyClass getFileStatClass() {
        return this.fileStatClass;
    }

    public RubyModule getEnumerableModule() {
        if (this.enumerableModule == null) {
            this.enumerableModule = RubyEnumerable.createEnumerableModule(this.ruby);
        }
        return this.enumerableModule;
    }

    public RubyModule getPrecisionModule() {
        if (this.precisionModule == null) {
            this.precisionModule = RubyPrecision.createPrecisionModule(this.ruby);
        }
        return this.precisionModule;
    }

    public RubyClass getJavaObjectClass() {
        if (this.javaObjectClass == null) {
            this.javaObjectClass = RubyJavaObject.createJavaObjectClass(this.ruby);
        }
        return this.javaObjectClass;
    }

    public RubyModule getJavaModule() {
        if (this.javaModule == null) {
            this.javaModule = RubyJava.createJavaModule(this.ruby);
        }
        return this.javaModule;
    }

    public RubyClass getJavaInterfaceClass() {
        if (this.javaInterfaceClass == null) {
            this.javaInterfaceClass = RubyJavaInterface.createJavaInterfaceClass(this.ruby);
        }
        return this.javaInterfaceClass;
    }

    public RubyClass getNumericClass() {
        if (this.numericClass == null) {
            this.numericClass = RubyNumeric.createNumericClass(this.ruby);
        }
        return this.numericClass;
    }

    public RubyClass getTimeClass() {
        if (this.timeClass == null) {
            this.timeClass = RubyTime.createTimeClass(this.ruby);
        }
        return this.timeClass;
    }

    public RubyMap getClassMap() {
        return this.classMap;
    }

    public RubyModule getClass(String name) {
        RubyModule type = (RubyModule)this.classMap.get(name);
        if (type == null) {
            type = this.getAutoload(name);
        }
        return type;
    }

    private RubyModule getAutoload(String name) {
        if ((name = name.intern()) == "Array") {
            return this.getArrayClass();
        }
        if (name == "Bignum") {
            return this.getBignumClass();
        }
        if (name == "Binding") {
            return this.getBindingClass();
        }
        if (name == "Comparable") {
            return this.getComparableModule();
        }
        if (name == "Continuation") {
            return this.getContinuationClass();
        }
        if (name == "Dir") {
            return this.getDirClass();
        }
        if (name == "Enumerable") {
            return this.getEnumerableModule();
        }
        if (name == "Exception") {
            return this.getExceptionClass();
        }
        if (name == "File") {
            return this.getFileClass();
        }
        if (name == "Fixnum") {
            return this.getFixnumClass();
        }
        if (name == "Float") {
            return this.getFloatClass();
        }
        if (name == "GC") {
            return this.getGcModule();
        }
        if (name == "Hash") {
            return this.getHashClass();
        }
        if (name == "Integer") {
            return this.getIntegerClass();
        }
        if (name == "IO") {
            return this.getIoClass();
        }
        if (name == "Java") {
            return this.getJavaModule();
        }
        if (name == "Marshal") {
            return this.getMarshalModule();
        }
        if (name == "MatchData") {
            return this.getMatchDataClass();
        }
        if (name == "Math") {
            return this.getMathModule();
        }
        if (name == "Method") {
            return this.getMethodClass();
        }
        if (name == "Numeric") {
            return this.getNumericClass();
        }
        if (name == "ObjectSpace") {
            return this.getObjectSpaceModule();
        }
        if (name == "Precision") {
            return this.getPrecisionModule();
        }
        if (name == "Proc") {
            return this.getProcClass();
        }
        if (name == "Process") {
            return this.getProcessModule();
        }
        if (name == "Range") {
            return this.getRangeClass();
        }
        if (name == "Regexp") {
            return this.getRegExpClass();
        }
        if (name == "String") {
            return this.getStringClass();
        }
        if (name == "Struct") {
            return this.getStructClass();
        }
        if (name == "Symbol") {
            return this.getSymbolClass();
        }
        if (name == "Thread") {
            return this.getThreadClass();
        }
        if (name == "ThreadGroup") {
            return this.getThreadGroupClass();
        }
        if (name == "Time") {
            return this.getTimeClass();
        }
        return null;
    }

    public RubyModule getClassFromPath(String path) {
        RubyModule result = this.getClass(path);
        if (result != null) {
            return result;
        }
        IRubyObject evaluatedPath = this.ruby.evalScript(path);
        RubyClass type = evaluatedPath.getType();
        if (type != this.getClassClass() && type != this.getModuleClass()) {
            return null;
        }
        return (RubyModule)evaluatedPath;
    }

    public void putClass(String name, RubyModule rbClass) {
        this.classMap.put(name, rbClass);
    }

    public Iterator nameIterator() {
        return this.classMap.keySet().iterator();
    }
}

