/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyHash;
import org.jruby.RubyJavaObject;
import org.jruby.RubyMethod;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyJavaIObject
extends RubyJavaObject
implements InvocationHandler {
    static /* synthetic */ Class class$org$jruby$RubyJavaIObject;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$RubyProc;

    public RubyJavaIObject(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createJavaInterfaceObjectClass(Ruby ruby) {
        RubyClass javaInterfaceClass = ruby.defineClass("JavaInterfaceObject", ruby.getClasses().getJavaObjectClass());
        javaInterfaceClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyJavaIObject == null ? (class$org$jruby$RubyJavaIObject = RubyJavaIObject.class$("org.jruby.RubyJavaIObject")) : class$org$jruby$RubyJavaIObject, "newInstance"));
        javaInterfaceClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyJavaIObject == null ? (class$org$jruby$RubyJavaIObject = RubyJavaIObject.class$("org.jruby.RubyJavaIObject")) : class$org$jruby$RubyJavaIObject, "initialize"));
        javaInterfaceClass.defineMethod("assign", CallbackFactory.getMethod(class$org$jruby$RubyJavaIObject == null ? (class$org$jruby$RubyJavaIObject = RubyJavaIObject.class$("org.jruby.RubyJavaIObject")) : class$org$jruby$RubyJavaIObject, "assign", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyJavaIObject.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, class$org$jruby$RubyProc == null ? (class$org$jruby$RubyProc = RubyJavaIObject.class$("org.jruby.RubyProc")) : class$org$jruby$RubyProc));
        return javaInterfaceClass;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        RubyString methodName;
        IRubyObject result = this.getRuntime().getNil();
        RubyHash interfaceProcs = (RubyHash)this.getInstanceVariable("interfaceProcs");
        IRubyObject proc = interfaceProcs.aref(methodName = RubyString.newString(this.getRuntime(), method.getName()));
        if (!proc.isNil()) {
            IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(this.getRuntime(), args);
            result = ((RubyProc)proc).call(rubyArgs);
        } else {
            IRubyObject rubyMethod = this.method(methodName);
            if (!rubyMethod.isNil()) {
                IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(this.getRuntime(), args);
                result = ((RubyMethod)rubyMethod).call(rubyArgs);
            } else {
                IRubyObject[] rubyArgs = new IRubyObject[args.length + 1];
                int i = 0;
                while (i < args.length) {
                    rubyArgs[i + 1] = JavaUtil.convertJavaToRuby(this.getRuntime(), args[i]);
                    ++i;
                }
                result = this.callMethod("send", rubyArgs);
            }
        }
        return JavaUtil.convertRubyToJava(this.getRuntime(), result, method.getReturnType());
    }

    public static RubyJavaIObject newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyJavaIObject newInterface = new RubyJavaIObject(recv.getRuntime(), (RubyClass)recv);
        newInterface.callInit(args);
        return newInterface;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(this.getRuntime(), "");
        }
        Class[] interfaces = new Class[args.length];
        int i = 0;
        while (i < args.length) {
            String name = ((RubyString)args[i]).getValue();
            interfaces[i] = this.getRuntime().getJavaSupport().loadJavaClass(name);
            ++i;
        }
        try {
            this.setValue(Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)this));
        }
        catch (IllegalArgumentException iaExcptn) {
            // empty catch block
        }
        this.setInstanceVariable("interfaceProcs", RubyHash.newHash(this.getRuntime()));
        return this;
    }

    public IRubyObject assign(RubyString methodName, RubyProc proc) {
        ((RubyHash)this.getInstanceVariable("interfaceProcs")).aset(methodName, proc);
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

