/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyJavaObject;
import org.jruby.RubyMethod;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyJavaInterface
extends RubyJavaObject {
    public RubyJavaInterface(Ruby ruby, Object proxyObject) {
        super(ruby, ruby.getClasses().getJavaInterfaceClass());
        this.setValue(proxyObject);
    }

    public static RubyClass createJavaInterfaceClass(Ruby ruby) {
        RubyClass javaInterfaceClass = ruby.defineClass("JavaInterface", ruby.getClasses().getJavaObjectClass());
        return javaInterfaceClass;
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Method interfaceMethod, final RubyProc proc) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{interfaceMethod.getDeclaringClass()}, new InvocationHandler(){

            public Object invoke(Object recv, Method imethod, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, proc.call(JavaUtil.convertJavaArrayToRuby(ruby, args)));
            }
        }));
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Method interfaceMethod, final RubyMethod method) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{interfaceMethod.getDeclaringClass()}, new InvocationHandler(){

            public Object invoke(Object recv, Method imethod, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, method.call(JavaUtil.convertJavaArrayToRuby(ruby, args)));
            }
        }));
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Method interfaceMethod, final IRubyObject receiver, final RubyString method) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{interfaceMethod.getDeclaringClass()}, new InvocationHandler(){

            public Object invoke(Object recv, Method imethod, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, receiver.callMethod(method.toId(), JavaUtil.convertJavaArrayToRuby(ruby, args)));
            }
        }));
    }

    public static RubyJavaInterface newJavaInterface(final Ruby ruby, Class javaInterface, final IRubyObject receiver) {
        return new RubyJavaInterface(ruby, Proxy.newProxyInstance(null, new Class[]{javaInterface}, new InvocationHandler(){

            public Object invoke(Object recv, Method method, Object[] args) {
                return JavaUtil.convertJavaToRuby(ruby, receiver.callMethod(method.getName(), JavaUtil.convertJavaArrayToRuby(ruby, args)));
            }
        }));
    }
}

