/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.ZSuperNode;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NameError;
import org.jruby.exceptions.RubyFrozenException;
import org.jruby.exceptions.RubySecurityException;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.methods.EvaluateMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Callback;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.Frame;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.util.Asserts;
import org.jruby.util.IdUtil;
import org.jruby.util.PrintfFormat;
import org.jruby.util.RubyHashMap;
import org.jruby.util.RubyMap;
import org.jruby.util.RubyMapMethod;

public class RubyObject
implements Cloneable,
IRubyObject {
    protected transient Ruby runtime;
    private RubyClass internalClass;
    private RubyMap instanceVariables;
    private boolean frozen;
    private boolean taint;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyObject;
    static /* synthetic */ Class class$org$jruby$RubyModule;

    public RubyObject(Ruby ruby) {
        this(ruby, null, false);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, true);
    }

    public RubyObject(Ruby ruby, RubyClass rubyClass, boolean useObjectSpace) {
        this.runtime = ruby;
        this.internalClass = rubyClass;
        this.frozen = false;
        this.taint = false;
        if (useObjectSpace) {
            ruby.objectSpace.add(this);
        }
    }

    public static IRubyObject nilObject(Ruby ruby) {
        if (ruby.getNil() != null) {
            return ruby.getNil();
        }
        return new RubyObject(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public RubyClass makeMetaClass(RubyClass type) {
        this.setInternalClass(type.newSingletonClass());
        this.getInternalClass().attachSingletonClass(this);
        return this.getInternalClass();
    }

    public Class getJavaClass() {
        return class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyObject.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject;
    }

    public boolean equals(Object other) {
        return other == this || other instanceof IRubyObject && this.callMethod("==", (IRubyObject)other).isTrue();
    }

    public String toString() {
        return ((RubyString)this.callMethod("to_s")).getValue();
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public RubyMap getInstanceVariables() {
        return this.instanceVariables;
    }

    public void setInstanceVariables(RubyMap instanceVariables) {
        this.instanceVariables = instanceVariables;
    }

    public RubyClass getInternalClass() {
        if (this.isNil()) {
            return this.getRuntime().getClasses().getNilClass();
        }
        return this.internalClass;
    }

    public void setInternalClass(RubyClass rubyClass) {
        this.internalClass = rubyClass;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    public boolean isTaint() {
        return this.taint;
    }

    public void setTaint(boolean taint) {
        this.taint = taint;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isTrue() {
        return !this.isNil();
    }

    public boolean isFalse() {
        return this.isNil();
    }

    public boolean respondsTo(String name) {
        return this.getInternalClass().isMethodBound(name, false);
    }

    public static void createObjectClass(RubyModule objectClass) {
        objectClass.defineMethod("==", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "equal", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyObject.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        objectClass.defineMethod("=~", CallbackFactory.getFalseMethod(1));
        objectClass.defineMethod("clone", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "rbClone"));
        objectClass.defineMethod("dup", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "dup"));
        objectClass.defineMethod("eql?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "equal", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyObject.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        objectClass.defineMethod("respond_to?", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "respond_to"));
        objectClass.defineMethod("extend", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "extend"));
        objectClass.defineMethod("freeze", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "freeze"));
        objectClass.defineMethod("frozen?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "frozen"));
        objectClass.defineMethod("id", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "id"));
        objectClass.defineMethod("hash", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "hash"));
        objectClass.defineMethod("__id__", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "id"));
        objectClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "inspect"));
        objectClass.defineMethod("instance_eval", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_eval"));
        objectClass.defineMethod("instance_of?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule));
        objectClass.defineMethod("instance_variables", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "instance_variables"));
        objectClass.defineMethod("is_a?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "kind_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule));
        objectClass.defineMethod("kind_of?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "kind_of", class$org$jruby$RubyModule == null ? (class$org$jruby$RubyModule = RubyObject.class$("org.jruby.RubyModule")) : class$org$jruby$RubyModule));
        objectClass.defineMethod("method", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "method", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyObject.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        objectClass.defineMethod("methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "methods"));
        objectClass.defineMethod("nil?", CallbackFactory.getFalseMethod(0));
        objectClass.defineMethod("private_methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "private_methods"));
        objectClass.defineMethod("protected_methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "protected_methods"));
        objectClass.defineMethod("public_methods", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "methods"));
        objectClass.defineMethod("send", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "send"));
        objectClass.defineMethod("__send__", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "send"));
        objectClass.defineMethod("taint", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "taint"));
        objectClass.defineMethod("tainted?", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "tainted"));
        objectClass.defineMethod("to_a", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "to_a"));
        objectClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "to_s"));
        objectClass.defineMethod("type", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "type"));
        objectClass.defineMethod("untaint", CallbackFactory.getMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "untaint"));
        objectClass.defineMethod("method_missing", CallbackFactory.getOptMethod(class$org$jruby$RubyObject == null ? (class$org$jruby$RubyObject = RubyObject.class$("org.jruby.RubyObject")) : class$org$jruby$RubyObject, "method_missing"));
        objectClass.defineAlias("===", "==");
        objectClass.defineAlias("class", "type");
        objectClass.defineAlias("equal?", "==");
    }

    public int argCount(IRubyObject[] args, int min, int max) {
        int len = args.length;
        if (len < min || max > -1 && len > max) {
            throw new ArgumentError(this.getRuntime(), "Wrong # of arguments for method. " + args.length + " is not in Range " + min + ".." + max);
        }
        return len;
    }

    public boolean isKindOf(RubyModule type) {
        return this.getInternalClass().ancestors().includes(type);
    }

    private RubyClass getNilSingletonClass() {
        RubyClass rubyClass = this.getInternalClass();
        if (!rubyClass.isSingleton()) {
            rubyClass = rubyClass.newSingletonClass();
            rubyClass.attachSingletonClass(this);
        }
        return rubyClass;
    }

    public RubyClass getSingletonClass() {
        if (this.isNil()) {
            return this.getNilSingletonClass();
        }
        RubyClass type = this.getInternalClass().isSingleton() ? this.getInternalClass() : this.makeMetaClass(this.getInternalClass());
        type.setTaint(this.isTaint());
        type.setFrozen(this.isFrozen());
        return type;
    }

    public void defineSingletonMethod(String name, Callback method) {
        this.getSingletonClass().defineMethod(name, method);
    }

    public void setupClone(IRubyObject obj) {
        this.setInternalClass(obj.getInternalClass().getSingletonClassClone());
        this.getInternalClass().attachSingletonClass(this);
        this.frozen = obj.isFrozen();
        this.taint = obj.isTaint();
    }

    protected void infectBy(IRubyObject obj) {
        this.setTaint(this.isTaint() || obj.isTaint());
    }

    public IRubyObject callMethod(String name, IRubyObject[] args) {
        return this.getInternalClass().call(this, name, args, CallType.FUNCTIONAL);
    }

    public IRubyObject callMethod(String name) {
        return this.callMethod(name, new IRubyObject[0]);
    }

    public IRubyObject funcall3(String name, IRubyObject[] args) {
        return this.getInternalClass().call(this, name, args, CallType.NORMAL);
    }

    public IRubyObject callMethod(String name, IRubyObject arg) {
        return this.callMethod(name, new IRubyObject[]{arg});
    }

    public IRubyObject getInstanceVariable(String name) {
        IRubyObject value;
        if (this.getInstanceVariables() != null && (value = (IRubyObject)this.getInstanceVariables().get(name)) != null) {
            return value;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject setInstanceVariable(String name, IRubyObject value) {
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't modify instance variable");
        }
        if (this.isFrozen()) {
            throw new RubyFrozenException(this.getRuntime(), "");
        }
        if (this.getInstanceVariables() == null) {
            this.setInstanceVariables(new RubyHashMap());
        }
        this.getInstanceVariables().put(name, value);
        return value;
    }

    public boolean isInstanceVarDefined(String name) {
        return this.getInstanceVariables() != null && this.getInstanceVariables().get(name) != null;
    }

    public RubyModule getClassVarSingleton() {
        return this.getInternalClass();
    }

    public IRubyObject eval(INode n) {
        return EvaluateVisitor.createVisitor(this).eval(n);
    }

    public void callInit(IRubyObject[] args) {
        this.runtime.getIterStack().push(this.runtime.isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
        this.callMethod("initialize", args);
        this.runtime.getIterStack().pop();
    }

    public void extendObject(RubyModule module) {
        this.getSingletonClass().includeModule(module);
    }

    public String toId() {
        throw new TypeError(this.getRuntime(), this.inspect().getValue() + " is not a symbol");
    }

    public IRubyObject convertToType(String targetType, String convertMethod, boolean raise) {
        if (!this.respondsTo(convertMethod)) {
            if (raise) {
                throw new TypeError(this.runtime, "Failed to convert " + this.getInternalClass().toName() + " into " + targetType + ".");
            }
            return this.runtime.getNil();
        }
        return this.callMethod(convertMethod);
    }

    public IRubyObject convertType(Class type, String targetType, String convertMethod) {
        if (type.isAssignableFrom(this.getClass())) {
            return this;
        }
        IRubyObject result = this.convertToType(targetType, convertMethod, true);
        if (!type.isAssignableFrom(result.getClass())) {
            throw new TypeError(this.runtime, this.getInternalClass().toName() + "#" + convertMethod + " should return " + targetType + ".");
        }
        return result;
    }

    public void checkSafeString() {
        if (this.runtime.getSafeLevel() > 0 && this.isTaint()) {
            if (this.runtime.getCurrentFrame().getLastFunc() != null) {
                throw new RubySecurityException(this.runtime, "Insecure operation - " + this.runtime.getCurrentFrame().getLastFunc());
            }
            throw new RubySecurityException(this.runtime, "Insecure operation: -r");
        }
        this.getRuntime().secure(4);
        if (!(this instanceof RubyString)) {
            throw new TypeError(this.getRuntime(), "wrong argument type " + this.getInternalClass().toName() + " (expected String)");
        }
    }

    public IRubyObject specificEval(RubyModule mod, IRubyObject[] args) {
        if (this.getRuntime().isBlockGiven()) {
            if (args.length > 0) {
                throw new ArgumentError(this.getRuntime(), "wrong # of arguments (" + args.length + " for 0)");
            }
            return this.yieldUnder(mod);
        }
        if (args.length == 0) {
            throw new ArgumentError(this.getRuntime(), "block not supplied");
        }
        if (args.length > 3) {
            String lastFuncName = this.runtime.getCurrentFrame().getLastFunc();
            throw new ArgumentError(this.getRuntime(), "wrong # of arguments: " + lastFuncName + "(src) or " + lastFuncName + "{..}");
        }
        IRubyObject file = args.length > 1 ? args[1] : RubyString.newString(this.getRuntime(), "(eval)");
        IRubyObject line = args.length > 2 ? args[2] : RubyFixnum.one(this.getRuntime());
        return this.evalUnder(mod, args[0], file, line);
    }

    public IRubyObject evalUnder(RubyModule under, IRubyObject src, IRubyObject file, IRubyObject line) {
        return under.executeUnder(new Callback(){

            public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                return args[0].eval(args[1], self.getRuntime().getNil(), ((RubyString)args[2]).getValue(), RubyNumeric.fix2int(args[3]));
            }

            public int getArity() {
                return -1;
            }
        }, new IRubyObject[]{this, src, file, line});
    }

    public IRubyObject yieldUnder(RubyModule under) {
        return under.executeUnder(new Callback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public IRubyObject execute(IRubyObject self, IRubyObject[] args) {
                Block oldBlock = RubyObject.this.runtime.getBlockStack().getCurrent().cloneBlock();
                RubyObject.this.runtime.getBlockStack().getCurrent().getFrame().setNamespace(RubyObject.this.runtime.getCurrentFrame().getNamespace());
                try {
                    IRubyObject iRubyObject = RubyObject.this.runtime.yield(args[0], args[0], RubyObject.this.runtime.getRubyClass(), false);
                    Object var6_5 = null;
                    RubyObject.this.runtime.getBlockStack().setCurrent(oldBlock);
                    return iRubyObject;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    RubyObject.this.runtime.getBlockStack().setCurrent(oldBlock);
                    throw throwable;
                }
            }

            public int getArity() {
                return -1;
            }
        }, new IRubyObject[]{this});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject eval(IRubyObject src, IRubyObject scope, String file, int line) {
        ISourcePosition savedPosition = this.runtime.getPosition();
        Iter iter = this.runtime.getCurrentFrame().getIter();
        if (file == null) {
            file = this.runtime.getSourceFile();
        }
        if (scope.isNil() && this.runtime.getFrameStack().getPrevious() != null) {
            this.runtime.getCurrentFrame().setIter(this.runtime.getFrameStack().getPrevious().getIter());
        }
        this.getRuntime().pushClass(this.runtime.getCBase());
        IRubyObject result = this.getRuntime().getNil();
        try {
            INode node = this.getRuntime().parse(src.toString(), file);
            result = this.eval(node);
            Object var10_9 = null;
            this.runtime.popClass();
            if (scope.isNil()) {
                this.runtime.getCurrentFrame().setIter(iter);
            }
            this.runtime.setPosition(savedPosition);
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            this.runtime.popClass();
            if (scope.isNil()) {
                this.runtime.getCurrentFrame().setIter(iter);
            }
            this.runtime.setPosition(savedPosition);
            throw throwable;
        }
        return result;
    }

    public RubyBoolean equal(IRubyObject obj) {
        if (this.isNil()) {
            return RubyBoolean.newBoolean(this.getRuntime(), obj.isNil());
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this == obj);
    }

    public RubyBoolean respond_to(IRubyObject[] args) {
        this.argCount(args, 1, 2);
        String name = args[0].toId();
        boolean includePrivate = args.length > 1 ? args[1].isTrue() : false;
        return RubyBoolean.newBoolean(this.runtime, this.getInternalClass().isMethodBound(name, !includePrivate));
    }

    public RubyFixnum id() {
        return RubyFixnum.newFixnum(this.getRuntime(), System.identityHashCode(this));
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, System.identityHashCode(this));
    }

    public final int hashCode() {
        return RubyNumeric.fix2int(this.callMethod("hash"));
    }

    public RubyClass type() {
        return this.getInternalClass().getRealClass();
    }

    public IRubyObject rbClone() {
        try {
            IRubyObject clone = (IRubyObject)this.clone();
            clone.setupClone(this);
            if (this.getInstanceVariables() != null) {
                ((RubyObject)clone).setInstanceVariables(this.getInstanceVariables().cloneRubyMap());
            }
            return clone;
        }
        catch (CloneNotSupportedException cnsExcptn) {
            Asserts.assertNotReached(cnsExcptn.getMessage());
            return null;
        }
    }

    public IRubyObject dup() {
        IRubyObject dup = this.callMethod("clone");
        if (!dup.getClass().equals(this.getClass())) {
            throw new TypeError(this.getRuntime(), "duplicated object must be same type");
        }
        dup.setInternalClass(this.type());
        dup.setFrozen(false);
        return dup;
    }

    public RubyBoolean tainted() {
        if (this.isTaint()) {
            return this.getRuntime().getTrue();
        }
        return this.getRuntime().getFalse();
    }

    public IRubyObject taint() {
        this.getRuntime().secure(4);
        if (!this.isTaint()) {
            if (this.isFrozen()) {
                throw new RubyFrozenException(this.getRuntime(), "object");
            }
            this.setTaint(true);
        }
        return this;
    }

    public IRubyObject untaint() {
        this.getRuntime().secure(3);
        if (this.isTaint()) {
            if (this.isFrozen()) {
                throw new RubyFrozenException(this.getRuntime(), "object");
            }
            this.setTaint(false);
        }
        return this;
    }

    public IRubyObject freeze() {
        if (this.getRuntime().getSafeLevel() >= 4 && this.isTaint()) {
            throw new RubySecurityException(this.getRuntime(), "Insecure: can't freeze object");
        }
        this.setFrozen(true);
        return this;
    }

    public RubyBoolean frozen() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isFrozen());
    }

    public RubyString inspect() {
        return (RubyString)this.callMethod("to_s");
    }

    public RubyBoolean instance_of(RubyModule type) {
        return RubyBoolean.newBoolean(this.getRuntime(), this.type() == type);
    }

    public RubyArray instance_variables() {
        ArrayList<RubyString> names = new ArrayList<RubyString>();
        Iterator iter = this.instanceVariables.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            names.add(RubyString.newString(this.getRuntime(), name));
        }
        return RubyArray.newArray(this.runtime, names);
    }

    public RubyBoolean kind_of(RubyModule type) {
        return RubyBoolean.newBoolean(this.runtime, this.isKindOf(type));
    }

    public IRubyObject methods() {
        return this.getInternalClass().instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public IRubyObject protected_methods() {
        return this.getInternalClass().protected_instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public IRubyObject private_methods() {
        return this.getInternalClass().private_instance_methods(new IRubyObject[]{this.getRuntime().getTrue()});
    }

    public RubyArray singleton_methods() {
        RubyArray ary = RubyArray.newArray(this.getRuntime());
        RubyClass type = this.getInternalClass();
        while (type != null && type.isSingleton()) {
            type.getMethods().foreach(new RubyMapMethod(){

                public int execute(Object key, Object value, Object arg) {
                    RubyString name = RubyString.newString(RubyObject.this.getRuntime(), (String)key);
                    if (((ICallable)value).getVisibility().isPublic()) {
                        if (!((RubyArray)arg).includes(name)) {
                            if ((ICallable)value == null) {
                                ((RubyArray)arg).append(RubyObject.this.getRuntime().getNil());
                            }
                            ((RubyArray)arg).append(name);
                        }
                    } else if (value instanceof EvaluateMethod && ((EvaluateMethod)value).getNode() instanceof ZSuperNode) {
                        ((RubyArray)arg).append(RubyObject.this.getRuntime().getNil());
                        ((RubyArray)arg).append(name);
                    }
                    return 0;
                }
            }, ary);
            type = type.getSuperClass();
        }
        ary.compact_bang();
        return ary;
    }

    public IRubyObject method(IRubyObject symbol) {
        return this.getInternalClass().newMethod(this, symbol.toId(), this.getRuntime().getClasses().getMethodClass());
    }

    public RubyArray to_a() {
        return RubyArray.newArray(this.getRuntime(), this);
    }

    public RubyString to_s() {
        String cname = this.getInternalClass().toName();
        RubyString str = RubyString.newString(this.getRuntime(), "");
        str.setValue("#<" + cname + ":0x" + Integer.toHexString(System.identityHashCode(this)) + ">");
        str.setTaint(this.isTaint());
        return str;
    }

    public IRubyObject instance_eval(IRubyObject[] args) {
        return this.specificEval(this.getSingletonClass(), args);
    }

    public IRubyObject extend(IRubyObject[] args) {
        if (args.length == 0) {
            throw new ArgumentError(this.runtime, "wrong # of arguments");
        }
        int i = 0;
        while (i < args.length) {
            args[i].callMethod("extend_object", this);
            ++i;
        }
        return this;
    }

    public IRubyObject method_missing(IRubyObject[] args) {
        boolean noClass;
        if (args.length == 0) {
            throw new ArgumentError(this.getRuntime(), "no id given");
        }
        String name = args[0].toId();
        String description = this.callMethod("inspect").toString();
        boolean bl = noClass = description.charAt(0) == '#';
        if (this.isNil()) {
            noClass = true;
            description = "nil";
        } else if (this == this.runtime.getTrue()) {
            noClass = true;
            description = "true";
        } else if (this == this.runtime.getFalse()) {
            noClass = true;
            description = "false";
        }
        String format = "Undefined method '%s' for %s%s%s";
        if (this.runtime.getLastCallStatus().isPrivate()) {
            format = "private method '%s' called for %s%s%s";
        } else if (this.runtime.getLastCallStatus().isProtected()) {
            format = "protected method '%s' called for %s%s%s";
        } else if (this.runtime.getLastCallStatus().isVariable() && IdUtil.isLocal(name)) {
            format = "Undefined local variable or method '%s' for %s%s%s";
        }
        String msg = new PrintfFormat(format).sprintf(new Object[]{name, description, noClass ? "" : ":", noClass ? "" : this.getType().toName()});
        Frame current = this.runtime.getCurrentFrame();
        try {
            throw new NameError(this.getRuntime(), msg);
        }
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject send(IRubyObject[] args) {
        IRubyObject iRubyObject;
        if (args.length < 1) {
            throw new ArgumentError(this.runtime, "no method name given");
        }
        String name = args[0].toId();
        IRubyObject[] newArgs = new IRubyObject[args.length - 1];
        System.arraycopy(args, 1, newArgs, 0, newArgs.length);
        this.runtime.getIterStack().push(this.runtime.isBlockGiven() ? Iter.ITER_PRE : Iter.ITER_NOT);
        try {
            iRubyObject = this.getInternalClass().call(this, name, newArgs, CallType.FUNCTIONAL);
            Object var6_5 = null;
            this.getRuntime().getIterStack().pop();
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.getRuntime().getIterStack().pop();
            throw throwable;
        }
        return iRubyObject;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(111);
        RubySymbol classname = RubySymbol.newSymbol(this.runtime, this.getInternalClass().getClassname());
        output.dumpObject(classname);
        if (this.getInstanceVariables() == null) {
            output.dumpInt(0);
        } else {
            output.dumpInt(this.getInstanceVariables().size());
            Iterator iter = this.getInstanceVariables().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                String name = (String)entry.getKey();
                IRubyObject value = (IRubyObject)entry.getValue();
                output.dumpObject(RubySymbol.newSymbol(this.runtime, name));
                output.dumpObject(value);
            }
        }
    }

    public RubyClass getType() {
        return this.type();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

