/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubySymbol;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RubyIndexException;
import org.jruby.exceptions.TypeError;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.IndexedCallback;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Asserts;
import org.jruby.util.Pack;
import org.jruby.util.PrintfFormat;

public class RubyString
extends RubyObject
implements IndexCallable {
    private static final String encoding = "iso8859-1";
    private String value;
    private static final int M_CLONE = 101;
    private static final int M_DUP = 1;
    private static final int M_OP_CMP = 2;
    private static final int M_EQUAL = 3;
    private static final int M_HASH = 4;
    private static final int M_OP_PLUS = 5;
    private static final int M_FORMAT = 7;
    private static final int M_LENGTH = 8;
    private static final int M_EMPTY = 9;
    private static final int M_MATCH = 10;
    private static final int M_MATCH2 = 11;
    private static final int M_SUCC = 12;
    private static final int M_SUCC_BANG = 13;
    private static final int M_UPTO = 14;
    private static final int M_REPLACE = 15;
    private static final int M_TO_I = 20;
    private static final int M_TO_F = 21;
    private static final int M_INSPECT = 22;
    private static final int M_CONCAT = 50;
    private static final int M_INTERN = 51;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$jruby$RubyString;
    static /* synthetic */ Class class$org$jruby$RubyInteger;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;

    public RubyString(Ruby ruby) {
        this(ruby, (String)null);
    }

    public RubyString(Ruby ruby, String str) {
        this(ruby, ruby.getClasses().getStringClass(), str);
    }

    public RubyString(Ruby ruby, RubyClass rubyClass, String str) {
        super(ruby, rubyClass);
        this.value = str;
    }

    public static RubyString nilString(Ruby ruby) {
        return new RubyString(ruby){

            public boolean isNil() {
                return true;
            }
        };
    }

    public Class getJavaClass() {
        return class$java$lang$String == null ? (class$java$lang$String = RubyString.class$("java.lang.String")) : class$java$lang$String;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public String toString() {
        return this.getValue();
    }

    public static String bytesToString(byte[] bytes) {
        try {
            return new String(bytes, encoding);
        }
        catch (UnsupportedEncodingException e) {
            Asserts.assertNotReached("unsupported encoding " + e);
            return null;
        }
    }

    public static byte[] stringToBytes(String string) {
        try {
            return string.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            Asserts.assertNotReached("unsupported encoding " + e);
            return null;
        }
    }

    public byte[] toByteArray() {
        return RubyString.stringToBytes(this.value);
    }

    public static RubyClass createStringClass(Ruby ruby) {
        RubyClass stringClass = ruby.defineClass("String", ruby.getClasses().getObjectClass());
        stringClass.includeModule(ruby.getClasses().getComparableModule());
        stringClass.includeModule(ruby.getClasses().getEnumerableModule());
        stringClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "newInstance"));
        stringClass.defineMethod("initialize", IndexedCallback.create(15, 1));
        stringClass.defineMethod("clone", IndexedCallback.create(101, 0));
        stringClass.defineMethod("dup", IndexedCallback.create(1, 0));
        stringClass.defineMethod("<=>", IndexedCallback.create(2, 1));
        stringClass.defineMethod("==", IndexedCallback.create(3, 1));
        stringClass.defineMethod("===", IndexedCallback.create(3, 1));
        stringClass.defineMethod("eql?", IndexedCallback.create(3, 1));
        stringClass.defineMethod("hash", IndexedCallback.create(4, 0));
        stringClass.defineMethod("+", IndexedCallback.create(5, 1));
        stringClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "op_mul", class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyString.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger));
        stringClass.defineMethod("%", IndexedCallback.create(7, 1));
        stringClass.defineMethod("[]", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "aref"));
        stringClass.defineMethod("[]=", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "aset"));
        stringClass.defineMethod("length", IndexedCallback.create(8, 0));
        stringClass.defineMethod("size", IndexedCallback.create(8, 0));
        stringClass.defineMethod("empty?", IndexedCallback.create(9, 0));
        stringClass.defineMethod("=~", IndexedCallback.create(10, 1));
        stringClass.defineMethod("~", IndexedCallback.create(11, 0));
        stringClass.defineMethod("succ", IndexedCallback.create(12, 0));
        stringClass.defineMethod("succ!", IndexedCallback.create(13, 0));
        stringClass.defineMethod("next", IndexedCallback.create(12, 0));
        stringClass.defineMethod("next!", IndexedCallback.create(13, 0));
        stringClass.defineMethod("upto", IndexedCallback.create(14, 1));
        stringClass.defineMethod("index", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "index"));
        stringClass.defineMethod("rindex", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "rindex"));
        stringClass.defineMethod("replace", IndexedCallback.create(15, 1));
        stringClass.defineMethod("to_i", IndexedCallback.create(20, 0));
        stringClass.defineMethod("to_f", IndexedCallback.create(21, 0));
        stringClass.defineMethod("to_s", CallbackFactory.getSelfMethod(0));
        stringClass.defineMethod("to_str", CallbackFactory.getSelfMethod(0));
        stringClass.defineMethod("inspect", IndexedCallback.create(22, 0));
        stringClass.defineMethod("dump", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "dump"));
        stringClass.defineMethod("upcase", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "upcase"));
        stringClass.defineMethod("downcase", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "downcase"));
        stringClass.defineMethod("capitalize", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "capitalize"));
        stringClass.defineMethod("swapcase", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "swapcase"));
        stringClass.defineMethod("upcase!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "upcase_bang"));
        stringClass.defineMethod("downcase!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "downcase_bang"));
        stringClass.defineMethod("capitalize!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "capitalize_bang"));
        stringClass.defineMethod("swapcase!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "swapcase_bang"));
        stringClass.defineMethod("hex", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "hex"));
        stringClass.defineMethod("oct", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "oct"));
        stringClass.defineMethod("split", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "split"));
        stringClass.defineMethod("reverse", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "reverse"));
        stringClass.defineMethod("reverse!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "reverse_bang"));
        stringClass.defineMethod("concat", IndexedCallback.create(50, 1));
        stringClass.defineMethod("<<", IndexedCallback.create(50, 1));
        stringClass.defineMethod("intern", IndexedCallback.create(51, 0));
        stringClass.defineMethod("include?", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "include", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyString.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        stringClass.defineMethod("scan", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "scan", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyString.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        stringClass.defineMethod("ljust", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "ljust", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyString.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        stringClass.defineMethod("rjust", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "rjust", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyString.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        stringClass.defineMethod("center", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "center", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyString.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        stringClass.defineMethod("sub", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "sub"));
        stringClass.defineMethod("gsub", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "gsub"));
        stringClass.defineMethod("chop", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chop"));
        stringClass.defineMethod("chomp", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chomp"));
        stringClass.defineMethod("strip", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "strip"));
        stringClass.defineMethod("sub!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "sub_bang"));
        stringClass.defineMethod("gsub!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "gsub_bang"));
        stringClass.defineMethod("chop!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chop_bang"));
        stringClass.defineMethod("chomp!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "chomp_bang"));
        stringClass.defineMethod("strip!", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "strip_bang"));
        stringClass.defineMethod("tr", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr"));
        stringClass.defineMethod("tr_s", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr_s"));
        stringClass.defineMethod("delete", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "delete"));
        stringClass.defineMethod("squeeze", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "squeeze"));
        stringClass.defineMethod("count", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "count"));
        stringClass.defineMethod("tr!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr_bang"));
        stringClass.defineMethod("tr_s!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "tr_s_bang"));
        stringClass.defineMethod("delete!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "delete_bang"));
        stringClass.defineMethod("squeeze!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "squeeze_bang"));
        stringClass.defineMethod("each_line", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "each_line"));
        stringClass.defineMethod("each", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "each_line"));
        stringClass.defineMethod("each_byte", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "each_byte"));
        stringClass.defineMethod("slice", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "aref"));
        stringClass.defineMethod("slice!", CallbackFactory.getOptMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "slice_bang"));
        stringClass.defineMethod("unpack", CallbackFactory.getMethod(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "unpack", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        return stringClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 101: {
                return this.rbClone();
            }
            case 1: {
                return this.dup();
            }
            case 2: {
                return this.op_cmp(args[0]);
            }
            case 3: {
                return this.equal(args[0]);
            }
            case 4: {
                return this.hash();
            }
            case 5: {
                return this.op_plus(args[0]);
            }
            case 7: {
                return this.format(args[0]);
            }
            case 8: {
                return this.length();
            }
            case 9: {
                return this.empty();
            }
            case 10: {
                return this.match(args[0]);
            }
            case 11: {
                return this.match2();
            }
            case 12: {
                return this.succ();
            }
            case 13: {
                return this.succ_bang();
            }
            case 14: {
                return this.upto(args[0]);
            }
            case 15: {
                return this.replace(args[0]);
            }
            case 20: {
                return this.to_i();
            }
            case 21: {
                return this.to_f();
            }
            case 22: {
                return this.inspect();
            }
            case 50: {
                return this.concat(args[0]);
            }
            case 51: {
                return this.intern();
            }
        }
        Asserts.assertNotReached();
        return null;
    }

    public static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    public static boolean isUpper(char c) {
        return c >= 'A' && c <= 'Z';
    }

    public static boolean isLower(char c) {
        return c >= 'a' && c <= 'z';
    }

    public static boolean isLetter(char c) {
        return RubyString.isUpper(c) || RubyString.isLower(c);
    }

    public static boolean isAlnum(char c) {
        return RubyString.isUpper(c) || RubyString.isLower(c) || RubyString.isDigit(c);
    }

    public static boolean isPrint(char c) {
        return c >= ' ' && c <= '~';
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, this.getValue().hashCode());
    }

    public static RubyString objAsString(IRubyObject obj) {
        if (obj instanceof RubyString) {
            return (RubyString)obj;
        }
        return (RubyString)obj.callMethod("to_s");
    }

    public int cmp(RubyString other) {
        return this.getValue().compareTo(other.getValue());
    }

    public String toId() {
        return this.getValue();
    }

    public RubyString newString(String s) {
        RubyClass type = this.getInternalClass();
        while (type.isIncluded() || type.isSingleton()) {
            type = type.getSuperClass();
        }
        return new RubyString(this.getRuntime(), type, s);
    }

    public static RubyString newString(Ruby ruby, String str) {
        return new RubyString(ruby, str);
    }

    public static RubyString newString(Ruby ruby, String str, int len) {
        return new RubyString(ruby, str.substring(0, len));
    }

    public static RubyString newString(Ruby ruby, byte[] bytes) {
        return RubyString.newString(ruby, RubyString.bytesToString(bytes));
    }

    public IRubyObject dup() {
        RubyString newStr = this.newString(this.getValue());
        newStr.infectBy(this);
        return newStr;
    }

    public IRubyObject rbClone() {
        IRubyObject newObject = this.dup();
        newObject.setupClone(this);
        return newObject;
    }

    public RubyString cat(String str) {
        this.value = this.value + str;
        return this;
    }

    public RubyString to_s() {
        return this;
    }

    public RubyString replace(IRubyObject other) {
        RubyString str = RubyString.stringValue(other);
        if (this == other || this.getValue().equals(str.getValue())) {
            return this;
        }
        this.setValue(str.getValue());
        this.infectBy(str);
        return this;
    }

    public RubyString reverse() {
        StringBuffer sb = new StringBuffer(this.getValue().length());
        int i = this.getValue().length() - 1;
        while (i >= 0) {
            sb.append(this.getValue().charAt(i));
            --i;
        }
        return this.newString(sb.toString());
    }

    public RubyString reverse_bang() {
        StringBuffer sb = new StringBuffer(this.getValue().length());
        int i = this.getValue().length() - 1;
        while (i >= 0) {
            sb.append(this.getValue().charAt(i));
            --i;
        }
        this.setValue(sb.toString());
        return this;
    }

    public static RubyString newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyString newString = RubyString.newString(recv.getRuntime(), "");
        newString.setInternalClass((RubyClass)recv);
        newString.callInit(args);
        return newString;
    }

    public RubyFixnum op_cmp(IRubyObject other) {
        return RubyFixnum.newFixnum(this.getRuntime(), this.cmp(RubyString.stringValue(other)));
    }

    public RubyBoolean equal(IRubyObject other) {
        if (other == this) {
            return this.getRuntime().getTrue();
        }
        if (!(other instanceof RubyString)) {
            return this.getRuntime().getFalse();
        }
        return this.getValue().equals(((RubyString)other).getValue()) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject match(IRubyObject other) {
        if (other instanceof RubyRegexp) {
            return ((RubyRegexp)other).match(this);
        }
        if (other instanceof RubyString) {
            return RubyRegexp.newRegexp((RubyString)other, 0).match(this);
        }
        return other.callMethod("=~", this);
    }

    public IRubyObject match2() {
        return RubyRegexp.newRegexp(this, 0).match2();
    }

    public RubyString capitalize() {
        int length = this.getValue().length();
        StringBuffer sb = new StringBuffer(length);
        if (length > 0) {
            sb.append(Character.toUpperCase(this.getValue().charAt(0)));
        }
        if (length > 1) {
            sb.append(this.getValue().toLowerCase().substring(1));
        }
        return this.newString(sb.toString());
    }

    public RubyString capitalize_bang() {
        int length = this.getValue().length();
        StringBuffer sb = new StringBuffer(length);
        if (length > 0) {
            sb.append(Character.toUpperCase(this.getValue().charAt(0)));
        }
        if (length > 1) {
            sb.append(this.getValue().toLowerCase().substring(1));
        }
        this.setValue(sb.toString());
        return this;
    }

    public RubyString upcase() {
        return this.newString(this.getValue().toUpperCase());
    }

    public RubyString upcase_bang() {
        this.setValue(this.getValue().toUpperCase());
        return this;
    }

    public RubyString downcase() {
        return this.newString(this.getValue().toLowerCase());
    }

    public RubyString downcase_bang() {
        this.setValue(this.getValue().toLowerCase());
        return this;
    }

    public RubyString swapcase() {
        RubyString newString = this.newString(this.getValue());
        return newString.swapcase_bang();
    }

    public RubyString swapcase_bang() {
        char[] chars = this.getValue().toCharArray();
        StringBuffer sb = new StringBuffer(chars.length);
        int i = 0;
        while (i < chars.length) {
            if (!Character.isLetter(chars[i])) {
                sb.append(chars[i]);
            } else if (Character.isLowerCase(chars[i])) {
                sb.append(Character.toUpperCase(chars[i]));
            } else {
                sb.append(Character.toLowerCase(chars[i]));
            }
            ++i;
        }
        this.setValue(this.getValue().toLowerCase());
        return this;
    }

    public RubyString dump() {
        return this.inspect(true);
    }

    public RubyString inspect() {
        return this.inspect(false);
    }

    private RubyString inspect(boolean dump) {
        int length = this.getValue().length();
        StringBuffer sb = new StringBuffer(length + 2 + length / 100);
        sb.append('\"');
        int i = 0;
        while (i < length) {
            char c = this.getValue().charAt(i);
            if (RubyString.isAlnum(c)) {
                sb.append(c);
            } else if (c == '\"' || c == '\\') {
                sb.append('\\').append(c);
            } else if (dump && c == '#') {
                sb.append('\\').append(c);
            } else if (RubyString.isPrint(c)) {
                sb.append(c);
            } else if (c == '\n') {
                sb.append('\\').append('n');
            } else if (c == '\r') {
                sb.append('\\').append('r');
            } else if (c == '\t') {
                sb.append('\\').append('t');
            } else if (c == '\f') {
                sb.append('\\').append('f');
            } else if (c == '\u000b') {
                sb.append('\\').append('v');
            } else if (c == '\u0007') {
                sb.append('\\').append('a');
            } else if (c == '\u001b') {
                sb.append('\\').append('e');
            } else {
                sb.append(new PrintfFormat("\\%.3o").sprintf(c));
            }
            ++i;
        }
        sb.append('\"');
        return RubyString.newString(this.getRuntime(), sb.toString());
    }

    public RubyString op_plus(IRubyObject other) {
        RubyString str = RubyString.stringValue(other);
        RubyString newString = this.newString(this.getValue() + str.getValue());
        newString.infectBy(str);
        return newString;
    }

    public RubyString op_mul(RubyInteger other) {
        long len = other.getLongValue();
        if (len < 0L) {
            throw new ArgumentError(this.getRuntime(), "negative argument");
        }
        if (len > 0L && Long.MAX_VALUE / len < (long)this.getValue().length()) {
            throw new ArgumentError(this.getRuntime(), "argument too big");
        }
        StringBuffer sb = new StringBuffer((int)((long)this.getValue().length() * len));
        int i = 0;
        while ((long)i < len) {
            sb.append(this.getValue());
            ++i;
        }
        RubyString newString = this.newString(sb.toString());
        newString.setTaint(this.isTaint());
        return newString;
    }

    public RubyFixnum length() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.getValue().length());
    }

    public RubyBoolean empty() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.getValue().length() == 0);
    }

    public RubyString append(IRubyObject other) {
        this.infectBy(other);
        return this.cat(RubyString.stringValue(other).getValue());
    }

    public RubyString concat(IRubyObject other) {
        if (other instanceof RubyFixnum && ((RubyFixnum)other).getLongValue() < 256L) {
            char c = (char)((RubyFixnum)other).getLongValue();
            return this.cat("" + c);
        }
        return this.append(other);
    }

    public static RubyString stringValue(IRubyObject anObject) {
        if (anObject instanceof RubyString) {
            return (RubyString)anObject;
        }
        return (RubyString)anObject.convertType(class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyString.class$("org.jruby.RubyString")) : class$org$jruby$RubyString, "String", "to_str");
    }

    public IRubyObject sub(IRubyObject[] args) {
        return this.sub(args, false);
    }

    public IRubyObject sub_bang(IRubyObject[] args) {
        return this.sub(args, true);
    }

    private IRubyObject sub(IRubyObject[] args, boolean bang) {
        IRubyObject repl = this.getRuntime().getNil();
        boolean iter = false;
        if (args.length == 1 && this.getRuntime().isBlockGiven()) {
            iter = true;
        } else if (args.length == 2) {
            repl = args[1];
        } else {
            throw new ArgumentError(this.getRuntime(), "wrong number of arguments");
        }
        RubyRegexp pat = RubyRegexp.regexpValue(args[0]);
        if (pat.search(this, 0) >= 0) {
            RubyMatchData match = (RubyMatchData)this.getRuntime().getBackref();
            RubyString newStr = match.pre_match();
            newStr.append((RubyString)(iter ? this.getRuntime().yield(match.group(0L)) : pat.regsub(repl, match)));
            newStr.append(match.post_match());
            if (bang) {
                this.replace(newStr);
                return this;
            }
            return newStr;
        }
        if (bang) {
            return this.getRuntime().getNil();
        }
        return this;
    }

    public IRubyObject gsub(IRubyObject[] args) {
        return this.gsub(args, false);
    }

    public IRubyObject gsub_bang(IRubyObject[] args) {
        return this.gsub(args, true);
    }

    private IRubyObject gsub(IRubyObject[] args, boolean bang) {
        IRubyObject repl = this.getRuntime().getNil();
        boolean iter = false;
        if (args.length == 1 && this.getRuntime().isBlockGiven()) {
            iter = true;
        } else if (args.length == 2) {
            repl = args[1];
        } else {
            throw new ArgumentError(this.getRuntime(), "wrong number of arguments");
        }
        boolean taint = repl.isTaint();
        RubyRegexp pat = RubyRegexp.regexpValue(args[0]);
        int beg = pat.search(this, 0);
        if (beg < 0) {
            return bang ? this.getRuntime().getNil() : this.dup();
        }
        StringBuffer sbuf = new StringBuffer();
        String str = this.getValue();
        int offset = 0;
        while (beg >= 0) {
            RubyMatchData match = (RubyMatchData)this.getRuntime().getBackref();
            sbuf.append(str.substring(offset, beg));
            IRubyObject newStr = iter ? this.getRuntime().yield(match.group(0L)) : pat.regsub(repl, match);
            taint |= newStr.isTaint();
            sbuf.append(((RubyString)newStr).getValue());
            offset = match.matchEndPosition();
            beg = pat.search(this, offset == beg ? beg + 1 : offset);
        }
        sbuf.append(str.substring(offset, str.length()));
        if (bang) {
            this.setTaint(this.isTaint() || taint);
            this.setValue(sbuf.toString());
            return this;
        }
        RubyString result = this.newString(sbuf.toString());
        result.setTaint(taint);
        return result;
    }

    public IRubyObject index(IRubyObject[] args) {
        return this.index(args, false);
    }

    public IRubyObject rindex(IRubyObject[] args) {
        return this.index(args, true);
    }

    private IRubyObject index(IRubyObject[] args, boolean reverse) {
        int pos = 0;
        if (reverse) {
            pos = this.getValue().length();
        }
        if (this.argCount(args, 1, 2) == 2) {
            pos = RubyNumeric.fix2int(args[1]);
        }
        if (pos < 0 && (pos += this.getValue().length()) < 0) {
            return this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyRegexp) {
            int dummy = pos = ((RubyRegexp)args[0]).search(this, pos);
            while (reverse && dummy > -1) {
                pos = dummy;
                dummy = ((RubyRegexp)args[0]).search(this, pos + 1);
            }
        } else if (args[0] instanceof RubyString) {
            String sub = ((RubyString)args[0]).getValue();
            pos = reverse ? this.getValue().lastIndexOf(sub, pos) : this.getValue().indexOf(sub, pos);
        } else if (args[0] instanceof RubyFixnum) {
            char c = (char)((RubyFixnum)args[0]).getLongValue();
            pos = reverse ? this.getValue().lastIndexOf(c, pos) : this.getValue().indexOf(c, pos);
        } else {
            throw new ArgumentError(this.getRuntime(), "wrong type of argument");
        }
        if (pos == -1) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), pos);
    }

    private IRubyObject substr(int beg, int len) {
        int strLen = this.getValue().length();
        if (len < 0 || beg > strLen) {
            return this.getRuntime().getNil();
        }
        if (beg < 0 && (beg += strLen) < 0) {
            return this.getRuntime().getNil();
        }
        int end = Math.min(strLen, beg + len);
        RubyString newStr = this.newString(this.getValue().substring(beg, end));
        newStr.infectBy(this);
        return newStr;
    }

    private IRubyObject replace(int beg, int len, RubyString repl) {
        int strLen = this.getValue().length();
        if (beg + len >= strLen) {
            len = strLen - beg;
        }
        this.setValue(this.getValue().substring(0, beg) + repl.getValue() + this.getValue().substring(beg + len));
        this.infectBy(repl);
        return this;
    }

    public IRubyObject aref(IRubyObject[] args) {
        if (this.argCount(args, 1, 2) == 2) {
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            return this.substr(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            int idx = RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx += this.getValue().length();
            }
            if (idx < 0 || idx >= this.getValue().length()) {
                return this.getRuntime().getNil();
            }
            return RubyFixnum.newFixnum(this.getRuntime(), this.getValue().charAt(idx));
        }
        if (args[0] instanceof RubyRegexp) {
            if (RubyRegexp.regexpValue(args[0]).search(this, 0) >= 0) {
                return RubyRegexp.last_match(this.getRuntime().getBackref());
            }
            return this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyString) {
            if (this.getValue().indexOf(RubyString.stringValue(args[0]).getValue()) != -1) {
                return args[0];
            }
            return this.getRuntime().getNil();
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getValue().length(), true, false);
            if (begLen == null) {
                return this.getRuntime().getNil();
            }
            return this.substr((int)begLen[0], (int)begLen[1]);
        }
        int idx = (int)RubyNumeric.num2long(args[0]);
        if (idx < 0) {
            idx += this.getValue().length();
        }
        if (idx < 0 || idx >= this.getValue().length()) {
            return this.getRuntime().getNil();
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.getValue().charAt(idx));
    }

    public IRubyObject aset(IRubyObject[] args) {
        int strLen = this.getValue().length();
        if (this.argCount(args, 2, 3) == 3) {
            RubyString repl = RubyString.stringValue(args[2]);
            int beg = RubyNumeric.fix2int(args[0]);
            int len = RubyNumeric.fix2int(args[1]);
            if (len < 0) {
                throw new RubyIndexException(this.getRuntime(), "negative length");
            }
            if (beg < 0) {
                beg += strLen;
            }
            if (beg < 0 || beg >= strLen) {
                throw new RubyIndexException(this.getRuntime(), "string index out of bounds");
            }
            if (beg + len > strLen) {
                len = strLen - beg;
            }
            this.replace(beg, len, repl);
            return repl;
        }
        if (args[0] instanceof RubyFixnum) {
            int idx = RubyNumeric.fix2int(args[0]);
            if (idx < 0) {
                idx += this.getValue().length();
            }
            if (idx < 0 || idx >= this.getValue().length()) {
                throw new RubyIndexException(this.getRuntime(), "string index out of bounds");
            }
            if (args[1] instanceof RubyFixnum) {
                char c = (char)RubyNumeric.fix2int(args[1]);
                this.setValue(this.getValue().substring(0, idx) + c + this.getValue().substring(idx + 1));
            } else {
                this.replace(idx, 1, RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRegexp) {
            this.sub_bang(args);
            return args[1];
        }
        if (args[0] instanceof RubyString) {
            RubyString orig = RubyString.stringValue(args[0]);
            int beg = this.getValue().indexOf(orig.getValue());
            if (beg != -1) {
                this.replace(beg, orig.getValue().length(), RubyString.stringValue(args[1]));
            }
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] idxs = ((RubyRange)args[0]).getBeginLength(this.getValue().length(), true, true);
            this.replace((int)idxs[0], (int)idxs[1], RubyString.stringValue(args[1]));
            return args[1];
        }
        throw new TypeError(this.getRuntime(), "wrong argument type");
    }

    public IRubyObject slice_bang(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        IRubyObject[] newArgs = new IRubyObject[argc + 1];
        newArgs[0] = args[0];
        if (argc > 1) {
            newArgs[1] = args[1];
        }
        newArgs[argc] = this.newString("");
        IRubyObject result = this.aref(args);
        this.aset(newArgs);
        return result;
    }

    public IRubyObject format(IRubyObject arg) {
        if (arg instanceof RubyArray) {
            Object[] args = new Object[((RubyArray)arg).getLength()];
            int i = 0;
            while (i < args.length) {
                args[i] = JavaUtil.convertRubyToJava(this.runtime, ((RubyArray)arg).entry(i));
                ++i;
            }
            return RubyString.newString(this.runtime, new PrintfFormat(Locale.US, this.getValue()).sprintf(args));
        }
        return RubyString.newString(this.runtime, new PrintfFormat(Locale.US, this.getValue()).sprintf(JavaUtil.convertRubyToJava(this.runtime, arg)));
    }

    public IRubyObject succ() {
        return this.succ(false);
    }

    public IRubyObject succ_bang() {
        return this.succ(true);
    }

    private RubyString succ(boolean bang) {
        if (this.getValue().length() == 0) {
            return bang ? this : (RubyString)this.dup();
        }
        StringBuffer sbuf = new StringBuffer(this.getValue());
        boolean alnumSeen = false;
        int pos = -1;
        char c = '\u0000';
        char n = '\u0000';
        int i = sbuf.length() - 1;
        while (i >= 0) {
            c = sbuf.charAt(i);
            if (RubyString.isAlnum(c)) {
                alnumSeen = true;
                if (RubyString.isDigit(c) && c < '9' || RubyString.isLower(c) && c < 'z' || RubyString.isUpper(c) && c < 'Z') {
                    sbuf.setCharAt(i, (char)(c + '\u0001'));
                    pos = -1;
                    break;
                }
                pos = i;
                n = RubyString.isDigit(c) ? (char)'0' : (RubyString.isLower(c) ? (char)'a' : 'A');
                sbuf.setCharAt(i, n);
            }
            --i;
        }
        if (!alnumSeen) {
            int i2 = sbuf.length() - 1;
            while (i2 >= 0) {
                c = sbuf.charAt(i2);
                if (c < '\u00ff') {
                    sbuf.setCharAt(i2, (char)(c + '\u0001'));
                    pos = -1;
                    break;
                }
                pos = i2;
                n = '\u0001';
                sbuf.setCharAt(i2, '\u0000');
                --i2;
            }
        }
        if (pos > -1) {
            sbuf.insert(pos, n);
        }
        if (bang) {
            this.setValue(sbuf.toString());
            return this;
        }
        RubyString newStr = (RubyString)this.dup();
        newStr.setValue(sbuf.toString());
        return newStr;
    }

    public IRubyObject upto(IRubyObject str) {
        return this.upto(str, false);
    }

    public IRubyObject upto(IRubyObject str, boolean excl) {
        RubyString current = this;
        RubyString end = RubyString.stringValue(str);
        while (current.cmp(end) <= 0) {
            this.getRuntime().yield(current);
            if (current.cmp(end) == 0) break;
            current = current.succ(false);
            if (excl && current.cmp(end) == 0 || current.getValue().length() > end.getValue().length()) break;
        }
        return this;
    }

    public RubyBoolean include(IRubyObject obj) {
        if (obj instanceof RubyFixnum) {
            char c = (char)RubyNumeric.fix2int(obj);
            return this.getValue().indexOf(c) == -1 ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
        }
        String str = RubyString.stringValue(obj).getValue();
        return this.getValue().indexOf(str) == -1 ? this.getRuntime().getFalse() : this.getRuntime().getTrue();
    }

    public IRubyObject to_i() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 10);
    }

    public IRubyObject oct() {
        int pos;
        int base = 8;
        String str = this.getValue().trim();
        int n = pos = str.charAt(0) == '-' || str.charAt(0) == '+' ? 1 : 0;
        if (str.indexOf("0x") == pos || str.indexOf("0X") == pos) {
            base = 16;
        } else if (str.indexOf("0b") == pos || str.indexOf("0B") == pos) {
            base = 2;
        }
        return RubyNumeric.str2inum(this.getRuntime(), this, base);
    }

    public IRubyObject hex() {
        return RubyNumeric.str2inum(this.getRuntime(), this, 16);
    }

    public IRubyObject to_f() {
        return RubyNumeric.str2fnum(this.getRuntime(), this);
    }

    /*
     * Unable to fully structure code
     */
    public RubyArray split(IRubyObject[] args) {
        block16: {
            limit = 0;
            pat = null;
            str = null;
            argc = this.argCount(args, 0, 2);
            if (argc == 2 && (limit = RubyNumeric.fix2int(args[1])) == 1) {
                return RubyArray.newArray(this.getRuntime(), this.dup());
            }
            result = RubyArray.newArray(this.getRuntime(), 0L);
            pos = 0;
            beg = 0;
            hits = 0;
            len = this.getValue().length();
            if (argc > 0) {
                if (args[0] instanceof RubyRegexp) {
                    pat = RubyRegexp.regexpValue(args[0]);
                } else {
                    str = RubyString.stringValue(args[0]);
                    if (str.getValue().equals(" ")) {
                        pat = RubyRegexp.newRegexp(this.getRuntime(), "\\s+", 0);
                    } else if (str.getValue().length() != 1) {
                        pat = RubyRegexp.newRegexp(str, 0);
                    }
                }
            } else {
                pat = RubyRegexp.newRegexp(this.getRuntime(), "\\s+", 0);
            }
            if (pat == null) ** GOTO lbl38
            while ((beg = pat.search(this, pos)) > -1) {
                end = ((RubyMatchData)this.getRuntime().getBackref()).matchEndPosition();
                result.append(this.substr(pos, beg == pos && end == beg ? 1 : beg - pos));
                v0 = pos = end == beg ? beg + 1 : end;
                if (++hits + 1 != limit) {
                    continue;
                }
                break block16;
            }
            break block16;
lbl-1000:
            // 1 sources

            {
                result.append(this.substr(pos, beg - pos));
                if (++hits + 1 == limit) break;
                pos = beg + 1;
lbl38:
                // 2 sources

                ** while ((beg = this.getValue().indexOf((String)str.getValue(), (int)pos)) > -1)
            }
        }
        if (hits == 0) {
            result.append(this.dup());
        } else if (pos <= len) {
            result.append(this.substr(pos, len - pos));
        }
        if (limit == 0) {
            while (((RubyString)result.entry(result.getLength() - 1)).empty().isTrue()) {
                result.pop();
            }
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public IRubyObject scan(IRubyObject arg) {
        pat = RubyRegexp.regexpValue(arg);
        start = 0;
        if (this.getRuntime().isBlockGiven()) ** GOTO lbl30
        ary = RubyArray.newArray(this.getRuntime());
        while (pat.search(this, start) != -1) {
            md = (RubyMatchData)this.getRuntime().getBackref();
            if (md.getSize() == 1L) {
                ary.append(md.group(0L));
            } else {
                ary.append(md.subseq(1L, md.getSize()));
            }
            if (md.matchEndPosition() == md.matchStartPosition()) {
                ++start;
                continue;
            }
            start = md.matchEndPosition();
        }
        return ary;
lbl-1000:
        // 1 sources

        {
            md = (RubyMatchData)this.getRuntime().getBackref();
            if (md.getSize() == 1L) {
                this.getRuntime().yield(md.group(0L));
            } else {
                this.getRuntime().yield(md.subseq(1L, md.getSize()));
            }
            if (md.matchEndPosition() == md.matchStartPosition()) {
                ++start;
                continue;
            }
            start = md.matchEndPosition();
lbl30:
            // 3 sources

            ** while (pat.search((IRubyObject)this, (int)start) != -1)
        }
lbl31:
        // 1 sources

        return this;
    }

    public IRubyObject ljust(IRubyObject arg) {
        int len = RubyNumeric.fix2int(arg);
        if (len <= this.getValue().length()) {
            return this.dup();
        }
        Object[] args = new Object[]{this.getValue(), new Integer(-len)};
        return this.newString(new PrintfFormat("%*2$s").sprintf(args));
    }

    public IRubyObject rjust(IRubyObject arg) {
        int len = RubyNumeric.fix2int(arg);
        if (len <= this.getValue().length()) {
            return this.dup();
        }
        Object[] args = new Object[]{this.getValue(), new Integer(len)};
        return this.newString(new PrintfFormat("%*2$s").sprintf(args));
    }

    public IRubyObject center(IRubyObject arg) {
        int strLen;
        int len = RubyNumeric.fix2int(arg);
        if (len <= (strLen = this.getValue().length())) {
            return this.dup();
        }
        StringBuffer sbuf = new StringBuffer(len);
        int lead = (len - strLen) / 2;
        int pos = 0;
        while (pos < len) {
            if (pos == lead) {
                sbuf.append(this.getValue());
                pos += strLen;
                continue;
            }
            sbuf.append(' ');
            ++pos;
        }
        return this.newString(sbuf.toString());
    }

    private String getChop() {
        if (this.getValue().length() == 0) {
            return null;
        }
        int end = this.getValue().length() - 1;
        if (this.getValue().charAt(end) == '\n' && end > 0 && this.getValue().charAt(end - 1) == '\r') {
            --end;
        }
        return this.getValue().substring(0, end);
    }

    public IRubyObject chop() {
        String newStr = this.getChop();
        if (newStr == null) {
            return this.dup();
        }
        return this.newString(newStr);
    }

    public IRubyObject chop_bang() {
        String newStr = this.getChop();
        if (newStr == null) {
            return this.getRuntime().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    protected String getChomp(IRubyObject[] args) {
        if (this.getValue().length() == 0) {
            return null;
        }
        String sep = null;
        if (this.argCount(args, 0, 1) == 1) {
            sep = RubyString.stringValue(args[0]).getValue();
        }
        int end = -1;
        if (sep != null && this.getValue().endsWith(sep)) {
            return this.getValue().substring(0, this.getValue().lastIndexOf(sep));
        }
        if (this.getValue().endsWith("\r\n")) {
            end = this.getValue().length() - 2;
        } else if (this.getValue().endsWith("\n") || this.getValue().endsWith("\r")) {
            end = this.getValue().length() - 1;
        }
        return end == -1 ? null : this.getValue().substring(0, end);
    }

    public IRubyObject chomp(IRubyObject[] args) {
        String newStr = this.getChomp(args);
        if (newStr == null) {
            return this.dup();
        }
        return this.newString(newStr);
    }

    public IRubyObject chomp_bang(IRubyObject[] args) {
        String newStr = this.getChomp(args);
        if (newStr == null) {
            return this.getRuntime().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    public IRubyObject strip() {
        if (this.getValue().length() == 0) {
            return this.dup();
        }
        return this.newString(this.getValue().trim());
    }

    public IRubyObject strip_bang() {
        if (this.getValue().length() == 0) {
            return this.getRuntime().getNil();
        }
        String newStr = this.getValue().trim();
        if (newStr.equals(this.getValue())) {
            return this.getRuntime().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    private String expandTemplate(String spec, boolean invertOK) {
        int len = spec.length();
        if (len <= 1) {
            return spec;
        }
        StringBuffer sbuf = new StringBuffer();
        int pos = invertOK && spec.startsWith("^") ? 1 : 0;
        while (pos < len) {
            int c1 = spec.charAt(pos);
            if (pos + 2 < len && spec.charAt(pos + 1) == '-') {
                char c2 = spec.charAt(pos + 2);
                if (c2 > c1) {
                    int i = c1;
                    while (i <= c2) {
                        sbuf.append((char)i);
                        ++i;
                    }
                }
                pos += 3;
                continue;
            }
            sbuf.append((char)c1);
            ++pos;
        }
        return sbuf.toString();
    }

    private String setupTable(String[] specs) {
        int[] table = new int[256];
        int numSets = 0;
        int i = 0;
        while (i < specs.length) {
            String template = this.expandTemplate(specs[i], true);
            boolean invert = specs[i].length() > 1 && specs[i].startsWith("^");
            int j = 0;
            while (j < 256) {
                if (template.indexOf((char)j) != -1) {
                    int n = j;
                    table[n] = table[n] + (invert ? -1 : 1);
                }
                ++j;
            }
            numSets += invert ? 0 : 1;
            ++i;
        }
        StringBuffer sbuf = new StringBuffer();
        int k = 0;
        while (k < 256) {
            if (table[k] == numSets) {
                sbuf.append((char)k);
            }
            ++k;
        }
        return sbuf.toString();
    }

    public IRubyObject count(IRubyObject[] args) {
        int argc = this.argCount(args, 1, -1);
        String[] specs = new String[argc];
        int i = 0;
        while (i < argc) {
            specs[i] = RubyString.stringValue(args[i]).getValue();
            ++i;
        }
        String table = this.setupTable(specs);
        int count = 0;
        int j = 0;
        while (j < this.getValue().length()) {
            if (table.indexOf(this.getValue().charAt(j)) != -1) {
                ++count;
            }
            ++j;
        }
        return RubyFixnum.newFixnum(this.getRuntime(), count);
    }

    private String getDelete(IRubyObject[] args) {
        int argc = this.argCount(args, 1, -1);
        String[] specs = new String[argc];
        int i = 0;
        while (i < argc) {
            specs[i] = RubyString.stringValue(args[i]).getValue();
            ++i;
        }
        String table = this.setupTable(specs);
        int strLen = this.getValue().length();
        StringBuffer sbuf = new StringBuffer(strLen);
        int j = 0;
        while (j < strLen) {
            char c = this.getValue().charAt(j);
            if (table.indexOf(c) == -1) {
                sbuf.append(c);
            }
            ++j;
        }
        return sbuf.toString();
    }

    public IRubyObject delete(IRubyObject[] args) {
        RubyString newStr = this.newString(this.getDelete(args));
        newStr.infectBy(this);
        return newStr;
    }

    public IRubyObject delete_bang(IRubyObject[] args) {
        String newStr = this.getDelete(args);
        if (newStr.equals(this.getValue())) {
            return this.getRuntime().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    private String getSqueeze(IRubyObject[] args) {
        int argc = args.length;
        String[] specs = null;
        if (argc > 0) {
            specs = new String[argc];
            int i = 0;
            while (i < argc) {
                specs[i] = RubyString.stringValue(args[i]).getValue();
                ++i;
            }
        }
        String table = specs == null ? null : this.setupTable(specs);
        int strLen = this.getValue().length();
        if (strLen <= 1) {
            return this.getValue();
        }
        StringBuffer sbuf = new StringBuffer(strLen);
        char c1 = this.getValue().charAt(0);
        sbuf.append(c1);
        int j = 1;
        while (j < strLen) {
            char c2 = this.getValue().charAt(j);
            if (c2 != c1 || table != null && table.indexOf(c2) == -1) {
                sbuf.append(c2);
                c1 = c2;
            }
            ++j;
        }
        return sbuf.toString();
    }

    public IRubyObject squeeze(IRubyObject[] args) {
        RubyString newStr = this.newString(this.getSqueeze(args));
        newStr.infectBy(this);
        return newStr;
    }

    public IRubyObject squeeze_bang(IRubyObject[] args) {
        String newStr = this.getSqueeze(args);
        if (newStr.equals(this.getValue())) {
            return this.getRuntime().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    private String tr(IRubyObject[] args, boolean squeeze) {
        if (args.length != 2) {
            throw new ArgumentError(this.getRuntime(), "wrong number of arguments");
        }
        String srchSpec = RubyString.stringValue(args[0]).getValue();
        String srch = this.expandTemplate(srchSpec, true);
        if (srchSpec.startsWith("^")) {
            StringBuffer sbuf = new StringBuffer(256);
            int i = 0;
            while (i < 256) {
                char c = (char)i;
                if (srch.indexOf(c) == -1) {
                    sbuf.append(c);
                }
                ++i;
            }
            srch = sbuf.toString();
        }
        String repl = this.expandTemplate(RubyString.stringValue(args[1]).getValue(), false);
        int strLen = this.getValue().length();
        if (strLen == 0 || srch.length() == 0) {
            return this.getValue();
        }
        int repLen = repl.length();
        StringBuffer sbuf = new StringBuffer(strLen);
        int n = -1;
        int i = 0;
        while (i < strLen) {
            char c;
            char cs = this.getValue().charAt(i);
            int pos = srch.indexOf(cs);
            if (pos == -1) {
                sbuf.append(cs);
                c = '\uffffffff';
            } else if (repLen > 0) {
                char cr = repl.charAt(Math.min(pos, repLen - 1));
                if (!squeeze || cr != c) {
                    sbuf.append(cr);
                    c = cr;
                }
            }
            ++i;
        }
        return sbuf.toString();
    }

    public IRubyObject tr(IRubyObject[] args) {
        RubyString newStr = this.newString(this.tr(args, false));
        newStr.infectBy(this);
        return newStr;
    }

    public IRubyObject tr_bang(IRubyObject[] args) {
        String newStr = this.tr(args, false);
        if (newStr.equals(this.getValue())) {
            return this.getRuntime().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    public IRubyObject tr_s(IRubyObject[] args) {
        RubyString newStr = this.newString(this.tr(args, true));
        newStr.infectBy(this);
        return newStr;
    }

    public IRubyObject tr_s_bang(IRubyObject[] args) {
        String newStr = this.tr(args, true);
        if (newStr.equals(this.getValue())) {
            return this.getRuntime().getNil();
        }
        this.setValue(newStr);
        return this;
    }

    public IRubyObject each_line(IRubyObject[] args) {
        int strLen = this.getValue().length();
        if (strLen == 0) {
            return this;
        }
        String sep = null;
        if (this.argCount(args, 0, 1) == 1) {
            sep = RubyRegexp.quote(RubyString.stringValue(args[0]).getValue());
        }
        if (sep == null) {
            sep = "(?:\\n|\\r\\n?)";
        } else if (sep.length() == 0) {
            sep = "(?:\\n|\\r\\n?){2,}";
        }
        RubyRegexp pat = RubyRegexp.newRegexp(this.getRuntime(), ".*?" + sep, 4);
        int start = 0;
        while (pat.search(this, start) != -1) {
            RubyMatchData md = (RubyMatchData)this.getRuntime().getBackref();
            this.getRuntime().yield(md.group(0L));
            start = md.matchEndPosition();
        }
        if (start < strLen) {
            this.getRuntime().yield(this.substr(start, strLen - start));
        }
        return this;
    }

    public RubyString each_byte() {
        byte[] lByteValue = this.toByteArray();
        int lLength = lByteValue.length;
        int i = 0;
        while (i < lLength) {
            this.runtime.yield(RubyFixnum.newFixnum(this.runtime, lByteValue[i]));
            ++i;
        }
        return this;
    }

    public RubySymbol intern() {
        return RubySymbol.newSymbol(this.getRuntime(), this.getValue());
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(34);
        output.dumpString(this.getValue());
    }

    public static RubyString unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyString.newString(input.getRuntime(), input.unmarshalString());
    }

    public RubyArray unpack(RubyString iFmt) {
        return Pack.unpack(this.value, iFmt);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        encoding = encoding;
        M_CLONE = 101;
        M_DUP = 1;
        M_OP_CMP = 2;
        M_EQUAL = 3;
        M_HASH = 4;
        M_OP_PLUS = 5;
        M_FORMAT = 7;
        M_LENGTH = 8;
        M_EMPTY = 9;
        M_MATCH = 10;
        M_MATCH2 = 11;
        M_SUCC = 12;
        M_SUCC_BANG = 13;
        M_UPTO = 14;
        M_REPLACE = 15;
        M_TO_I = 20;
        M_TO_F = 21;
        M_INSPECT = 22;
        M_CONCAT = 50;
        M_INTERN = 51;
    }
}

