/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast.visitor;

import org.ablaf.ast.INode;
import org.ablaf.common.IErrorHandler;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.FalseNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NilNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.TrueNode;
import org.jruby.ast.visitor.AbstractVisitor;

public class UselessStatementVisitor
extends AbstractVisitor {
    private IErrorHandler errorHandler;

    public UselessStatementVisitor(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    protected void visitNode(INode iVisited) {
    }

    private void handleUselessWarn(INode node, String useless) {
        this.errorHandler.handleError(1, node.getPosition(), "Useless use of " + useless + "in void context.", null);
    }

    public void visitCallNode(CallNode iVisited) {
        String name = iVisited.getName().intern();
        if (name == "+" || name == "-" || name == "*" || name == "/" || name == "%" || name == "**" || name == "+@" || name == "-@" || name == "|" || name == "^" || name == "&" || name == "<=>" || name == ">" || name == ">=" || name == "<" || name == "<=" || name == "==" || name == "!=") {
            this.handleUselessWarn(iVisited, name);
        }
    }

    public void visitBackRefNode(BackRefNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
    }

    public void visitDVarNode(DVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
    }

    public void visitGlobalVarNode(GlobalVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
    }

    public void visitLocalVarNode(LocalVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
    }

    public void visitNthRefNode(NthRefNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
    }

    public void visitClassVarNode(ClassVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
    }

    public void visitInstVarNode(InstVarNode iVisited) {
        this.handleUselessWarn(iVisited, "a variable");
    }

    public void visitConstNode(ConstNode iVisited) {
        this.handleUselessWarn(iVisited, "a constant");
    }

    public void visitBignumNode(BignumNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitDRegxNode(DRegexpNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitDStrNode(DStrNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitFixnumNode(FixnumNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitFloatNode(FloatNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitRegexpNode(RegexpNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitStrNode(StrNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitSymbolNode(SymbolNode iVisited) {
        this.handleUselessWarn(iVisited, "a literal");
    }

    public void visitClassNode(ClassNode iVisited) {
        this.handleUselessWarn(iVisited, "::");
    }

    public void visitColon2Node(Colon2Node iVisited) {
        this.handleUselessWarn(iVisited, "::");
    }

    public void visitDotNode(DotNode iVisited) {
        this.handleUselessWarn(iVisited, iVisited.isExclusive() ? "..." : "..");
    }

    public void visitDefinedNode(DefinedNode iVisited) {
        this.handleUselessWarn(iVisited, "defined?");
    }

    public void visitFalseNode(FalseNode iVisited) {
        this.handleUselessWarn(iVisited, "false");
    }

    public void visitNilNode(NilNode iVisited) {
        this.handleUselessWarn(iVisited, "nil");
    }

    public void visitSelfNode(SelfNode iVisited) {
        this.handleUselessWarn(iVisited, "self");
    }

    public void visitTrueNode(TrueNode iVisited) {
        this.handleUselessWarn(iVisited, "true");
    }

    public void visitNewlineNode(NewlineNode iVisited) {
        this.acceptNode(iVisited.getNextNode());
    }
}

