/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

import java.util.Iterator;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyString;
import org.jruby.exceptions.JumpException;
import org.jruby.runtime.Frame;

public class RaiseException
extends JumpException {
    private RubyException exception;

    public RaiseException(RubyException actException) {
        this.setException(actException);
    }

    public RaiseException(Ruby ruby, RubyClass excptnClass, String msg) {
        super(msg);
        this.setException(RubyException.newException(ruby, excptnClass, msg));
    }

    public RaiseException(Ruby ruby, String excptnClassName, String msg) {
        super(msg);
        RubyClass excptnClass = (RubyClass)ruby.getRubyModule(excptnClassName);
        if (excptnClass == null) {
            System.err.println(excptnClassName);
        }
        this.setException(RubyException.newException(ruby, excptnClass, msg));
    }

    public Throwable fillInStackTrace() {
        return this.originalFillInStackTrace();
    }

    public static RubyArray createBacktrace(Ruby ruby, int level) {
        RubyArray backtrace = RubyArray.newArray(ruby);
        Iterator iter = ruby.getFrameStack().iterator();
        while (level-- > 0) {
            if (!iter.hasNext()) {
                return RubyArray.nilArray(ruby);
            }
            iter.next();
        }
        Frame frame = null;
        if (iter.hasNext()) {
            frame = (Frame)iter.next();
        }
        while (frame != null && frame.getFile() != null) {
            StringBuffer sb = new StringBuffer(100);
            Frame previous = null;
            if (iter.hasNext() && (previous = (Frame)iter.next()).getLastFunc() != null) {
                sb.append(frame.getFile()).append(':').append(frame.getLine());
                sb.append(":in '").append(previous.getLastFunc()).append('\'');
            } else {
                sb.append(frame.getFile()).append(':').append(frame.getLine());
            }
            backtrace.append(RubyString.newString(ruby, sb.toString()));
            frame = previous;
        }
        return backtrace;
    }

    public RubyException getException() {
        return this.exception;
    }

    protected void setException(RubyException newException) {
        Ruby ruby = newException.getRuntime();
        if (ruby.getRuntime().getTraceFunction() != null) {
            ruby.getRuntime().callTraceFunction("return", ruby.getSourceFile(), ruby.getSourceLine(), ruby.getCurrentFrame().getSelf(), ruby.getCurrentFrame().getLastFunc(), ruby.getCurrentFrame().getLastClass());
        }
        this.exception = newException;
        if (ruby.stackTraces > 5) {
            return;
        }
        ++ruby.stackTraces;
        if (newException.callMethod("backtrace").isNil() && ruby.getSourceFile() != null) {
            newException.callMethod("set_backtrace", RaiseException.createBacktrace(ruby, -1));
        }
        --ruby.stackTraces;
    }
}

