/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.RubyProxy;
import org.jruby.javasupport.RubyProxyFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyConversion {
    RubyProxyFactory factory = null;
    static /* synthetic */ Class class$java$util$Collection;

    public RubyConversion(RubyProxyFactory factory) {
        this.factory = factory;
    }

    public Ruby getRuby() {
        return this.factory.getRuby();
    }

    public IRubyObject[] convertJavaToRuby(Object[] obj) {
        if (obj == null) {
            return new IRubyObject[0];
        }
        IRubyObject[] ret = new IRubyObject[obj.length];
        int i = 0;
        while (i < obj.length) {
            ret[i] = this.convertJavaToRuby(obj[i]);
            ++i;
        }
        return ret;
    }

    public IRubyObject convertJavaToRuby(Object obj) {
        if (obj == null) {
            return this.getRuby().getNil();
        }
        if (obj instanceof Set) {
            obj = new ArrayList((Set)((Object)obj));
        }
        Class type = JavaUtil.getCanonicalJavaClass(obj.getClass());
        return JavaUtil.convertJavaToRuby(this.getRuby(), obj, type);
    }

    public Object[] convertRubyToJava(IRubyObject[] obj) {
        Object[] ret = new Object[obj.length];
        int i = 0;
        while (i < obj.length) {
            ret[i] = this.convertRubyToJava(obj[i]);
            ++i;
        }
        return ret;
    }

    public Object convertRubyToJava(IRubyObject obj) {
        return this.convertRubyToJava(obj, null);
    }

    public Object convertRubyToJava(IRubyObject obj, Class type) {
        if ((type = JavaUtil.getCanonicalJavaClass(type)) != null) {
            type.getName();
        }
        if (type == Void.TYPE || obj == null || obj.isNil()) {
            return null;
        }
        if (obj instanceof RubyArray) {
            try {
                return this.convertRubyArrayToJava((RubyArray)obj, type);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        try {
            RubyProxy proxy = this.factory.getProxyForObject(obj, type);
            if (proxy != null) {
                return proxy;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return JavaUtil.convertRubyToJava(this.getRuby(), obj, type);
    }

    public Object convertRubyArrayToJava(RubyArray array, Class type) throws InstantiationException, IllegalAccessException {
        if (type.isArray()) {
            return JavaUtil.convertRubyToJava(this.getRuby(), array, type);
        }
        if ((class$java$util$Collection == null ? (class$java$util$Collection = RubyConversion.class$("java.util.Collection")) : class$java$util$Collection).isAssignableFrom(type)) {
            Collection ret = (Collection)type.newInstance();
            Iterator it = array.getList().iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                ret.add(this.convertRubyToJava((IRubyObject)obj));
            }
            return ret;
        }
        throw new UnsupportedOperationException(type.getName() + " not supported");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

