/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.test;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import junit.framework.Assert;
import org.jruby.Ruby;
import org.jruby.javasupport.ReflectionClassMap;
import org.jruby.javasupport.RubyProxyFactory;
import org.jruby.javasupport.RubyToJavaClassMap;
import org.jruby.javasupport.test.RubyTestCase;
import org.jruby.javasupport.test.RubyTestObject;
import org.jruby.javasupport.test.TestIntWrapper;
import org.jruby.javasupport.test.TestIntWrapperImpl;

public class TestRubyProxyFactory
extends RubyTestCase {
    private static final double EPSILON = 0.0;
    private static final String RUBY_FILE = "test.rb";
    private static final String RUBY_PACKAGE = "org.jruby.javasupport.test";
    private Ruby ruby = null;
    private RubyToJavaClassMap classMap = null;
    private RubyProxyFactory factory = null;
    private RubyTestObject test = null;
    static /* synthetic */ Class class$org$jruby$javasupport$test$RubyTestObject;
    static /* synthetic */ Class class$org$jruby$javasupport$test$TestIntWrapper;

    public TestRubyProxyFactory(String name) {
        super(name);
    }

    public void setUp() throws IOException {
        this.ruby = this.createRuby(((Object)((Object)this)).getClass().getResource(RUBY_FILE));
        this.classMap = new ReflectionClassMap(RUBY_PACKAGE);
        this.factory = new RubyProxyFactory(this.ruby, this.classMap);
        this.test = (RubyTestObject)((Object)this.factory.newProxyObject(class$org$jruby$javasupport$test$RubyTestObject == null ? (class$org$jruby$javasupport$test$RubyTestObject = TestRubyProxyFactory.class$("org.jruby.javasupport.test.RubyTestObject")) : class$org$jruby$javasupport$test$RubyTestObject));
    }

    public void tearDown() {
        this.ruby = null;
        this.classMap = null;
        this.factory = null;
        this.test = null;
    }

    public void testList() {
        ArrayList<String> l = new ArrayList<String>();
        this.test.setList(l);
        Assert.assertEquals((String)"empty list", l, (Object)this.test.getList());
        l.add("obj1");
        Assert.assertTrue((String)"unset list", (!l.equals(this.test.getList()) ? 1 : 0) != 0);
        this.test.setList(l);
        Assert.assertEquals((String)"one-element list", l, (Object)this.test.getList());
        l.add("obj2");
        this.test.setList(l);
        Assert.assertEquals((String)"two-element list", l, (Object)this.test.getList());
        Assert.assertEquals((String)"joined list", (Object)"obj1,obj2", (Object)this.test.joinList());
    }

    public void testNewProxyObject() {
        Assert.assertNotNull((Object)this.test);
    }

    public void testDuplicateProxyObjects() {
        RubyTestObject test2 = (RubyTestObject)((Object)this.factory.newProxyObject(class$org$jruby$javasupport$test$RubyTestObject == null ? (class$org$jruby$javasupport$test$RubyTestObject = TestRubyProxyFactory.class$("org.jruby.javasupport.test.RubyTestObject")) : class$org$jruby$javasupport$test$RubyTestObject));
        Assert.assertNotNull((Object)test2);
        Assert.assertTrue((this.test != test2 ? 1 : 0) != 0);
    }

    public void testNoArgs() {
        this.test.noArgs();
    }

    public void testInteger() {
        this.test.setNumber(10);
        Assert.assertEquals((int)10, (int)this.test.getNumberAsInt());
    }

    public void testDouble() {
        this.test.setNumber(3.1415);
        Assert.assertEquals((double)3.1415, (double)this.test.getNumberAsDouble(), (double)0.0);
    }

    public void testLong() {
        this.test.setNumber(0x80000001L);
        Assert.assertEquals((long)0x80000001L, (long)this.test.getNumberAsLong());
        Assert.assertTrue((this.test.getNumberAsLong() > Integer.MAX_VALUE ? 1 : 0) != 0);
    }

    public void testNumberObjs() {
        this.test.setNumber(new Integer(30));
        Assert.assertEquals((Object)new Integer(30), (Object)this.test.getNumberAsIntObj());
        this.test.setNumber(new Double(30.145));
        Assert.assertEquals((Object)new Double(30.145), (Object)this.test.getNumberAsDoubleObj());
        this.test.setNumber(new Long(100000000000001L));
        Assert.assertEquals((Object)new Long(100000000000001L), (Object)this.test.getNumberAsLongObj());
    }

    public void testNumberBoundaries() {
        this.test.setNumber(Integer.MAX_VALUE);
        Assert.assertEquals((int)Integer.MAX_VALUE, (int)this.test.getNumberAsInt());
        this.test.setNumber(Integer.MIN_VALUE);
        Assert.assertEquals((int)Integer.MIN_VALUE, (int)this.test.getNumberAsInt());
        this.test.setNumber(Long.MAX_VALUE);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)this.test.getNumberAsLong());
        this.test.setNumber(Long.MIN_VALUE);
        Assert.assertEquals((long)Long.MIN_VALUE, (long)this.test.getNumberAsLong());
        this.test.setNumber(0.0);
        Assert.assertEquals((double)0.0, (double)this.test.getNumberAsDouble(), (double)0.0);
        this.test.setNumber(-0.0);
        Assert.assertEquals((double)-0.0, (double)this.test.getNumberAsDouble(), (double)0.0);
        this.test.setNumber(Double.MAX_VALUE);
        Assert.assertEquals((double)Double.MAX_VALUE, (double)this.test.getNumberAsDouble(), (double)0.0);
        this.test.setNumber(Double.MIN_VALUE);
        Assert.assertEquals((double)Double.MIN_VALUE, (double)this.test.getNumberAsDouble(), (double)0.0);
        this.test.setNumber(Double.NaN);
        Assert.assertTrue((boolean)Double.isNaN(this.test.getNumberAsDouble()));
        this.test.setNumber(Double.POSITIVE_INFINITY);
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)this.test.getNumberAsDouble(), (double)0.0);
        this.test.setNumber(Double.NEGATIVE_INFINITY);
        Assert.assertEquals((double)Double.NEGATIVE_INFINITY, (double)this.test.getNumberAsDouble(), (double)0.0);
    }

    public void testString() {
        this.test.setString("test string");
        Assert.assertEquals((Object)"test string", (Object)this.test.getString());
    }

    public void testBool() {
        this.test.setBool(true);
        Assert.assertEquals((boolean)true, (boolean)this.test.getBool());
        this.test.setBool(false);
        Assert.assertEquals((boolean)false, (boolean)this.test.getBool());
    }

    public void testEmptyString() {
        this.test.setString("");
        Assert.assertEquals((Object)"", (Object)this.test.getString());
    }

    public void testObject() {
        Object obj = new Object();
        this.test.setObject(obj);
        Assert.assertEquals((Object)obj.getClass().getName(), (Object)this.test.getObject().getClass().getName());
        Assert.assertEquals((Object)obj, (Object)this.test.getObject());
        Assert.assertTrue((obj == this.test.getObject() ? 1 : 0) != 0);
    }

    public void testToString() {
        this.test.setString("foobar");
        Assert.assertEquals((Object)"<foobar>", (Object)this.test.toString());
    }

    public void testNil() {
        Assert.assertNull((String)"implicit nil value", (Object)this.test.getString());
        this.test.setString("test");
        Assert.assertNotNull((String)"non-nil value", (Object)this.test.getString());
        this.test.setString(null);
        Assert.assertNull((String)"explicit nil value", (Object)this.test.getString());
    }

    public void testOutcomingProxy() {
        this.test.setString("str");
        RubyTestObject test2 = this.test.duplicate();
        Assert.assertTrue((this.test != test2 ? 1 : 0) != 0);
        Assert.assertEquals((Object)"str", (Object)test2.getString());
    }

    public void testIngoingProxy() {
        Assert.assertTrue((boolean)this.test.isSelf(this.test));
        Assert.assertTrue((!this.test.isSelf(this.test.duplicate()) ? 1 : 0) != 0);
    }

    public void testGlobalVariable() throws ClassNotFoundException {
        RubyTestObject global = (RubyTestObject)((Object)this.factory.getProxyForGlobal("$global_test"));
        Assert.assertNotNull((Object)global);
        Assert.assertEquals((Object)"global obj", (Object)global.getString());
    }

    public void testNilGlobalVariable() {
        RubyTestObject nilGlobal = (RubyTestObject)((Object)this.factory.getProxyForGlobal("$nil_global"));
        Assert.assertNull((Object)nilGlobal);
    }

    public void testListConversion() {
        LinkedList<String> l = new LinkedList<String>();
        l.add("obj1");
        l.add("obj2");
        l.add("obj3");
        this.test.setList(l);
        Assert.assertTrue((boolean)(l instanceof LinkedList));
        Assert.assertTrue((!(l instanceof ArrayList) ? 1 : 0) != 0);
        List l2 = this.test.getList();
        Assert.assertTrue((boolean)(l2 instanceof ArrayList));
        Assert.assertTrue((!(l2 instanceof LinkedList) ? 1 : 0) != 0);
    }

    public void testMapConversion() {
        TreeMap<String, Integer> m = new TreeMap<String, Integer>();
        m.put("obj1", new Integer(1));
        m.put("obj2", new Integer(2));
        m.put("obj3", new Integer(3));
        this.test.setMap(m);
        Map m2 = this.test.getMap();
        Assert.assertTrue((boolean)(m instanceof TreeMap));
        Assert.assertTrue((!(m instanceof HashMap) ? 1 : 0) != 0);
        Assert.assertTrue((boolean)(m2 instanceof HashMap));
        Assert.assertTrue((!(m2 instanceof TreeMap) ? 1 : 0) != 0);
    }

    public void testListWithDuplicates() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("obj1");
        l.add("obj1");
        l.add("obj2");
        l.add("obj3");
        l.add("obj2");
        this.test.setList(l);
        Assert.assertEquals((Object)"obj1,obj1,obj2,obj3,obj2", (Object)this.test.joinList());
        List l2 = this.test.getList();
        Assert.assertTrue((l != l2 ? 1 : 0) != 0);
        Assert.assertEquals(l, (Object)l2);
    }

    public void testSetOperations() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("obj1");
        this.test.setList(l);
        Assert.assertEquals((String)"single object", (Object)"obj1", (Object)this.test.joinList());
        this.test.addToList("obj2");
        Assert.assertEquals((String)"added object", (Object)"obj1,obj2", (Object)this.test.joinList());
        this.test.removeFromList("obj1");
        Assert.assertEquals((String)"removed object", (Object)"obj2", (Object)this.test.joinList());
    }

    public void testListAsArray() {
        Object[] str = new Object[]{"obj1", "obj2"};
        this.test.setList(Arrays.asList(str));
        Assert.assertTrue((boolean)Arrays.equals(str, this.test.getListAsArray()));
        Assert.assertEquals((Object)"obj1,obj2", (Object)this.test.joinList());
    }

    public void testListAsListToStringArray() {
        Object[] str = new String[]{"obj1", "obj2"};
        this.test.setList(Arrays.asList(str));
        Assert.assertTrue((boolean)Arrays.equals(str, this.test.getListAsStringArray()));
        Assert.assertEquals((Object)"obj1,obj2", (Object)this.test.joinList());
    }

    public void testListAsStringArray() {
        Object[] str = new String[]{"obj1", "obj2"};
        this.test.setList(str);
        Assert.assertTrue((boolean)Arrays.equals(str, this.test.getListAsStringArray()));
        Assert.assertEquals((Object)"obj1,obj2", (Object)this.test.joinList());
    }

    public void testListAsListToIntegerArray() {
        Object[] arr = new Integer[]{new Integer(1), new Integer(2)};
        this.test.setList(Arrays.asList(arr));
        Assert.assertTrue((boolean)Arrays.equals(arr, (Object[])this.test.getListAsIntegerArray()));
        Assert.assertEquals((Object)"1,2", (Object)this.test.joinList());
        Assert.assertTrue((boolean)Arrays.equals(new int[]{1, 2}, this.test.getListAsIntArray()));
    }

    public void testListAsIntArray() {
        int[] arr = new int[]{1, 2, 1};
        this.test.setList(arr);
        Assert.assertTrue((boolean)Arrays.equals(arr, this.test.getListAsIntArray()));
        Assert.assertEquals((Object)"1,2,1", (Object)this.test.joinList());
    }

    public void testListAsIntegerArray() {
        Object[] arr = new Integer[]{new Integer(1), new Integer(2)};
        this.test.setList(arr);
        Assert.assertTrue((boolean)Arrays.equals(arr, (Object[])this.test.getListAsIntegerArray()));
        Assert.assertEquals((Object)"1,2", (Object)this.test.joinList());
    }

    public void testListAsSet() {
        HashSet<String> s = new HashSet<String>();
        s.add("obj1");
        s.add("obj2");
        s.add("obj2");
        s.add("obj3");
        this.test.setList(s);
        Set s3 = this.test.getListAsSet();
        Assert.assertTrue((s != s3 ? 1 : 0) != 0);
        Assert.assertEquals(s, (Object)s3);
        HashSet<String> s2 = new HashSet<String>();
        s2.add("obj3");
        s2.add("obj1");
        s2.add("obj2");
        Assert.assertEquals(s2, (Object)s3);
    }

    public void testListAsCollection() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("obj1");
        l.add("obj2");
        l.add("obj2");
        l.add("obj3");
        this.test.setList(l);
        Assert.assertEquals((Object)"obj1,obj2,obj2,obj3", (Object)this.test.joinList());
        Assert.assertEquals(new LinkedList(l), (Object)this.test.getListAsCollection());
    }

    public void testListOfJavaObjs() {
        ArrayList<TestIntWrapperImpl> l = new ArrayList<TestIntWrapperImpl>();
        int i = 1;
        while (i <= 3) {
            l.add(new TestIntWrapperImpl(i));
            ++i;
        }
        this.test.setList(l);
        List l2 = this.test.getList();
        Assert.assertTrue((l != l2 ? 1 : 0) != 0);
        Assert.assertEquals(l, (Object)l2);
        int i2 = 1;
        while (i2 <= 3) {
            TestIntWrapper obj = (TestIntWrapper)l2.get(i2 - 1);
            Assert.assertEquals((long)i2, (long)obj.getInteger());
            Assert.assertEquals((Object)("<java: " + i2 + ">"), (Object)obj.toString());
            Assert.assertTrue((boolean)l.contains(obj));
            ++i2;
        }
    }

    public void testListOfProxies() {
        TestIntWrapper obj;
        ArrayList<TestIntWrapper> l = new ArrayList<TestIntWrapper>();
        int i = 1;
        while (i <= 3) {
            obj = (TestIntWrapper)((Object)this.factory.newProxyObject(class$org$jruby$javasupport$test$TestIntWrapper == null ? TestRubyProxyFactory.class$("org.jruby.javasupport.test.TestIntWrapper") : class$org$jruby$javasupport$test$TestIntWrapper, new Long[]{new Long(i)}));
            l.add(obj);
            ++i;
        }
        this.test.setList(l);
        List l2 = this.test.getList();
        Assert.assertTrue((l != l2 ? 1 : 0) != 0);
        Assert.assertEquals(l, (Object)l2);
        int i2 = 1;
        while (i2 <= 3) {
            obj = (TestIntWrapper)l2.get(i2 - 1);
            Assert.assertEquals((long)i2, (long)obj.getInteger());
            Assert.assertEquals((Object)("<ruby: " + i2 + ">"), (Object)obj.toString());
            Assert.assertTrue((boolean)l.contains(obj));
            ++i2;
        }
    }

    public void testMap() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("key1", "value1");
        m.put("key2", "value2");
        m.put("key1", "value3");
        this.test.setMap(m);
        Map m2 = this.test.getMap();
        Assert.assertTrue((m != m2 ? 1 : 0) != 0);
        Assert.assertEquals(m, (Object)m2);
    }

    public void testMapOfJavaObjs() {
        HashMap<Long, TestIntWrapperImpl> m = new HashMap<Long, TestIntWrapperImpl>();
        int i = 1;
        while (i <= 3) {
            m.put(new Long(i), new TestIntWrapperImpl(i));
            ++i;
        }
        this.test.setMap(m);
        Map m2 = this.test.getMap();
        Assert.assertTrue((m != m2 ? 1 : 0) != 0);
        Assert.assertEquals(m, (Object)m2);
        int i2 = 1;
        while (i2 <= 3) {
            TestIntWrapper obj = (TestIntWrapper)m2.get(new Long(i2));
            Assert.assertEquals((long)i2, (long)obj.getInteger());
            Assert.assertEquals((Object)("<java: " + i2 + ">"), (Object)obj.toString());
            ++i2;
        }
    }

    public void testMapOfProxies() {
        HashMap<Long, TestIntWrapper> m = new HashMap<Long, TestIntWrapper>();
        int i = 1;
        while (i <= 3) {
            TestIntWrapper obj = (TestIntWrapper)((Object)this.factory.newProxyObject(class$org$jruby$javasupport$test$TestIntWrapper == null ? TestRubyProxyFactory.class$("org.jruby.javasupport.test.TestIntWrapper") : class$org$jruby$javasupport$test$TestIntWrapper, new Long[]{new Long(i)}));
            m.put(new Long(i), obj);
            ++i;
        }
        this.test.setMap(m);
        Map m2 = this.test.getMap();
        Assert.assertTrue((m != m2 ? 1 : 0) != 0);
        int i2 = 1;
        while (i2 <= 3) {
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        EPSILON = 0.0;
        RUBY_FILE = RUBY_FILE;
        RUBY_PACKAGE = RUBY_PACKAGE;
    }
}

