/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import org.ablaf.common.ISourcePosition;
import org.ablaf.internal.lexer.DefaultLexerPosition;
import org.ablaf.internal.lexer.DefaultLexerSupport;
import org.ablaf.lexer.ILexerSource;
import org.jruby.lexer.yacc.IRubyLexerSupport;

public class RubyLexerSupport
extends DefaultLexerSupport
implements IRubyLexerSupport {
    private String buffer = null;
    private int bufferPos = -1;
    private ISourcePosition startPosition = null;

    public RubyLexerSupport(ILexerSource source) {
        super(source);
    }

    public void setBuffer(String buffer, ISourcePosition startPosition) {
        this.buffer = buffer;
        this.bufferPos = 0;
        this.startPosition = startPosition;
    }

    public ISourcePosition getPosition() {
        if (this.bufferPos == -1) {
            return super.getPosition();
        }
        return new DefaultLexerPosition(this.startPosition.getFile(), this.startPosition.getLine(), this.startPosition.getColumn() + this.bufferPos);
    }

    public char read() {
        if (this.bufferPos == -1) {
            return super.read();
        }
        if (this.bufferPos >= this.buffer.length()) {
            this.bufferPos = -1;
            return super.read();
        }
        return this.buffer.charAt(this.bufferPos++);
    }

    public char unread() {
        if (this.bufferPos == -1) {
            return super.unread();
        }
        if (this.bufferPos > 0) {
            return this.buffer.charAt(--this.bufferPos);
        }
        return '\u0000';
    }
}

