/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.EOFException;
import java.io.IOException;
import java.math.BigInteger;
import org.ablaf.common.IErrorHandler;
import org.ablaf.common.ISourcePosition;
import org.ablaf.lexer.ILexerSource;
import org.ablaf.lexer.ILexerState;
import org.ablaf.lexer.ILexerSupport;
import org.ablaf.lexer.IYaccLexer;
import org.jruby.ast.AbstractNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.types.IListNode;
import org.jruby.ast.util.ListNodeUtil;
import org.jruby.lexer.yacc.IRubyLexerSupport;
import org.jruby.lexer.yacc.Keyword;
import org.jruby.lexer.yacc.LexState;
import org.jruby.lexer.yacc.Messages;
import org.jruby.lexer.yacc.RubyLexerSupport;
import org.jruby.lexer.yacc.StringToken;

public class RubyYaccLexer
implements IYaccLexer {
    private int token = 0;
    private Object yaccValue;
    private IRubyLexerSupport support;
    private IErrorHandler errorHandler;
    private LexState lexState;
    private StringBuffer tokenbuf;
    private long cond_stack;
    private int cond_nest = 0;
    private long cmdarg_stack;
    ISourcePosition _curPos;

    public boolean advance() throws IOException {
        this.token = this.yylex();
        return this.token != 0;
    }

    public int token() {
        return this.token;
    }

    public Object value() {
        return this.yaccValue;
    }

    public void COND_PUSH() {
        ++this.cond_nest;
        this.cond_stack = this.cond_stack << 1 | 1L;
    }

    public void COND_POP() {
        --this.cond_nest;
        this.cond_stack >>= 1;
    }

    private boolean COND_P() {
        return this.cond_nest > 0 && (this.cond_stack & 1L) != 0L;
    }

    public void CMDARG_PUSH() {
        this.cmdarg_stack = this.cmdarg_stack << 1 | 1L;
    }

    public void CMDARG_POP() {
        this.cmdarg_stack >>= 1;
    }

    private boolean CMDARG_P() {
        return this.cmdarg_stack != 0L && (this.cmdarg_stack & 1L) != 0L;
    }

    public void resetStacks() {
        this.cond_nest = 0;
        this.cond_stack = 0L;
        this.cmdarg_stack = 0L;
    }

    private int nextc() {
        int c = this.support.read();
        if (c == 65535 || c == 0) {
            c = -1;
        }
        return c;
    }

    private void pushback(int c) {
        this.support.unread();
    }

    private boolean peek(int c) {
        return this.support.isNext((char)c);
    }

    private String tok() {
        return this.tokenbuf.toString();
    }

    private int toklen() {
        return this.tokenbuf.length();
    }

    private char toklast() {
        return this.tokenbuf.charAt(this.toklen() - 1);
    }

    private void newtok() {
        this.tokenbuf = new StringBuffer(60);
    }

    private void tokadd(int c) {
        this.tokenbuf.append((char)c);
    }

    private char readEscape() {
        char c = this.support.read();
        switch (c) {
            case '\\': {
                return '\\';
            }
            case 'n': {
                return '\n';
            }
            case 't': {
                return '\t';
            }
            case 'r': {
                return '\r';
            }
            case 'f': {
                return '\f';
            }
            case 'v': {
                return '\u0013';
            }
            case 'a': {
                return '\u0007';
            }
            case 'e': {
                return '3';
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                this.support.unread();
                return (char)Integer.parseInt(this.support.readOct(3), 8);
            }
            case 'x': {
                return (char)Integer.parseInt(this.support.readHex(2), 16);
            }
            case 'b': {
                return '\b';
            }
            case 's': {
                return ' ';
            }
            case 'M': {
                c = this.support.read();
                if (c != '-') {
                    this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("invalid_escape_expected_minus", String.valueOf(c)));
                    this.support.unread();
                    return '\u0000';
                }
                c = this.support.read();
                if (c == '\\') {
                    return (char)(this.readEscape() | 0x80);
                }
                if (c == '\u0000') {
                    this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("invalid_escape_unterminated_string"));
                    return '\u0000';
                }
                return (char)(c & 0xFF | 0x80);
            }
            case 'C': {
                c = this.support.read();
                if (c != '-') {
                    this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("invalid_escape_expected_minus", String.valueOf(c)));
                    this.support.unread();
                    return '\u0000';
                }
            }
            case 'c': {
                c = this.support.read();
                if (c == '\\') {
                    c = this.readEscape();
                } else {
                    if (c == '?') {
                        return '\u0177';
                    }
                    if (c == '\u0000') {
                        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("invalid_escape_unterminated_string"));
                        return '\u0000';
                    }
                }
                return (char)(c & 0x9F);
            }
            case '\u0000': {
                this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("invalid_escape_unterminated_string"));
                return '\u0000';
            }
        }
        return c;
    }

    private int parseRegexp(char closeQuote, char openQuote) {
        ISourcePosition position = this.support.getPosition();
        DRegexpNode list = new DRegexpNode(position);
        StringToken token = new StringToken(this.support, this.errorHandler, position);
        int nest = 0;
        boolean lDyn = false;
        char c = this.support.read();
        while (c != '\u0000' && (c != closeQuote || nest != 0)) {
            switch (c) {
                case '#': {
                    try {
                        lDyn = this.parseExpressionString(list, closeQuote, token) || lDyn;
                        break;
                    }
                    catch (EOFException e) {
                        this.errorHandler.handleError(11, position, Messages.getString("unterminated_regexp"));
                        return 0;
                    }
                }
                case '\\': {
                    try {
                        token.appendEscape(closeQuote);
                        break;
                    }
                    catch (EOFException e) {
                        return 0;
                    }
                }
                case '\u0000': {
                    this.errorHandler.handleError(11, position, Messages.getString("unterminated_regexp"));
                    return 0;
                }
                default: {
                    if (openQuote != '\u0000') {
                        if (c == openQuote) {
                            ++nest;
                        } else if (c == closeQuote) {
                            --nest;
                        }
                    }
                    token.append(c);
                }
            }
            c = this.support.read();
        }
        int options = 0;
        boolean once = false;
        int kcode = 0;
        char c2 = this.support.read();
        block21: while (true) {
            switch (c2) {
                case 'i': {
                    options |= 1;
                    break;
                }
                case 'x': {
                    options |= 2;
                    break;
                }
                case 'p': {
                    this.errorHandler.handleError(1, position, Messages.getString("opsolete_slash_p_option"));
                    options |= 0xC;
                    break;
                }
                case 'm': {
                    options |= 4;
                    break;
                }
                case 'o': {
                    once = true;
                    break block21;
                }
                case 'n': {
                    kcode = 16;
                    break;
                }
                case 'e': {
                    kcode = 32;
                    break;
                }
                case 's': {
                    kcode = 48;
                    break;
                }
                case 'u': {
                    kcode = 64;
                    break;
                }
                default: {
                    this.support.unread();
                    break block21;
                }
            }
            c2 = this.support.read();
        }
        this.lexState = LexState.EXPR_END;
        if (lDyn) {
            if (token.getLength() > 0) {
                list.add(new StrNode(token.getPosition(), token.getToken()));
            }
            list.setOptions(options | kcode);
            list.setOnce(once);
            this.yaccValue = list;
            return 316;
        }
        this.yaccValue = new RegexpNode(position, token.getToken(), options | kcode);
        return 314;
    }

    private int parseString(int func, int closeQuote, int openQuote) {
        if (func == 39) {
            return this.parseSingleQuotedString(closeQuote, openQuote);
        }
        if (func == 0) {
            this.yaccValue = this.support.readLine();
            return 312;
        }
        ISourcePosition position = this.support.getPosition();
        StringToken token = new StringToken(this.support, this.errorHandler, position);
        AbstractNode list = func == 96 ? new DXStrNode(position) : new DStrNode(position);
        int nest = 0;
        boolean lDyn = false;
        char c = this.support.read();
        while (c != closeQuote || nest > 0) {
            switch (c) {
                case '\u0000': {
                    this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                    return 0;
                }
                case '#': {
                    try {
                        lDyn = this.parseExpressionString((IListNode)((Object)list), (char)closeQuote, token) || lDyn;
                        break;
                    }
                    catch (EOFException e) {
                        this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                        return 0;
                    }
                }
                case '\\': {
                    c = this.support.read();
                    if (c == '\n') break;
                    if (c == closeQuote) {
                        token.append(c);
                        break;
                    }
                    this.support.unread();
                    if (func != 34) {
                        token.append('\\');
                    }
                    token.append(this.readEscape());
                    break;
                }
                default: {
                    if (openQuote != 0) {
                        if (c == openQuote) {
                            ++nest;
                        }
                        if (c == closeQuote && nest-- == 0) break;
                    }
                    token.append(c);
                }
            }
            c = this.support.read();
        }
        this.lexState = LexState.EXPR_END;
        if (lDyn) {
            if (token.getLength() > 0) {
                list.add(new StrNode(token.getPosition(), token.getToken()));
            }
            this.yaccValue = list;
            return func == 96 ? 315 : 319;
        }
        this.yaccValue = token.getToken();
        return func == 96 ? 313 : 312;
    }

    /*
     * WARNING - void declaration
     */
    private int parseSingleQuotedString(int closeQuote, int openQuote) {
        int c;
        ISourcePosition position = this.support.getPosition();
        int nest = 0;
        StringBuffer stringToken = new StringBuffer();
        block4: while ((c = this.nextc()) != closeQuote || nest > 0) {
            void var4_6;
            if (var4_6 == -1) {
                this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                return 0;
            }
            if (var4_6 == 92) {
                c = this.nextc();
                switch (c) {
                    case 10: {
                        continue block4;
                    }
                    case 92: {
                        c = 92;
                        break;
                    }
                    default: {
                        if (c == closeQuote || openQuote != 0 && c == openQuote) {
                            stringToken.append((char)c);
                            continue block4;
                        }
                        stringToken.append('\\');
                    }
                }
            }
            if (openQuote != 0) {
                if (c == openQuote) {
                    ++nest;
                }
                if (c == closeQuote && nest-- == 0) break;
            }
            stringToken.append((char)c);
        }
        this.lexState = LexState.EXPR_END;
        this.yaccValue = stringToken.toString();
        return 312;
    }

    private int parseQuotedWords(int closeQuote, int openQuote) {
        int c = this.nextc();
        ISourcePosition position = this.support.getPosition();
        while (RubyYaccLexer.isSpace(c)) {
            c = this.nextc();
        }
        this.pushback(c);
        ArrayNode qwords = new ArrayNode(position);
        int nest = 0;
        StringBuffer stringToken = new StringBuffer();
        block5: while ((c = this.nextc()) != closeQuote || nest > 0) {
            if (c == -1) {
                this.errorHandler.handleError(11, position, Messages.getString("unterminated_string"));
                return 0;
            }
            if (c == 92) {
                c = this.nextc();
                switch (c) {
                    case 10: {
                        continue block5;
                    }
                    case 92: {
                        c = 92;
                        break;
                    }
                    default: {
                        if (c == closeQuote || openQuote != 0 && c == openQuote) {
                            stringToken.append((char)c);
                            continue block5;
                        }
                        if (!RubyYaccLexer.isSpace(c)) {
                            stringToken.append('\\');
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (RubyYaccLexer.isSpace(c)) {
                qwords.add(new StrNode(this.support.getPosition(), stringToken.toString()));
                stringToken.setLength(0);
                c = this.nextc();
                while (RubyYaccLexer.isSpace(c)) {
                    c = this.nextc();
                }
                this.pushback(c);
                continue;
            }
            if (openQuote != 0) {
                if (c == openQuote) {
                    ++nest;
                }
                if (c == closeQuote && nest-- == 0) break;
            }
            stringToken.append((char)c);
        }
        if (stringToken.length() > 0) {
            qwords.add(new StrNode(this.support.getPosition(), stringToken.toString()));
        }
        this.lexState = LexState.EXPR_END;
        this.yaccValue = qwords;
        return 320;
    }

    /*
     * Unable to fully structure code
     */
    private int parseHereDocument(int closeQuote, boolean indent) {
        position = this.support.getPosition();
        this.newtok();
        switch (closeQuote) {
            case 34: 
            case 39: 
            case 96: {
                while ((c = this.nextc()) != closeQuote) {
                    this.tokadd((int)var3_4);
                }
                if (closeQuote != 39) break;
                closeQuote = 0;
                break;
            }
            default: {
                c = closeQuote;
                closeQuote = 34;
                if (RubyYaccLexer.isIdentifierChar(c)) ** GOTO lbl19
                this.errorHandler.handleError(1, this.support.getPosition(), Messages.getString("deprecated_bare_<<"));
                break;
lbl-1000:
                // 1 sources

                {
                    this.tokadd(c);
                    c = this.nextc();
lbl19:
                    // 2 sources

                    ** while (RubyYaccLexer.isIdentifierChar((int)c))
                }
lbl20:
                // 1 sources

                this.pushback(c);
            }
        }
        startPosition = this.support.getPosition();
        buffer = this.support.readLine() + '\n';
        eos = this.tok();
        sb = new StringBuffer();
        list = null;
        while (true) {
            if ((line = this.support.readLine()) == null) {
                this.errorHandler.handleError(11, position, Messages.getString("cannot_found_string_before_eof", eos));
                return 0;
            }
            if ((indent && line.trim().startsWith(eos) || line.startsWith(eos)) && line.trim().length() == eos.length()) break;
            this.support.unread(line.length() + 1);
            do {
                switch (this.parseString(closeQuote, 10, 10)) {
                    case 312: 
                    case 313: {
                        this.yaccValue = (String)this.yaccValue + '\n';
                        if (list == null) {
                            sb.append(this.yaccValue);
                            break;
                        }
                        list.add(new StrNode(this.support.getPosition(), (String)this.yaccValue));
                        break;
                    }
                    case 319: {
                        if (list == null) {
                            list = new DStrNode(this.support.getPosition());
                            list.add(new StrNode(this.support.getPosition(), sb.toString()));
                        }
                    }
                    case 315: {
                        if (list == null) {
                            list = new DXStrNode(this.support.getPosition());
                            list.add(new StrNode(this.support.getPosition(), sb.toString()));
                        }
                        ListNodeUtil.addAll(list, (IListNode)this.yaccValue);
                        list.add(new StrNode(this.support.getPosition(), "\n"));
                        break;
                    }
                    case 0: {
                        this.errorHandler.handleError(11, position, Messages.getString("cannot_found_string_before_eof", eos));
                        return 0;
                    }
                }
            } while (this.support.getLastRead() != '\n');
        }
        this.lexState = LexState.EXPR_END;
        this.support.setBuffer(buffer, startPosition);
        switch (closeQuote) {
            case 0: 
            case 34: 
            case 39: {
                if (list != null) {
                    this.yaccValue = list;
                    return 319;
                }
                this.yaccValue = sb.toString();
                return 312;
            }
            case 96: {
                if (list != null) {
                    this.yaccValue = list;
                    return 315;
                }
                this.yaccValue = sb.toString();
                return 313;
            }
        }
        return 0;
    }

    private void arg_ambiguous() {
        this.errorHandler.handleError(2, this.support.getPosition(), Messages.getString("ambiguous_first_argument"));
    }

    public ISourcePosition getPosition() {
        return this._curPos;
    }

    private int yylex() {
        int c;
        int space_seen = 0;
        block50: while (true) {
            c = this.nextc();
            switch (c) {
                case -1: 
                case 0: 
                case 4: 
                case 26: {
                    return 0;
                }
                case 9: 
                case 12: 
                case 13: 
                case 19: 
                case 32: {
                    ++space_seen;
                    continue block50;
                }
                case 35: {
                    while ((c = this.nextc()) != 10) {
                        if (c != -1) continue;
                        return 0;
                    }
                }
                case 10: {
                    if (this.lexState.isExprBeg() || this.lexState.isExprFName() || this.lexState.isExprDot()) continue block50;
                    this.lexState = LexState.EXPR_BEG;
                    return 10;
                }
                case 61: {
                    if (this.support.getPosition().getColumn() != 1 || !this.support.isNext("begin") || !Character.isWhitespace(this.support.getCharAt(6))) break block50;
                    do {
                        if ((c = this.nextc()) != -1) continue;
                        this.errorHandler.handleError(11, Messages.getString("unterminated_embedded_document"));
                        return 0;
                    } while (c != 61 || this.support.getPosition().getColumn() != 1 || !this.support.isNext("end") || !Character.isWhitespace(this.support.getCharAt(4)));
                    this.support.readLine();
                    continue block50;
                }
            }
            break;
        }
        this.pushback(c);
        this._curPos = this.support.getPosition();
        block53: while (true) {
            c = this.nextc();
            switch (c) {
                case 42: {
                    c = this.nextc();
                    if (c == 42) {
                        if (this.nextc() == 61) {
                            this.lexState = LexState.EXPR_BEG;
                            this.yaccValue = "**";
                            return 342;
                        }
                        this.support.unread();
                        c = 323;
                    } else {
                        if (c == 61) {
                            this.yaccValue = "*";
                            this.lexState = LexState.EXPR_BEG;
                            return 342;
                        }
                        this.support.unread();
                        if (this.isArgState() && space_seen != 0 && !RubyYaccLexer.isSpace(c)) {
                            this.errorHandler.handleError(2, this.support.getPosition(), Messages.getString("star_interpreted_as_argument_prefix"));
                            c = 347;
                        } else {
                            c = this.lexState.isExprBeg() || this.lexState.isExprMid() ? 347 : 42;
                        }
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return c;
                }
                case 33: {
                    this.lexState = LexState.EXPR_BEG;
                    c = this.nextc();
                    if (c == 61) {
                        return 327;
                    }
                    if (c == 126) {
                        return 333;
                    }
                    this.pushback(c);
                    return 33;
                }
                case 61: {
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    c = this.nextc();
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 61) {
                            return 326;
                        }
                        this.pushback(c);
                        return 325;
                    }
                    if (c == 126) {
                        return 332;
                    }
                    if (c == 62) {
                        return 343;
                    }
                    this.pushback(c);
                    return 61;
                }
                case 60: {
                    c = this.nextc();
                    if (!(c != 60 || this.lexState.isExprEnd() || this.lexState.isExprEndArg() || this.lexState.isExprClass() || this.isArgState() && space_seen == 0)) {
                        char c2 = this.support.read();
                        boolean indent = false;
                        if (c2 == '-') {
                            indent = true;
                            c2 = this.support.read();
                        }
                        if ("\"'`".indexOf(c2) != -1 || RubyYaccLexer.isIdentifierChar(c2)) {
                            return this.parseHereDocument(c2, indent);
                        }
                        this.support.unread();
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    if (c == 61) {
                        c = this.nextc();
                        if (c == 62) {
                            return 324;
                        }
                        this.pushback(c);
                        return 329;
                    }
                    if (c == 60) {
                        if (this.nextc() == 61) {
                            this.lexState = LexState.EXPR_BEG;
                            this.yaccValue = "<<";
                            return 342;
                        }
                        this.pushback(c);
                        return 338;
                    }
                    this.pushback(c);
                    return 60;
                }
                case 62: {
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    c = this.nextc();
                    if (c == 61) {
                        return 328;
                    }
                    if (c == 62) {
                        c = this.nextc();
                        if (c == 61) {
                            this.lexState = LexState.EXPR_BEG;
                            this.yaccValue = ">>";
                            return 342;
                        }
                        this.pushback(c);
                        return 339;
                    }
                    this.pushback(c);
                    return 62;
                }
                case 34: {
                    return this.parseString(c, c, 0);
                }
                case 96: {
                    if (this.lexState.isExprFName()) {
                        return c;
                    }
                    if (this.lexState.isExprDot()) {
                        return c;
                    }
                    return this.parseString(c, c, 0);
                }
                case 39: {
                    return this.parseSingleQuotedString(c, 0);
                }
                case 63: {
                    if (this.lexState.isExprEnd()) {
                        this.lexState = LexState.EXPR_BEG;
                        return 63;
                    }
                    c = this.nextc();
                    if (c == -1) {
                        this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("incomplete_character_syntax"));
                        return 0;
                    }
                    if (this.isArgState() && RubyYaccLexer.isSpace(c)) {
                        this.pushback(c);
                        this.lexState = LexState.EXPR_BEG;
                        return 63;
                    }
                    if (c == 92) {
                        c = this.readEscape();
                    }
                    this.lexState = LexState.EXPR_END;
                    this.yaccValue = new Long(c &= 0xFF);
                    return 310;
                }
                case 38: {
                    c = this.nextc();
                    if (c == 38) {
                        this.lexState = LexState.EXPR_BEG;
                        c = this.nextc();
                        if (c == 61) {
                            this.yaccValue = "&&";
                            return 342;
                        }
                        this.pushback(c);
                        return 330;
                    }
                    if (c == 61) {
                        this.yaccValue = "&";
                        this.lexState = LexState.EXPR_BEG;
                        return 342;
                    }
                    this.pushback(c);
                    if (this.isArgState() && space_seen != 0 && !RubyYaccLexer.isSpace(c)) {
                        this.errorHandler.handleError(2, this.support.getPosition(), Messages.getString("amp_interpreted_as_argument_prefix"));
                        c = 348;
                    } else {
                        c = this.lexState.isExprBeg() || this.lexState.isExprMid() ? 348 : 38;
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return c;
                }
                case 124: {
                    c = this.nextc();
                    if (c == 124) {
                        this.lexState = LexState.EXPR_BEG;
                        c = this.nextc();
                        if (c == 61) {
                            this.yaccValue = "||";
                            return 342;
                        }
                        this.support.unread();
                        return 331;
                    }
                    if (c == 61) {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "|";
                        return 342;
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.support.unread();
                    return 124;
                }
                case 43: {
                    c = this.nextc();
                    if (this.lexState.isExprFName() || this.lexState.isExprDot()) {
                        this.lexState = LexState.EXPR_ARG;
                        if (c == 64) {
                            return 321;
                        }
                        this.pushback(c);
                        return 43;
                    }
                    if (c == 61) {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "+";
                        return 342;
                    }
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid() || this.isArgState() && space_seen != 0 && !RubyYaccLexer.isSpace(c)) {
                        if (this.isArgState()) {
                            this.arg_ambiguous();
                        }
                        this.lexState = LexState.EXPR_BEG;
                        this.pushback(c);
                        if (Character.isDigit((char)c)) {
                            c = 43;
                            return this.parseNumber((char)c);
                        }
                        return 321;
                    }
                    this.lexState = LexState.EXPR_BEG;
                    this.pushback(c);
                    return 43;
                }
                case 45: {
                    c = this.nextc();
                    if (this.lexState.isExprFName() || this.lexState.isExprDot()) {
                        this.lexState = LexState.EXPR_ARG;
                        if (c == 64) {
                            return 322;
                        }
                        this.pushback(c);
                        return 45;
                    }
                    if (c == 61) {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "-";
                        return 342;
                    }
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid() || this.isArgState() && space_seen != 0 && !RubyYaccLexer.isSpace(c)) {
                        if (this.isArgState()) {
                            this.arg_ambiguous();
                        }
                        this.lexState = LexState.EXPR_BEG;
                        this.pushback(c);
                        if (Character.isDigit((char)c)) {
                            c = 45;
                            return this.parseNumber((char)c);
                        }
                        return 322;
                    }
                    this.lexState = LexState.EXPR_BEG;
                    this.pushback(c);
                    return 45;
                }
                case 46: {
                    this.lexState = LexState.EXPR_BEG;
                    c = this.nextc();
                    if (c == 46) {
                        c = this.nextc();
                        if (c == 46) {
                            return 335;
                        }
                        this.pushback(c);
                        return 334;
                    }
                    this.pushback(c);
                    if (!Character.isDigit((char)c)) {
                        this.lexState = LexState.EXPR_DOT;
                        return 46;
                    }
                    c = 46;
                }
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: {
                    return this.parseNumber((char)c);
                }
                case 93: 
                case 125: {
                    this.lexState = LexState.EXPR_END;
                    return c;
                }
                case 41: {
                    if (this.cond_nest > 0) {
                        this.cond_stack >>= 1;
                    }
                    this.lexState = LexState.EXPR_END;
                    return c;
                }
                case 58: {
                    c = this.nextc();
                    if (c == 58) {
                        if (this.lexState.isExprBeg() || this.lexState.isExprMid() || this.isArgState() && space_seen != 0) {
                            this.lexState = LexState.EXPR_BEG;
                            return 341;
                        }
                        this.lexState = LexState.EXPR_DOT;
                        return 340;
                    }
                    this.pushback(c);
                    if (this.lexState.isExprEnd() || RubyYaccLexer.isSpace(c)) {
                        this.lexState = LexState.EXPR_BEG;
                        return 58;
                    }
                    this.lexState = LexState.EXPR_FNAME;
                    return 349;
                }
                case 47: {
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        return this.parseRegexp('/', '/');
                    }
                    c = this.nextc();
                    if (c == 61) {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "/";
                        return 342;
                    }
                    this.pushback(c);
                    if (this.isArgState() && space_seen != 0 && !RubyYaccLexer.isSpace(c)) {
                        this.arg_ambiguous();
                        return this.parseRegexp('/', '/');
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return 47;
                }
                case 94: {
                    c = this.nextc();
                    if (c == 61) {
                        this.lexState = LexState.EXPR_BEG;
                        this.yaccValue = "^";
                        return 342;
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.pushback(c);
                    return 94;
                }
                case 44: 
                case 59: {
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case 126: {
                    if ((this.lexState.isExprFName() || this.lexState.isExprDot()) && (c = this.nextc()) != 64) {
                        this.pushback(c);
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    return 126;
                }
                case 40: {
                    if (this.cond_nest > 0) {
                        this.cond_stack = this.cond_stack << 1 | 0L;
                    }
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        c = 344;
                    } else if (this.lexState.isExprArg() && space_seen != 0) {
                        this.errorHandler.handleError(2, this.support.getPosition(), this.tok() + Messages.getString("interpreted_as_method_call"));
                    }
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case 91: {
                    if (this.lexState.isExprFName() || this.lexState.isExprDot()) {
                        this.lexState = LexState.EXPR_ARG;
                        c = this.nextc();
                        if (c == 93) {
                            c = this.nextc();
                            if (c == 61) {
                                return 337;
                            }
                            this.pushback(c);
                            return 336;
                        }
                        this.pushback(c);
                        return 91;
                    }
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        c = 345;
                    } else if (this.isArgState() && space_seen != 0) {
                        c = 345;
                    }
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case 123: {
                    if (!this.lexState.isExprEnd() && !this.lexState.isExprArg()) {
                        c = 346;
                    }
                    this.lexState = LexState.EXPR_BEG;
                    return c;
                }
                case 92: {
                    c = this.nextc();
                    if (c == 10) {
                        space_seen = 1;
                        continue block53;
                    }
                    this.pushback(c);
                    return 92;
                }
                case 37: {
                    if (this.lexState.isExprBeg() || this.lexState.isExprMid()) {
                        return this.parseQuotation();
                    }
                    c = this.nextc();
                    if (c == 61) {
                        this.yaccValue = "%";
                        return 342;
                    }
                    if (this.isArgState() && space_seen != 0 && !RubyYaccLexer.isSpace(c)) {
                        this.support.unread();
                        return this.parseQuotation();
                    }
                    this.lexState = this.lexState.isExprFName() || this.lexState.isExprDot() ? LexState.EXPR_ARG : LexState.EXPR_BEG;
                    this.pushback(c);
                    return 37;
                }
                case 36: {
                    this.lexState = LexState.EXPR_END;
                    this.newtok();
                    c = this.nextc();
                    switch (c) {
                        case 95: {
                            c = this.nextc();
                            if (RubyYaccLexer.isIdentifierChar(c)) {
                                this.tokadd(36);
                                this.tokadd(95);
                                break;
                            }
                            this.pushback(c);
                            c = 95;
                        }
                        case 33: 
                        case 34: 
                        case 36: 
                        case 42: 
                        case 44: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 59: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 63: 
                        case 64: 
                        case 92: 
                        case 126: {
                            this.tokadd(36);
                            this.tokadd(c);
                            this.yaccValue = this.tok();
                            return 306;
                        }
                        case 45: {
                            this.tokadd(36);
                            this.tokadd(c);
                            c = this.nextc();
                            this.tokadd(c);
                            this.yaccValue = this.tok();
                            return 306;
                        }
                        case 38: 
                        case 39: 
                        case 43: 
                        case 96: {
                            this.yaccValue = new BackRefNode(this.support.getPosition(), (char)c);
                            return 317;
                        }
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            this.tokadd(36);
                            while (Character.isDigit((char)c)) {
                                this.tokadd(c);
                                c = this.nextc();
                            }
                            if (RubyYaccLexer.isIdentifierChar(c)) break block53;
                            this.pushback(c);
                            this.yaccValue = new NthRefNode(this.support.getPosition(), Integer.parseInt(this.tok().substring(1)));
                            return 318;
                        }
                        default: {
                            if (!RubyYaccLexer.isIdentifierChar(c)) {
                                this.pushback(c);
                                return 36;
                            }
                        }
                        case 48: {
                            this.tokadd(36);
                            break;
                        }
                    }
                    break block53;
                }
                case 64: {
                    c = this.nextc();
                    this.newtok();
                    this.tokadd(64);
                    if (c == 64) {
                        this.tokadd(64);
                        c = this.nextc();
                    }
                    if (Character.isDigit((char)c)) {
                        this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("invalid_instance_variable_name", String.valueOf((char)c)));
                    }
                    if (RubyYaccLexer.isIdentifierChar(c)) break block53;
                    this.pushback(c);
                    return 64;
                }
                default: {
                    if (!RubyYaccLexer.isIdentifierChar(c) || Character.isDigit((char)c)) {
                        this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("invalid_char_in_expression", String.valueOf((char)c)));
                        continue block53;
                    }
                    this.newtok();
                    break block53;
                }
            }
            break;
        }
        while (RubyYaccLexer.isIdentifierChar(c)) {
            this.tokadd(c);
            c = this.nextc();
        }
        if ((c == 33 || c == 63) && RubyYaccLexer.isIdentifierChar(this.tok().charAt(0)) && !this.peek(61)) {
            this.tokadd(c);
        } else {
            this.pushback(c);
        }
        int result = 0;
        switch (this.tok().charAt(0)) {
            case '$': {
                this.lexState = LexState.EXPR_END;
                result = 306;
                break;
            }
            case '@': {
                this.lexState = LexState.EXPR_END;
                if (this.tok().charAt(1) == '@') {
                    result = 309;
                    break;
                }
                result = 307;
                break;
            }
            default: {
                Keyword kw;
                if (!this.lexState.isExprDot() && (kw = RubyYaccLexer.getKeyword(this.tok(), this.toklen())) != null) {
                    LexState state = this.lexState;
                    this.lexState = kw.state;
                    if (state.isExprFName()) {
                        this.yaccValue = kw.name;
                    }
                    if (kw.id0 == 280) {
                        if (this.COND_P()) {
                            return 281;
                        }
                        if (this.CMDARG_P()) {
                            return 282;
                        }
                        return 280;
                    }
                    if (state.isExprBeg()) {
                        return kw.id0;
                    }
                    if (kw.id0 != kw.id1) {
                        this.lexState = LexState.EXPR_BEG;
                    }
                    return kw.id1;
                }
                if (this.toklast() == '!' || this.toklast() == '?') {
                    result = 305;
                } else {
                    if (this.lexState.isExprFName()) {
                        c = this.nextc();
                        if (!(c != 61 || this.peek(126) || this.peek(62) || this.peek(61) && this.support.getCharAt(1) != '>')) {
                            result = 304;
                            this.tokadd(c);
                        } else {
                            this.pushback(c);
                        }
                    }
                    result = result == 0 && Character.isUpperCase(this.tok().charAt(0)) ? 308 : 304;
                }
                this.lexState = this.lexState.isExprBeg() || this.lexState.isExprDot() || this.lexState.isExprArg() ? LexState.EXPR_ARG : LexState.EXPR_END;
            }
        }
        this.yaccValue = this.tok();
        return result;
    }

    private int parseQuotation() {
        char type = this.support.read();
        int openQuote = type;
        if (Character.isLetterOrDigit(type)) {
            openQuote = this.support.read();
        } else {
            type = 'Q';
        }
        if (type == '\u0000' || openQuote == 0) {
            this.errorHandler.handleError(11, this.support.getPosition(), Messages.getString("unterminated_quoted_string"));
            return 0;
        }
        int closeQuote = openQuote;
        if (openQuote == 40) {
            closeQuote = 41;
        } else if (openQuote == 91) {
            closeQuote = 93;
        } else if (openQuote == 123) {
            closeQuote = 125;
        } else if (openQuote == 60) {
            closeQuote = 62;
        } else {
            openQuote = 0;
        }
        switch (type) {
            case 'Q': {
                return this.parseString(34, closeQuote, openQuote);
            }
            case 'q': {
                return this.parseSingleQuotedString(closeQuote, openQuote);
            }
            case 'w': {
                return this.parseQuotedWords(closeQuote, openQuote);
            }
            case 'x': {
                return this.parseString(96, closeQuote, openQuote);
            }
            case 'r': {
                return this.parseRegexp((char)closeQuote, (char)openQuote);
            }
        }
        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("unknown_quotation_type", String.valueOf(type)));
        return 0;
    }

    private int parseNumber(char c) {
        this.lexState = LexState.EXPR_END;
        StringBuffer number = new StringBuffer();
        if (c == '-') {
            number.append(c);
            c = this.support.read();
        } else if (c == '+') {
            c = this.support.read();
        }
        char nondigit = '\u0000';
        if (c == '0') {
            int startLen = number.length();
            c = this.support.read();
            switch (c) {
                case 'X': 
                case 'x': {
                    c = this.support.read();
                    if (RubyYaccLexer.isHexDigit(c)) {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (!RubyYaccLexer.isHexDigit(c)) break;
                                nondigit = '\u0000';
                                number.append(c);
                            }
                            c = this.support.read();
                        }
                    }
                    this.support.unread();
                    if (number.length() == startLen) {
                        this.errorHandler.handleError(10, Messages.getString("number_without_hex_digits"));
                    } else if (nondigit != '\u0000') {
                        this.errorHandler.handleError(10, Messages.getString("trailing_uc"));
                    }
                    this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 16);
                    return 310;
                }
                case 'B': 
                case 'b': {
                    c = this.support.read();
                    if (c == '0' || c == '1') {
                        while (true) {
                            if (c == '_') {
                                if (nondigit != '\u0000') break;
                                nondigit = c;
                            } else {
                                if (c != '0' && c != '1') break;
                                nondigit = '\u0000';
                                number.append(c);
                            }
                            c = this.support.read();
                        }
                    }
                    this.support.unread();
                    if (number.length() == startLen) {
                        this.errorHandler.handleError(10, Messages.getString("number_without_bin_digits"));
                    } else if (nondigit != '\u0000') {
                        this.errorHandler.handleError(10, Messages.getString("trailing_uc"));
                    }
                    this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 2);
                    return 310;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '_': {
                    while (true) {
                        if (c == '_') {
                            if (nondigit != '\u0000') break;
                            nondigit = c;
                        } else {
                            if (c < '0' || c > '7') break;
                            nondigit = '\u0000';
                            number.append(c);
                        }
                        c = this.support.read();
                    }
                    if (number.length() > startLen) {
                        this.support.unread();
                        if (nondigit != '\u0000') {
                            this.errorHandler.handleError(10, Messages.getString("trailing_uc"));
                        }
                        this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 8);
                        return 310;
                    }
                }
                case '8': 
                case '9': {
                    this.errorHandler.handleError(10, Messages.getString("illegal_octal_digit"));
                    break;
                }
                case '.': 
                case 'E': 
                case 'e': {
                    number.append('0');
                    break;
                }
                default: {
                    this.support.unread();
                    this.yaccValue = new Long(0L);
                    return 310;
                }
            }
        }
        boolean seen_point = false;
        boolean seen_e = false;
        while (true) {
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    nondigit = '\u0000';
                    number.append(c);
                    break;
                }
                case '.': {
                    if (nondigit != '\u0000') {
                        this.support.unread();
                        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("trailing_uc"));
                        break;
                    }
                    if (seen_point || seen_e) {
                        this.support.unread();
                        return this.getNumberToken(number.toString(), true, nondigit);
                    }
                    c = this.support.read();
                    if (!Character.isDigit(c)) {
                        this.support.unread(2);
                        if (this.support.getLastRead() == '_') break;
                        this.yaccValue = RubyYaccLexer.getInteger(number.toString(), 10);
                        return 310;
                    }
                    number.append('.');
                    number.append(c);
                    seen_point = true;
                    nondigit = '\u0000';
                    break;
                }
                case 'E': 
                case 'e': {
                    if (nondigit != '\u0000') {
                        this.support.unread();
                        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("trailing_uc"));
                        return 0;
                    }
                    if (seen_e) {
                        this.support.unread();
                        return this.getNumberToken(number.toString(), true, nondigit);
                    }
                    number.append(c);
                    seen_e = true;
                    nondigit = c;
                    c = this.support.read();
                    if (c == '-' || c == '+') {
                        number.append(c);
                        nondigit = c;
                        break;
                    }
                    this.support.unread();
                    break;
                }
                case '_': {
                    if (nondigit != '\u0000') {
                        this.errorHandler.handleError(10, this.support.getPosition(), Messages.getString("trailing_uc"));
                        return 0;
                    }
                    nondigit = c;
                    break;
                }
                default: {
                    this.support.unread();
                    return this.getNumberToken(number.toString(), seen_e || seen_point, nondigit);
                }
            }
            c = this.support.read();
        }
    }

    private int getNumberToken(String number, boolean isFloat, char nondigit) {
        if (nondigit != '\u0000') {
            this.errorHandler.handleError(10, Messages.getString("trailing_uc", String.valueOf(nondigit)));
            return 0;
        }
        if (isFloat) {
            Double d = new Double(0.0);
            try {
                d = Double.valueOf(number);
            }
            catch (NumberFormatException e) {
                this.errorHandler.handleError(1, this.support.getPosition(), Messages.getString("float_out_of_range", number));
            }
            this.yaccValue = d;
            return 311;
        }
        this.yaccValue = RubyYaccLexer.getInteger(number, 10);
        return 310;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private boolean parseExpressionString(IListNode list, char closeQuote, StringToken token) throws EOFException {
        c = this.support.read();
        switch (c) {
            case '$': 
            case '@': 
            case '{': {
                break;
            }
            default: {
                token.append('#');
                this.support.unread();
                return false;
            }
        }
        if (token.getLength() > 0) {
            list.add(new StrNode(token.getPosition(), token.getToken()));
        }
        token.newToken(this.support.getPosition());
        brace = '\uffffffff';
        block3 : switch (c) {
            case '$': {
                token.append('$');
                c = this.support.read();
                if (c == '\u0000') {
                    throw new EOFException();
                }
                switch (c) {
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        while (Character.isDigit(c)) {
                            token.append(c);
                            c = this.support.read();
                        }
                        this.pushback(c);
                        list.add(new NthRefNode(token.getPosition(), Integer.parseInt(token.getToken().substring(1))));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                    case '&': 
                    case '+': {
                        list.add(new BackRefNode(token.getPosition(), c));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                    case '!': 
                    case '$': 
                    case '*': 
                    case ',': 
                    case '.': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '?': 
                    case '@': 
                    case '\\': 
                    case '_': 
                    case '~': {
                        token.append(c);
                        list.add(new GlobalVarNode(token.getPosition(), token.getToken()));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                }
                if (c == closeQuote) {
                    list.add(new StrNode(token.getPosition(), "#$"));
                    this.support.unread();
                    token.newToken(this.support.getPosition());
                    return true;
                }
                switch (c) {
                    case '\"': 
                    case '/': {
                        token.append(c);
                        list.add(new GlobalVarNode(token.getPosition(), token.getToken()));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                    case '\'': 
                    case '`': {
                        list.add(new BackRefNode(token.getPosition(), c));
                        token.newToken(this.support.getPosition());
                        return true;
                    }
                }
                if (RubyYaccLexer.isIdentifierChar(c)) ** GOTO lbl68
                this.errorHandler.handleError(10, token.getPosition(), Messages.getString("bad_global_variable"));
                token.newToken(this.support.getPosition());
                return true;
lbl-1000:
                // 1 sources

                {
                    token.append(c);
                    c = this.support.read();
lbl68:
                    // 2 sources

                    ** while (RubyYaccLexer.isIdentifierChar((int)c))
                }
lbl69:
                // 1 sources

                this.support.unread();
                list.add(new GlobalVarNode(token.getPosition(), token.getToken()));
                token.newToken(this.support.getPosition());
                return true;
            }
            case '@': {
                token.append(c);
                c = this.support.read();
                if (c == '@') {
                    token.append(c);
                    c = this.support.read();
                }
                while (RubyYaccLexer.isIdentifierChar(c)) {
                    token.append(c);
                    c = this.support.read();
                }
                this.support.unread();
                if (token.getToken().startsWith("@@")) {
                    list.add(new ClassVarNode(token.getPosition(), token.getToken()));
                } else {
                    list.add(new InstVarNode(token.getPosition(), token.getToken()));
                }
                token.newToken(this.support.getPosition());
                return true;
            }
            case '{': {
                if (c == '{') {
                    brace = '}';
                }
                nest = 0;
                block27: while (true) {
                    c = this.support.read();
                    switch (c) {
                        case '\u0000': {
                            if (nest > 0) {
                                this.errorHandler.handleError(10, token.getPosition(), Messages.getString("bad_substitution"));
                                token.newToken(this.support.getPosition());
                                return true;
                            }
                            throw new EOFException();
                        }
                        case '}': {
                            if (c == brace) {
                                if (nest == 0) break;
                                --nest;
                            }
                            token.append(c);
                            continue block27;
                        }
                        case '\\': {
                            c = this.support.read();
                            if (c == '\u0000') {
                                throw new EOFException();
                            }
                            if (c == closeQuote) {
                                token.append(c);
                                continue block27;
                            }
                            token.append('\\');
                            token.append(c);
                            continue block27;
                        }
                        case '{': {
                            if (brace != '\uffffffff') {
                                ++nest;
                            }
                        }
                        case '\"': 
                        case '/': 
                        case '`': {
                            if (c == closeQuote) {
                                this.pushback(c);
                                list.add(new StrNode(token.getPosition(), "#"));
                                this.errorHandler.handleError(2, this.support.getPosition(), Messages.getString("bad_substitution"));
                                list.add(new StrNode(token.getPosition(), token.getToken()));
                                token.newToken(this.support.getPosition());
                                return true;
                            }
                        }
                        default: {
                            token.append(c);
                            break;
                        }
                    }
                    if (c == brace) break block3;
                }
            }
        }
        list.add(new EvStrNode(token.getPosition(), token.getToken()));
        token.newToken(this.support.getPosition());
        return true;
    }

    private final boolean isArgState() {
        return this.lexState.isExprArg();
    }

    private static final Keyword getKeyword(String w, int len) {
        return Keyword.getKeyword(w, len);
    }

    private final void yyerror(String msg) {
        this.errorHandler.handleError(0, this.support.getPosition(), msg);
    }

    private static final Object getInteger(String value, int radix) {
        try {
            return Long.valueOf(value, radix);
        }
        catch (NumberFormatException e) {
            return new BigInteger(value, radix);
        }
    }

    private static final boolean isIdentifierChar(int ch) {
        return Character.isLetterOrDigit((char)ch) || ch == 95;
    }

    private static final boolean isSpace(int c) {
        return Character.isWhitespace((char)c);
    }

    private static final boolean isHexDigit(int c) {
        return c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70;
    }

    public void setErrorHandler(IErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setSource(ILexerSource source) {
        this.support = new RubyLexerSupport(source);
    }

    public void setState(ILexerState state) {
        this.lexState = (LexState)state;
    }

    public ILexerSupport getSupport() {
        return this.support;
    }
}

