/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jruby.util.collections.StackElement;

public class LocalNamesElement
implements StackElement {
    private LocalNamesElement next;
    private List localNames;
    private int blockLevel;

    public StackElement getNext() {
        return this.next;
    }

    public void setNext(StackElement newNext) {
        this.next = (LocalNamesElement)newNext;
    }

    public boolean isLocalRegistered(String name) {
        if (this.localNames == null) {
            return false;
        }
        Iterator iter = this.localNames.iterator();
        while (iter.hasNext()) {
            if (!name.equals(iter.next())) continue;
            return true;
        }
        return false;
    }

    public int getLocalIndex(String name) {
        if (name == null) {
            return this.localNames != null ? this.localNames.size() : 0;
        }
        if (this.localNames == null) {
            return this.registerLocal(name);
        }
        int i = 0;
        while (i < this.localNames.size()) {
            if (name.equals(this.localNames.get(i))) {
                return i;
            }
            ++i;
        }
        return this.registerLocal(name);
    }

    public int registerLocal(String name) {
        if (this.localNames == null) {
            this.localNames = new ArrayList();
            this.localNames.add("_");
            this.localNames.add("~");
            if (name.equals("_")) {
                return 0;
            }
            if (name.equals("~")) {
                return 1;
            }
        }
        this.localNames.add(name);
        return this.localNames.size() - 1;
    }

    public int getBlockLevel() {
        return this.blockLevel;
    }

    public void setBlockLevel(int blockLevel) {
        this.blockLevel = blockLevel;
    }

    public List getLocalNames() {
        return this.localNames != null ? Collections.unmodifiableList(this.localNames) : Collections.EMPTY_LIST;
    }

    public void setLocalNames(List localNames) {
        this.localNames = localNames;
    }
}

