/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.parser;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.ablaf.ast.INode;
import org.ablaf.lexer.ILexerSource;
import org.ablaf.lexer.LexerFactory;
import org.ablaf.parser.IParser;
import org.jruby.Ruby;
import org.jruby.parser.DefaultRubyParser;
import org.jruby.parser.IRubyParserResult;
import org.jruby.parser.RubyParserConfiguration;

public class Parser {
    private final Ruby runtime;
    private IParser internalParser = new DefaultRubyParser();

    public Parser(Ruby ruby) {
        this.runtime = ruby;
    }

    public INode parse(String file, String content) {
        return this.parse(file, new StringReader(content));
    }

    public INode parse(String file, Reader content) {
        return this.parse(file, content, new RubyParserConfiguration());
    }

    public INode parse(String file, String content, List blockVariableNames) {
        RubyParserConfiguration config = new RubyParserConfiguration();
        config.setBlockVariables(blockVariableNames);
        return this.parse(file, new StringReader(content), config);
    }

    private INode parse(String file, Reader content, RubyParserConfiguration config) {
        config.setLocalVariables(this.runtime.getScope().getLocalNames());
        this.internalParser.setErrorHandler(this.runtime.getErrorHandler());
        this.internalParser.init(config);
        ILexerSource lexerSource = LexerFactory.getInstance().getSource(file, content);
        IRubyParserResult result = (IRubyParserResult)this.internalParser.parse(lexerSource);
        if (this.hasNewLocalVariables(result)) {
            this.runtime.getScope().setLocalNames(new ArrayList(result.getLocalVariables()));
        }
        return result.getAST();
    }

    private boolean hasNewLocalVariables(IRubyParserResult result) {
        int newSize = 0;
        if (result.getLocalVariables() != null) {
            newSize = result.getLocalVariables().size();
        }
        int oldSize = 0;
        if (this.runtime.getScope().getLocalNames() != null) {
            oldSize = this.runtime.getScope().getLocalNames().size();
        }
        return newSize > oldSize;
    }
}

