/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.util.HashMap;
import java.util.Map;
import org.ablaf.ast.INode;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyModule;
import org.jruby.RubyThread;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.ZeroArgNode;
import org.jruby.evaluator.AssignmentVisitor;
import org.jruby.evaluator.EvaluateVisitor;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.NextJump;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.RedoJump;
import org.jruby.exceptions.ReturnJump;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockStack;
import org.jruby.runtime.Frame;
import org.jruby.runtime.FrameStack;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.Iter;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ScopeStack;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RubyStack;
import org.jruby.util.collections.CollectionFactory;
import org.jruby.util.collections.IStack;

public class ThreadContext {
    private final Ruby ruby;
    private BlockStack blockStack;
    private RubyStack dynamicVarsStack;
    private RubyThread currentThread;
    private Map localVariables;
    private ScopeStack scopeStack;
    private FrameStack frameStack;
    private IStack iterStack;

    public ThreadContext(Ruby ruby) {
        this.ruby = ruby;
        this.blockStack = new BlockStack();
        this.dynamicVarsStack = new RubyStack();
        this.localVariables = new HashMap();
        this.scopeStack = new ScopeStack(ruby);
        this.frameStack = new FrameStack(ruby);
        this.iterStack = CollectionFactory.getInstance().newStack();
        this.pushDynamicVars();
    }

    public BlockStack getBlockStack() {
        return this.blockStack;
    }

    public RubyStack getDynamicVarsStack() {
        return this.dynamicVarsStack;
    }

    public Map getCurrentDynamicVars() {
        return (Map)this.dynamicVarsStack.peek();
    }

    public void pushDynamicVars() {
        this.dynamicVarsStack.push(new HashMap());
    }

    public RubyThread getCurrentThread() {
        return this.currentThread;
    }

    public Map getLocalVariables() {
        return this.localVariables;
    }

    public void setCurrentThread(RubyThread currentThread) {
        this.currentThread = currentThread;
    }

    public IRubyObject eval(Ruby ruby1, INode node) {
        return EvaluateVisitor.createVisitor(this.ruby.getTopSelf()).eval(node);
    }

    public ScopeStack getScopeStack() {
        return this.scopeStack;
    }

    public FrameStack getFrameStack() {
        return this.frameStack;
    }

    public IStack getIterStack() {
        return this.iterStack;
    }

    public Frame getCurrentFrame() {
        return (Frame)this.getFrameStack().peek();
    }

    public Iter getCurrentIter() {
        return (Iter)this.getIterStack().peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject yield(IRubyObject value, IRubyObject self, RubyModule klass, boolean checkArguments) {
        ICallable method;
        if (!this.ruby.isBlockGiven()) {
            throw new RaiseException(this.ruby, this.ruby.getExceptions().getLocalJumpError(), "yield called out of block");
        }
        this.pushDynamicVars();
        Block currentBlock = this.getBlockStack().getCurrent();
        this.getFrameStack().push(currentBlock.getFrame());
        Namespace oldNamespace = this.ruby.getNamespace();
        this.ruby.setNamespace(this.getCurrentFrame().getNamespace());
        Scope oldScope = (Scope)this.getScopeStack().getTop();
        this.getScopeStack().setTop(currentBlock.getScope());
        this.getBlockStack().pop();
        this.getDynamicVarsStack().push(currentBlock.getDynamicVariables());
        this.ruby.pushClass(klass != null ? klass : currentBlock.getKlass());
        if (klass == null) {
            self = currentBlock.getSelf();
        }
        if (value == null) {
            value = RubyArray.newArray(this.ruby, 0L);
        }
        if ((method = currentBlock.getMethod()) == null) {
            return this.ruby.getNil();
        }
        this.getIterStack().push(currentBlock.getIter());
        IRubyObject[] args = this.prepareArguments(value, self, currentBlock.getVar(), checkArguments);
        try {
            IRubyObject iRubyObject;
            try {
                while (true) {
                    try {
                        iRubyObject = method.call(this.ruby, self, null, args, false);
                        Object var14_13 = null;
                    }
                    catch (RedoJump rExcptn) {
                        continue;
                    }
                    break;
                }
            }
            catch (NextJump nExcptn) {
                IRubyObject iRubyObject2 = this.ruby.getNil();
                Object var14_14 = null;
                this.getIterStack().pop();
                this.ruby.popClass();
                this.getDynamicVarsStack().pop();
                this.getBlockStack().setCurrent(currentBlock);
                this.getFrameStack().pop();
                this.ruby.setNamespace(oldNamespace);
                this.getScopeStack().setTop(oldScope);
                this.getDynamicVarsStack().pop();
                return iRubyObject2;
            }
            catch (ReturnJump rExcptn) {
                IRubyObject iRubyObject3 = rExcptn.getReturnValue();
                Object var14_15 = null;
                this.getIterStack().pop();
                this.ruby.popClass();
                this.getDynamicVarsStack().pop();
                this.getBlockStack().setCurrent(currentBlock);
                this.getFrameStack().pop();
                this.ruby.setNamespace(oldNamespace);
                this.getScopeStack().setTop(oldScope);
                this.getDynamicVarsStack().pop();
                return iRubyObject3;
            }
            this.getIterStack().pop();
            this.ruby.popClass();
            this.getDynamicVarsStack().pop();
            this.getBlockStack().setCurrent(currentBlock);
            this.getFrameStack().pop();
            this.ruby.setNamespace(oldNamespace);
            this.getScopeStack().setTop(oldScope);
            this.getDynamicVarsStack().pop();
            return iRubyObject;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            this.getIterStack().pop();
            this.ruby.popClass();
            this.getDynamicVarsStack().pop();
            this.getBlockStack().setCurrent(currentBlock);
            this.getFrameStack().pop();
            this.ruby.setNamespace(oldNamespace);
            this.getScopeStack().setTop(oldScope);
            this.getDynamicVarsStack().pop();
            throw throwable;
        }
    }

    private IRubyObject[] prepareArguments(IRubyObject value, IRubyObject self, INode blockVariableNode, boolean checkArguments) {
        value = this.prepareBlockVariable(value, self, blockVariableNode, checkArguments);
        if (blockVariableNode == null && checkArguments && value instanceof RubyArray && ((RubyArray)value).getLength() == 1) {
            value = ((RubyArray)value).entry(0L);
        }
        return this.arrayify(value);
    }

    private IRubyObject[] arrayify(IRubyObject value) {
        if (value instanceof RubyArray) {
            return ((RubyArray)value).toJavaArray();
        }
        return new IRubyObject[]{value};
    }

    private IRubyObject prepareBlockVariable(IRubyObject value, IRubyObject self, INode blockVariableNode, boolean checkArguments) {
        if (blockVariableNode == null) {
            return value;
        }
        if (checkArguments && value instanceof RubyArray) {
            RubyArray arrayValue = (RubyArray)value;
            if (blockVariableNode instanceof ZeroArgNode && arrayValue.getLength() != 0) {
                throw new ArgumentError(this.ruby, arrayValue.getLength(), 0);
            }
            if (!(blockVariableNode instanceof MultipleAsgnNode) && arrayValue.getLength() == 1) {
                value = arrayValue.entry(0L);
            }
        }
        new AssignmentVisitor(this.ruby, self).assign(blockVariableNode, value, checkArguments);
        return value;
    }
}

