/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jruby.Ruby;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;

public class ScriptTestSuite
extends TestSuite {
    private static final String TEST_DIR = "test";
    private static final String TEST_INDEX;

    public ScriptTestSuite(String name) {
        super(name);
    }

    /*
     * WARNING - void declaration
     */
    public static Test suite() throws IOException {
        String line;
        TestSuite suite = new TestSuite();
        Ruby ruby = ScriptTestSuite.setupInterpreter();
        File testIndex = new File("test/test_index");
        if (!testIndex.canRead()) {
            suite.addTest((Test)new FailingTest("ScriptTestSuite", "Couldn't locate " + TEST_INDEX + ". Make sure you run the tests from the base " + "directory of the JRuby sourcecode."));
            return suite;
        }
        BufferedReader testFiles = new BufferedReader(new InputStreamReader(new FileInputStream(testIndex)));
        while ((line = testFiles.readLine()) != null) {
            void var4_4;
            line = var4_4.trim();
            if (line.startsWith("#") || line.length() == 0) continue;
            suite.addTest((Test)new ScriptTest(ruby, line));
        }
        return suite;
    }

    private static Ruby setupInterpreter() {
        Ruby result = Ruby.getDefaultInstance(null);
        return result;
    }

    static {
        TEST_DIR = TEST_DIR;
        TEST_INDEX = TEST_DIR + File.separator + "test_index";
    }

    private static class ScriptTest
    extends TestCase {
        private final Ruby ruby;
        private final String filename;

        public ScriptTest(Ruby ruby, String filename) {
            super(filename);
            this.ruby = ruby;
            this.filename = filename;
        }

        private String scriptName() {
            return new File(ScriptTestSuite.TEST_DIR + File.separator + this.filename).getPath();
        }

        public void runTest() throws Throwable {
            StringBuffer script = new StringBuffer();
            script.append("require 'minirunit'").append('\n');
            script.append("test_load('").append(this.scriptName()).append("')").append('\n');
            script.append("test_get_last_failed()").append('\n');
            IRubyObject lastFailed = this.ruby.evalScript(script.toString());
            if (!lastFailed.isNil()) {
                RubyString message = (RubyString)lastFailed.callMethod("to_s");
                Assert.fail((String)message.getValue());
            }
            System.out.flush();
        }
    }

    private static class FailingTest
    extends TestCase {
        private final String message;

        public FailingTest(String name, String message) {
            super(name);
            this.message = message;
        }

        public void runTest() throws Throwable {
            Assert.fail((String)this.message);
        }
    }
}

