/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.runtime.builtin.IRubyObject;

public class TestRubyObject
extends TestCase {
    private Ruby ruby;
    private IRubyObject rubyObject;

    public TestRubyObject(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
        this.rubyObject = this.ruby.getFactory().newObject(this.ruby.getClasses().getObjectClass());
    }

    public void testNil() {
        Assert.assertTrue((!this.rubyObject.isNil() ? 1 : 0) != 0);
    }

    public void testTrue() {
        Assert.assertTrue((boolean)this.rubyObject.isTrue());
    }

    public void testEquals() {
        Assert.assertTrue((boolean)this.rubyObject.equals(this.rubyObject));
    }

    public void testClone() {
        Assert.assertTrue((this.rubyObject.rbClone().getType() == this.rubyObject.getType() ? 1 : 0) != 0);
    }

    public void testDup() {
        Assert.assertTrue((this.rubyObject.dup().getType() == this.rubyObject.getType() ? 1 : 0) != 0);
    }

    public void testType() {
        Assert.assertEquals((Object)"Object", (Object)this.rubyObject.getType().name().toString());
    }

    public void testFreeze() {
        Assert.assertTrue((!this.rubyObject.isFrozen() ? 1 : 0) != 0);
        this.rubyObject.setFrozen(true);
        Assert.assertTrue((boolean)this.rubyObject.isFrozen());
    }

    public void testTaint() {
        Assert.assertTrue((!this.rubyObject.isTaint() ? 1 : 0) != 0);
        this.rubyObject.setTaint(true);
        Assert.assertTrue((boolean)this.rubyObject.isTaint());
    }

    public void test_to_s() {
        Assert.assertTrue((boolean)this.rubyObject.toString().startsWith("#<Object:0x"));
    }

    public void test_kind_of() {
        Assert.assertTrue((boolean)this.rubyObject.isKindOf(this.ruby.getClasses().getObjectClass()));
    }
}

