/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.test;

import java.util.ArrayList;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jruby.Ruby;
import org.jruby.RubySymbol;

public class TestRubySymbol
extends TestCase {
    private Ruby ruby;

    public TestRubySymbol(String name) {
        super(name);
    }

    public void setUp() {
        this.ruby = Ruby.getDefaultInstance(null);
        this.ruby.getLoadService().init(this.ruby, new ArrayList());
    }

    public void testSymbolTable() throws Exception {
        RubySymbol.SymbolTable st = new RubySymbol.SymbolTable();
        Assert.assertNull((Object)st.lookup("somename"));
        RubySymbol symbol = RubySymbol.newSymbol(this.ruby, "somename");
        st.store(symbol);
        Assert.assertSame((Object)symbol, (Object)st.lookup("somename"));
        RubySymbol nilSymbol = RubySymbol.nilSymbol(this.ruby);
        st.store(nilSymbol);
        Assert.assertSame((Object)nilSymbol, (Object)st.lookup(null));
    }

    public void testNilSymbol() throws Exception {
        Assert.assertTrue((boolean)RubySymbol.nilSymbol(this.ruby).isNil());
        Assert.assertSame((Object)RubySymbol.nilSymbol(this.ruby), (Object)RubySymbol.nilSymbol(this.ruby));
    }
}

