/*
 * Copyright (C) 2002 Anders Bengtsson <ndrsbngtssn@yahoo.se>
 *
 * JRuby - http://jruby.sourceforge.net
 *
 * This file is part of JRuby
 *
 * JRuby is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * JRuby is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with JRuby; if not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, MA  02111-1307 USA
 */
package org.jruby.util.collections;

import java.util.*;

public class IdentitySet {
    private Collection items = new ArrayList();

    public void add(Object item) {
        items.add(item);
    }

    public void remove(Object item) {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            Object storedItem = iter.next();
            if (item == storedItem) {
                iter.remove();
            }
        }
    }

    public boolean contains(Object item) {
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            Object storedItem = iter.next();
            if (item == storedItem) {
                return true;
            }
        }
        return false;
    }
}
