/*
 * Decompiled with CFR 0.152.
 */
package org.ablaf.internal.ast;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.ablaf.ast.IAstDecoder;
import org.ablaf.ast.IAstEncoder;
import org.ablaf.ast.IAstMarshal;
import org.ablaf.ast.INode;
import org.jruby.util.Asserts;

public class SerializationAstMarshal
implements IAstMarshal {
    public IAstEncoder openEncoder(OutputStream output) {
        try {
            final ObjectOutputStream oout = new ObjectOutputStream(output);
            return new IAstEncoder(){

                public void writeNode(INode node) {
                    try {
                        oout.writeObject(node);
                    }
                    catch (IOException e) {
                        Asserts.notReached("IOException: " + e.getMessage());
                    }
                }

                public void close() {
                    try {
                        oout.close();
                    }
                    catch (IOException e) {
                        Asserts.notReached("IOException: " + e.getMessage());
                    }
                }
            };
        }
        catch (IOException e) {
            Asserts.notReached("IOException: " + e.getMessage());
            return null;
        }
    }

    public IAstDecoder openDecoder(InputStream input) {
        try {
            final ObjectInputStream oin = new ObjectInputStream(input);
            return new IAstDecoder(){

                public INode readNode() {
                    try {
                        return (INode)oin.readObject();
                    }
                    catch (IOException e) {
                        Asserts.notReached("IOException: " + e.getMessage());
                        return null;
                    }
                    catch (ClassNotFoundException e) {
                        Asserts.notReached("ClassNotFoundException: " + e.getMessage());
                        return null;
                    }
                }

                public void close() {
                    try {
                        oin.close();
                    }
                    catch (IOException e) {
                        Asserts.notReached("IOException: " + e.getMessage());
                    }
                }
            };
        }
        catch (IOException e) {
            Asserts.notReached("IOException: " + e.getMessage());
            return null;
        }
    }
}

