/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.exceptions.FrozenError;

public final class IncludedModuleWrapper
extends RubyClass {
    private RubyModule delegate;

    public IncludedModuleWrapper(Ruby ruby, RubyClass superClass, RubyModule delegate) {
        super(ruby, superClass);
        this.delegate = delegate;
    }

    public IncludedModuleWrapper newIncludeClass(RubyClass superClass) {
        return new IncludedModuleWrapper(this.getRuntime(), superClass, this.getDelegate());
    }

    public boolean isModule() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public boolean isIncluded() {
        return true;
    }

    protected void testFrozen() {
        if (this.isFrozen()) {
            throw new FrozenError(this.getRuntime(), "module");
        }
    }

    public RubyClass getMetaClass() {
        return this.delegate.getMetaClass();
    }

    public void setMetaClass(RubyClass newRubyClass) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    public Map getMethods() {
        return this.delegate.getMethods();
    }

    public void setMethods(Map newMethods) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    public Map getInstanceVariables() {
        return this.delegate.getInstanceVariables();
    }

    public void setInstanceVariables(Map newMethods) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    public String getClassname() {
        return this.delegate.getClassname();
    }

    public RubyModule getDelegate() {
        return this.delegate;
    }

    public RubyClass getRealClass() {
        return this.getSuperClass().getRealClass();
    }
}

