/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import org.ablaf.ast.INode;
import org.jruby.KernelModule;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyGlobal;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.ThrowJump;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.ParserSupport;
import org.jruby.util.Asserts;
import org.jruby.util.CommandlineParser;

public class Main {
    private static CommandlineParser commandline;
    private static boolean hasPrintedUsage;

    public static void main(String[] args) {
        commandline = new CommandlineParser(args);
        if (Main.commandline.showVersion) {
            Main.showVersion();
        }
        if (!commandline.shouldRunInterpreter()) {
            return;
        }
        long now = -1L;
        if (Main.commandline.isBenchmarking) {
            now = System.currentTimeMillis();
        }
        Main.runInterpreter(Main.getScriptSource(), Main.displayedFileName());
        if (Main.commandline.isBenchmarking) {
            System.out.println("Runtime: " + (System.currentTimeMillis() - now) + " ms");
        }
    }

    private static void showVersion() {
        System.out.print("ruby ");
        System.out.print("1.6.7");
        System.out.print(" (");
        System.out.print("2002-10-28");
        System.out.print(") [");
        System.out.print("java");
        System.out.println("]");
    }

    public static void printUsage() {
        if (!hasPrintedUsage) {
            System.out.println("Usage: jruby [switches] [rubyfile.rb] [arguments]");
            System.out.println("    -e 'command'    one line of script. Several -e's allowed. Omit [programfile]");
            System.out.println("    -b              benchmark mode, times the script execution");
            System.out.println("    -Idirectory     specify $LOAD_PATH directory (may be used more than once)");
            System.out.println("    -R 'name'       The regexp engine to use, for now can be JDK, GNU or ORO");
            hasPrintedUsage = true;
        }
    }

    private static void runInterpreter(Reader reader, String filename) {
        Ruby runtime = Ruby.getDefaultInstance(Main.commandline.sRegexpAdapter);
        try {
            Main.initializeRuntime(runtime, filename);
            INode parsedScript = Main.getParsedScript(runtime, reader, filename);
            runtime.eval(parsedScript);
        }
        catch (RaiseException rExcptn) {
            runtime.printError(rExcptn.getException());
        }
        catch (ThrowJump throwJump) {
            runtime.printError(throwJump.getNameError());
        }
    }

    private static INode getParsedScript(Ruby runtime, Reader reader, String filename) {
        INode result = runtime.parse(reader, filename);
        if (Main.commandline.assumePrinting) {
            result = new ParserSupport().appendPrintToBlock(result);
        }
        if (Main.commandline.assumeLoop) {
            result = new ParserSupport().appendWhileLoopToBlock(result, Main.commandline.processLineEnds, Main.commandline.sDoSplit);
        }
        return result;
    }

    private static void initializeRuntime(Ruby runtime, String filename) {
        RubyArray argumentArray = RubyArray.newArray(runtime, JavaUtil.convertJavaArrayToRuby(runtime, Main.commandline.scriptArguments));
        runtime.setVerbose(Main.commandline.verbose);
        Main.defineGlobal(runtime, "$VERBOSE", Main.commandline.verbose);
        runtime.defineGlobalConstant("ARGV", argumentArray);
        Main.defineGlobal(runtime, "$-p", Main.commandline.assumePrinting);
        Main.defineGlobal(runtime, "$-n", Main.commandline.assumeLoop);
        Main.defineGlobal(runtime, "$-a", Main.commandline.sDoSplit);
        Main.defineGlobal(runtime, "$-l", Main.commandline.processLineEnds);
        runtime.getGlobalVariables().defineReadonly("$*", new ValueAccessor(argumentArray));
        runtime.defineVariable(new RubyGlobal.StringGlobalVariable(runtime, "$0", RubyString.newString(runtime, filename)));
        runtime.getLoadService().init(runtime, commandline.loadPaths());
        Iterator iter = commandline.requiredLibraries().iterator();
        while (iter.hasNext()) {
            String scriptName = (String)iter.next();
            KernelModule.require(runtime.getTopSelf(), RubyString.newString(runtime, scriptName));
        }
    }

    private static void defineGlobal(Ruby runtime, String name, boolean value) {
        runtime.getGlobalVariables().defineReadonly(name, new ValueAccessor(value ? runtime.getTrue() : runtime.getNil()));
    }

    private static Reader getScriptSource() {
        if (commandline.hasInlineScript()) {
            return new StringReader(commandline.inlineScript());
        }
        if (Main.commandline.scriptFileName != null) {
            File file = new File(Main.commandline.scriptFileName);
            try {
                return new BufferedReader(new FileReader(file));
            }
            catch (IOException e) {
                System.err.println("Error opening script file: " + e.getMessage());
                System.exit(1);
            }
        } else {
            return new InputStreamReader(System.in);
        }
        Asserts.notReached();
        return null;
    }

    private static String displayedFileName() {
        if (commandline.hasInlineScript()) {
            return "-e";
        }
        return Main.commandline.scriptFileName;
    }

    static {
        hasPrintedUsage = false;
    }
}

