/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IMetaClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubySymbol;
import org.jruby.exceptions.FrozenError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Asserts;

public class MetaClass
extends RubyClass
implements IMetaClass {
    public RubyClass type;

    public MetaClass(Ruby runtime, RubyClass type) {
        super(runtime, runtime.getClasses().getClassClass(), type);
        Asserts.notNull(type);
        this.type = type;
    }

    public MetaClass(Ruby runtime, RubyClass type, RubyClass superClass) {
        super(runtime, type, superClass);
    }

    public boolean isSingleton() {
        return true;
    }

    protected RubyClass subclass() {
        throw new TypeError(this.runtime, "can't make subclass of virtual class");
    }

    protected void testFrozen() {
        if (this.isFrozen()) {
            throw new FrozenError(this.getRuntime(), "object");
        }
    }

    public void attachToObject(IRubyObject object) {
        this.setInstanceVariable("__attached__", object);
    }

    public RubyClass getRealClass() {
        return this.getSuperClass().getRealClass();
    }

    public void methodAdded(RubySymbol symbol) {
        this.getAttachedObject().callMethod("singleton_method_added", symbol);
    }

    public IRubyObject getAttachedObject() {
        return this.getInstanceVariable("__attached__");
    }
}

