/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.ablaf.ast.INode;
import org.ablaf.common.ISourcePosition;
import org.jruby.IncludedModuleWrapper;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyClasses;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyGlobal;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ThreadClass;
import org.jruby.TopSelfFactory;
import org.jruby.common.IRubyErrorHandler;
import org.jruby.common.RubyErrorHandler;
import org.jruby.exceptions.BreakJump;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.RetryJump;
import org.jruby.exceptions.ReturnJump;
import org.jruby.exceptions.SecurityError;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.internal.runtime.ValueAccessor;
import org.jruby.internal.runtime.builtin.ObjectFactory;
import org.jruby.internal.runtime.methods.IterateMethod;
import org.jruby.javasupport.JavaSupport;
import org.jruby.javasupport.JavaUtil;
import org.jruby.parser.Parser;
import org.jruby.runtime.BlockStack;
import org.jruby.runtime.Callback;
import org.jruby.runtime.DynamicVariableSet;
import org.jruby.runtime.Frame;
import org.jruby.runtime.FrameStack;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.IGlobalVariables;
import org.jruby.runtime.Iter;
import org.jruby.runtime.LastCallStatus;
import org.jruby.runtime.Namespace;
import org.jruby.runtime.ObjectSpace;
import org.jruby.runtime.RubyExceptions;
import org.jruby.runtime.Scope;
import org.jruby.runtime.ScopeStack;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IObjectFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.ILoadService;
import org.jruby.runtime.load.LoadServiceFactory;
import org.jruby.runtime.regexp.IRegexpAdapter;
import org.jruby.util.Asserts;
import org.jruby.util.RubyStack;
import org.jruby.util.collections.IStack;

public final class Ruby {
    private ThreadContext mainContext = new ThreadContext(this);
    private ThreadContextLocal threadContext = new ThreadContextLocal(this.mainContext);
    public int stackTraces = 0;
    public ObjectSpace objectSpace = new ObjectSpace();
    public final RubyFixnum[] fixnumCache = new RubyFixnum[256];
    public final RubySymbol.SymbolTable symbolTable = new RubySymbol.SymbolTable();
    public long randomSeed = 0L;
    public Random random = new Random();
    private RubyProc traceFunction;
    private boolean isWithinTrace = false;
    private int safeLevel = 0;
    private IObjectFactory factory = new ObjectFactory(this);
    private IRubyObject nilObject;
    private RubyBoolean trueObject;
    private RubyBoolean falseObject;
    private RubyClasses classes;
    private RubyExceptions exceptions;
    private IRubyObject topSelf;
    private Scope topScope = null;
    private Frame topFrame;
    private Namespace namespace;
    private Namespace topNamespace;
    private boolean isVerbose = false;
    private RubyModule wrapper;
    private RubyStack classStack = new RubyStack();
    private JavaSupport javaSupport;
    private Class regexpAdapterClass;
    private Parser parser = new Parser(this);
    private LastCallStatus lastCallStatus = new LastCallStatus(this);
    private ILoadService loadService = LoadServiceFactory.createLoadService(this);
    private IGlobalVariables globalVariables = new GlobalVariables(this);
    private IRubyErrorHandler errorHandler = new RubyErrorHandler(this);
    private static final int TRACE_HEAD = 8;
    private static final int TRACE_TAIL = 5;
    private static final int TRACE_MAX = 18;

    public void dispose() {
        this.threadContext.dereferenceMainContext();
    }

    private Ruby(Class regexpAdapterClass) {
        this.regexpAdapterClass = regexpAdapterClass;
        this.nilObject = RubyObject.nilObject(this);
        this.trueObject = new RubyBoolean(this, true);
        this.falseObject = new RubyBoolean(this, false);
        this.javaSupport = new JavaSupport(this);
    }

    public static Ruby getDefaultInstance(String regexpEngineName) {
        Class regexpAdapterClass = IRegexpAdapter.getAdapter(regexpEngineName);
        Ruby ruby = new Ruby(regexpAdapterClass);
        ruby.init();
        return ruby;
    }

    public static Ruby getDefaultInstance() {
        return Ruby.getDefaultInstance((String)null);
    }

    public static Ruby getDefaultInstance(Class regexpAdapterClass) {
        Ruby ruby = new Ruby(regexpAdapterClass);
        ruby.init();
        return ruby;
    }

    public Object evalScript(String script, Class returnClass) {
        IRubyObject result = this.evalScript(script);
        return JavaUtil.convertRubyToJava(result, returnClass);
    }

    public IRubyObject evalScript(String script) {
        return this.eval(this.parse(script, "<script>"));
    }

    public IRubyObject eval(INode node) {
        return this.getCurrentContext().eval(node);
    }

    public Class getRegexpAdapterClass() {
        return this.regexpAdapterClass;
    }

    public RubyClasses getClasses() {
        return this.classes;
    }

    public RubyBoolean getTrue() {
        return this.trueObject;
    }

    public RubyBoolean getFalse() {
        return this.falseObject;
    }

    public IRubyObject getNil() {
        return this.nilObject;
    }

    public RubyModule getRubyModule(String name) {
        return this.classes.getClass(name);
    }

    public RubyClass getClass(String name) {
        return (RubyClass)this.classes.getClass(name);
    }

    public RubyClass defineClass(String name, RubyClass superClass) {
        if (superClass == null) {
            superClass = this.getClasses().getObjectClass();
        }
        RubyClass newClass = RubyClass.newClass(this, superClass, name);
        newClass.makeMetaClass(superClass.getMetaClass());
        newClass.inheritedBy(superClass);
        this.classes.putClass(name, newClass);
        return newClass;
    }

    public RubyClass defineClass(String name, String superName) {
        RubyClass superClass = this.getClass(superName);
        Asserts.isTrue(superClass != null, "can't find superclass '" + superName + "'");
        return this.defineClass(name, superClass);
    }

    public RubyModule defineModule(String name) {
        RubyModule newModule = RubyModule.newModule(this, name);
        this.getClasses().putClass(name, newModule);
        return newModule;
    }

    public int getSafeLevel() {
        return this.safeLevel;
    }

    public void setSafeLevel(int safeLevel) {
        this.safeLevel = safeLevel;
    }

    public void secure(int level) {
        if (level <= this.safeLevel) {
            throw new SecurityError(this, "Insecure operation '" + this.getCurrentFrame().getLastFunc() + "' at level " + this.safeLevel);
        }
    }

    public void defineGlobalConstant(String name, IRubyObject value) {
        this.getClasses().getObjectClass().defineConstant(name, value);
    }

    public IRubyObject getTopConstant(String name) {
        IRubyObject constant = this.getClasses().getClass(name);
        if (constant == null) {
            constant = this.getLoadService().autoload(name);
        }
        return constant;
    }

    public boolean isClassDefined(String name) {
        return this.classes.getClass(name) != null;
    }

    public IRubyObject yield(IRubyObject value) {
        return this.yield(value, null, null, false);
    }

    public IRubyObject yield(IRubyObject value, IRubyObject self, RubyModule klass, boolean checkArguments) {
        return this.getCurrentContext().yield(value, self, klass, checkArguments);
    }

    public Scope currentScope() {
        return this.getScope().current();
    }

    public IRubyObject getTopSelf() {
        return this.topSelf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject iterate(Callback iterateMethod, IRubyObject data1, Callback blockMethod, IRubyObject data2) {
        this.getIterStack().push(Iter.ITER_PRE);
        this.getBlockStack().push(null, new IterateMethod(blockMethod, data2), this.getTopSelf());
        try {
            while (true) {
                IRubyObject iRubyObject;
                try {
                    iRubyObject = iterateMethod.execute(data1, null);
                }
                catch (BreakJump bExcptn) {
                    IRubyObject iRubyObject2 = this.getNil();
                    Object var9_8 = null;
                    this.getIterStack().pop();
                    this.getBlockStack().pop();
                    return iRubyObject2;
                }
                catch (ReturnJump rExcptn) {
                    IRubyObject iRubyObject3 = rExcptn.getReturnValue();
                    Object var9_9 = null;
                    this.getIterStack().pop();
                    this.getBlockStack().pop();
                    return iRubyObject3;
                }
                catch (RetryJump rExcptn) {
                    continue;
                }
                Object var9_7 = null;
                this.getIterStack().pop();
                this.getBlockStack().pop();
                return iRubyObject;
                break;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.getIterStack().pop();
            this.getBlockStack().pop();
            throw throwable;
        }
    }

    private void init() {
        this.getIterStack().push(Iter.ITER_NOT);
        this.getFrameStack().push();
        this.topFrame = this.getCurrentFrame();
        this.getScope().push();
        this.topScope = this.currentScope();
        this.setCurrentVisibility(Visibility.PRIVATE);
        this.classes = new RubyClasses(this);
        this.classes.initCoreClasses();
        RubyGlobal.createGlobals(this);
        this.exceptions = new RubyExceptions(this);
        this.exceptions.initDefaultExceptionClasses();
        this.topSelf = TopSelfFactory.createTopSelf(this);
        this.classStack.push(this.getClasses().getObjectClass());
        this.getCurrentFrame().setSelf(this.topSelf);
        this.namespace = this.topNamespace = new Namespace(this.getClasses().getObjectClass());
        this.getCurrentFrame().setNamespace(this.namespace);
        this.classes.initBuiltinClasses();
        this.getScope().pop();
        this.getScope().push(this.topScope);
    }

    public ScopeStack getScope() {
        return this.getCurrentContext().getScopeStack();
    }

    public String getSourceFile() {
        return this.getPosition().getFile();
    }

    public int getSourceLine() {
        return this.getPosition().getLine();
    }

    public boolean isVerbose() {
        return this.isVerbose;
    }

    public boolean isBlockGiven() {
        return this.getCurrentFrame().isBlockGiven();
    }

    public boolean isFBlockGiven() {
        Frame previous = this.getFrameStack().getPrevious();
        if (previous == null) {
            return false;
        }
        return previous.isBlockGiven();
    }

    public void pushClass(RubyModule newClass) {
        this.classStack.push(newClass);
    }

    public void popClass() {
        this.classStack.pop();
    }

    public void setVerbose(boolean verbose) {
        this.isVerbose = verbose;
        this.errorHandler.setVerbose(verbose);
    }

    public DynamicVariableSet getDynamicVars() {
        return this.getCurrentContext().getCurrentDynamicVars();
    }

    public IRubyObject getDynamicValue(String name) {
        IRubyObject result = this.getDynamicVars().get(name);
        if (result == null) {
            return this.getNil();
        }
        return result;
    }

    public RubyModule getRubyClass() {
        RubyModule rubyClass = (RubyModule)this.classStack.peek();
        if (rubyClass.isIncluded()) {
            return ((IncludedModuleWrapper)rubyClass).getDelegate();
        }
        return rubyClass;
    }

    public FrameStack getFrameStack() {
        return this.getCurrentContext().getFrameStack();
    }

    public Frame getCurrentFrame() {
        return this.getCurrentContext().getCurrentFrame();
    }

    public Frame getTopFrame() {
        return this.topFrame;
    }

    public void setTopFrame(Frame topFrame) {
        this.topFrame = topFrame;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Namespace newNamespace) {
        this.namespace = newNamespace;
    }

    public Namespace getTopNamespace() {
        return this.topNamespace;
    }

    public JavaSupport getJavaSupport() {
        return this.javaSupport;
    }

    public IStack getIterStack() {
        return this.getCurrentContext().getIterStack();
    }

    public Iter getCurrentIter() {
        return this.getCurrentContext().getCurrentIter();
    }

    public BlockStack getBlockStack() {
        return this.getCurrentContext().getBlockStack();
    }

    public RubyModule getCBase() {
        return this.getCurrentFrame().getNamespace().getNamespaceModule();
    }

    public Visibility getCurrentVisibility() {
        return this.currentScope().getVisibility();
    }

    public void setCurrentVisibility(Visibility visibility) {
        this.currentScope().setVisibility(visibility);
    }

    public RubyModule getWrapper() {
        return this.wrapper;
    }

    public void setWrapper(RubyModule wrapper) {
        this.wrapper = wrapper;
    }

    public RubyExceptions getExceptions() {
        return this.exceptions;
    }

    public void defineVariable(final GlobalVariable variable) {
        this.globalVariables.define(variable.name(), new IAccessor(){

            public IRubyObject getValue() {
                return variable.get();
            }

            public IRubyObject setValue(IRubyObject newValue) {
                return variable.set(newValue);
            }
        });
    }

    public void defineReadonlyVariable(String name, IRubyObject value) {
        this.globalVariables.defineReadonly(name, new ValueAccessor(value));
    }

    public INode parse(Reader content, String file) {
        return this.parser.parse(file, content);
    }

    public INode parse(String content, String file) {
        return this.parser.parse(file, content);
    }

    public IRubyObject getLastline() {
        if (this.getScope().hasLocalVariables()) {
            return this.getScope().getValue(0);
        }
        return RubyString.nilString(this);
    }

    public void setLastline(IRubyObject value) {
        if (!this.getScope().hasLocalVariables()) {
            this.getScope().resetLocalVariables(new ArrayList<String>(Arrays.asList("_", "~")));
        }
        this.getScope().setValue(0, value);
    }

    public IRubyObject getBackref() {
        if (this.getScope().hasLocalVariables()) {
            return this.getScope().getValue(1);
        }
        return this.getNil();
    }

    public void setBackref(IRubyObject match) {
        if (!this.getScope().hasLocalVariables()) {
            this.getScope().resetLocalVariables(new ArrayList<String>(Arrays.asList("_", "~")));
        }
        this.getScope().setValue(1, match);
    }

    public Parser getParser() {
        return this.parser;
    }

    public ThreadContext getCurrentContext() {
        return (ThreadContext)this.threadContext.get();
    }

    public ThreadContext getMainContext() {
        return this.mainContext;
    }

    public void registerNewContext(ThreadClass thread) {
        this.threadContext.set(new ThreadContext(this));
        this.getCurrentContext().setCurrentThread(thread);
    }

    public ISourcePosition getPosition() {
        return this.getCurrentContext().getPosition();
    }

    public void setPosition(String file, int line) {
        this.getCurrentContext().setPosition(file, line);
    }

    public void setPosition(ISourcePosition position) {
        this.getCurrentContext().setPosition(position);
    }

    public void pushDynamicVars() {
        this.getCurrentContext().pushDynamicVars();
    }

    public void popDynamicVars() {
        this.getCurrentContext().popDynamicVars();
    }

    public void setDynamicVariable(String name, IRubyObject value) {
        this.getDynamicVars().set(name, value);
    }

    public List getDynamicNames() {
        return this.getDynamicVars().names();
    }

    public IObjectFactory getFactory() {
        return this.factory;
    }

    public LastCallStatus getLastCallStatus() {
        return this.lastCallStatus;
    }

    public ILoadService getLoadService() {
        return this.loadService;
    }

    public IRubyErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public IRubyObject callSuper(IRubyObject[] args) {
        return this.getCurrentContext().callSuper(args);
    }

    public PrintStream getErrorStream() {
        return new PrintStream(((RubyIO)this.getGlobalVariables().get("$stderr")).getOutStream());
    }

    public InputStream getInputStream() {
        return ((RubyIO)this.getGlobalVariables().get("$stdin")).getInStream();
    }

    public PrintStream getOutputStream() {
        return new PrintStream(((RubyIO)this.getGlobalVariables().get("$stdout")).getOutStream());
    }

    public void printError(RubyException excp) {
        if (excp == null || excp.isNil()) {
            return;
        }
        RubyArray backtrace = (RubyArray)excp.callMethod("backtrace");
        if (backtrace.isNil()) {
            if (this.getSourceFile() != null) {
                this.getErrorStream().print(this.getSourceFile() + ':' + this.getSourceLine());
            } else {
                this.getErrorStream().print(this.getSourceLine());
            }
        } else if (backtrace.getLength() == 0) {
            this.printErrorPos();
        } else {
            IRubyObject mesg = backtrace.first();
            if (mesg.isNil()) {
                this.printErrorPos();
            } else {
                this.getErrorStream().print(mesg);
            }
        }
        RubyClass type = excp.getMetaClass();
        String info = excp.toString();
        if (type == this.getExceptions().getRuntimeError() && (info == null || info.length() == 0)) {
            this.getErrorStream().print(": unhandled exception\n");
        } else {
            String path = type.getClassPath().toString();
            if (info.length() == 0) {
                this.getErrorStream().print(": " + path + '\n');
            } else {
                if (path.startsWith("#")) {
                    path = null;
                }
                String tail = null;
                if (info.indexOf("\n") != -1) {
                    tail = info.substring(info.indexOf("\n") + 1);
                    info = info.substring(0, info.indexOf("\n"));
                }
                this.getErrorStream().print(": " + info);
                if (path != null) {
                    this.getErrorStream().print(" (" + path + ")\n");
                }
                if (tail != null) {
                    this.getErrorStream().print(tail + '\n');
                }
            }
        }
        if (!backtrace.isNil()) {
            IRubyObject[] elements = backtrace.toJavaArray();
            int i = 0;
            while (i < elements.length) {
                if (elements[i] instanceof RubyString) {
                    this.getErrorStream().print("\tfrom " + elements[i] + '\n');
                }
                if (i == 8 && elements.length > 18) {
                    this.getErrorStream().print("\t ... " + (elements.length - 8 - 5) + "levels...\n");
                    i = elements.length - 5;
                }
                ++i;
            }
        }
    }

    private void printErrorPos() {
        if (this.getSourceFile() != null) {
            if (this.getCurrentFrame().getLastFunc() != null) {
                this.getErrorStream().print(this.getSourceFile() + ':' + this.getSourceLine());
                this.getErrorStream().print(":in '" + this.getCurrentFrame().getLastFunc() + '\'');
            } else if (this.getSourceLine() != 0) {
                this.getErrorStream().print(this.getSourceFile() + ':' + this.getSourceLine());
            } else {
                this.getErrorStream().print(this.getSourceFile());
            }
        }
    }

    public void loadScript(RubyString scriptName, RubyString source, boolean wrap) {
        this.loadScript(scriptName.getValue(), new StringReader(source.getValue()), wrap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadScript(String scriptName, Reader source, boolean wrap) {
        IRubyObject self = this.getTopSelf();
        Namespace savedNamespace = this.getNamespace();
        this.pushDynamicVars();
        RubyModule wrapper = this.getWrapper();
        this.setNamespace(this.getTopNamespace());
        if (!wrap) {
            this.secure(4);
            this.pushClass(this.getClasses().getObjectClass());
            this.setWrapper(null);
        } else {
            this.setWrapper(RubyModule.newModule(this));
            this.pushClass(this.getWrapper());
            self = this.getTopSelf().rbClone();
            self.extendObject(this.getRubyClass());
            this.setNamespace(new Namespace(this.getWrapper(), this.getNamespace()));
        }
        String last_func = this.getCurrentFrame().getLastFunc();
        this.getFrameStack().push();
        this.getCurrentFrame().setLastFunc(null);
        this.getCurrentFrame().setLastClass(null);
        this.getCurrentFrame().setSelf(self);
        this.getCurrentFrame().setNamespace(new Namespace(this.getRubyClass(), null));
        this.getScope().push();
        this.setCurrentVisibility(Visibility.PRIVATE);
        try {
            INode node = this.parse(source, scriptName);
            self.eval(node);
        }
        finally {
            this.getCurrentFrame().setLastFunc(last_func);
            this.setNamespace(savedNamespace);
            this.getScope().pop();
            this.getFrameStack().pop();
            this.popClass();
            this.popDynamicVars();
            this.setWrapper(wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadNode(String scriptName, INode node, boolean wrap) {
        IRubyObject self = this.getTopSelf();
        Namespace savedNamespace = this.getNamespace();
        this.pushDynamicVars();
        RubyModule wrapper = this.getWrapper();
        this.setNamespace(this.getTopNamespace());
        if (!wrap) {
            this.secure(4);
            this.pushClass(this.getClasses().getObjectClass());
            this.setWrapper(null);
        } else {
            this.setWrapper(RubyModule.newModule(this));
            this.pushClass(this.getWrapper());
            self = this.getTopSelf().rbClone();
            self.extendObject(this.getRubyClass());
            this.setNamespace(new Namespace(this.getWrapper(), this.getNamespace()));
        }
        String last_func = this.getCurrentFrame().getLastFunc();
        this.getFrameStack().push();
        this.getCurrentFrame().setLastFunc(null);
        this.getCurrentFrame().setLastClass(null);
        this.getCurrentFrame().setSelf(self);
        this.getCurrentFrame().setNamespace(new Namespace(this.getRubyClass(), null));
        this.getScope().push();
        this.setCurrentVisibility(Visibility.PRIVATE);
        try {
            self.eval(node);
        }
        finally {
            this.getCurrentFrame().setLastFunc(last_func);
            this.setNamespace(savedNamespace);
            this.getScope().pop();
            this.getFrameStack().pop();
            this.popClass();
            this.popDynamicVars();
            this.setWrapper(wrapper);
        }
    }

    public void loadFile(File file, boolean wrap) {
        Asserts.notNull(file, "No such file to load");
        try {
            BufferedReader source = new BufferedReader(new FileReader(file));
            this.loadScript(file.getPath(), source, wrap);
            source.close();
        }
        catch (IOException ioExcptn) {
            throw IOError.fromException(this, ioExcptn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void callTraceFunction(String event, ISourcePosition position, IRubyObject self, String name, IRubyObject type) {
        if (!this.isWithinTrace && this.traceFunction != null) {
            this.isWithinTrace = true;
            ISourcePosition savePosition = this.getPosition();
            String file = position.getFile();
            if (file == null) {
                file = "(ruby)";
            }
            if (type == null) {
                type = this.getFalse();
            }
            this.getFrameStack().push();
            this.getCurrentFrame().setIter(Iter.ITER_NOT);
            try {
                this.traceFunction.call(new IRubyObject[]{RubyString.newString(this, event), RubyString.newString(this, file), RubyFixnum.newFixnum(this, position.getLine()), name != null ? RubySymbol.newSymbol(this, name) : this.getNil(), self != null ? self : this.getNil(), type});
                Object var9_8 = null;
                this.getFrameStack().pop();
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.getFrameStack().pop();
                this.setPosition(savePosition);
                this.isWithinTrace = false;
                throw throwable;
            }
            this.setPosition(savePosition);
            this.isWithinTrace = false;
            {
            }
        }
    }

    public RubyProc getTraceFunction() {
        return this.traceFunction;
    }

    public void setTraceFunction(RubyProc traceFunction) {
        this.traceFunction = traceFunction;
    }

    public IGlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    private static class ThreadContextLocal
    extends ThreadLocal {
        private ThreadContext mainContext;

        public ThreadContextLocal(ThreadContext mainContext) {
            this.mainContext = mainContext;
        }

        protected Object initialValue() {
            return this.mainContext;
        }

        public void dereferenceMainContext() {
            this.mainContext = null;
            this.set(null);
        }
    }
}

