/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.FrozenError;
import org.jruby.exceptions.IndexError;
import org.jruby.exceptions.SecurityError;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.builtin.definitions.ArrayDefinition;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Pack;
import org.jruby.util.collections.IdentitySet;

public class RubyArray
extends RubyObject
implements IndexCallable {
    private ArrayList list;
    private boolean tmpLock;
    static /* synthetic */ Class class$org$jruby$RubyArray;
    static /* synthetic */ Class class$org$jruby$RubyFixnum;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyString;

    private RubyArray(Ruby ruby, ArrayList list) {
        super(ruby, ruby.getClasses().getArrayClass());
        this.list = list;
    }

    public static RubyArray nilArray(Ruby ruby) {
        return new RubyArray(ruby, null){

            public boolean isNil() {
                return true;
            }
        };
    }

    public ArrayList getList() {
        return this.list;
    }

    public IRubyObject[] toJavaArray() {
        return this.list.toArray(new IRubyObject[this.getLength()]);
    }

    public boolean isTmpLock() {
        return this.tmpLock;
    }

    public void setTmpLock(boolean tmpLock) {
        this.tmpLock = tmpLock;
    }

    public int getLength() {
        return this.list.size();
    }

    public boolean includes(IRubyObject item) {
        int i = 0;
        int n = this.getLength();
        while (i < n) {
            if (item.callMethod("==", this.entry(i)).isTrue()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static RubyClass createArrayClass(Ruby ruby) {
        RubyClass arrayClass = new ArrayDefinition(ruby).getType();
        arrayClass.defineMethod("to_a", CallbackFactory.getSelfMethod(0));
        arrayClass.defineMethod("to_ary", CallbackFactory.getSelfMethod(0));
        arrayClass.defineMethod("at", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "at", class$org$jruby$RubyFixnum == null ? (class$org$jruby$RubyFixnum = RubyArray.class$("org.jruby.RubyFixnum")) : class$org$jruby$RubyFixnum));
        arrayClass.defineMethod("slice", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "aref"));
        arrayClass.defineMethod("slice!", CallbackFactory.getOptMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "slice_bang"));
        arrayClass.defineMethod("assoc", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "assoc", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("rassoc", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "rassoc", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("+", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_plus", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("*", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_times", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("-", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_diff", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("&", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_and", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("|", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "op_or", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyArray.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        arrayClass.defineMethod("uniq", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "uniq"));
        arrayClass.defineMethod("uniq!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "uniq_bang"));
        arrayClass.defineMethod("compact", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "compact"));
        arrayClass.defineMethod("compact!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "compact_bang"));
        arrayClass.defineMethod("flatten", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "flatten"));
        arrayClass.defineMethod("flatten!", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "flatten_bang"));
        arrayClass.defineMethod("nitems", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "nitems"));
        arrayClass.defineMethod("pack", CallbackFactory.getMethod(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "pack", class$org$jruby$RubyString == null ? (class$org$jruby$RubyString = RubyArray.class$("org.jruby.RubyString")) : class$org$jruby$RubyString));
        return arrayClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 61441: {
                return this.initialize(args);
            }
            case 61442: {
                return this.inspect();
            }
            case 61443: {
                return this.to_s();
            }
            case 61444: {
                return this.frozen();
            }
            case 61445: {
                return this.equal(args[0]);
            }
            case 61446: {
                return this.eql(args[0]);
            }
            case 61447: {
                return this.hash();
            }
            case 61448: {
                return this.aref(args);
            }
            case 61449: {
                return this.aset(args);
            }
            case 61450: {
                return this.first();
            }
            case 61451: {
                return this.last();
            }
            case 61452: {
                return this.concat(args[0]);
            }
            case 61453: {
                return this.append(args[0]);
            }
            case 61454: {
                return this.push(args);
            }
            case 61455: {
                return this.pop();
            }
            case 61456: {
                return this.shift();
            }
            case 61457: {
                return this.unshift(args);
            }
            case 61458: {
                return this.each();
            }
            case 61459: {
                return this.each_index();
            }
            case 61460: {
                return this.reverse_each();
            }
            case 61461: {
                return this.length();
            }
            case 61462: {
                return this.empty_p();
            }
            case 61463: {
                return this.index(args[0]);
            }
            case 61464: {
                return this.rindex(args[0]);
            }
            case 61465: {
                return this.indices(args);
            }
            case 61466: {
                return this.rbClone();
            }
            case 61467: {
                return this.join(args);
            }
            case 61468: {
                return this.reverse();
            }
            case 61469: {
                return this.reverse_bang();
            }
            case 61470: {
                return this.sort();
            }
            case 61471: {
                return this.sort_bang();
            }
            case 61472: {
                return this.collect();
            }
            case 61473: {
                return this.collect_bang();
            }
            case 61474: {
                return this.delete(args[0]);
            }
            case 61475: {
                return this.delete_at(args[0]);
            }
            case 61476: {
                return this.delete_if();
            }
            case 61477: {
                return this.reject_bang();
            }
            case 61478: {
                return this.replace(args[0]);
            }
            case 61479: {
                return this.clear();
            }
            case 61481: {
                return this.include_p(args[0]);
            }
            case 61482: {
                return this.op_cmp(args[0]);
            }
            case 61480: {
                return this.fill(args);
            }
        }
        return super.callIndexed(index, args);
    }

    public RubyFixnum hash() {
        return RubyFixnum.newFixnum(this.runtime, this.list.hashCode());
    }

    public void modify() {
        if (this.isFrozen()) {
            throw new FrozenError(this.getRuntime(), "Array");
        }
        if (this.isTmpLock()) {
            throw new TypeError(this.getRuntime(), "can't modify array during sort");
        }
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw new SecurityError(this.getRuntime(), "Insecure: can't modify array");
        }
    }

    private void autoExpand(long toLength) {
        this.list.ensureCapacity((int)toLength);
        int i = this.getLength();
        while ((long)i < toLength) {
            this.list.add(this.getRuntime().getNil());
            ++i;
        }
    }

    private void store(long index, IRubyObject value) {
        this.modify();
        if (index < 0L && (index += (long)this.getLength()) < 0L) {
            throw new IndexError(this.getRuntime(), "index " + (index - (long)this.getLength()) + " out of array");
        }
        this.autoExpand(index + 1L);
        this.list.set((int)index, value);
    }

    public IRubyObject entry(long offset) {
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        if (offset < 0L) {
            offset += (long)this.getLength();
        }
        if (offset < 0L || (long)this.getLength() <= offset) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.get((int)offset);
    }

    public RubyArray unshift(IRubyObject item) {
        this.modify();
        this.list.add(0, item);
        return this;
    }

    public IRubyObject subseq(long beg, long len) {
        int length = this.getLength();
        if (beg > (long)length || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)length) {
            len = (long)length - beg;
        }
        if (len <= 0L) {
            return RubyArray.newArray(this.getRuntime(), 0L);
        }
        RubyArray ary2 = RubyArray.newArray(this.getRuntime(), new ArrayList(this.list.subList((int)beg, (int)(len + beg))));
        return ary2;
    }

    public void replace(long beg, long len, IRubyObject repl) {
        int length = this.getLength();
        if (len < 0L) {
            throw new IndexError(this.getRuntime(), "Negative array length: " + len);
        }
        if (beg < 0L) {
            beg += (long)length;
        }
        if (beg < 0L) {
            throw new IndexError(this.getRuntime(), "Index out of bounds: " + beg);
        }
        this.modify();
        int i = 0;
        while (beg < (long)this.getLength() && (long)i < len) {
            this.list.remove((int)beg);
            ++i;
        }
        this.autoExpand(beg);
        if (repl instanceof RubyArray) {
            ArrayList repList = ((RubyArray)repl).getList();
            this.list.ensureCapacity(this.getLength() + repList.size());
            this.list.addAll((int)beg, new ArrayList(repList));
        } else if (!repl.isNil()) {
            this.list.add((int)beg, repl);
        }
    }

    public static RubyArray arrayValue(IRubyObject other) {
        if (other instanceof RubyArray) {
            return (RubyArray)other;
        }
        try {
            return (RubyArray)other.convertType(class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyArray.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray, "Array", "to_ary");
        }
        catch (Exception ex) {
            throw new ArgumentError(other.getRuntime(), "can't convert arg to Array: " + ex.getMessage());
        }
    }

    private boolean flatten(ArrayList array) {
        return this.flatten(array, new IdentitySet());
    }

    private boolean flatten(ArrayList array, IdentitySet visited) {
        if (visited.contains(array)) {
            throw new ArgumentError(this.runtime, "tried to flatten recursive array");
        }
        visited.add(array);
        boolean isModified = false;
        int i = array.size() - 1;
        while (i >= 0) {
            if (array.get(i) instanceof RubyArray) {
                ArrayList ary2 = ((RubyArray)array.remove(i)).getList();
                this.flatten(ary2, visited);
                array.addAll(i, ary2);
                isModified = true;
            }
            --i;
        }
        visited.remove(array);
        return isModified;
    }

    public static final RubyArray newArray(Ruby ruby, long len) {
        return new RubyArray(ruby, new ArrayList((int)len));
    }

    public static final RubyArray newArray(Ruby ruby) {
        return new RubyArray(ruby, new ArrayList(16));
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject obj) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(1);
        list.add(obj);
        return new RubyArray(ruby, list);
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject car, IRubyObject cdr) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(2);
        list.add(car);
        list.add(cdr);
        return new RubyArray(ruby, list);
    }

    public static final RubyArray newArray(Ruby ruby, ArrayList list) {
        return new RubyArray(ruby, list);
    }

    public static RubyArray newArray(Ruby ruby, IRubyObject[] args) {
        int size = args.length;
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(size);
        int i = 0;
        while (i < size) {
            list.add(args[i]);
            ++i;
        }
        return new RubyArray(ruby, list);
    }

    public static RubyArray newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyArray array = RubyArray.newArray(recv.getRuntime());
        array.setMetaClass((RubyClass)recv);
        array.callInit(args);
        return array;
    }

    public static RubyArray create(IRubyObject recv, IRubyObject[] args) {
        RubyArray array = RubyArray.newArray(recv.getRuntime(), args);
        array.setMetaClass((RubyClass)recv);
        return array;
    }

    public RubyFixnum length() {
        return RubyFixnum.newFixnum(this.getRuntime(), this.getLength());
    }

    public RubyArray push(IRubyObject[] items) {
        this.modify();
        boolean tainted = false;
        int i = 0;
        while (i < items.length) {
            tainted |= items[i].isTaint();
            this.list.add(items[i]);
            ++i;
        }
        this.setTaint(this.isTaint() || tainted);
        return this;
    }

    public RubyArray append(IRubyObject value) {
        this.modify();
        this.list.add(value);
        this.infectBy(value);
        return this;
    }

    public IRubyObject pop() {
        this.modify();
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.remove(this.getLength() - 1);
    }

    public IRubyObject shift() {
        this.modify();
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.remove(0);
    }

    public RubyArray unshift(IRubyObject[] items) {
        if (items.length == 0) {
            throw new ArgumentError(this.getRuntime(), "wrong # of arguments(at least 1)");
        }
        this.modify();
        boolean taint = false;
        int i = 0;
        while (i < items.length) {
            taint |= items[i].isTaint();
            this.list.add(i, items[i]);
            ++i;
        }
        this.setTaint(this.isTaint() || taint);
        return this;
    }

    public RubyBoolean include_p(IRubyObject item) {
        return RubyBoolean.newBoolean(this.runtime, this.includes(item));
    }

    public RubyBoolean frozen() {
        return RubyBoolean.newBoolean(this.getRuntime(), this.isFrozen() || this.isTmpLock());
    }

    public IRubyObject initialize(IRubyObject[] args) {
        int argc = this.argCount(args, 0, 2);
        long len = 0L;
        if (argc != 0) {
            len = RubyNumeric.fix2long(args[0]);
        }
        this.modify();
        if (len < 0L) {
            throw new ArgumentError(this.getRuntime(), "negative array size");
        }
        if (len > Integer.MAX_VALUE) {
            throw new ArgumentError(this.getRuntime(), "array size too big");
        }
        this.list = new ArrayList((int)len);
        if (len > 0L) {
            IRubyObject obj = argc == 2 ? args[1] : this.getRuntime().getNil();
            Collections.fill(this.list, obj);
        }
        return this;
    }

    public IRubyObject aref(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            if (beg < 0L) {
                beg += (long)this.getLength();
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            return this.entry(RubyNumeric.fix2long(args[0]));
        }
        if (args[0] instanceof RubyBignum) {
            throw new IndexError(this.getRuntime(), "index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), true, false);
            if (begLen == null) {
                return this.getRuntime().getNil();
            }
            return this.subseq(begLen[0], begLen[1]);
        }
        return this.entry(RubyNumeric.num2long(args[0]));
    }

    public IRubyObject aset(IRubyObject[] args) {
        int argc = this.argCount(args, 2, 3);
        if (argc == 3) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            this.replace(beg, len, args[2]);
            return args[2];
        }
        if (args[0] instanceof RubyFixnum) {
            this.store(RubyNumeric.fix2long(args[0]), args[1]);
            return args[1];
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], args[1]);
            return args[1];
        }
        if (args[0] instanceof RubyBignum) {
            throw new IndexError(this.getRuntime(), "Index too large");
        }
        this.store(RubyNumeric.num2long(args[0]), args[1]);
        return args[1];
    }

    public IRubyObject at(RubyFixnum pos) {
        return this.entry(pos.getLongValue());
    }

    public RubyArray concat(IRubyObject obj) {
        this.modify();
        RubyArray other = RubyArray.arrayValue(obj);
        this.list.addAll(other.getList());
        this.infectBy(other);
        return this;
    }

    public RubyString inspect() {
        int length = this.getLength();
        if (length == 0) {
            return RubyString.newString(this.getRuntime(), "[]");
        }
        RubyString result = RubyString.newString(this.getRuntime(), "[");
        RubyString separator = RubyString.newString(this.getRuntime(), ", ");
        int i = 0;
        while (i < length) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(this.entry(i).callMethod("inspect"));
            ++i;
        }
        result.cat("]");
        return result;
    }

    public IRubyObject first() {
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return this.entry(0L);
    }

    public IRubyObject last() {
        if (this.getLength() == 0) {
            return this.getRuntime().getNil();
        }
        return this.entry(this.getLength() - 1);
    }

    public IRubyObject each() {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.getRuntime().yield(this.entry(i));
            ++i;
        }
        return this;
    }

    public IRubyObject each_index() {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.getRuntime().yield(RubyFixnum.newFixnum(this.getRuntime(), i));
            ++i;
        }
        return this;
    }

    public IRubyObject reverse_each() {
        long i = this.getLength();
        while (i > 0L) {
            this.getRuntime().yield(this.entry(i - 1L));
            --i;
        }
        return this;
    }

    RubyString join(RubyString sep) {
        int length = this.getLength();
        if (length == 0) {
            RubyString.newString(this.getRuntime(), "");
        }
        boolean taint = this.isTaint() || sep.isTaint();
        IRubyObject tmp = this.entry(0L);
        taint |= tmp.isTaint();
        RubyString str = tmp instanceof RubyString ? (RubyString)tmp.dup() : (tmp instanceof RubyArray ? ((RubyArray)tmp).join(sep) : RubyString.objAsString(tmp));
        long i = 1L;
        while (i < (long)length) {
            tmp = this.entry(i);
            taint |= tmp.isTaint();
            if (tmp instanceof RubyArray) {
                tmp = ((RubyArray)tmp).join(sep);
            } else if (!(tmp instanceof RubyString)) {
                tmp = RubyString.objAsString(tmp);
            }
            str.append(sep.op_plus(tmp));
            ++i;
        }
        str.setTaint(taint);
        return str;
    }

    public RubyString join(IRubyObject[] args) {
        int argc = this.argCount(args, 0, 1);
        IRubyObject sep = argc == 1 ? args[0] : this.getRuntime().getGlobalVariables().get("$,");
        return this.join(sep.isNil() ? RubyString.newString(this.getRuntime(), "") : RubyString.stringValue(sep));
    }

    public RubyString to_s() {
        IRubyObject separatorObject = this.getRuntime().getGlobalVariables().get("$,");
        RubyString separator = separatorObject.isNil() ? RubyString.newString(this.getRuntime(), "") : RubyString.stringValue(separatorObject);
        return this.join(separator);
    }

    public RubyArray to_a() {
        return this;
    }

    public RubyBoolean equal(IRubyObject obj) {
        RubyArray ary;
        if (this == obj) {
            return this.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        int length = this.getLength();
        if (length != (ary = (RubyArray)obj).getLength()) {
            return this.getRuntime().getFalse();
        }
        long i = 0L;
        while (i < (long)length) {
            if (!this.entry(i).callMethod("==", ary.entry(i)).isTrue()) {
                return this.getRuntime().getFalse();
            }
            ++i;
        }
        return this.getRuntime().getTrue();
    }

    public RubyBoolean eql(IRubyObject obj) {
        RubyArray ary;
        if (!(obj instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        int length = this.getLength();
        if (length != (ary = (RubyArray)obj).getLength()) {
            return this.getRuntime().getFalse();
        }
        long i = 0L;
        while (i < (long)length) {
            if (!this.entry(i).callMethod("eql?", ary.entry(i)).isTrue()) {
                return this.getRuntime().getFalse();
            }
            ++i;
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject compact_bang() {
        this.modify();
        boolean isChanged = false;
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (this.entry(i).isNil()) {
                this.list.remove(i);
                isChanged = true;
            }
            --i;
        }
        return isChanged ? this : this.getRuntime().getNil();
    }

    public IRubyObject compact() {
        RubyArray ary = (RubyArray)this.dup();
        ary.compact_bang();
        return ary;
    }

    public IRubyObject empty_p() {
        return this.getLength() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject clear() {
        this.modify();
        this.list.clear();
        return this;
    }

    public IRubyObject fill(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 3);
        int beg = 0;
        int len = this.getLength();
        switch (argc) {
            case 1: {
                break;
            }
            case 2: {
                if (args[1] instanceof RubyRange) {
                    long[] begLen = ((RubyRange)args[1]).getBeginLength(len, false, true);
                    beg = (int)begLen[0];
                    len = (int)begLen[1];
                    break;
                }
            }
            default: {
                int n = beg = args[1].isNil() ? beg : RubyNumeric.fix2int(args[1]);
                if (beg < 0 && (beg += len) < 0) {
                    throw new IndexError(this.getRuntime(), "Negative array index");
                }
                len -= beg;
                if (argc != 3 || args[2].isNil()) break;
                len = RubyNumeric.fix2int(args[2]);
            }
        }
        this.modify();
        this.autoExpand(beg + len);
        int i = beg;
        while (i < beg + len) {
            this.list.set(i, args[0]);
            ++i;
        }
        return this;
    }

    public IRubyObject index(IRubyObject obj) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            if (obj.callMethod("==", this.entry(i)).isTrue()) {
                return RubyFixnum.newFixnum(this.getRuntime(), i);
            }
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rindex(IRubyObject obj) {
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (obj.callMethod("==", this.entry(i)).isTrue()) {
                return RubyFixnum.newFixnum(this.getRuntime(), i);
            }
            --i;
        }
        return this.getRuntime().getNil();
    }

    public RubyArray indices(IRubyObject[] args) {
        IRubyObject[] result = new IRubyObject[args.length];
        boolean taint = false;
        int i = 0;
        while (i < args.length) {
            result[i] = this.entry(RubyNumeric.fix2int(args[i]));
            taint |= result[i].isTaint();
            ++i;
        }
        RubyArray ary = RubyArray.create(this.getMetaClass(), result);
        ary.setTaint(taint);
        return ary;
    }

    public IRubyObject rbClone() {
        RubyArray result = RubyArray.newArray(this.getRuntime(), new ArrayList(this.list));
        result.setupClone(this);
        return result;
    }

    public RubyArray reverse_bang() {
        if (this.list.size() <= 1) {
            return RubyArray.nilArray(this.runtime);
        }
        this.modify();
        Collections.reverse(this.list);
        return this;
    }

    public IRubyObject reverse() {
        RubyArray result = (RubyArray)this.dup();
        result.reverse_bang();
        return result;
    }

    public RubyArray collect() {
        if (!this.getRuntime().isBlockGiven()) {
            return (RubyArray)this.dup();
        }
        ArrayList<IRubyObject> ary = new ArrayList<IRubyObject>();
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            ary.add(this.getRuntime().yield(this.entry(i)));
            ++i;
        }
        return new RubyArray(this.getRuntime(), ary);
    }

    public RubyArray collect_bang() {
        this.modify();
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            this.list.set(i, this.getRuntime().yield(this.entry(i)));
            ++i;
        }
        return this;
    }

    public IRubyObject delete(IRubyObject obj) {
        this.modify();
        IRubyObject result = this.getRuntime().getNil();
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (obj.callMethod("==", this.entry(i)).isTrue()) {
                result = (IRubyObject)this.list.remove(i);
            }
            --i;
        }
        if (result.isNil() && this.getRuntime().isBlockGiven()) {
            result = this.getRuntime().yield(this.entry(0L));
        }
        return result;
    }

    public IRubyObject delete_at(IRubyObject obj) {
        this.modify();
        int pos = (int)RubyNumeric.num2long(obj);
        int len = this.getLength();
        if (pos >= len) {
            return this.getRuntime().getNil();
        }
        if (pos < 0 && (pos += len) < 0) {
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.remove(pos);
    }

    public IRubyObject reject_bang() {
        this.modify();
        IRubyObject retVal = this.getRuntime().getNil();
        int i = this.getLength() - 1;
        while (i >= 0) {
            if (this.getRuntime().yield(this.entry(i)).isTrue()) {
                retVal = (IRubyObject)this.list.remove(i);
            }
            --i;
        }
        return retVal.isNil() ? retVal : this;
    }

    public IRubyObject delete_if() {
        this.reject_bang();
        return this;
    }

    public IRubyObject replace(IRubyObject other) {
        this.replace(0L, this.getLength(), RubyArray.arrayValue(other));
        return this;
    }

    public IRubyObject op_cmp(IRubyObject other) {
        RubyArray ary = RubyArray.arrayValue(other);
        int otherLen = ary.getLength();
        int len = this.getLength();
        if (len != otherLen) {
            return len > otherLen ? RubyFixnum.one(this.getRuntime()) : RubyFixnum.minus_one(this.getRuntime());
        }
        int i = 0;
        while (i < len) {
            RubyFixnum result = (RubyFixnum)this.entry(i).callMethod("<=>", ary.entry(i));
            if (result.getLongValue() != 0L) {
                return result;
            }
            ++i;
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject slice_bang(IRubyObject[] args) {
        int argc = this.argCount(args, 1, 2);
        IRubyObject result = this.aref(args);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            this.replace(beg, len, this.getRuntime().getNil());
        } else if (args[0] instanceof RubyFixnum && RubyNumeric.fix2long(args[0]) < (long)this.getLength()) {
            this.replace(RubyNumeric.fix2long(args[0]), 1L, this.getRuntime().getNil());
        } else if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], this.getRuntime().getNil());
        }
        return result;
    }

    public IRubyObject assoc(IRubyObject arg) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            RubyArray ary;
            if (this.entry(i) instanceof RubyArray && ((RubyArray)this.entry(i)).getLength() > 0 && arg.callMethod("==", (ary = (RubyArray)this.entry(i)).entry(0L)).isTrue()) {
                return ary;
            }
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rassoc(IRubyObject arg) {
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            RubyArray ary;
            if (this.entry(i) instanceof RubyArray && ((RubyArray)this.entry(i)).getLength() > 1 && arg.callMethod("==", (ary = (RubyArray)this.entry(i)).entry(1L)).isTrue()) {
                return ary;
            }
            ++i;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject flatten_bang() {
        this.modify();
        if (this.flatten(this.list)) {
            return this;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject flatten() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.flatten_bang();
        return rubyArray;
    }

    public IRubyObject nitems() {
        int count = 0;
        int i = 0;
        int len = this.getLength();
        while (i < len) {
            count += this.entry(i).isNil() ? 0 : 1;
            ++i;
        }
        return RubyFixnum.newFixnum(this.getRuntime(), count);
    }

    public IRubyObject op_plus(IRubyObject other) {
        ArrayList otherList = RubyArray.arrayValue(other).getList();
        ArrayList newList = new ArrayList(this.getLength() + otherList.size());
        newList.addAll(this.list);
        newList.addAll(otherList);
        return new RubyArray(this.getRuntime(), newList);
    }

    public IRubyObject op_times(IRubyObject arg) {
        if (arg instanceof RubyString) {
            return this.join((RubyString)arg);
        }
        int len = (int)RubyNumeric.num2long(arg);
        if (len < 0) {
            throw new ArgumentError(this.getRuntime(), "negative argument");
        }
        ArrayList newList = new ArrayList(this.getLength() * len);
        int i = 0;
        while (i < len) {
            newList.addAll(this.list);
            ++i;
        }
        return new RubyArray(this.getRuntime(), newList);
    }

    private ArrayList uniq(List oldList) {
        ArrayList newList = new ArrayList(oldList.size());
        HashSet passed = new HashSet(oldList.size());
        Iterator iter = oldList.iterator();
        while (iter.hasNext()) {
            Object item = iter.next();
            if (passed.contains(item)) continue;
            passed.add(item);
            newList.add(item);
        }
        newList.trimToSize();
        return newList;
    }

    public IRubyObject uniq_bang() {
        this.modify();
        ArrayList newList = this.uniq(this.list);
        if (newList.equals(this.list)) {
            return this.getRuntime().getNil();
        }
        this.list = newList;
        return this;
    }

    public IRubyObject uniq() {
        return new RubyArray(this.getRuntime(), this.uniq(this.list));
    }

    public IRubyObject op_diff(IRubyObject other) {
        ArrayList ary1 = this.uniq(this.list);
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        int len2 = ary2.size();
        int i = ary1.size() - 1;
        while (i >= 0) {
            IRubyObject obj = (IRubyObject)ary1.get(i);
            int j = 0;
            while (j < len2) {
                if (obj.callMethod("==", (IRubyObject)ary2.get(j)).isTrue()) {
                    ary1.remove(i);
                    break;
                }
                ++j;
            }
            --i;
        }
        return new RubyArray(this.getRuntime(), ary1);
    }

    public IRubyObject op_and(IRubyObject other) {
        ArrayList ary1 = this.uniq(this.list);
        int len1 = ary1.size();
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        int len2 = ary2.size();
        ArrayList<IRubyObject> ary3 = new ArrayList<IRubyObject>(len1);
        int i = 0;
        while (i < len1) {
            IRubyObject obj = (IRubyObject)ary1.get(i);
            int j = 0;
            while (j < len2) {
                if (obj.callMethod("==", (IRubyObject)ary2.get(j)).isTrue()) {
                    ary3.add(obj);
                    break;
                }
                ++j;
            }
            ++i;
        }
        ary3.trimToSize();
        return new RubyArray(this.getRuntime(), ary3);
    }

    public IRubyObject op_or(IRubyObject other) {
        ArrayList ary1 = new ArrayList(this.list);
        ArrayList ary2 = RubyArray.arrayValue(other).getList();
        ary1.addAll(ary2);
        return new RubyArray(this.getRuntime(), this.uniq(ary1));
    }

    public RubyArray sort() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.sort_bang();
        return rubyArray;
    }

    public IRubyObject sort_bang() {
        if (this.getLength() <= 1) {
            return this.getRuntime().getNil();
        }
        this.modify();
        this.setTmpLock(true);
        if (this.getRuntime().isBlockGiven()) {
            Collections.sort(this.list, new BlockComparator());
        } else {
            Collections.sort(this.list, new DefaultComparator());
        }
        this.setTmpLock(false);
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        output.write(91);
        output.dumpInt(this.getList().size());
        Iterator iter = this.getList().iterator();
        while (iter.hasNext()) {
            output.dumpObject((IRubyObject)iter.next());
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyArray result = RubyArray.newArray(input.getRuntime());
        input.registerLinkTarget(result);
        int size = input.unmarshalInt();
        int i = 0;
        while (i < size) {
            result.append(input.unmarshalObject());
            ++i;
        }
        return result;
    }

    public RubyString pack(RubyString iFmt) {
        return Pack.pack(this.list, iFmt);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            IRubyObject obj1 = (IRubyObject)o1;
            IRubyObject obj2 = (IRubyObject)o2;
            if (o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                return (int)(RubyNumeric.fix2long(obj1) - RubyNumeric.fix2long(obj2));
            }
            if (o1 instanceof RubyString && o2 instanceof RubyString) {
                return RubyNumeric.fix2int(((RubyString)o1).op_cmp((IRubyObject)o2));
            }
            return RubyNumeric.fix2int(obj1.callMethod("<=>", obj2));
        }

        public boolean equals(Object other) {
            return this == other;
        }
    }

    class BlockComparator
    implements Comparator {
        BlockComparator() {
        }

        public int compare(Object o1, Object o2) {
            IRubyObject result = RubyArray.this.getRuntime().yield(RubyArray.newArray(RubyArray.this.getRuntime(), (IRubyObject)o1, (IRubyObject)o2));
            return (int)((RubyNumeric)result).getLongValue();
        }

        public boolean equals(Object other) {
            return this == other;
        }
    }
}

