/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jruby.FileStatClass;
import org.jruby.KernelModule;
import org.jruby.MetaClass;
import org.jruby.Method;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyDir;
import org.jruby.RubyEnumerable;
import org.jruby.RubyException;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyGC;
import org.jruby.RubyHash;
import org.jruby.RubyIO;
import org.jruby.RubyInteger;
import org.jruby.RubyMarshal;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObjectSpace;
import org.jruby.RubyPrecision;
import org.jruby.RubyProc;
import org.jruby.RubyRange;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubyStruct;
import org.jruby.RubySymbol;
import org.jruby.RubyTime;
import org.jruby.ThreadClass;
import org.jruby.UnboundMethod;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.TypeError;
import org.jruby.internal.runtime.builtin.definitions.ObjectDefinition;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.IAutoloadMethod;
import org.jruby.util.BuiltinScript;

public class RubyClasses {
    private Ruby runtime;
    private RubyClass arrayClass;
    private RubyClass bignumClass;
    private RubyClass bindingClass;
    private RubyClass classClass;
    private RubyClass continuationClass;
    private RubyClass dirClass;
    private RubyClass exceptionClass;
    private RubyClass falseClass;
    private RubyClass fileClass;
    private RubyClass fileStatClass;
    private RubyClass fixnumClass;
    private RubyClass floatClass;
    private RubyClass hashClass;
    private RubyClass integerClass;
    private RubyClass ioClass;
    private RubyClass javaObjectClass;
    private RubyClass javaArrayClass;
    private RubyClass matchDataClass;
    private RubyClass methodClass;
    private RubyClass moduleClass;
    private RubyClass nilClass;
    private RubyClass numericClass;
    private RubyClass objectClass;
    private RubyClass procClass;
    private RubyClass rangeClass;
    private RubyClass regExpClass;
    private RubyClass stringClass;
    private RubyClass structClass;
    private RubyClass structTmsClass;
    private RubyClass symbolClass;
    private RubyClass threadClass;
    private RubyClass threadGroupClass;
    private RubyClass timeClass;
    private RubyClass trueClass;
    private RubyClass unboundMethodClass;
    private RubyModule comparableModule;
    private RubyModule enumerableModule;
    private RubyModule gcModule;
    private RubyModule javaModule;
    private RubyModule kernelModule;
    private RubyModule marshalModule;
    private RubyModule mathModule;
    private RubyModule objectSpaceModule;
    private RubyModule processModule;
    private RubyModule precisionModule;
    private Map classMap;

    public RubyClasses(Ruby ruby) {
        this.runtime = ruby;
        this.classMap = new HashMap();
    }

    private RubyClass defineBootClass(String name, RubyClass superClass) {
        RubyClass bootClass = RubyClass.newClass(this.runtime, superClass, name);
        this.classMap.put(name, bootClass);
        return bootClass;
    }

    public void initCoreClasses() {
        this.objectClass = this.defineBootClass("Object", null);
        this.moduleClass = this.defineBootClass("Module", this.objectClass);
        this.classClass = this.defineBootClass("Class", this.moduleClass);
        MetaClass metaClass = this.objectClass.makeMetaClass(this.classClass);
        metaClass = this.moduleClass.makeMetaClass(metaClass);
        metaClass = this.classClass.makeMetaClass(metaClass);
        this.kernelModule = KernelModule.createKernelModule(this.runtime);
        this.objectClass.includeModule(this.kernelModule);
        this.objectClass.definePrivateMethod("initialize", CallbackFactory.getNilMethod(-1));
        this.classClass.definePrivateMethod("inherited", CallbackFactory.getNilMethod(1));
        new ObjectDefinition(this.runtime).getModule();
        RubyClass.createClassClass(this.classClass);
        RubyModule.createModuleClass(this.moduleClass);
        this.nilClass = RubyNil.createNilClass(this.runtime);
        this.falseClass = RubyBoolean.createFalseClass(this.runtime);
        this.trueClass = RubyBoolean.createTrueClass(this.runtime);
        this.threadClass = ThreadClass.createThreadClass(this.runtime);
        this.runtime.getLoadService().addAutoload("UnboundMethod", new IAutoloadMethod(){

            public IRubyObject load(Ruby runtime, String name) {
                return UnboundMethod.defineUnboundMethodClass(runtime);
            }
        });
    }

    public void initBuiltinClasses() {
        new BuiltinScript("FalseClass").load(this.runtime);
        new BuiltinScript("TrueClass").load(this.runtime);
        new BuiltinScript("Enumerable").load(this.runtime);
    }

    public RubyClass getBindingClass() {
        return this.bindingClass;
    }

    public RubyClass getClassClass() {
        return this.classClass;
    }

    public RubyClass getModuleClass() {
        return this.moduleClass;
    }

    public RubyClass getStructClass() {
        if (this.structClass == null) {
            this.structClass = RubyStruct.createStructClass(this.runtime);
        }
        return this.structClass;
    }

    public RubyModule getComparableModule() {
        if (this.comparableModule == null) {
            this.comparableModule = RubyComparable.createComparable(this.runtime);
        }
        return this.comparableModule;
    }

    public RubyClass getHashClass() {
        if (this.hashClass == null) {
            this.hashClass = RubyHash.createHashClass(this.runtime);
        }
        return this.hashClass;
    }

    public RubyModule getMathModule() {
        if (this.mathModule == null) {
            this.mathModule = RubyMath.createMathModule(this.runtime);
        }
        return this.mathModule;
    }

    public RubyClass getRegExpClass() {
        if (this.regExpClass == null) {
            this.regExpClass = RubyRegexp.createRegexpClass(this.runtime);
        }
        return this.regExpClass;
    }

    public RubyModule getProcessModule() {
        return this.processModule;
    }

    public RubyClass getIoClass() {
        if (this.ioClass == null) {
            this.ioClass = RubyIO.createIOClass(this.runtime);
        }
        return this.ioClass;
    }

    public RubyClass getThreadGroupClass() {
        return this.threadGroupClass;
    }

    public RubyClass getBignumClass() {
        if (this.bignumClass == null) {
            this.bignumClass = RubyBignum.createBignumClass(this.runtime);
        }
        return this.bignumClass;
    }

    public RubyClass getStructTmsClass() {
        return this.structTmsClass;
    }

    public RubyClass getRangeClass() {
        if (this.rangeClass == null) {
            this.rangeClass = RubyRange.createRangeClass(this.runtime);
        }
        return this.rangeClass;
    }

    public RubyModule getGcModule() {
        if (this.gcModule == null) {
            this.gcModule = RubyGC.createGCModule(this.runtime);
        }
        return this.gcModule;
    }

    public RubyClass getSymbolClass() {
        if (this.symbolClass == null) {
            this.symbolClass = RubySymbol.createSymbolClass(this.runtime);
        }
        return this.symbolClass;
    }

    public RubyClass getProcClass() {
        if (this.procClass == null) {
            this.procClass = RubyProc.createProcClass(this.runtime);
        }
        return this.procClass;
    }

    public RubyClass getContinuationClass() {
        return this.continuationClass;
    }

    public RubyClass getFalseClass() {
        return this.falseClass;
    }

    public RubyClass getFloatClass() {
        if (this.floatClass == null) {
            this.floatClass = RubyFloat.createFloatClass(this.runtime);
        }
        return this.floatClass;
    }

    public RubyClass getMethodClass() {
        if (this.methodClass == null) {
            this.methodClass = Method.createMethodClass(this.runtime);
        }
        return this.methodClass;
    }

    public RubyClass getMatchDataClass() {
        if (this.matchDataClass == null) {
            this.matchDataClass = RubyMatchData.createMatchDataClass(this.runtime);
        }
        return this.matchDataClass;
    }

    public RubyModule getMarshalModule() {
        if (this.marshalModule == null) {
            this.marshalModule = RubyMarshal.createMarshalModule(this.runtime);
        }
        return this.marshalModule;
    }

    public RubyClass getFixnumClass() {
        if (this.fixnumClass == null) {
            this.fixnumClass = RubyFixnum.createFixnumClass(this.runtime);
        }
        return this.fixnumClass;
    }

    public RubyClass getObjectClass() {
        return this.objectClass;
    }

    public RubyModule getObjectSpaceModule() {
        if (this.objectSpaceModule == null) {
            this.objectSpaceModule = RubyObjectSpace.createObjectSpaceModule(this.runtime);
        }
        return this.objectSpaceModule;
    }

    public RubyClass getDirClass() {
        if (this.dirClass == null) {
            this.dirClass = RubyDir.createDirClass(this.runtime);
        }
        return this.dirClass;
    }

    public RubyClass getExceptionClass() {
        if (this.exceptionClass == null) {
            this.exceptionClass = RubyException.createExceptionClass(this.runtime);
        }
        return this.exceptionClass;
    }

    public RubyClass getStringClass() {
        if (this.stringClass == null) {
            this.stringClass = RubyString.createStringClass(this.runtime);
        }
        return this.stringClass;
    }

    public RubyClass getTrueClass() {
        return this.trueClass;
    }

    public RubyClass getIntegerClass() {
        if (this.integerClass == null) {
            this.integerClass = RubyInteger.createIntegerClass(this.runtime);
        }
        return this.integerClass;
    }

    public RubyModule getKernelModule() {
        return this.kernelModule;
    }

    public RubyClass getThreadClass() {
        return this.threadClass;
    }

    public RubyClass getFileClass() {
        if (this.fileClass == null) {
            this.fileClass = RubyFile.createFileClass(this.runtime);
        }
        return this.fileClass;
    }

    public RubyClass getFileStatClass() {
        if (this.fileStatClass == null) {
            this.fileStatClass = FileStatClass.createFileStatClass(this.runtime);
        }
        return this.fileStatClass;
    }

    public RubyClass getNilClass() {
        return this.nilClass;
    }

    public RubyClass getArrayClass() {
        if (this.arrayClass == null) {
            this.arrayClass = RubyArray.createArrayClass(this.runtime);
        }
        return this.arrayClass;
    }

    public RubyModule getEnumerableModule() {
        if (this.enumerableModule == null) {
            this.enumerableModule = RubyEnumerable.createEnumerableModule(this.runtime);
        }
        return this.enumerableModule;
    }

    public RubyModule getPrecisionModule() {
        if (this.precisionModule == null) {
            this.precisionModule = RubyPrecision.createPrecisionModule(this.runtime);
        }
        return this.precisionModule;
    }

    public RubyClass getJavaObjectClass() {
        if (this.javaObjectClass == null) {
            this.javaObjectClass = JavaObject.createJavaObjectClass(this.runtime);
        }
        return this.javaObjectClass;
    }

    public RubyClass getJavaArrayClass() {
        if (this.javaArrayClass == null) {
            this.javaArrayClass = JavaArray.createJavaArrayClass(this.runtime);
        }
        return this.javaArrayClass;
    }

    public RubyModule getJavaModule() {
        if (this.javaModule == null) {
            this.javaModule = Java.createJavaModule(this.runtime);
        }
        return this.javaModule;
    }

    public RubyClass getNumericClass() {
        if (this.numericClass == null) {
            this.numericClass = RubyNumeric.createNumericClass(this.runtime);
        }
        return this.numericClass;
    }

    public RubyClass getTimeClass() {
        if (this.timeClass == null) {
            this.timeClass = RubyTime.createTimeClass(this.runtime);
        }
        return this.timeClass;
    }

    public RubyClass getUnboundMethodClass() {
        if (this.unboundMethodClass == null) {
            this.unboundMethodClass = UnboundMethod.defineUnboundMethodClass(this.runtime);
        }
        return this.unboundMethodClass;
    }

    public Map getClassMap() {
        return this.classMap;
    }

    public RubyModule getClass(String name) {
        RubyModule type = (RubyModule)this.classMap.get(name);
        if (type == null) {
            type = this.getAutoload(name);
        }
        return type;
    }

    private RubyModule getAutoload(String name) {
        if ((name = name.intern()) == "Array") {
            return this.getArrayClass();
        }
        if (name == "Bignum") {
            return this.getBignumClass();
        }
        if (name == "Binding") {
            return this.getBindingClass();
        }
        if (name == "Comparable") {
            return this.getComparableModule();
        }
        if (name == "Continuation") {
            return this.getContinuationClass();
        }
        if (name == "Dir") {
            return this.getDirClass();
        }
        if (name == "Enumerable") {
            return this.getEnumerableModule();
        }
        if (name == "Exception") {
            return this.getExceptionClass();
        }
        if (name == "File") {
            return this.getFileClass();
        }
        if (name == "Fixnum") {
            return this.getFixnumClass();
        }
        if (name == "Float") {
            return this.getFloatClass();
        }
        if (name == "GC") {
            return this.getGcModule();
        }
        if (name == "Hash") {
            return this.getHashClass();
        }
        if (name == "Integer") {
            return this.getIntegerClass();
        }
        if (name == "IO") {
            return this.getIoClass();
        }
        if (name == "Java") {
            return this.getJavaModule();
        }
        if (name == "Marshal") {
            return this.getMarshalModule();
        }
        if (name == "MatchData") {
            return this.getMatchDataClass();
        }
        if (name == "Math") {
            return this.getMathModule();
        }
        if (name == "Method") {
            return this.getMethodClass();
        }
        if (name == "Numeric") {
            return this.getNumericClass();
        }
        if (name == "ObjectSpace") {
            return this.getObjectSpaceModule();
        }
        if (name == "Precision") {
            return this.getPrecisionModule();
        }
        if (name == "Proc") {
            return this.getProcClass();
        }
        if (name == "Process") {
            return this.getProcessModule();
        }
        if (name == "Range") {
            return this.getRangeClass();
        }
        if (name == "Regexp") {
            return this.getRegExpClass();
        }
        if (name == "String") {
            return this.getStringClass();
        }
        if (name == "Struct") {
            return this.getStructClass();
        }
        if (name == "Symbol") {
            return this.getSymbolClass();
        }
        if (name == "ThreadGroup") {
            return this.getThreadGroupClass();
        }
        if (name == "Time") {
            return this.getTimeClass();
        }
        if (name == "UnboundMethod") {
            return this.getUnboundMethodClass();
        }
        return null;
    }

    public RubyModule getClassFromPath(String path) {
        if (path.charAt(0) == '#') {
            throw new ArgumentError(this.runtime, "can't retrieve anonymous class " + path);
        }
        IRubyObject type = this.runtime.evalScript(path);
        if (!(type instanceof RubyModule)) {
            throw new TypeError(this.runtime, "class path " + path + " does not point class");
        }
        return (RubyModule)type;
    }

    public void putClass(String name, RubyModule rbClass) {
        this.classMap.put(name, rbClass);
    }

    public Iterator nameIterator() {
        return this.classMap.keySet().iterator();
    }
}

