/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyException
extends RubyObject {
    private RubyArray backtrace;
    public IRubyObject message;
    static /* synthetic */ Class class$org$jruby$RubyException;
    static /* synthetic */ Class class$org$jruby$RubyArray;

    private RubyException(Ruby ruby, RubyClass rubyClass) {
        this(ruby, rubyClass, null);
    }

    private RubyException(Ruby ruby, RubyClass rubyClass, String message) {
        super(ruby, rubyClass);
        this.message = message == null ? ruby.getNil() : RubyString.newString(ruby, message);
    }

    public static RubyClass createExceptionClass(Ruby ruby) {
        RubyClass exceptionClass = ruby.defineClass("Exception", ruby.getClasses().getObjectClass());
        exceptionClass.defineSingletonMethod("exception", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "newInstance"));
        exceptionClass.defineSingletonMethod("new", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "newInstance"));
        exceptionClass.defineMethod("initialize", CallbackFactory.getOptMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "initialize"));
        exceptionClass.defineMethod("exception", CallbackFactory.getOptMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "exception"));
        exceptionClass.defineMethod("to_s", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "to_s"));
        exceptionClass.defineMethod("to_str", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "to_s"));
        exceptionClass.defineMethod("message", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "to_s"));
        exceptionClass.defineMethod("inspect", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "inspect"));
        exceptionClass.defineMethod("backtrace", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "backtrace"));
        exceptionClass.defineMethod("set_backtrace", CallbackFactory.getMethod(class$org$jruby$RubyException == null ? (class$org$jruby$RubyException = RubyException.class$("org.jruby.RubyException")) : class$org$jruby$RubyException, "set_backtrace", class$org$jruby$RubyArray == null ? (class$org$jruby$RubyArray = RubyException.class$("org.jruby.RubyArray")) : class$org$jruby$RubyArray));
        return exceptionClass;
    }

    public static RubyException newException(Ruby ruby, RubyClass excptnClass, String msg) {
        return new RubyException(ruby, excptnClass, msg);
    }

    public static RubyException newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyException newException = new RubyException(recv.getRuntime(), (RubyClass)recv);
        newException.callInit(args);
        return newException;
    }

    public IRubyObject initialize(IRubyObject[] args) {
        if (args.length > 0) {
            this.message = args[0];
        }
        return this;
    }

    public RubyArray backtrace() {
        if (this.backtrace == null) {
            return RubyArray.nilArray(this.runtime);
        }
        return this.backtrace;
    }

    public RubyArray set_backtrace(RubyArray newBacktrace) {
        this.backtrace = newBacktrace;
        return newBacktrace;
    }

    public RubyException exception(IRubyObject[] args) {
        switch (args.length) {
            case 0: {
                return this;
            }
            case 1: {
                if (args[0] == this) {
                    return this;
                }
                return RubyException.newInstance(this.getMetaClass(), args);
            }
        }
        throw new ArgumentError(this.getRuntime(), "Wrong argument count");
    }

    public RubyString to_s() {
        if (this.message.isNil()) {
            return RubyString.newString(this.getRuntime(), this.getMetaClass().getClassPath());
        }
        this.message.setTaint(this.isTaint());
        return (RubyString)this.message.callMethod("to_s");
    }

    public RubyString inspect() {
        RubyClass rubyClass = this.getMetaClass();
        RubyString exception = RubyString.stringValue(this);
        if (exception.getValue().length() == 0) {
            return RubyString.newString(this.getRuntime(), rubyClass.getClassPath());
        }
        StringBuffer sb = new StringBuffer();
        sb.append("#<");
        sb.append(rubyClass.getClassPath());
        sb.append(": ");
        sb.append(exception.getValue());
        sb.append(">");
        return RubyString.newString(this.getRuntime(), sb.toString());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

