/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.internal.runtime.builtin.definitions.FixnumDefinition;
import org.jruby.runtime.IndexCallable;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyFixnum
extends RubyInteger
implements IndexCallable {
    private long value;
    private static final int BIT_SIZE = 64;
    private static final long MAX_MARSHAL_FIXNUM = 0x3FFFFFFFL;

    public RubyFixnum(Ruby ruby) {
        this(ruby, 0L);
    }

    public RubyFixnum(Ruby ruby, long value) {
        super(ruby, ruby.getClasses().getFixnumClass());
        this.value = value;
    }

    public static RubyClass createFixnumClass(Ruby runtime) {
        RubyClass fixnumClass = new FixnumDefinition(runtime).getType();
        fixnumClass.includeModule(runtime.getClasses().getPrecisionModule());
        return fixnumClass;
    }

    public IRubyObject callIndexed(int index, IRubyObject[] args) {
        switch (index) {
            case 61463: {
                return this.aref(args[0]);
            }
            case 61441: {
                return this.to_f();
            }
            case 61442: {
                return this.to_s();
            }
            case 61445: {
                return this.op_lshift(args[0]);
            }
            case 61446: {
                return this.op_rshift(args[0]);
            }
            case 61447: {
                return this.op_plus(args[0]);
            }
            case 61448: {
                return this.op_minus(args[0]);
            }
            case 61449: {
                return this.op_mul(args[0]);
            }
            case 61450: {
                return this.op_div(args[0]);
            }
            case 61451: {
                return this.op_mod(args[0]);
            }
            case 61452: {
                return this.op_pow(args[0]);
            }
            case 61453: {
                return this.equal(args[0]);
            }
            case 61454: {
                return this.op_cmp(args[0]);
            }
            case 61455: {
                return this.op_gt(args[0]);
            }
            case 61456: {
                return this.op_ge(args[0]);
            }
            case 61457: {
                return this.op_lt(args[0]);
            }
            case 61458: {
                return this.op_le(args[0]);
            }
            case 61459: {
                return this.op_and(args[0]);
            }
            case 61460: {
                return this.op_or(args[0]);
            }
            case 61461: {
                return this.op_xor(args[0]);
            }
            case 61462: {
                return this.size();
            }
            case 61464: {
                return this.hash();
            }
            case 61465: {
                return this.id2name();
            }
            case 61466: {
                return this.invert();
            }
            case 61467: {
                return this.id();
            }
            case 61443: {
                return this.taint();
            }
            case 61444: {
                return this.freeze();
            }
        }
        return super.callIndexed(index, args);
    }

    public Class getJavaClass() {
        return Long.TYPE;
    }

    public double getDoubleValue() {
        return this.value;
    }

    public long getLongValue() {
        return this.value;
    }

    public static RubyFixnum zero(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 0L);
    }

    public static RubyFixnum one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, 1L);
    }

    public static RubyFixnum minus_one(Ruby ruby) {
        return RubyFixnum.newFixnum(ruby, -1L);
    }

    protected int compareValue(RubyNumeric other) {
        if (other instanceof RubyBignum) {
            return -((RubyBignum)other).compareValue(this);
        }
        if (other instanceof RubyFloat) {
            double otherVal = other.getDoubleValue();
            return (double)this.value > otherVal ? 1 : ((double)this.value < otherVal ? -1 : 0);
        }
        long otherVal = other.getLongValue();
        return this.value > otherVal ? 1 : (this.value < otherVal ? -1 : 0);
    }

    public RubyFixnum hash() {
        return this.newFixnum((int)this.value ^ (int)(this.value >> 32));
    }

    public static RubyFixnum newFixnum(Ruby ruby, long value) {
        RubyFixnum fixnum;
        if (value >= 0L && value < (long)ruby.fixnumCache.length) {
            fixnum = ruby.fixnumCache[(int)value];
            if (fixnum == null) {
                ruby.fixnumCache[(int)value] = fixnum = new RubyFixnum(ruby, value);
            }
        } else {
            fixnum = new RubyFixnum(ruby, value);
        }
        return fixnum;
    }

    public RubyFixnum newFixnum(long value) {
        return RubyFixnum.newFixnum(this.runtime, value);
    }

    public static RubyInteger induced_from(IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyFixnum) {
            return (RubyFixnum)number;
        }
        if (number instanceof RubyFloat) {
            return ((RubyFloat)number).to_i();
        }
        if (number instanceof RubyBignum) {
            return RubyFixnum.newFixnum(recv.getRuntime(), ((RubyBignum)number).getLongValue());
        }
        return (RubyFixnum)number.convertToType("Fixnum", "to_int", true);
    }

    public RubyNumeric op_plus(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return ((RubyFloat)other).op_plus(this);
        }
        if (other instanceof RubyBignum) {
            return ((RubyBignum)other).op_plus(this);
        }
        long otherValue = other.getLongValue();
        long result = this.value + otherValue;
        if (this.value < 0L && otherValue < 0L && result > 0L || this.value > 0L && otherValue > 0L && result < 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_plus(other);
        }
        return this.newFixnum(result);
    }

    public RubyNumeric op_minus(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_minus(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
        }
        long otherValue = other.getLongValue();
        long result = this.value - otherValue;
        if (this.value < 0L && otherValue > 0L && result > 0L || this.value > 0L && otherValue < 0L && result < 0L) {
            return RubyBignum.newBignum(this.getRuntime(), this.value).op_minus(other);
        }
        return this.newFixnum(result);
    }

    public RubyNumeric op_mul(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_mul(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mul(other);
        }
        long otherValue = other.getLongValue();
        long result = this.value * otherValue;
        if (result / otherValue == this.value) {
            return this.newFixnum(result);
        }
        return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mul(other);
    }

    public RubyNumeric op_div(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_div(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_div(other);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() / other.getLongValue());
    }

    public RubyNumeric op_mod(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_mod(other);
        }
        if (other instanceof RubyBignum) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_mod(other);
        }
        return RubyFixnum.newFixnum(this.getRuntime(), this.getLongValue() % other.getLongValue());
    }

    public RubyNumeric op_pow(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        if (other instanceof RubyFloat) {
            return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_pow(other);
        }
        if (other.getLongValue() == 0L) {
            return RubyFixnum.newFixnum(this.getRuntime(), 1L);
        }
        if (other.getLongValue() == 1L) {
            return this;
        }
        if (other.getLongValue() > 1L) {
            return RubyBignum.newBignum(this.getRuntime(), this.getLongValue()).op_pow(other);
        }
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue()).op_pow(other);
    }

    public RubyBoolean equal(IRubyObject other) {
        if (!(other instanceof RubyNumeric)) {
            return this.getRuntime().getFalse();
        }
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue((RubyNumeric)other) == 0);
    }

    public RubyNumeric op_cmp(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyFixnum.newFixnum(this.getRuntime(), this.compareValue(other));
    }

    public RubyBoolean op_gt(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) > 0);
    }

    public RubyBoolean op_ge(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) >= 0);
    }

    public RubyBoolean op_lt(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) < 0);
    }

    public RubyBoolean op_le(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        return RubyBoolean.newBoolean(this.getRuntime(), this.compareValue(other) <= 0);
    }

    public RubyString to_s() {
        return RubyString.newString(this.getRuntime(), String.valueOf(this.getLongValue()));
    }

    public RubyFloat to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    public RubyInteger op_lshift(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        long width = other.getLongValue();
        if (width < 0L) {
            return this.op_rshift(other.op_uminus());
        }
        if (width > 64L || this.value >>> (int)(64L - width) > 0L) {
            RubyBignum lBigValue = new RubyBignum(this.runtime, RubyBignum.bigIntValue(this));
            return lBigValue.op_lshift(other);
        }
        return this.newFixnum(this.value << (int)width);
    }

    public RubyInteger op_rshift(IRubyObject num) {
        RubyNumeric other = RubyNumeric.numericValue(num);
        long width = other.getLongValue();
        if (width < 0L) {
            return this.op_lshift(other.op_uminus());
        }
        return this.newFixnum(this.value >>> (int)width);
    }

    public RubyNumeric op_and(IRubyObject other) {
        RubyNumeric otherNumeric = RubyNumeric.numericValue(other);
        long otherLong = otherNumeric.getTruncatedLongValue();
        return this.newFixnum(this.value & otherLong);
    }

    public RubyInteger op_or(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.callMethod("|", this);
        }
        RubyNumeric otherNumeric = RubyNumeric.numericValue(other);
        return this.newFixnum(this.value | otherNumeric.getLongValue());
    }

    public RubyInteger op_xor(IRubyObject other) {
        if (other instanceof RubyBignum) {
            return (RubyInteger)other.callMethod("^", this);
        }
        RubyNumeric otherNumeric = RubyNumeric.numericValue(other);
        return this.newFixnum(this.value ^ otherNumeric.getLongValue());
    }

    public RubyFixnum size() {
        return this.newFixnum((long)Math.ceil(8.0));
    }

    public RubyFixnum aref(IRubyObject position) {
        RubyNumeric numericPosition = RubyNumeric.numericValue(position);
        long mask = 1 << (int)numericPosition.getLongValue();
        return this.newFixnum((this.value & mask) == 0L ? 0L : 1L);
    }

    public RubySymbol id2name() {
        return RubySymbol.getSymbol(this.runtime, this.value);
    }

    public RubyFixnum invert() {
        return this.newFixnum(this.value ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public RubyFixnum id() {
        return this.newFixnum(this.value * 2L + 1L);
    }

    public IRubyObject taint() {
        return this;
    }

    public IRubyObject freeze() {
        return this;
    }

    public void marshalTo(MarshalStream output) throws IOException {
        if (this.value <= 0x3FFFFFFFL) {
            output.write(105);
            output.dumpInt((int)this.value);
        } else {
            output.dumpObject(RubyBignum.newBignum(this.runtime, this.value));
        }
    }

    public static RubyFixnum unmarshalFrom(UnmarshalStream input) throws IOException {
        return RubyFixnum.newFixnum(input.getRuntime(), input.unmarshalInt());
    }
}

