/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.RangeError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyInteger
extends RubyNumeric {
    static /* synthetic */ Class class$org$jruby$RubyInteger;
    static /* synthetic */ Class class$org$jruby$runtime$builtin$IRubyObject;
    static /* synthetic */ Class class$org$jruby$RubyNumeric;

    public RubyInteger(Ruby ruby, RubyClass rubyClass) {
        super(ruby, rubyClass);
    }

    public static RubyClass createIntegerClass(Ruby ruby) {
        RubyClass integerClass = ruby.defineClass("Integer", ruby.getClasses().getNumericClass());
        integerClass.getMetaClass().undefineMethod("new");
        integerClass.defineSingletonMethod("induced_from", CallbackFactory.getSingletonMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "induced_from", class$org$jruby$runtime$builtin$IRubyObject == null ? (class$org$jruby$runtime$builtin$IRubyObject = RubyInteger.class$("org.jruby.runtime.builtin.IRubyObject")) : class$org$jruby$runtime$builtin$IRubyObject));
        integerClass.defineMethod("chr", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "chr"));
        integerClass.defineMethod("integer?", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "int_p"));
        integerClass.defineMethod("to_i", CallbackFactory.getSelfMethod(0));
        integerClass.defineMethod("to_int", CallbackFactory.getSelfMethod(0));
        integerClass.defineMethod("ceil", CallbackFactory.getSelfMethod(0));
        integerClass.defineMethod("floor", CallbackFactory.getSelfMethod(0));
        integerClass.defineMethod("round", CallbackFactory.getSelfMethod(0));
        integerClass.defineMethod("truncate", CallbackFactory.getSelfMethod(0));
        integerClass.defineMethod("next", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "succ"));
        integerClass.defineMethod("succ", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "succ"));
        integerClass.defineMethod("downto", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "downto", class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric));
        integerClass.defineMethod("step", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "step", class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric, class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric));
        integerClass.defineMethod("times", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "times"));
        integerClass.defineMethod("upto", CallbackFactory.getMethod(class$org$jruby$RubyInteger == null ? (class$org$jruby$RubyInteger = RubyInteger.class$("org.jruby.RubyInteger")) : class$org$jruby$RubyInteger, "upto", class$org$jruby$RubyNumeric == null ? (class$org$jruby$RubyNumeric = RubyInteger.class$("org.jruby.RubyNumeric")) : class$org$jruby$RubyNumeric));
        return integerClass;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.runtime, this.getDoubleValue());
    }

    public static RubyInteger induced_from(IRubyObject recv, IRubyObject number) {
        if (number instanceof RubyNumeric) {
            return (RubyInteger)number.callMethod("to_i");
        }
        throw new TypeError(recv.getRuntime(), "failed to convert " + number.getMetaClass() + " into Integer");
    }

    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw new RangeError(this.getRuntime(), this.toString() + " out of char range");
        }
        return RubyString.newString(this.getRuntime(), new String(new char[]{(char)this.getLongValue()}));
    }

    public IRubyObject downto(RubyNumeric to) {
        RubyNumeric i = this;
        while (!i.callMethod("<", to).isTrue()) {
            this.getRuntime().yield(i);
            i = (RubyNumeric)i.callMethod("-", RubyFixnum.one(this.getRuntime()));
        }
        return this;
    }

    public RubyBoolean int_p() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject step(RubyNumeric to, RubyNumeric step) {
        RubyNumeric i = this;
        if (step.getLongValue() == 0L) {
            throw new ArgumentError(this.getRuntime(), "step cannot be 0");
        }
        String cmp = "<";
        if (((RubyBoolean)step.callMethod("<", RubyFixnum.newFixnum(this.getRuntime(), 0L))).isFalse()) {
            cmp = ">";
        }
        while (!i.callMethod(cmp, to).isTrue()) {
            this.getRuntime().yield(i);
            i = (RubyNumeric)i.callMethod("+", step);
        }
        return this;
    }

    public IRubyObject times() {
        RubyNumeric i = RubyFixnum.zero(this.getRuntime());
        while (i.callMethod("<", this).isTrue()) {
            this.getRuntime().yield(i);
            i = (RubyNumeric)i.callMethod("+", RubyFixnum.one(this.getRuntime()));
        }
        return this;
    }

    public IRubyObject succ() {
        return this.callMethod("+", RubyFixnum.one(this.getRuntime()));
    }

    public IRubyObject upto(RubyNumeric to) {
        RubyNumeric i = this;
        while (!i.callMethod(">", to).isTrue()) {
            this.getRuntime().yield(i);
            i = (RubyNumeric)i.callMethod("+", RubyFixnum.one(this.getRuntime()));
        }
        return this;
    }

    public RubyInteger to_i() {
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

