/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jruby.Ruby;
import org.jruby.RubyFixnum;
import org.jruby.RubyIO;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.exceptions.ArgumentError;
import org.jruby.exceptions.IOError;
import org.jruby.exceptions.NotImplementedError;
import org.jruby.exceptions.TypeError;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;

public class RubyMarshal {
    static /* synthetic */ Class class$org$jruby$RubyMarshal;

    public static RubyModule createMarshalModule(Ruby ruby) {
        RubyModule marshalModule = ruby.defineModule("Marshal");
        marshalModule.defineSingletonMethod("dump", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyMarshal == null ? (class$org$jruby$RubyMarshal = RubyMarshal.class$("org.jruby.RubyMarshal")) : class$org$jruby$RubyMarshal, "dump"));
        marshalModule.defineSingletonMethod("load", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyMarshal == null ? (class$org$jruby$RubyMarshal = RubyMarshal.class$("org.jruby.RubyMarshal")) : class$org$jruby$RubyMarshal, "load"));
        marshalModule.defineSingletonMethod("restore", CallbackFactory.getOptSingletonMethod(class$org$jruby$RubyMarshal == null ? (class$org$jruby$RubyMarshal = RubyMarshal.class$("org.jruby.RubyMarshal")) : class$org$jruby$RubyMarshal, "load"));
        return marshalModule;
    }

    public static IRubyObject dump(IRubyObject recv, IRubyObject[] args) {
        if (args.length < 1) {
            throw new ArgumentError(recv.getRuntime(), "wrong # of arguments(at least 1)");
        }
        IRubyObject objectToDump = args[0];
        RubyIO io = null;
        int depthLimit = -1;
        if (args.length >= 2) {
            if (args[1] instanceof RubyIO) {
                io = (RubyIO)args[1];
            } else if (args[1] instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)args[1]).getLongValue();
            }
            if (args.length == 3) {
                depthLimit = (int)((RubyFixnum)args[2]).getLongValue();
            }
        }
        try {
            if (io != null) {
                RubyMarshal.dumpToStream(objectToDump, io.getOutStream(), depthLimit);
                return io;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            RubyMarshal.dumpToStream(objectToDump, stringOutput, depthLimit);
            return RubyString.newString(recv.getRuntime(), stringOutput.toByteArray());
        }
        catch (IOException ioe) {
            throw IOError.fromException(recv.getRuntime(), ioe);
        }
    }

    public static IRubyObject load(IRubyObject recv, IRubyObject[] args) {
        try {
            if (args.length < 1) {
                throw new ArgumentError(recv.getRuntime(), "wrong # of arguments(at least 1)");
            }
            IRubyObject in = args[0];
            if (in instanceof RubyIO) {
                throw new NotImplementedError(recv.getRuntime());
            }
            if (!in.respondsTo("to_str")) {
                throw new TypeError(recv.getRuntime(), "instance of IO needed");
            }
            RubyString inString = (RubyString)in.callMethod("to_str");
            ByteArrayInputStream rawInput = new ByteArrayInputStream(inString.toByteArray());
            UnmarshalStream input = new UnmarshalStream(recv.getRuntime(), rawInput);
            return input.unmarshalObject();
        }
        catch (IOException ioe) {
            throw IOError.fromException(recv.getRuntime(), ioe);
        }
    }

    private static void dumpToStream(IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(object.getRuntime(), rawOutput, depthLimit);
        output.dumpObject(object);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

